/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.networkinterface;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.hierarchy.IChildrenProvider;
import com.helger.commons.string.ToStringGenerator;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChildrenProviderNetworkInterface
implements IChildrenProvider<NetworkInterface> {
    public boolean hasChildren(@Nonnull NetworkInterface networkInterface) {
        return networkInterface.getSubInterfaces().hasMoreElements();
    }

    @Nonnegative
    public int getChildCount(@Nonnull NetworkInterface networkInterface) {
        return IteratorHelper.getSize(networkInterface.getSubInterfaces());
    }

    @Nullable
    public ICommonsCollection<NetworkInterface> getAllChildren(@Nonnull NetworkInterface networkInterface) {
        Enumeration<NetworkInterface> enumeration = networkInterface.getSubInterfaces();
        return enumeration.hasMoreElements() ? CollectionHelper.newList(enumeration) : null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

