/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.url.EURLProtocol;
import com.helger.commons.url.IURLProtocol;
import com.helger.network.port.SchemeDefaultPortMapper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EHttpProxyType implements IHasID<String>
{
    HTTP("http", (IURLProtocol)EURLProtocol.HTTP, SchemeDefaultPortMapper.getDefaultPortOrThrow("http")),
    HTTPS("https", (IURLProtocol)EURLProtocol.HTTPS, SchemeDefaultPortMapper.getDefaultPortOrThrow("https")),
    FTP("ftp", (IURLProtocol)EURLProtocol.FTP, SchemeDefaultPortMapper.getDefaultPortOrThrow("http"));

    private final String m_sID;
    private final IURLProtocol m_aURLProtocol;
    private final int m_nDefaultPort;

    private EHttpProxyType(@Nonnegative String string2, IURLProtocol iURLProtocol, int n2) {
        this.m_sID = string2;
        this.m_aURLProtocol = iURLProtocol;
        this.m_nDefaultPort = n2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public IURLProtocol getURLProtocol() {
        return this.m_aURLProtocol;
    }

    @Nonnegative
    public int getDefaultPort() {
        return this.m_nDefaultPort;
    }

    @Nonnull
    public String getPropertyNameProxyHost() {
        return this.m_sID + ".proxyHost";
    }

    @Nullable
    public String getProxyHost() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameProxyHost());
    }

    @Nonnull
    public String getPropertyNameProxyPort() {
        return this.m_sID + ".proxyPort";
    }

    @Nullable
    public String getProxyPort() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameProxyPort());
    }

    @Nonnull
    public String getPropertyNameProxyUser() {
        return this.m_sID + ".proxyUser";
    }

    @Nullable
    public String getProxyUser() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameProxyUser());
    }

    @Nonnull
    public String getPropertyNameProxyPassword() {
        return this.m_sID + ".proxyPassword";
    }

    @Nullable
    public String getProxyPassword() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameProxyPassword());
    }

    @Nonnull
    public String getPropertyNameNoProxyHosts() {
        return this == HTTPS ? HTTP.getPropertyNameNoProxyHosts() : this.m_sID + ".noProxyHosts";
    }

    @Nullable
    public String getNoProxyHosts() {
        return SystemProperties.getPropertyValueOrNull((String)this.getPropertyNameNoProxyHosts());
    }

    @Nullable
    public static EHttpProxyType getFromIDOrNull(@Nullable String string) {
        return (EHttpProxyType)EnumHelper.getFromIDOrNull(EHttpProxyType.class, (Object)string);
    }

    @Nullable
    public static EHttpProxyType getFromURLProtocolOrDefault(@Nullable IURLProtocol iURLProtocol, @Nullable EHttpProxyType eHttpProxyType2) {
        return (EHttpProxyType)EnumHelper.findFirst(EHttpProxyType.class, eHttpProxyType -> eHttpProxyType.m_aURLProtocol.equals(iURLProtocol), (Enum)eHttpProxyType2);
    }
}

