/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.network.port.NetworkPortHelper;
import com.helger.network.proxy.EHttpProxyType;
import com.helger.network.proxy.HttpProxyAuthenticator;
import com.helger.network.proxy.IProxyConfig;
import com.helger.network.proxy.SocksProxyConfig;
import com.helger.network.proxy.UseSystemProxyConfig;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class HttpProxyConfig
implements IProxyConfig {
    private final EHttpProxyType m_eProxyType;
    private final String m_sHost;
    private final int m_nPort;
    private final String m_sUserName;
    private final String m_sPassword;
    private final ICommonsList<String> m_aNonProxyHosts = new CommonsArrayList();

    public HttpProxyConfig(@Nonnull EHttpProxyType eHttpProxyType, @Nonnull @Nonempty String string, @Nonnegative int n) {
        this(eHttpProxyType, string, n, null, null, null);
    }

    public HttpProxyConfig(@Nonnull EHttpProxyType eHttpProxyType, @Nonnull @Nonempty String string, @Nonnegative int n, @Nullable List<String> list) {
        this(eHttpProxyType, string, n, null, null, list);
    }

    public HttpProxyConfig(@Nonnull EHttpProxyType eHttpProxyType, @Nonnull @Nonempty String string, @Nonnegative int n, @Nullable String string2, @Nullable String string3, @Nullable List<String> list) {
        ValueEnforcer.notNull((Object)((Object)eHttpProxyType), (String)"ProxyType");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"HostName");
        ValueEnforcer.isTrue((boolean)NetworkPortHelper.isValidPort(n), () -> "The passed port is invalid: " + n);
        this.m_eProxyType = eHttpProxyType;
        this.m_sHost = string;
        this.m_nPort = n;
        this.m_sUserName = string2;
        this.m_sPassword = string3;
        if (list != null) {
            for (String string4 : list) {
                if (!StringHelper.hasText((String)string4)) continue;
                this.m_aNonProxyHosts.add((Object)string4);
            }
        }
    }

    @Nonnull
    public EHttpProxyType getType() {
        return this.m_eProxyType;
    }

    @Nonnull
    public String getHost() {
        return this.m_sHost;
    }

    @Nonnegative
    public int getPort() {
        return this.m_nPort;
    }

    public boolean hasUserNameOrPassword() {
        return StringHelper.hasText((String)this.m_sUserName) || this.m_sPassword != null;
    }

    @Nullable
    public String getUserName() {
        return this.m_sUserName;
    }

    @Nullable
    public String getPassword() {
        return this.m_sPassword;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getNonProxyHosts() {
        return (ICommonsList)this.m_aNonProxyHosts.getClone();
    }

    @Nullable
    public Authenticator getAsAuthenticator() {
        if (StringHelper.hasNoText((String)this.m_eProxyType.getProxyUser())) {
            return null;
        }
        return new HttpProxyAuthenticator(this.m_eProxyType);
    }

    @Override
    public void activateGlobally() {
        SocksProxyConfig.deactivateGlobally();
        UseSystemProxyConfig.deactivateGlobally();
        SystemProperties.setPropertyValue((String)this.m_eProxyType.getPropertyNameProxyHost(), (String)this.m_sHost);
        SystemProperties.setPropertyValue((String)this.m_eProxyType.getPropertyNameProxyPort(), (String)Integer.toString(this.m_nPort));
        SystemProperties.setPropertyValue((String)this.m_eProxyType.getPropertyNameProxyUser(), (String)this.m_sUserName);
        SystemProperties.setPropertyValue((String)this.m_eProxyType.getPropertyNameProxyPassword(), (String)this.m_sPassword);
        SystemProperties.setPropertyValue((String)this.m_eProxyType.getPropertyNameNoProxyHosts(), (String)StringHelper.getImploded((char)'|', this.m_aNonProxyHosts));
    }

    public static void deactivateGlobally() {
        for (EHttpProxyType eHttpProxyType : EHttpProxyType.values()) {
            SystemProperties.removePropertyValue((String)eHttpProxyType.getPropertyNameProxyHost());
            SystemProperties.removePropertyValue((String)eHttpProxyType.getPropertyNameProxyPort());
            SystemProperties.removePropertyValue((String)eHttpProxyType.getPropertyNameProxyUser());
            SystemProperties.removePropertyValue((String)eHttpProxyType.getPropertyNameProxyPassword());
            SystemProperties.removePropertyValue((String)eHttpProxyType.getPropertyNameNoProxyHosts());
        }
    }

    @Override
    @Nonnull
    public Proxy getAsProxy() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.m_sHost, this.m_nPort));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HttpProxyConfig httpProxyConfig = (HttpProxyConfig)object;
        return this.m_eProxyType.equals((Object)httpProxyConfig.m_eProxyType) && this.m_sHost.equals(httpProxyConfig.m_sHost) && this.m_nPort == httpProxyConfig.m_nPort && EqualsHelper.equals((Object)this.m_sUserName, (Object)httpProxyConfig.m_sUserName) && EqualsHelper.equals((Object)this.m_sPassword, (Object)httpProxyConfig.m_sPassword) && EqualsHelper.equals(this.m_aNonProxyHosts, httpProxyConfig.m_aNonProxyHosts);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eProxyType).append((Object)this.m_sHost).append(this.m_nPort).append((Object)this.m_sUserName).append((Object)this.m_sPassword).append(this.m_aNonProxyHosts).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ProxyType", (Enum)this.m_eProxyType).append("Host", (Object)this.m_sHost).append("Port", this.m_nPort).append("UserName", (Object)this.m_sUserName).appendPassword("Password").append("NonProxyHosts", this.m_aNonProxyHosts).getToString();
    }
}

