/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy;

import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.network.proxy.HttpProxyConfig;
import com.helger.network.proxy.IProxyConfig;
import com.helger.network.proxy.SocksProxyConfig;
import java.net.Proxy;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UseSystemProxyConfig
implements IProxyConfig {
    public static final String SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";

    public boolean isUseSystemProxies() {
        return StringParser.parseBool((String)SystemProperties.getPropertyValueOrNull((String)SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES), (boolean)false);
    }

    @Override
    public void activateGlobally() {
        UseSystemProxyConfig.activateGloballyStatic();
    }

    public static void activateGloballyStatic() {
        HttpProxyConfig.deactivateGlobally();
        SocksProxyConfig.deactivateGlobally();
        SystemProperties.setPropertyValue((String)SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES, (String)Boolean.TRUE.toString());
    }

    public static void deactivateGlobally() {
        SystemProperties.removePropertyValue((String)SYSPROP_JAVA_NET_USE_SYSTEM_PROXIES);
    }

    @Override
    @Nullable
    public Proxy getAsProxy() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

