/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.autoconf;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.script.ScriptHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.timing.StopWatch;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.network.dns.DNSResolver;
import com.helger.network.proxy.EHttpProxyType;
import com.helger.network.proxy.HttpProxyConfig;
import com.helger.network.proxy.IProxyConfig;
import com.helger.network.proxy.NoProxyConfig;
import com.helger.network.proxy.SocksProxyConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyAutoConfigHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ProxyAutoConfigHelper.class);
    private static final ScriptEngine s_aScriptEngine = ScriptHelper.createNashornEngine();
    private final IReadableResource m_aPACRes;
    private final String m_sPACCode;

    public ProxyAutoConfigHelper(@Nonnull IReadableResource iReadableResource) throws ScriptException {
        this.m_aPACRes = (IReadableResource)ValueEnforcer.notNull((Object)iReadableResource, (String)"PACResource");
        this.m_sPACCode = null;
        s_aScriptEngine.eval(this.m_aPACRes.getReader(ScriptHelper.DEFAULT_SCRIPT_CHARSET));
    }

    public ProxyAutoConfigHelper(@Nonnull String string) throws ScriptException {
        this.m_aPACRes = null;
        this.m_sPACCode = (String)ValueEnforcer.notNull((Object)string, (String)"PACCode");
        s_aScriptEngine.eval(this.m_sPACCode);
    }

    @Nullable
    public String findProxyForURL(@Nonnull String string, @Nonnull String string2) throws ScriptException {
        Object object = s_aScriptEngine.eval("findProxyForURL('" + string + "', '" + string2 + "')");
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @Nonnull
    public ICommonsList<IProxyConfig> getProxyListForURL(String string, String string2) throws ScriptException {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        String string3 = this.findProxyForURL(string, string2);
        if (string3 != null && (string3 = string3.trim()).length() > 0) {
            for (String string4 : StringHelper.getExploded((char)';', (String)string3)) {
                String string5;
                String string6;
                String[] stringArray;
                boolean bl = true;
                if ((string4 = string4.trim()).equals("DIRECT")) {
                    commonsArrayList.add((Object)new NoProxyConfig());
                    bl = false;
                } else if (string4.startsWith("PROXY")) {
                    stringArray = StringHelper.getExplodedArray((char)' ', (String)string4, (int)2);
                    if (stringArray.length == 2 && (stringArray = StringHelper.getExplodedArray((char)':', (String)stringArray[1], (int)2)).length == 2) {
                        string6 = stringArray[0];
                        string5 = stringArray[1];
                        EHttpProxyType eHttpProxyType = EHttpProxyType.getFromURLProtocolOrDefault(URLProtocolRegistry.getInstance().getProtocol(string6), EHttpProxyType.HTTP);
                        int n = StringParser.parseInt((String)string5, (int)eHttpProxyType.getDefaultPort());
                        commonsArrayList.add((Object)new HttpProxyConfig(eHttpProxyType, string6, n));
                        bl = false;
                    }
                } else if (string4.startsWith("SOCKS") && (stringArray = StringHelper.getExplodedArray((char)' ', (String)string4, (int)2)).length == 2 && (stringArray = StringHelper.getExplodedArray((char)':', (String)stringArray[1], (int)2)).length == 2) {
                    string6 = stringArray[0];
                    string5 = stringArray[1];
                    int n = StringParser.parseInt((String)string5, (int)1080);
                    commonsArrayList.add((Object)new SocksProxyConfig(string6, n));
                    bl = false;
                }
                if (!bl) continue;
                s_aLogger.warn("Found unknown proxy directive '" + string4 + "'");
            }
        }
        return commonsArrayList;
    }

    static {
        try {
            StopWatch stopWatch = StopWatch.createdStarted();
            s_aScriptEngine.eval("var dnsResolve = function(hostName){ return " + DNSResolver.class.getName() + ".dnsResolve(hostName); }");
            s_aScriptEngine.eval("var dnsResolveEx = function(hostName){ return " + DNSResolver.class.getName() + ".dnsResolveEx(hostName); }");
            s_aScriptEngine.eval("var myIpAddress = function(){ return " + DNSResolver.class.getName() + ".getMyIpAddress(); }");
            s_aScriptEngine.eval(new ClassPathResource("proxy-js/pac-utils.js").getReader(ScriptHelper.DEFAULT_SCRIPT_CHARSET));
            long l = stopWatch.stopAndGetMillis();
            if (l > 100L) {
                s_aLogger.info("Initial PAC script compilaiton took " + l + " ms");
            }
        }
        catch (ScriptException scriptException) {
            throw new InitializationException("Failed to init ProxyAutoConfig Nashorn script!", (Throwable)scriptException);
        }
    }
}

