/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.appinfo;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.HCHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap3.alert.BootstrapInfoBox;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.prism.BootstrapPrismJS;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.configfile.ConfigurationFile;
import com.helger.photon.core.configfile.ConfigurationFileManager;
import com.helger.photon.core.configfile.EConfigurationFileSyntax;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.prism.EPrismLanguage;
import com.helger.photon.uictrls.prism.EPrismPlugin;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageAppInfoConfigurationFiles<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageAppInfoConfigurationFiles(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_APPINFO_CONFIG_FILES.getAsMLT());
    }

    public BasePageAppInfoConfigurationFiles(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageAppInfoConfigurationFiles(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageAppInfoConfigurationFiles(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        ConfigurationFileManager configurationFileManager = ConfigurationFileManager.getInstance();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        for (ConfigurationFile configurationFile : configurationFileManager.getAllConfigurationFiles()) {
            HCNodeList hCNodeList2 = new HCNodeList();
            String string = "";
            if (configurationFile.hasDescription()) {
                hCNodeList2.addChild((IHCNode)this.getUIHandler().createDataGroupHeader(configurationFile.getDescription()));
            }
            if (configurationFile.exists()) {
                String string2 = configurationFile.getContentAsString();
                hCNodeList2.addChild((IHCNode)new BootstrapPrismJS(EPrismLanguage.find((EConfigurationFileSyntax)configurationFile.getSyntaxHighlightLanguage())).addPlugin(EPrismPlugin.LINE_NUMBERS).addChild(string2));
            } else {
                hCNodeList2.addChild((IHCNode)new BootstrapErrorBox().addChild(EText.MSG_DOES_NOT_EXIST.getDisplayText(locale)));
                string = " (!)";
            }
            bootstrapTabBox.addTab(HCHelper.getAsHTMLID((String)configurationFile.getID()), configurationFile.getResource().getPath() + string, (IHCNode)hCNodeList2);
        }
        if (bootstrapTabBox.hasNoTabs()) {
            hCNodeList.addChild((IHCNode)new BootstrapInfoBox().addChild(EText.MSG_NO_CONFIG_FILES.getDisplayText(locale)));
        } else {
            hCNodeList.addChild((IHCNode)bootstrapTabBox);
        }
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_DOES_NOT_EXIST("Die Konfigurationsdatei existiert nicht!", "The configuration file does not exist!"),
        MSG_NO_CONFIG_FILES("Es sind keine Konfigurationsdateien registriert.", "No configuration files are registered.");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

