/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.appinfo;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.UITextFormatter;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.web.scope.IGlobalWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageAppInfoGlobalScope<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageAppInfoGlobalScope(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_APPINFO_GLOBAL_SCOPE.getAsMLT());
    }

    public BasePageAppInfoGlobalScope(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageAppInfoGlobalScope(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageAppInfoGlobalScope(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    @Nonnull
    private IHCNode _getGlobalScopeInfo(@Nonnull WPECTYPE WPECTYPE, @Nonnull IGlobalWebScope iGlobalWebScope) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = new HCNodeList();
        BootstrapViewForm bootstrapViewForm = new BootstrapViewForm();
        bootstrapViewForm.setCondensed(true);
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_ID.getDisplayText(locale)).setCtrl(iGlobalWebScope.getID()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_CREATION_DT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)iGlobalWebScope.getCreationDateTime(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_VALID.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iGlobalWebScope.isValid(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_IN_DESTRUCTION.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iGlobalWebScope.isInDestruction(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_DESTROYED.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iGlobalWebScope.isDestroyed(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_ATTRS.getDisplayText(locale)).setCtrl(Integer.toString(iGlobalWebScope.attrs().size())));
        hCNodeList.addChild((IHCNode)bootstrapViewForm);
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_TYPE.getDisplayText(locale)), new DTCol(EText.MSG_VALUE.getDisplayText(locale))}).setID("globalscope");
        for (Map.Entry entry : iGlobalWebScope.attrs().entrySet()) {
            hCTable.addBodyRow().addCell((String)entry.getKey()).addCell(ClassHelper.getClassLocalName(entry.getValue())).addCell(UITextFormatter.getToStringContent(entry.getValue()));
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
        return hCNodeList;
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        IGlobalWebScope iGlobalWebScope = WebScopeManager.getGlobalScope();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        hCNodeList.addChild(this._getGlobalScopeInfo(WPECTYPE, iGlobalWebScope));
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_SCOPE_ID("Kontext ID", "Scope ID"),
        MSG_SCOPE_CREATION_DT("Erstellungszeit", "Creation date time"),
        MSG_SCOPE_VALID("Kontext g\u00fcltig?", "Scope valid?"),
        MSG_SCOPE_IN_DESTRUCTION("Kontext in Zerst\u00f6rung?", "Scope in destruction?"),
        MSG_SCOPE_DESTROYED("Kontext zerst\u00f6rt?", "Scope destroyed?"),
        MSG_SCOPE_ATTRS("Attribute", "Attributes"),
        MSG_NAME("Name", "Wert"),
        MSG_TYPE("Typ", "Type"),
        MSG_VALUE("Wert", "Value");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

