/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.appinfo;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.go.GoMappingItem;
import com.helger.photon.core.go.GoMappingManager;
import com.helger.photon.core.go.GoServlet;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.xservlet.servletstatus.ServletStatusManager;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageAppInfoGo<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private final GoMappingManager m_aGoMappingMgr;

    public BasePageAppInfoGo(@Nonnull @Nonempty String string, @Nonnull GoMappingManager goMappingManager) {
        super(string, EWebPageText.PAGE_NAME_APPINFO_GO.getAsMLT());
        this.m_aGoMappingMgr = (GoMappingManager)ValueEnforcer.notNull((Object)goMappingManager, (String)"GoMappingMgr");
    }

    public BasePageAppInfoGo(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull GoMappingManager goMappingManager) {
        super(string, string2);
        this.m_aGoMappingMgr = (GoMappingManager)ValueEnforcer.notNull((Object)goMappingManager, (String)"GoMappingMgr");
    }

    public BasePageAppInfoGo(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3, @Nonnull GoMappingManager goMappingManager) {
        super(string, string2, string3);
        this.m_aGoMappingMgr = (GoMappingManager)ValueEnforcer.notNull((Object)goMappingManager, (String)"GoMappingMgr");
    }

    public BasePageAppInfoGo(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2, @Nonnull GoMappingManager goMappingManager) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aGoMappingMgr = (GoMappingManager)ValueEnforcer.notNull((Object)goMappingManager, (String)"GoMappingMgr");
    }

    @Nonnull
    protected final GoMappingManager getGoMappingMgr() {
        return this.m_aGoMappingMgr;
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        hCNodeList.addChild((IHCNode)new HCDiv().addChild(EText.MSG_GO_SERVLET.getDisplayText(locale) + EPhotonCoreText.getYesOrNo((boolean)ServletStatusManager.getInstance().isServletRegistered(GoServlet.class), (Locale)locale)));
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_KEY.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_INTERNAL.getDisplayText(locale)).setDataSort(new int[]{1, 0}), new DTCol(EText.MSG_URL.getDisplayText(locale)), new DTCol(EText.MSG_EDITABLE.getDisplayText(locale)).setDataSort(new int[]{3, 0})}).setID(this.getID());
        for (GoMappingItem goMappingItem : this.m_aGoMappingMgr.getAllItems().values()) {
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(goMappingItem.getKey());
            hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)goMappingItem.isInternal(), (Locale)locale));
            hCRow.addCell(HCA.createLinkedWebsite((String)goMappingItem.getTargetURLAsString()));
            hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)goMappingItem.isEditable(), (Locale)locale));
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_GO_SERVLET("GoServlet registriert: ", "GoServlet registered: "),
        MSG_KEY("ID", "ID"),
        MSG_INTERNAL("Intern?", "Internal?"),
        MSG_URL("Ziel-URL", "Target URL"),
        MSG_EDITABLE("Editierbar?", "Editable?");

        @Nonnull
        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

