/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.appinfo;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.grouping.HCLI;
import com.helger.html.hc.html.grouping.HCUL;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.textlevel.HCEM;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.bootstrap3.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap3.alert.BootstrapInfoBox;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.table.BootstrapTable;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerContext;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.impl.matchers.GroupMatcher;
import com.helger.schedule.quartz.QuartzSchedulerHelper;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageAppInfoScheduler<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageAppInfoScheduler(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_APPINFO_SCHEDULER.getAsMLT());
    }

    public BasePageAppInfoScheduler(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageAppInfoScheduler(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageAppInfoScheduler(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        try {
            BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
            for (IScheduler iScheduler : QuartzSchedulerHelper.getSchedulerFactory().getAllSchedulers()) {
                Object object3;
                Object object22;
                BootstrapViewForm bootstrapViewForm;
                HCNodeList hCNodeList2 = new HCNodeList();
                SchedulerContext schedulerContext = iScheduler.getContext();
                if (schedulerContext.isNotEmpty()) {
                    hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.MSG_CONTEXT.getDisplayText(locale)));
                    bootstrapViewForm = new HCTable(new IHCCol[]{HCCol.star(), HCCol.star()});
                    for (Object object22 : schedulerContext.entrySet()) {
                        bootstrapViewForm.addBodyRow().addCells(new String[]{(String)object22.getKey(), object22.getValue().toString()});
                    }
                    hCNodeList2.addChild((IHCNode)bootstrapViewForm);
                }
                bootstrapViewForm = new BootstrapViewForm();
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SUMMARY.getDisplayText(locale)).setCtrl((Iterable)HCExtHelper.nl2divList((String)iScheduler.getMetaData().getSummary())));
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EXECUTING_JOBS.getDisplayText(locale)).setCtrl(Integer.toString(iScheduler.getCurrentlyExecutingJobs().size())));
                CommonsArrayList commonsArrayList = new CommonsArrayList();
                for (Object object3 : iScheduler.getListenerManager().getJobListeners()) {
                    commonsArrayList.add((Object)(object3.getName() + " - " + object3.getClass().getName()));
                }
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_LISTENERS.getDisplayText(locale)).setCtrl((Iterable)HCExtHelper.list2divList((Iterable)commonsArrayList)));
                hCNodeList2.addChild((IHCNode)bootstrapViewForm);
                object22 = new HCUL();
                object3 = iScheduler.getTriggerGroupNames().iterator();
                while (object3.hasNext()) {
                    String string = (String)object3.next();
                    for (TriggerKey triggerKey : iScheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)string))) {
                        ITrigger iTrigger = iScheduler.getTrigger(triggerKey);
                        JobKey jobKey = iTrigger.getJobKey();
                        IJobDetail iJobDetail = iScheduler.getJobDetail(jobKey);
                        HCLI hCLI = (HCLI)object22.addAndReturnItem(jobKey.getName());
                        HCUL hCUL = (HCUL)hCLI.addAndReturnChild((IHCNode)new HCUL());
                        hCUL.addItem(EText.MSG_JOB_CLASS.getDisplayText(locale) + iJobDetail.getJobClass().getName());
                        hCUL.addItem(EText.MSG_TRIGGER_KEY.getDisplayText(locale) + iTrigger.getKey().toString());
                        hCUL.addItem(EText.MSG_START_TIME.getDisplayText(locale) + PDTToString.getAsString((LocalDateTime)PDTFactory.createLocalDateTime((Date)iTrigger.getStartTime()), (Locale)locale));
                        if (iTrigger.getEndTime() != null) {
                            hCUL.addItem(EText.MSG_END_TIME.getDisplayText(locale) + PDTToString.getAsString((LocalDateTime)PDTFactory.createLocalDateTime((Date)iTrigger.getEndTime()), (Locale)locale));
                        }
                        hCUL.addItem(EText.MSG_PREVIOUS_FIRE_TIME.getDisplayText(locale) + PDTToString.getAsString((LocalDateTime)PDTFactory.createLocalDateTime((Date)iTrigger.getPreviousFireTime()), (Locale)locale));
                        hCUL.addItem(EText.MSG_NEXT_FIRE_TIME.getDisplayText(locale) + PDTToString.getAsString((LocalDateTime)PDTFactory.createLocalDateTime((Date)iTrigger.getNextFireTime()), (Locale)locale));
                        BootstrapTable bootstrapTable = new BootstrapTable(new IHCCol[]{HCCol.star(), HCCol.star()});
                        bootstrapTable.setCondensed(true);
                        for (Map.Entry entry : iJobDetail.getJobDataMap().entrySet()) {
                            bootstrapTable.addBodyRow().addCells(new String[]{(String)entry.getKey(), String.valueOf(entry.getValue())});
                        }
                        hCUL.addItem(new IHCNode[]{new HCTextNode(EText.MSG_JOB_DATA.getDisplayText(locale)), bootstrapTable.hasBodyRows() ? bootstrapTable : new HCEM().addChild(EText.MSG_NONE.getDisplayText(locale))});
                    }
                }
                hCNodeList2.addChild((IHCNode)object22);
                bootstrapTabBox.addTab(iScheduler.getSchedulerName(), iScheduler.getSchedulerName(), (IHCNode)hCNodeList2);
            }
            if (bootstrapTabBox.hasNoTabs()) {
                hCNodeList.addChild((IHCNode)new BootstrapInfoBox().addChild(EText.MSG_NOTHING_SCHEDULED.getDisplayText(locale)));
            } else {
                hCNodeList.addChild((IHCNode)bootstrapTabBox);
            }
        }
        catch (SchedulerException schedulerException) {
            hCNodeList.addChild((IHCNode)new BootstrapErrorBox().addChild(schedulerException.getMessage()));
        }
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_CONTEXT("Kontext", "Context"),
        MSG_SUMMARY("Zusammenfassung", "Summary"),
        MSG_EXECUTING_JOBS("Laufende Jobs", "Currently executing jobs"),
        MSG_LISTENERS("Job Listener", "Job listeners"),
        MSG_JOB_CLASS("Job: ", "Job: "),
        MSG_TRIGGER_KEY("Key: ", "Key: "),
        MSG_START_TIME("Startzeit: ", "Start time: "),
        MSG_END_TIME("Endzeit: ", "End time: "),
        MSG_PREVIOUS_FIRE_TIME("Letzter Aufruf: ", "Previous fire time: "),
        MSG_NEXT_FIRE_TIME("N\u00e4chster Aufruf: ", "Next fire time: "),
        MSG_JOB_DATA("JobData: ", "JobData: "),
        MSG_NONE("keine", "none"),
        MSG_NOTHING_SCHEDULED("Es sind keine Tasks geplant", "No actions are scheduled");

        @Nonnull
        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

