/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.appinfo;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.io.file.FileSystemIterator;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCBR;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.app.resource.WebSiteResourceBundleManager;
import com.helger.photon.app.resource.WebSiteResourceBundleSerialized;
import com.helger.photon.app.resource.WebSiteResourceCache;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.button.BootstrapButton;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.table.BootstrapTable;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.resource.ResourceBundleServlet;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageAppInfoWebSiteResourceBundles<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final String ACTION_CHANGE_CACHE_STATE = "changecachestate";
    private static final String ACTION_CHANGE_MERGE_CSS_STATE = "changemergecssstate";
    private static final String ACTION_CHANGE_MERGE_JS_STATE = "changemergejsstate";
    private final WebSiteResourceBundleManager m_aResBundleMgr;

    public BasePageAppInfoWebSiteResourceBundles(@Nonnull @Nonempty String string, @Nonnull WebSiteResourceBundleManager webSiteResourceBundleManager) {
        super(string, EWebPageText.PAGE_NAME_APPINFO_WEBRESBUNDLE.getAsMLT());
        this.m_aResBundleMgr = (WebSiteResourceBundleManager)ValueEnforcer.notNull((Object)webSiteResourceBundleManager, (String)"ResBundleMgr");
    }

    public BasePageAppInfoWebSiteResourceBundles(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull WebSiteResourceBundleManager webSiteResourceBundleManager) {
        super(string, string2);
        this.m_aResBundleMgr = (WebSiteResourceBundleManager)ValueEnforcer.notNull((Object)webSiteResourceBundleManager, (String)"ResBundleMgr");
    }

    public BasePageAppInfoWebSiteResourceBundles(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3, @Nonnull WebSiteResourceBundleManager webSiteResourceBundleManager) {
        super(string, string2, string3);
        this.m_aResBundleMgr = (WebSiteResourceBundleManager)ValueEnforcer.notNull((Object)webSiteResourceBundleManager, (String)"ResBundleMgr");
    }

    public BasePageAppInfoWebSiteResourceBundles(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2, @Nonnull WebSiteResourceBundleManager webSiteResourceBundleManager) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aResBundleMgr = (WebSiteResourceBundleManager)ValueEnforcer.notNull((Object)webSiteResourceBundleManager, (String)"ResBundleMgr");
    }

    @Nonnull
    protected final WebSiteResourceBundleManager getResBundleMgr() {
        return this.m_aResBundleMgr;
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        if (WPECTYPE.hasAction(ACTION_CHANGE_CACHE_STATE)) {
            WebSiteResourceCache.setCacheEnabled((!WebSiteResourceCache.isCacheEnabled() ? 1 : 0) != 0);
            boolean bl = WebSiteResourceCache.isCacheEnabled();
            WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(bl ? EText.MSG_CACHE_NOW_ENABLED.getDisplayText(locale) : EText.MSG_CACHE_NOW_DISABLED.getDisplayText(locale)));
            return;
        }
        if (WPECTYPE.hasAction(ACTION_CHANGE_MERGE_CSS_STATE)) {
            PhotonAppSettings.setMergeCSSResources((!PhotonAppSettings.isMergeCSSResources() ? 1 : 0) != 0);
            boolean bl = PhotonAppSettings.isMergeCSSResources();
            WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(bl ? EText.MSG_MERGE_CSS_NOW_ENABLED.getDisplayText(locale) : EText.MSG_MERGE_CSS_NOW_DISABLED.getDisplayText(locale)));
            return;
        }
        if (WPECTYPE.hasAction(ACTION_CHANGE_MERGE_JS_STATE)) {
            PhotonAppSettings.setMergeJSResources((!PhotonAppSettings.isMergeJSResources() ? 1 : 0) != 0);
            boolean bl = PhotonAppSettings.isMergeJSResources();
            WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(bl ? EText.MSG_MERGE_JS_NOW_ENABLED.getDisplayText(locale) : EText.MSG_MERGE_JS_NOW_DISABLED.getDisplayText(locale)));
            return;
        }
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        boolean bl = WebSiteResourceCache.isCacheEnabled();
        boolean bl2 = ResourceBundleServlet.isServletRegisteredInServletContext();
        boolean bl3 = PhotonAppSettings.isMergeCSSResources();
        boolean bl4 = PhotonAppSettings.isMergeJSResources();
        BootstrapTable bootstrapTable = (BootstrapTable)new BootstrapTable(new IHCCol[]{HCCol.star(), HCCol.star(), bl2 ? HCCol.star() : null}).setStriped(true);
        Object object = bootstrapTable.addBodyRow().addCell(EText.MSG_RESBUNDLE_SERVLET.getDisplayText(locale)).addCell(EPhotonCoreText.getYesOrNo((boolean)bl2, (Locale)locale));
        Object object22 = bootstrapTable.addBodyRow().addCell(EText.MSG_CACHE_ENABLED.getDisplayText(locale)).addCell(EPhotonCoreText.getYesOrNo((boolean)bl, (Locale)locale));
        HCRow hCRow = bootstrapTable.addBodyRow().addCell(EText.MSG_MERGE_CSS_ENABLED.getDisplayText(locale)).addCell(EPhotonCoreText.getYesOrNo((boolean)bl3, (Locale)locale));
        HCRow hCRow2 = bootstrapTable.addBodyRow().addCell(EText.MSG_MERGE_JS_ENABLED.getDisplayText(locale)).addCell(EPhotonCoreText.getYesOrNo((boolean)bl4, (Locale)locale));
        if (bl2) {
            object.addCell();
            object22.addCell((IHCNode)((BootstrapButton)new BootstrapButton().addChild(bl ? EPhotonCoreText.BUTTON_DISABLE.getDisplayText(locale) : EPhotonCoreText.BUTTON_ENABLE.getDisplayText(locale))).setOnClick((ISimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_CHANGE_CACHE_STATE)));
            hCRow.addCell((IHCNode)((BootstrapButton)new BootstrapButton().addChild(bl3 ? EPhotonCoreText.BUTTON_DISABLE.getDisplayText(locale) : EPhotonCoreText.BUTTON_ENABLE.getDisplayText(locale))).setOnClick((ISimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_CHANGE_MERGE_CSS_STATE)));
            hCRow2.addCell((IHCNode)((BootstrapButton)new BootstrapButton().addChild(bl4 ? EPhotonCoreText.BUTTON_DISABLE.getDisplayText(locale) : EPhotonCoreText.BUTTON_ENABLE.getDisplayText(locale))).setOnClick((ISimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_CHANGE_MERGE_JS_STATE)));
        }
        hCNodeList.addChild((IHCNode)bootstrapTable);
        hCNodeList.addChild((IHCNode)new HCBR());
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_DATE.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale), new DTCol(EText.MSG_RESOURCES.getDisplayText(locale)), new DTCol(EText.MSG_COND_COMMENT.getDisplayText(locale)).setDataSort(new int[]{3, 1}), new DTCol(EText.MSG_CSS_MEDIA.getDisplayText(locale)).setDataSort(new int[]{4, 1})}).setID(this.getID());
        ICommonsList iCommonsList = this.m_aResBundleMgr.getAllResourceBundlesSerialized();
        for (WebSiteResourceBundleSerialized webSiteResourceBundleSerialized : iCommonsList) {
            bootstrapTable = hCTable.addBodyRow();
            bootstrapTable.addCell(webSiteResourceBundleSerialized.getBundleID());
            bootstrapTable.addCell(PDTToString.getAsString((LocalDateTime)webSiteResourceBundleSerialized.getCreationDT(), (Locale)locale));
            bootstrapTable.addCell((Iterable)HCExtHelper.list2divList((Iterable)webSiteResourceBundleSerialized.getBundle().getAllResourcePaths()));
            bootstrapTable.addCell(webSiteResourceBundleSerialized.getBundle().getConditionalComment());
            bootstrapTable.addCell(webSiteResourceBundleSerialized.getBundle().hasMediaList() ? webSiteResourceBundleSerialized.getBundle().getMediaList().getMediaString() : null);
        }
        hCNodeList.addChild((IHCNode)hCTable);
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)iterator);
        if (GlobalDebug.isDebugMode()) {
            hCNodeList.addChild((IHCNode)this.getUIHandler().createDataGroupHeader("Resource bundle directory listing"));
            File file = WebFileIO.getDataIO().getFile("resource-bundles/");
            bootstrapTable = (HCTable)new HCTable(new IHCCol[]{new DTCol("Filename"), new DTCol("Active?")}).setID(this.getID() + "2");
            for (Object object22 : new FileSystemIterator(file)) {
                hCRow = bootstrapTable.addBodyRow();
                hCRow.addCell(((File)object22).getName());
                hCRow.addCell(this.m_aResBundleMgr.containsResourceBundleOfID(((File)object22).getName()) ? "yes" : "no");
            }
            hCNodeList.addChild((IHCNode)bootstrapTable);
            object = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)bootstrapTable);
            hCNodeList.addChild((IHCNode)object);
        }
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_CACHE_NOW_ENABLED("Der Cache ist jetzt aktiviert", "Cache is now enabled"),
        MSG_CACHE_NOW_DISABLED("Der Cache ist jetzt deaktiviert", "Cache is now disabled"),
        MSG_MERGE_CSS_NOW_ENABLED("Das Zusammenf\u00fchren von CSS ist jetzt aktiviert", "CSS merging is now enabled"),
        MSG_MERGE_CSS_NOW_DISABLED("Das Zusammenf\u00fchren von CSS ist jetzt deaktiviert", "CSS merging is now disabled"),
        MSG_MERGE_JS_NOW_ENABLED("Das Zusammenf\u00fchren von JS ist jetzt aktiviert", "JS merging is now enabled"),
        MSG_MERGE_JS_NOW_DISABLED("Das Zusammenf\u00fchren von JS ist jetzt deaktiviert", "JS merging is now disabled"),
        MSG_RESBUNDLE_SERVLET("ResourceBundleServlet registriert", "ResourceBundleServlet registered"),
        MSG_CACHE_ENABLED("Cache aktiv", "Cache enabled"),
        MSG_MERGE_CSS_ENABLED("Das Zusammenf\u00fchren von CSS ist aktiviert", "CSS merging is enabled"),
        MSG_MERGE_JS_ENABLED("Das Zusammenf\u00fchren von JS ist aktiviert", "JS merging is enabled"),
        MSG_ID("ID", "ID"),
        MSG_DATE("Datum", "Date"),
        MSG_RESOURCES("Resourcen", "Resources"),
        MSG_COND_COMMENT("Cond Comment", "Cond comment"),
        MSG_CSS_MEDIA("CSS Medien", "CSS media");

        @Nonnull
        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

