/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.data;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.impl.ICommonsNavigableSet;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.masterdata.locale.ContinentHelper;
import com.helger.masterdata.locale.EContinent;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.EUICtrlsCSSPathProvider;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.famfam.EFamFamFlagIcon;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageDataCountries<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageDataCountries(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_DATA_COUNTRIES.getAsMLT());
    }

    public BasePageDataCountries(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageDataCountries(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageDataCountries(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_NAME.getDisplayText(locale)), new DTCol(EText.MSG_CONTINENTS.getDisplayText(locale))}).setID(this.getID());
        for (Locale locale2 : CountryCache.getInstance().getAllCountryLocales()) {
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(locale2.getCountry());
            HCDiv hCDiv = new HCDiv();
            EFamFamFlagIcon eFamFamFlagIcon = EFamFamFlagIcon.getFromIDOrNull((String)locale2.getCountry());
            if (eFamFamFlagIcon != null) {
                hCDiv.addChild((IHCNode)eFamFamFlagIcon.getAsNode());
                hCDiv.addChild(" ");
            }
            hCDiv.addChild(locale2.getDisplayCountry(locale));
            hCRow.addCell((IHCNode)hCDiv);
            ICommonsNavigableSet iCommonsNavigableSet = ContinentHelper.getContinentsOfCountry((Locale)locale2);
            StringBuilder stringBuilder = new StringBuilder();
            if (iCommonsNavigableSet != null) {
                for (EContinent eContinent : iCommonsNavigableSet) {
                    if (eContinent == null) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(eContinent.getDisplayText(locale));
                }
            }
            hCRow.addCell(stringBuilder.toString());
        }
        hCNodeList.addChild((IHCNode)hCTable);
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)iterator);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICtrlsCSSPathProvider.FAMFAM_FLAGS);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_ID("ID", "ID"),
        MSG_NAME("Name", "Name"),
        MSG_CONTINENTS("Kontinente", "Continents");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

