/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.data;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.impl.ICommonsNavigableSet;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.masterdata.currency.CurrencyHelper;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.locale.ContinentHelper;
import com.helger.masterdata.locale.EContinent;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.EUICtrlsCSSPathProvider;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.photon.uictrls.famfam.EFamFamFlagIcon;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageDataCurrencies<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageDataCurrencies(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_DATA_CURRENCIES.getAsMLT());
    }

    public BasePageDataCurrencies(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageDataCurrencies(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageDataCurrencies(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_CODE.getDisplayText(locale)).setDataSort(new int[]{0, 6}).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_NAME.getDisplayText(locale)).setDataSort(new int[]{1, 6}), new DTCol(EText.MSG_SYMBOL.getDisplayText(locale)), new DTCol(EText.MSG_DEFAULT_FRACTION_DIGITS.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_EXAMPLE.getDisplayText(locale)), new DTCol(EText.MSG_CONTINENTS.getDisplayText(locale)), new DTCol(EText.MSG_LOCALE.getDisplayText(locale))}).setID(this.getID());
        for (Map.Entry entry : CurrencyHelper.getLocaleToCurrencyMap().entrySet()) {
            EContinent eContinent2;
            Locale locale2 = (Locale)entry.getKey();
            Currency currency = (Currency)entry.getValue();
            ECurrency eCurrency = ECurrency.getFromIDOrNull((String)currency.getCurrencyCode());
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(currency.getCurrencyCode());
            hCRow.addCell(eCurrency == null ? null : eCurrency.getDisplayText(locale));
            hCRow.addCell(currency.getSymbol(locale));
            hCRow.addCell(Integer.toString(currency.getDefaultFractionDigits()));
            hCRow.addCell(NumberFormat.getCurrencyInstance(locale2).format(12.3456));
            ICommonsNavigableSet iCommonsNavigableSet = ContinentHelper.getContinentsOfCountry((Locale)locale2);
            StringBuilder stringBuilder = new StringBuilder();
            if (iCommonsNavigableSet != null) {
                for (EContinent eContinent2 : iCommonsNavigableSet) {
                    if (eContinent2 == null) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(eContinent2.getDisplayText(locale));
                }
            }
            hCRow.addCell(stringBuilder.toString());
            HCDiv hCDiv = new HCDiv();
            eContinent2 = EFamFamFlagIcon.getFromIDOrNull((String)locale2.getCountry());
            if (eContinent2 != null) {
                hCDiv.addChild((IHCNode)eContinent2.getAsNode());
                hCDiv.addChild(" ");
            }
            hCDiv.addChild(locale2.getDisplayName(locale) + " [" + locale2.toString() + "]");
            hCRow.addCell((IHCNode)hCDiv);
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
        PhotonCSS.registerCSSIncludeForThisRequest((ICSSPathProvider)EUICtrlsCSSPathProvider.FAMFAM_FLAGS);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_CODE("Code", "Code"),
        MSG_NAME("Name", "Name"),
        MSG_SYMBOL("Symbol", "Symbol"),
        MSG_DEFAULT_FRACTION_DIGITS("Nachkommastellen", "Fraction digits"),
        MSG_EXAMPLE("Beispiel", "Example"),
        MSG_CONTINENTS("Kontinente", "Continents"),
        MSG_LOCALE("Locale", "Locale");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

