/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.data;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTConfig;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.time.zone.ZoneRules;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageDataTimeZones<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageDataTimeZones(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_DATA_TIMEZONES.getAsMLT());
    }

    public BasePageDataTimeZones(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageDataTimeZones(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageDataTimeZones(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTime();
        ZoneId zoneId = PDTConfig.getDefaultZoneId();
        hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.MSG_CURRENT_TIMEZONE.getDisplayText(locale) + zoneId.getId() + " - " + zoneId.getDisplayName(TextStyle.FULL, locale)));
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_NAME.getDisplayText(locale)), new DTCol(EText.MSG_SHORTNAME.getDisplayText(locale)), new DTCol(EText.MSG_OFFSET.getDisplayText(locale)).setDisplayType(EDTColType.DURATION, locale), new DTCol(EText.MSG_FIXED.getDisplayText(locale))}).setID(this.getID());
        for (String string : ZoneId.getAvailableZoneIds()) {
            ZoneId zoneId2 = ZoneId.of(string);
            ZoneRules zoneRules = zoneId2.getRules();
            ZoneOffset zoneOffset = zoneRules.getOffset(localDateTime);
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(string);
            hCRow.addCell(zoneId2.getDisplayName(TextStyle.FULL, locale));
            hCRow.addCell(zoneId2.getDisplayName(TextStyle.SHORT, locale));
            hCRow.addCell(Duration.ofSeconds(zoneOffset.getTotalSeconds()).toString());
            hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)zoneRules.isFixedOffset(), (Locale)locale));
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_CURRENT_TIMEZONE("Eingestellte Zeitzone: ", "Time zone set: "),
        MSG_ID("ID", "ID"),
        MSG_NAME("Name", "Name"),
        MSG_SHORTNAME("Kurzer Name", "Short name"),
        MSG_OFFSET("Aktuelle Abweichung", "Current offset"),
        MSG_FIXED("Konstant?", "Fixed?");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

