/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.monitoring;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.id.IHasID;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap3.alert.BootstrapQuestionBox;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPageForm;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandler;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDTColAction;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ISimpleWebExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.photon.security.login.LoginInfo;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.util.SecurityHelper;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.handler.IWebPageActionHandler;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageMonitoringLoginInfo<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPageForm<LoginInfo, WPECTYPE> {
    private static final String ACTION_LOGOUT_USER = "logoutuser";

    private void _init() {
        this.addCustomHandler(ACTION_LOGOUT_USER, (IWebPageActionHandler)new AbstractBootstrapWebPageActionHandler<LoginInfo, WPECTYPE>(true){

            @Nonnull
            public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull LoginInfo loginInfo) {
                if (!BasePageMonitoringLoginInfo.this.canLogoutUser((ISimpleWebExecutionContext)WPECTYPE, loginInfo.getUser())) {
                    throw new IllegalStateException("Won't work!");
                }
                Locale locale = WPECTYPE.getDisplayLocale();
                HCNodeList hCNodeList = WPECTYPE.getNodeList();
                String string = SecurityHelper.getUserDisplayName((IUser)loginInfo.getUser(), (Locale)locale);
                if (WPECTYPE.hasSubAction("perform")) {
                    loginInfo.getSessionScope().selfDestruct();
                    if (loginInfo.isLogout()) {
                        WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.LOGOUT_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{string})));
                    } else {
                        WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapErrorBox().addChild(EText.LOGOUT_ERROR.getDisplayTextWithArgs(locale, new Object[]{string})));
                    }
                    return EShowList.SHOW_LIST;
                }
                BootstrapForm bootstrapForm = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)this.getUIHandler().createFormSelf(WPECTYPE));
                bootstrapForm.addChild((IHCNode)new BootstrapQuestionBox().addChild(EText.LOGOUT_QUESTION.getDisplayTextWithArgs(locale, new Object[]{string})));
                BootstrapButtonToolbar bootstrapButtonToolbar = (BootstrapButtonToolbar)bootstrapForm.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
                bootstrapButtonToolbar.addHiddenField("action", BasePageMonitoringLoginInfo.ACTION_LOGOUT_USER);
                bootstrapButtonToolbar.addHiddenField("object", loginInfo.getID());
                bootstrapButtonToolbar.addHiddenField("action2", "perform");
                bootstrapButtonToolbar.addSubmitButtonYes(locale);
                bootstrapButtonToolbar.addButtonNo(locale);
                return EShowList.DONT_SHOW_LIST;
            }
        });
        this.setObjectLockingEnabled(true);
    }

    public BasePageMonitoringLoginInfo(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_MONITORING_LOGIN_INFO.getAsMLT());
        this._init();
    }

    public BasePageMonitoringLoginInfo(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
        this._init();
    }

    public BasePageMonitoringLoginInfo(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
        this._init();
    }

    public BasePageMonitoringLoginInfo(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
        this._init();
    }

    @Nullable
    protected String getObjectDisplayName(@Nonnull WPECTYPE WPECTYPE, @Nonnull LoginInfo loginInfo) {
        Locale locale = WPECTYPE.getDisplayLocale();
        return SecurityHelper.getUserDisplayName((IUser)loginInfo.getUser(), (Locale)locale);
    }

    @Nullable
    protected LoginInfo getSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nullable String string) {
        return LoggedInUserManager.getInstance().getLoginInfo(string);
    }

    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable LoginInfo loginInfo) {
        if (eWebPageFormAction.isEdit()) {
            return false;
        }
        return super.isActionAllowed(WPECTYPE, eWebPageFormAction, (IHasID)loginInfo);
    }

    protected void showSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull LoginInfo loginInfo) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.HEADER_DETAILS.getDisplayText(locale)));
        BootstrapViewForm bootstrapViewForm = (BootstrapViewForm)hCNodeList.addAndReturnChild((IHCNode)new BootstrapViewForm());
        bootstrapViewForm.setCondensed(true);
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_USERID.getDisplayText(locale)).setCtrl(loginInfo.getUserID()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_USERNAME.getDisplayText(locale)).setCtrl(SecurityHelper.getUserDisplayName((IUser)loginInfo.getUser(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_LOGINDT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)loginInfo.getLoginDT(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_LASTACCESSDT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)loginInfo.getLastAccessDT(), (Locale)locale)));
        if (loginInfo.getLogoutDT() != null) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_LOGOUTDT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)loginInfo.getLogoutDT(), (Locale)locale)));
        }
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SESSION_ID.getDisplayText(locale)).setCtrl(loginInfo.getSessionScope().getID()));
        IStringMap iStringMap = loginInfo.attrs();
        if (iStringMap.isEmpty()) {
            HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_VALUE.getDisplayText(locale))}).setID(loginInfo.getID());
            for (Map.Entry entry : iStringMap.entrySet()) {
                hCTable.addBodyRow().addCells(new String[]{(String)entry.getKey(), (String)entry.getValue()});
            }
            BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_ATTRS.getDisplayText(locale)).setCtrl(new IHCNode[]{hCTable, bootstrapDataTables}));
        }
    }

    protected void validateAndSaveInputParameters(@Nonnull WPECTYPE WPECTYPE, @Nullable LoginInfo loginInfo, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        throw new UnsupportedOperationException();
    }

    protected void showInputForm(@Nonnull WPECTYPE WPECTYPE, @Nullable LoginInfo loginInfo, @Nonnull BootstrapForm bootstrapForm, boolean bl, @Nonnull EWebPageFormAction eWebPageFormAction, @Nonnull FormErrorList formErrorList) {
        throw new UnsupportedOperationException();
    }

    protected final boolean canLogoutUser(@Nonnull ISimpleWebExecutionContext iSimpleWebExecutionContext, @Nullable IUser iUser) {
        if (iUser == null) {
            return false;
        }
        return iUser.isEnabled() && !iUser.isDeleted() && !iUser.isAdministrator() && !iUser.equals(iSimpleWebExecutionContext.getLoggedInUser());
    }

    @Nullable
    @OverrideOnDemand
    protected IHCNode getLogoutUserIcon() {
        return EDefaultIcon.KEY.getIcon().getAsNode();
    }

    protected void showListOfExistingObjects(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        BootstrapButtonToolbar bootstrapButtonToolbar = (BootstrapButtonToolbar)hCNodeList.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_USERNAME.getDisplayText(locale)), new DTCol(EText.MSG_LOGINDT.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale).setInitialSorting(ESortOrder.DESCENDING), new DTCol(EText.MSG_LASTACCESSDT.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale), new BootstrapDTColAction(locale)}).setID(this.getID());
        ICommonsCollection iCommonsCollection = LoggedInUserManager.getInstance().getAllLoginInfos();
        for (LoginInfo loginInfo : iCommonsCollection) {
            SimpleURL simpleURL = BasePageMonitoringLoginInfo.createViewURL(WPECTYPE, (IHasID)loginInfo);
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((IHCNode)new HCA((ISimpleURL)simpleURL).addChild(SecurityHelper.getUserDisplayName((IUser)loginInfo.getUser(), (Locale)locale)));
            hCRow.addCell(PDTToString.getAsString((LocalDateTime)loginInfo.getLoginDT(), (Locale)locale));
            hCRow.addCell(PDTToString.getAsString((LocalDateTime)loginInfo.getLastAccessDT(), (Locale)locale));
            IHCCell iHCCell = hCRow.addCell();
            if (this.canLogoutUser((ISimpleWebExecutionContext)WPECTYPE, loginInfo.getUser())) {
                String string = SecurityHelper.getUserDisplayName((IUser)loginInfo.getUser(), (Locale)locale);
                iHCCell.addChild((IHCNode)((HCA)new HCA((ISimpleURL)((SimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_LOGOUT_USER)).add("object", loginInfo.getID())).setTitle(EText.MSG_LOGOUT_USER.getDisplayTextWithArgs(locale, new Object[]{string}))).addChild(this.getLogoutUserIcon()));
                continue;
            }
            iHCCell.addChild((IHCNode)BasePageMonitoringLoginInfo.createEmptyAction());
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_USERNAME("Benutzername", "User name"),
        MSG_LOGINDT("Anmeldezeit", "Login time"),
        MSG_LASTACCESSDT("Letzter Zugriff", "Last access"),
        HEADER_DETAILS("Details des angemeldeten Benutzers", "Details of logged in user"),
        MSG_USERID("Benutzer-ID", "User ID"),
        MSG_LOGOUTDT("Abmeldezeit", "Logout time"),
        MSG_SESSION_ID("Session-ID", "Session ID"),
        MSG_ATTRS("Attribute", "Attributes"),
        MSG_NAME("Name", "Wert"),
        MSG_VALUE("Wert", "Value"),
        MSG_LOGOUT_USER("Benutzer {0} abmelden", "Log out user {0}"),
        LOGOUT_QUESTION("Sind Sie sicher, dass Sie den Benutzer ''{0}'' abmelden wollen?", "Are you sure you want to log out user ''{0}''?"),
        LOGOUT_SUCCESS("Benutzer ''{0}'' wurde erfolgreich abgemeldet.", "User ''{0}'' was successfully logged out."),
        LOGOUT_ERROR("Benutzer ''{0}'' konnte nicht abgemeldet werden, weil er nicht mehr angemeldet war.", "User ''{0}'' could not be logged out because he was not logged in.");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

