/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.monitoring;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.serialize.SerializationHelper;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPageForm;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDTColAction;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.security.util.SecurityHelper;
import com.helger.photon.uicore.UITextFormatter;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.scope.ISessionScope;
import com.helger.scope.mgr.ScopeSessionManager;
import com.helger.web.scope.ISessionWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageMonitoringSessions<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPageForm<ISessionScope, WPECTYPE> {
    public BasePageMonitoringSessions(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_MONITORING_SESSIONS.getAsMLT());
    }

    public BasePageMonitoringSessions(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageMonitoringSessions(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageMonitoringSessions(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    @Nullable
    protected ISessionScope getSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nullable String string) {
        return ScopeSessionManager.getInstance().getSessionScopeOfID(string);
    }

    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable ISessionScope iSessionScope) {
        if (eWebPageFormAction.isEdit()) {
            return false;
        }
        return super.isActionAllowed(WPECTYPE, eWebPageFormAction, (IHasID)iSessionScope);
    }

    @Nonnull
    private IHCNode _getSessionScopeInfo(@Nonnull WPECTYPE WPECTYPE, @Nonnull ISessionScope iSessionScope) {
        Object object;
        LocalDateTime localDateTime;
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = new HCNodeList();
        boolean bl = iSessionScope.getID().equals(WebScopeManager.getSessionScope().getID());
        BootstrapViewForm bootstrapViewForm = (BootstrapViewForm)hCNodeList.addAndReturnChild((IHCNode)new BootstrapViewForm());
        bootstrapViewForm.setCondensed(true);
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_ID.getDisplayText(locale)).setCtrl(iSessionScope.getID()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_MY_SESSION.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)bl, (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_VALID.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iSessionScope.isValid(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_IN_DESTRUCTION.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iSessionScope.isInDestruction(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_DESTROYED.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iSessionScope.isDestroyed(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_ATTRS.getDisplayText(locale)).setCtrl(Integer.toString(iSessionScope.attrs().size())));
        if (iSessionScope instanceof ISessionWebScope) {
            ISessionWebScope iSessionWebScope = (ISessionWebScope)iSessionScope;
            localDateTime = PDTFactory.createLocalDateTime((long)iSessionWebScope.getSession().getCreationTime());
            object = PDTFactory.createLocalDateTime((long)iSessionWebScope.getSession().getLastAccessedTime());
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_CREATION_DT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)localDateTime, (Locale)locale)));
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_LASTACCESS_DT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)object, (Locale)locale)));
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_SESSION_AGE.getDisplayText(locale)).setCtrl(Duration.between(localDateTime, PDTFactory.getCurrentLocalDateTime()).toString()));
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_SESSION_TIMEOUT.getDisplayText(locale)).setCtrl(EText.MSG_SCOPE_SESSION_TIMEOUT_TEXT.getDisplayTextWithArgs(locale, new Object[]{Long.toString(iSessionWebScope.getSession().getMaxInactiveInterval()), Long.toString(iSessionWebScope.getSession().getMaxInactiveInterval() / 60)})));
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_EXPIRATION_DT.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)((LocalDateTime)object).plusSeconds(iSessionWebScope.getSession().getMaxInactiveInterval()), (Locale)locale)));
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_SCOPE_IS_NEW.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iSessionWebScope.getSession().isNew(), (Locale)locale)));
        }
        boolean bl2 = SecurityHelper.isCurrentUserAssignedToUserGroup((String)"ugadmin");
        localDateTime = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_TYPE.getDisplayText(locale)), new DTCol(EText.MSG_VALUE.getDisplayText(locale))}).setID("sessionscope-" + iSessionScope.getID());
        for (Map.Entry entry : iSessionScope.attrs().entrySet()) {
            Object v = entry.getValue();
            HCRow hCRow = localDateTime.addBodyRow();
            hCRow.addCell((String)entry.getKey()).addCell(ClassHelper.getClassLocalName(entry.getValue()) + (bl2 ? BasePageMonitoringSessions._getUISize(v) : "")).addCell(UITextFormatter.getToStringContent(v));
        }
        hCNodeList.addChild((IHCNode)localDateTime);
        object = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)localDateTime);
        hCNodeList.addChild((IHCNode)object);
        return hCNodeList;
    }

    @Nonnull
    @Nonempty
    private static String _getUISize(Object object) {
        try {
            int n = SerializationHelper.getSerializedByteArray((Serializable)((Serializable)object)).length;
            return " [" + n + " Bytes]";
        }
        catch (RuntimeException runtimeException) {
            return " [unknown - " + runtimeException.getMessage() + "]";
        }
    }

    protected void showSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull ISessionScope iSessionScope) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BACK_TO_OVERVIEW.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.BACK_TO_LIST);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)BasePageMonitoringSessions.createViewURL(WPECTYPE, (IHasID)iSessionScope), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        hCNodeList.addChild(this._getSessionScopeInfo(WPECTYPE, iSessionScope));
    }

    protected void validateAndSaveInputParameters(@Nonnull WPECTYPE WPECTYPE, @Nullable ISessionScope iSessionScope, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        throw new UnsupportedOperationException();
    }

    protected void showInputForm(@Nonnull WPECTYPE WPECTYPE, @Nullable ISessionScope iSessionScope, @Nonnull BootstrapForm bootstrapForm, boolean bl, @Nonnull EWebPageFormAction eWebPageFormAction, @Nonnull FormErrorList formErrorList) {
        throw new UnsupportedOperationException();
    }

    protected void showListOfExistingObjects(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)), new DTCol(EText.MSG_ATTRCOUNT.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_LAST_ACCESS.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale).setInitialSorting(ESortOrder.DESCENDING), new BootstrapDTColAction(locale)}).setID(this.getID());
        String string = WebScopeManager.getSessionScope().getID();
        for (ISessionScope iSessionScope : ScopeSessionManager.getInstance().getAllSessionScopes()) {
            ISessionWebScope iSessionWebScope = iSessionScope instanceof ISessionWebScope ? (ISessionWebScope)iSessionScope : null;
            SimpleURL simpleURL = BasePageMonitoringSessions.createViewURL(WPECTYPE, (IHasID)iSessionScope);
            boolean bl = iSessionScope.getID().equals(string);
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((IHCNode)new HCA((ISimpleURL)simpleURL).addChild(iSessionScope.getID() + (bl ? EText.MSG_MY_SESSION.getDisplayText(locale) : "")));
            hCRow.addCell(Integer.toString(iSessionScope.attrs().size()));
            if (iSessionWebScope != null) {
                hCRow.addCell(PDTToString.getAsString((LocalDateTime)PDTFactory.createLocalDateTime((long)iSessionWebScope.getSession().getLastAccessedTime()), (Locale)locale));
            } else {
                hCRow.addCell();
            }
            hCRow.addCell();
        }
        hCNodeList.addChild((IHCNode)hCTable);
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)iterator);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_SESSION("Session Kontext", "Session scope"),
        MSG_ID("ID", "ID"),
        MSG_ATTRCOUNT("Attribute", "Attributes"),
        MSG_LAST_ACCESS("Letzter Zugriff", "Last access"),
        MSG_SCOPE_ID("Kontext ID", "Scope ID"),
        MSG_SCOPE_MY_SESSION("Meine Session?", "My session?"),
        MSG_SCOPE_VALID("Kontext g\u00fcltig?", "Scope valid?"),
        MSG_SCOPE_IN_DESTRUCTION("Kontext in Zerst\u00f6rung?", "Scope in destruction?"),
        MSG_SCOPE_DESTROYED("Kontext zerst\u00f6rt?", "Scope destroyed?"),
        MSG_SCOPE_ATTRS("Attribute", "Attributes"),
        MSG_SCOPE_CREATION_DT("Erstellungszeit", "Creation date time"),
        MSG_SCOPE_LASTACCESS_DT("Letzter Zugriff", "Last access date time"),
        MSG_SCOPE_SESSION_AGE("Session-Alter", "Session age"),
        MSG_SCOPE_SESSION_TIMEOUT("Session Timeout", "Session timeout"),
        MSG_SCOPE_SESSION_TIMEOUT_TEXT("{0} Sekunden (={1} Minuten)", "{0} seconds (={1} minutes)"),
        MSG_SCOPE_EXPIRATION_DT("Geplanter Ablauf", "Planned expiration date time"),
        MSG_SCOPE_IS_NEW("Neue Session?", "Is new session?"),
        MSG_NAME("Name", "Wert"),
        MSG_TYPE("Typ", "Type"),
        MSG_VALUE("Wert", "Value"),
        MSG_MY_SESSION(" [ich]", " [me]");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

