/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.monitoring;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.statistics.IStatisticsHandlerCache;
import com.helger.commons.statistics.IStatisticsHandlerCounter;
import com.helger.commons.statistics.IStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IStatisticsHandlerKeyedSize;
import com.helger.commons.statistics.IStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.IStatisticsHandlerSize;
import com.helger.commons.statistics.IStatisticsHandlerTimer;
import com.helger.commons.statistics.util.IStatisticsVisitorCallback;
import com.helger.commons.statistics.util.StatisticsVisitor;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageMonitoringStatistics<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageMonitoringStatistics(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_MONITORING_STATISTICS.getAsMLT());
    }

    public BasePageMonitoringStatistics(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageMonitoringStatistics(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageMonitoringStatistics(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        final HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setDataSort(new int[]{0, 1}), new DTCol(EText.MSG_KEY.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_TIMER_MIN.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_TIMER_MAX.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_TIMER_AVG.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_TIMER_SUM.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.DESCENDING)}).setID(this.getID() + "timer");
        final HCTable hCTable2 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setDataSort(new int[]{0, 1}), new DTCol(EText.MSG_KEY.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_MIN.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_MAX.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_AVG.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_SUM.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale)}).setID(this.getID() + "size");
        final HCTable hCTable3 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)).setDataSort(new int[]{0, 1}), new DTCol(EText.MSG_KEY.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_COUNT.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale)}).setID(this.getID() + "counter");
        final HCTable hCTable4 = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_NAME.getDisplayText(locale)), new DTCol(EText.MSG_INVOCATION.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_CACHE_HIT.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_CACHE_MISS.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale).setInitialSorting(ESortOrder.DESCENDING)}).setID(this.getID() + "cache");
        StatisticsVisitor.visitStatistics((IStatisticsVisitorCallback)new IStatisticsVisitorCallback(){

            public void onTimer(@Nonnull String string, @Nonnull IStatisticsHandlerTimer iStatisticsHandlerTimer) {
                if (iStatisticsHandlerTimer.getInvocationCount() > 0) {
                    hCTable.addBodyRow().addCells(new String[]{string, "", Integer.toString(iStatisticsHandlerTimer.getInvocationCount()), Long.toString(iStatisticsHandlerTimer.getMin()), Long.toString(iStatisticsHandlerTimer.getMax()), Long.toString(iStatisticsHandlerTimer.getAverage()), iStatisticsHandlerTimer.getSum().toString()});
                }
            }

            public void onSize(@Nonnull String string, @Nonnull IStatisticsHandlerSize iStatisticsHandlerSize) {
                if (iStatisticsHandlerSize.getInvocationCount() > 0) {
                    hCTable2.addBodyRow().addCells(new String[]{string, "", Integer.toString(iStatisticsHandlerSize.getInvocationCount()), Long.toString(iStatisticsHandlerSize.getMin()), Long.toString(iStatisticsHandlerSize.getMax()), Long.toString(iStatisticsHandlerSize.getAverage()), iStatisticsHandlerSize.getSum().toString()});
                }
            }

            public void onCounter(@Nonnull String string, @Nonnull IStatisticsHandlerCounter iStatisticsHandlerCounter) {
                if (iStatisticsHandlerCounter.getInvocationCount() > 0) {
                    hCTable3.addBodyRow().addCells(new String[]{string, "", Integer.toString(iStatisticsHandlerCounter.getInvocationCount()), Long.toString(iStatisticsHandlerCounter.getCount())});
                }
            }

            public void onCache(@Nonnull String string, @Nonnull IStatisticsHandlerCache iStatisticsHandlerCache) {
                if (iStatisticsHandlerCache.getInvocationCount() > 0) {
                    hCTable4.addBodyRow().addCells(new String[]{string, Integer.toString(iStatisticsHandlerCache.getInvocationCount()), Integer.toString(iStatisticsHandlerCache.getHits()), Integer.toString(iStatisticsHandlerCache.getMisses())});
                }
            }

            public void onKeyedTimer(@Nonnull String string, @Nonnull IStatisticsHandlerKeyedTimer iStatisticsHandlerKeyedTimer) {
                for (String string2 : iStatisticsHandlerKeyedTimer.getAllKeys()) {
                    int n = iStatisticsHandlerKeyedTimer.getInvocationCount(string2);
                    if (n <= 0) continue;
                    hCTable.addBodyRow().addCells(new String[]{string, string2, Integer.toString(n), Long.toString(iStatisticsHandlerKeyedTimer.getMin(string2)), Long.toString(iStatisticsHandlerKeyedTimer.getMax(string2)), Long.toString(iStatisticsHandlerKeyedTimer.getAverage(string2)), iStatisticsHandlerKeyedTimer.getSum(string2).toString()});
                }
            }

            public void onKeyedSize(@Nonnull String string, @Nonnull IStatisticsHandlerKeyedSize iStatisticsHandlerKeyedSize) {
                for (String string2 : iStatisticsHandlerKeyedSize.getAllKeys()) {
                    int n = iStatisticsHandlerKeyedSize.getInvocationCount(string2);
                    if (n <= 0) continue;
                    hCTable2.addBodyRow().addCells(new String[]{string, string2, Integer.toString(n), Long.toString(iStatisticsHandlerKeyedSize.getMin(string2)), Long.toString(iStatisticsHandlerKeyedSize.getMax(string2)), Long.toString(iStatisticsHandlerKeyedSize.getAverage(string2)), iStatisticsHandlerKeyedSize.getSum(string2).toString()});
                }
            }

            public void onKeyedCounter(@Nonnull String string, @Nonnull IStatisticsHandlerKeyedCounter iStatisticsHandlerKeyedCounter) {
                for (String string2 : iStatisticsHandlerKeyedCounter.getAllKeys()) {
                    int n = iStatisticsHandlerKeyedCounter.getInvocationCount(string2);
                    if (n <= 0) continue;
                    hCTable3.addBodyRow().addCells(new String[]{string, string2, Integer.toString(n), Long.toString(iStatisticsHandlerKeyedCounter.getCount(string2))});
                }
            }
        });
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        HCNodeList hCNodeList2 = new HCNodeList();
        hCNodeList2.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList2.addChild((IHCNode)bootstrapDataTables);
        bootstrapTabBox.addTab("timer", EText.MSG_TAB_TIMER.getDisplayText(locale), (IHCNode)hCNodeList2);
        hCNodeList2 = new HCNodeList();
        hCNodeList2.addChild((IHCNode)hCTable2);
        bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable2);
        hCNodeList2.addChild((IHCNode)bootstrapDataTables);
        bootstrapTabBox.addTab("size", EText.MSG_TAB_SIZE.getDisplayText(locale), (IHCNode)hCNodeList2);
        hCNodeList2 = new HCNodeList();
        hCNodeList2.addChild((IHCNode)hCTable3);
        bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable3);
        hCNodeList2.addChild((IHCNode)bootstrapDataTables);
        bootstrapTabBox.addTab("counter", EText.MSG_TAB_COUNTER.getDisplayText(locale), (IHCNode)hCNodeList2);
        hCNodeList2 = new HCNodeList();
        hCNodeList2.addChild((IHCNode)hCTable4);
        bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable4);
        hCNodeList2.addChild((IHCNode)bootstrapDataTables);
        bootstrapTabBox.addTab("cache", EText.MSG_TAB_CACHE.getDisplayText(locale), (IHCNode)hCNodeList2);
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_TAB_TIMER("Zeiten", "Timer"),
        MSG_TAB_SIZE("Gr\u00f6\u00dfe", "Size"),
        MSG_TAB_COUNTER("Z\u00e4hler", "Counter"),
        MSG_TAB_CACHE("Cache", "Cache"),
        MSG_NAME("Name", "Name"),
        MSG_KEY("Schl\u00fcssel", "Key"),
        MSG_INVOCATION("Aufrufe", "Invocations"),
        MSG_TIMER_MIN("Minimum (ms)", "Minimum (ms)"),
        MSG_TIMER_MAX("Maximum (ms)", "Maximum (ms)"),
        MSG_TIMER_AVG("Durchschnitt (ms)", "Average (ms)"),
        MSG_TIMER_SUM("Summe (ms)", "Sum (ms)"),
        MSG_MIN("Minimum", "Minimum"),
        MSG_MAX("Maximum", "Maximum"),
        MSG_AVG("Durchschnitt", "Average"),
        MSG_SUM("Summe", "Sum"),
        MSG_COUNT("Anzahl", "Count"),
        MSG_CACHE_HIT("Cache hit", "Cache hit"),
        MSG_CACHE_MISS("Cache miss", "Cache miss");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

