/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.monitoring;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.sysmigration.SystemMigrationManager;
import com.helger.photon.core.sysmigration.SystemMigrationResult;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageMonitoringSystemMigrations<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private final SystemMigrationManager m_aSystemMigrationMgr;

    public BasePageMonitoringSystemMigrations(@Nonnull @Nonempty String string, @Nonnull SystemMigrationManager systemMigrationManager) {
        super(string, EWebPageText.PAGE_NAME_MONITORING_SYSTEMMIGRATIONS.getAsMLT());
        this.m_aSystemMigrationMgr = (SystemMigrationManager)ValueEnforcer.notNull((Object)systemMigrationManager, (String)"SystemMigrationMgr");
    }

    public BasePageMonitoringSystemMigrations(@Nonnull @Nonempty String string, @Nonnull String string2, @Nonnull SystemMigrationManager systemMigrationManager) {
        super(string, string2);
        this.m_aSystemMigrationMgr = (SystemMigrationManager)ValueEnforcer.notNull((Object)systemMigrationManager, (String)"SystemMigrationMgr");
    }

    public BasePageMonitoringSystemMigrations(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3, @Nonnull SystemMigrationManager systemMigrationManager) {
        super(string, string2, string3);
        this.m_aSystemMigrationMgr = (SystemMigrationManager)ValueEnforcer.notNull((Object)systemMigrationManager, (String)"SystemMigrationMgr");
    }

    public BasePageMonitoringSystemMigrations(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2, @Nonnull SystemMigrationManager systemMigrationManager) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aSystemMigrationMgr = (SystemMigrationManager)ValueEnforcer.notNull((Object)systemMigrationManager, (String)"SystemMigrationMgr");
    }

    @Nonnull
    protected final SystemMigrationManager getSystemMigrationMgr() {
        return this.m_aSystemMigrationMgr;
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapButtonToolbar bootstrapButtonToolbar = new BootstrapButtonToolbar(WPECTYPE);
        bootstrapButtonToolbar.addButton(EPhotonCoreText.BUTTON_REFRESH.getDisplayText(locale), (ISimpleURL)WPECTYPE.getSelfHref(), (IIcon)EDefaultIcon.REFRESH);
        hCNodeList.addChild((IHCNode)bootstrapButtonToolbar);
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)), new DTCol(EText.MSG_DATE.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale).setInitialSorting(ESortOrder.DESCENDING), new DTCol(EText.MSG_SUCCESS.getDisplayText(locale)).setDataSort(new int[]{2, 1}), new DTCol(EText.MSG_ERRORMESSAGE.getDisplayText(locale)).setDataSort(new int[]{3, 2, 1})}).setID(this.getID());
        for (SystemMigrationResult systemMigrationResult : this.m_aSystemMigrationMgr.getAllMigrationResultsFlattened()) {
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell(systemMigrationResult.getID());
            hCRow.addCell(PDTToString.getAsString((LocalDateTime)systemMigrationResult.getExecutionDateTime(), (Locale)locale));
            hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)systemMigrationResult.isSuccess(), (Locale)locale));
            hCRow.addCell(systemMigrationResult.getErrorMessage());
        }
        hCNodeList.addChild((IHCNode)hCTable);
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)iterator);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_ID("ID", "ID"),
        MSG_DATE("Datum", "Date"),
        MSG_SUCCESS("Erfolg?", "Success?"),
        MSG_ERRORMESSAGE("Fehlermeldung", "Error message");

        @Nonnull
        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

