/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.security;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.id.IHasID;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.grouping.HCUL;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.label.BootstrapLabel;
import com.helger.photon.bootstrap3.label.EBootstrapLabelType;
import com.helger.photon.bootstrap3.pages.security.AbstractWebPageSecurityObjectWithAttributes;
import com.helger.photon.bootstrap3.pages.security.SecurityUIHelper;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.revocation.IRevocationStatus;
import com.helger.photon.security.util.SecurityHelper;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractWebPageSecurityToken<DATATYPE extends IHasID<String>, WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPageSecurityObjectWithAttributes<DATATYPE, WPECTYPE> {
    public static final int TOKEN_STRING_MIN_LENGTH = 16;

    public AbstractWebPageSecurityToken(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public AbstractWebPageSecurityToken(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText) {
        super(string, iMultilingualText);
    }

    public AbstractWebPageSecurityToken(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public AbstractWebPageSecurityToken(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    @Nonnull
    public static IHCNode createAccessTokenListUI(@Nonnull List<? extends IAccessToken> list, @Nonnull Locale locale) {
        HCUL hCUL = new HCUL();
        for (IAccessToken iAccessToken : CollectionHelper.getReverseList(list)) {
            IRevocationStatus iRevocationStatus = iAccessToken.getRevocationStatus();
            HCNodeList hCNodeList = new HCNodeList();
            if (iRevocationStatus.isRevoked()) {
                String string = SecurityHelper.getUserDisplayName((String)iRevocationStatus.getRevocationUserID(), (Locale)locale);
                hCNodeList.addChild((IHCNode)new BootstrapLabel(EBootstrapLabelType.DANGER).addChild(EBaseText.SHOW_REVOKED.getDisplayTextWithArgs(locale, new Object[]{string, PDTToString.getAsString((LocalDateTime)iRevocationStatus.getRevocationDateTime(), (Locale)locale), iRevocationStatus.getRevocationReason()})));
            } else if (!iAccessToken.isValidNow()) {
                hCNodeList.addChild((IHCNode)new BootstrapLabel(EBootstrapLabelType.DANGER).addChild(EBaseText.SHOW_INVALID_NOW.getDisplayText(locale)));
            } else {
                hCNodeList.addChild((IHCNode)new BootstrapLabel(EBootstrapLabelType.SUCCESS).addChild(EBaseText.SHOW_VALID_NOW.getDisplayText(locale)));
            }
            hCNodeList.addChild((IHCNode)((HCDiv)new HCDiv().addChild(EBaseText.SHOW_ACCESS_TOKEN.getDisplayText(locale))).addChild(SecurityUIHelper.createAccessTokenNode(iAccessToken.getTokenString())));
            hCNodeList.addChild((IHCNode)new HCDiv().addChild(EBaseText.SHOW_NOT_BEFORE.getDisplayTextWithArgs(locale, new Object[]{PDTToString.getAsString((LocalDateTime)iAccessToken.getNotBefore(), (Locale)locale)})));
            if (iAccessToken.getNotAfter() != null) {
                hCNodeList.addChild((IHCNode)new HCDiv().addChild(EBaseText.SHOW_NOT_BEFORE.getDisplayTextWithArgs(locale, new Object[]{PDTToString.getAsString((LocalDateTime)iAccessToken.getNotAfter(), (Locale)locale)})));
            }
            hCUL.addItem((IHCNode)hCNodeList);
        }
        return hCUL;
    }

    @Translatable
    protected static enum EBaseText implements IHasDisplayTextWithArgs
    {
        LABEL_TOKEN_STRING("Zugriffs-Token", "Access token"),
        HELPTEXT_TOKEN_STRING("Hier kann ein existierender Zugriffs-Token (Mindestl\u00e4nge von 16) von einem anderen System eingegeben werden. Wenn das Feld leer gelassen wird, wird ein neuer zuf\u00e4lliger Zugriffs-Token erstellt.", "An existing access token (minimum length of 16) from another system can be provided here. If the field stays empty, a new random access token is created."),
        LABEL_ACCESS_TOKENS("Zugriffs-Token", "Access tokens"),
        SHOW_REVOKED("Zur\u00fcckgezogen von {0} um {1}; Begr\u00fcndung: {2}", "Revoked by {0} on {1}; reason: {2}"),
        SHOW_INVALID_NOW("Jetzt nicht mehr g\u00fcltig", "Not valid now"),
        SHOW_VALID_NOW("Jetzt g\u00fcltig", "Valid now"),
        SHOW_ACCESS_TOKEN("Zugriffs-Token: ", "Access token: "),
        SHOW_NOT_BEFORE("G\u00fcltig ab: {0}", "Not before: {0}"),
        SHOW_NOT_AFTER("G\u00fcltig bis: {0}", "Not after: {0}"),
        ERR_TOKEN_STRING_TOO_SHORT("Das Zugriffs-Token ist zu kurz. Es muss mindestens 16 Zeichen haben.", "The access token is too short. It must have at least 16 characters."),
        ERR_TOKEN_STRING_IN_USE("Das Zugriffs-Token ist bereits vergeben und kann nicht nochmal vergeben werden.", "The access token is already in use and cannot be assigned again."),
        LABEL_REASON("Begr\u00fcndung", "Reason"),
        ERR_REASON_EMPTY("Es muss eine Bgr\u00fcndung angegeben werden!", "A reason must be provided!"),
        REVOKE_AND_CREATE_NEW_ACCESS_TOKEN_SUCCESS("Das alte Zugriffs-Token von ''{0}'' wurde widerrufen und ein Neues wurde erfolgreich erstellt.", "The old access token of ''{0}'' was revoked and a new access token was successfully created."),
        REVOKE_AND_CREATE_NEW_ACCESS_TOKEN_HEADER("Das alte Zugriffs-Token von ''{0}'' widerrufen und ein Neues erstellen", "Revoke the old access token of ''{0}'' and create a new access token"),
        CREATE_NEW_ACCESS_TOKEN_SUCCESS("Das neue Zugriffs-Token f\u00fcr ''{0}'' wurde erfolgreich erstellt.", "A new access token for ''{0}'' was successfully created."),
        CREATE_NEW_ACCESS_TOKEN_HEADER("Ein neues Zugriffs-Token f\u00fcr ''{0}'' erstellen", "Create a new access token for ''{0}''"),
        REVOKE_ACCESS_TOKEN_SUCCESS("Das alte Zugriffs-Token von ''{0}'' wurde erfolgreich widerrufen.", "The old access token of ''{0}'' was successfully revoked."),
        REVOKE_ACCESS_TOKEN_HEADER("Das alte Zugriffs-Token von ''{0}'' widerrufen", "Revoke the old access token of ''{0}''"),
        TITLE_ACTION_CREATE_NEW_ACCESS_TOKEN("Neuen Zugriffs-Token f\u00fcr ''{0}'' erzeugen", "Create new access token for ''{0}''"),
        TITLE_ACTION_REVOKE_ACCESS_TOKEN("Zugriffs-Token f\u00fcr ''{0}'' zur\u00fcckziehen", "Revoke access token for ''{0}''");

        private final IMultilingualText m_aTP;

        private EBaseText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

