/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.security;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCEditPassword;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.uictrls.ext.BootstrapSecurityUI;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.password.GlobalPasswordSettings;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.util.SecurityHelper;
import com.helger.photon.uicore.html.formlabel.ELabelType;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSecurityChangePassword<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public static final String FIELD_OLD_PASSWORD = "oldpassword";
    public static final String FIELD_NEW_PASSWORD = "newpassword";
    public static final String FIELD_NEW_PASSWORD_CONFIRM = "newpasswordconf";

    public BasePageSecurityChangePassword(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_CHANGE_PASSWORD.getAsMLT());
    }

    public BasePageSecurityChangePassword(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageSecurityChangePassword(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSecurityChangePassword(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        IUser iUser = WPECTYPE.getLoggedInUser();
        if (iUser == null) {
            hCNodeList.addChild((IHCNode)new BootstrapErrorBox().addChild(EText.ERROR_NO_USER_PRESENT.getDisplayText(locale)));
        } else {
            Object object;
            String string;
            String string2;
            Object object2;
            FormErrorList formErrorList = new FormErrorList();
            if (WPECTYPE.hasAction("perform") && this.getCSRFHandler().checkCSRFNonce(WPECTYPE).isContinue()) {
                IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
                object2 = WPECTYPE.params().getAsString((Object)FIELD_OLD_PASSWORD);
                string2 = WPECTYPE.params().getAsString((Object)FIELD_NEW_PASSWORD);
                string = WPECTYPE.params().getAsString((Object)FIELD_NEW_PASSWORD_CONFIRM);
                if (!iUserManager.areUserIDAndPasswordValid((String)iUser.getID(), (String)object2)) {
                    formErrorList.addFieldError(FIELD_OLD_PASSWORD, EText.ERROR_OLD_PASSWORD_INVALID.getDisplayText(locale));
                }
                object = GlobalPasswordSettings.getPasswordConstraintList().getInvalidPasswordDescriptions(string2, locale);
                for (String string3 : object) {
                    formErrorList.addFieldError(FIELD_NEW_PASSWORD, string3);
                }
                if (!EqualsHelper.equals((Object)string2, (Object)string)) {
                    formErrorList.addFieldError(FIELD_NEW_PASSWORD_CONFIRM, EText.ERROR_PASSWORDS_DONT_MATCH.getDisplayText(locale));
                }
                if (formErrorList.isEmpty()) {
                    iUserManager.setUserPassword((String)iUser.getID(), string2);
                    hCNodeList.addChild((IHCNode)new BootstrapSuccessBox().addChild(EText.SUCCESS_CHANGE_PW.getDisplayText(locale)));
                } else {
                    hCNodeList.addChild((IHCNode)this.getUIHandler().createIncorrectInputBox((ILayoutExecutionContext)WPECTYPE));
                }
            }
            boolean bl = GlobalPasswordSettings.getPasswordConstraintList().hasConstraints();
            object2 = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE));
            object2.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.TITLE.getDisplayTextWithArgs(locale, new Object[]{SecurityHelper.getUserDisplayName((IUser)iUser, (Locale)locale)})));
            string2 = EText.LABEL_OLD_PASSWORD.getDisplayText(locale);
            object2.addFormGroup(new BootstrapFormGroup().setLabel(string2, ELabelType.MANDATORY).setCtrl((IHCNode)new HCEditPassword(FIELD_OLD_PASSWORD).setPlaceholder(string2)).setErrorList(formErrorList.getListOfField(FIELD_OLD_PASSWORD)));
            string = EText.LABEL_PASSWORD.getDisplayText(locale);
            object2.addFormGroup(new BootstrapFormGroup().setLabel(string, bl ? ELabelType.MANDATORY : ELabelType.OPTIONAL).setCtrl((IHCNode)new HCEditPassword(FIELD_NEW_PASSWORD).setPlaceholder(string)).setHelpText((Iterable)BootstrapSecurityUI.createPasswordConstraintTip((Locale)locale)).setErrorList(formErrorList.getListOfField(FIELD_NEW_PASSWORD)));
            object = EText.LABEL_PASSWORD_CONFIRM.getDisplayText(locale);
            object2.addFormGroup(new BootstrapFormGroup().setLabel((String)object, bl ? ELabelType.MANDATORY : ELabelType.OPTIONAL).setCtrl((IHCNode)new HCEditPassword(FIELD_NEW_PASSWORD_CONFIRM).setPlaceholder((String)object)).setHelpText((Iterable)BootstrapSecurityUI.createPasswordConstraintTip((Locale)locale)).setErrorList(formErrorList.getListOfField(FIELD_NEW_PASSWORD_CONFIRM)));
            Iterator iterator = (BootstrapButtonToolbar)object2.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
            iterator.addHiddenField("action", "perform");
            iterator.addChild((IHCNode)this.getCSRFHandler().createCSRFNonceField());
            iterator.addSubmitButtonSave(locale);
        }
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        ERROR_NO_USER_PRESENT("Es ist kein Benutzer angemeldet, daher kann auch das Passwort nicht ge\u00e4ndert werden.", "Since no user is logged in no password change is possible."),
        TITLE("Passwort von ''{0}'' \u00e4ndern", "Change password of ''{0}''"),
        LABEL_OLD_PASSWORD("Altes Passwort", "Old password"),
        LABEL_PASSWORD("Neues Passwort", "New password"),
        LABEL_PASSWORD_CONFIRM("Neues Passwort (Best\u00e4tigung)", "New password (confirmation)"),
        ERROR_OLD_PASSWORD_INVALID("Das alte Passwort ist ung\u00fcltig!", "The old password is invalid!"),
        ERROR_PASSWORDS_DONT_MATCH("Die neuen Passw\u00f6rter stimmen nicht \u00fcberein!", "The new passwords don't match"),
        SUCCESS_CHANGE_PW("Das Passwort wurde erfolgreich ge\u00e4ndert!", "Sucessfully changed the password!");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

