/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.security;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.id.IHasID;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.name.IHasName;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.html.textlevel.HCEM;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap3.alert.BootstrapQuestionBox;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandlerDelete;
import com.helger.photon.bootstrap3.pages.security.AbstractWebPageSecurityObjectWithAttributes;
import com.helger.photon.bootstrap3.table.BootstrapTable;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDTColAction;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.role.IRole;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.usergroup.IUserGroupManager;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.handler.IWebPageActionHandler;
import com.helger.photon.uictrls.datatables.column.DTCol;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSecurityRoleManagement<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPageSecurityObjectWithAttributes<IRole, WPECTYPE> {
    private void _init() {
        this.setDeleteHandler((IWebPageActionHandler)new AbstractBootstrapWebPageActionHandlerDelete<IRole, WPECTYPE>(){

            protected void showQuery(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapForm bootstrapForm, @Nonnull IRole iRole) {
                Locale locale = WPECTYPE.getDisplayLocale();
                bootstrapForm.addChild((IHCNode)new BootstrapQuestionBox().addChild(EText.DELETE_QUERY.getDisplayTextWithArgs(locale, new Object[]{iRole.getName()})));
            }

            protected void performAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IRole iRole) {
                Locale locale = WPECTYPE.getDisplayLocale();
                IRoleManager iRoleManager = PhotonSecurityManager.getRoleMgr();
                if (iRoleManager.deleteRole((String)iRole.getID()).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.DELETE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iRole.getName()})));
                } else {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapErrorBox().addChild(EText.DELETE_ERROR.getDisplayTextWithArgs(locale, new Object[]{iRole.getName()})));
                }
            }
        });
    }

    public BasePageSecurityRoleManagement(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SECURITY_ROLES.getAsMLT());
        this._init();
    }

    public BasePageSecurityRoleManagement(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
        this._init();
    }

    public BasePageSecurityRoleManagement(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
        this._init();
    }

    public BasePageSecurityRoleManagement(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
        this._init();
    }

    @Nullable
    protected String getObjectDisplayName(@Nonnull WPECTYPE WPECTYPE, @Nonnull IRole iRole) {
        return iRole.getName();
    }

    @Nullable
    protected IRole getSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nullable String string) {
        IRoleManager iRoleManager = PhotonSecurityManager.getRoleMgr();
        return iRoleManager.getRoleOfID(string);
    }

    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable IRole iRole) {
        if (eWebPageFormAction.isEdit()) {
            return false;
        }
        if (eWebPageFormAction.isDelete()) {
            return BasePageSecurityRoleManagement.canDeleteRole(iRole);
        }
        return !eWebPageFormAction.isUndelete();
    }

    protected void showSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull IRole iRole) {
        CommonsArrayList commonsArrayList;
        HCNodeList hCNodeList;
        HCNodeList hCNodeList2;
        ICommonsList iCommonsList;
        HCNodeList hCNodeList3 = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList3.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.HEADER_DETAILS.getDisplayTextWithArgs(locale, new Object[]{iRole.getName()})));
        BootstrapViewForm bootstrapViewForm = (BootstrapViewForm)hCNodeList3.addAndReturnChild((IHCNode)new BootstrapViewForm());
        bootstrapViewForm.setCondensed(true);
        this.onShowSelectedObjectTableStart(WPECTYPE, bootstrapViewForm, iRole);
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_NAME.getDisplayText(locale)).setCtrl(iRole.getName()));
        if (iRole.hasDescription()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_DESCRIPTION.getDisplayText(locale)).setCtrl((Iterable)HCExtHelper.nl2divList((String)iRole.getDescription())));
        }
        if ((iCommonsList = PhotonSecurityManager.getUserGroupMgr().getAllUserGroupsWithAssignedRole((String)iRole.getID())).isEmpty()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USERGROUPS_0.getDisplayText(locale)).setCtrl((IHCNode)new HCEM().addChild(EText.NONE_ASSIGNED.getDisplayText(locale))));
        } else {
            hCNodeList2 = new HCNodeList();
            iCommonsList.getSortedInline(IHasName.getComparatorCollating((Locale)locale)).forEach(iUserGroup -> {
                HCNodeList cfr_ignored_0 = (HCNodeList)hCNodeList2.addChild((IHCNode)new HCDiv().addChild((IHCNode)new HCA((ISimpleURL)BasePageSecurityRoleManagement.createViewURL((ILayoutExecutionContext)WPECTYPE, (String)"admin_security_usergroup", (String)((String)iUserGroup.getID()), null)).addChild(iUserGroup.getName())));
            });
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USERGROUPS_N.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList.size())})).setCtrl((IHCNode)hCNodeList2));
            hCNodeList = new HCNodeList();
            commonsArrayList = new CommonsArrayList();
            IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
            for (Object object2 : iCommonsList) {
                for (String string : object2.getAllContainedUserIDs()) {
                    commonsArrayList.add((Object)iUserManager.getUserOfID(string));
                }
            }
            commonsArrayList.getSortedInline(IHasDisplayName.getComparatorCollating((Locale)locale)).forEach(iUser -> {
                HCNodeList cfr_ignored_0 = (HCNodeList)hCNodeList.addChild((IHCNode)new HCDiv().addChild((IHCNode)new HCA((ISimpleURL)BasePageSecurityRoleManagement.createViewURL((ILayoutExecutionContext)WPECTYPE, (String)"admin_security_user", (String)((String)iUser.getID()), null)).addChild(iUser.getDisplayName())));
            });
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USERS_N.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(commonsArrayList.size())})).setCtrl((IHCNode)hCNodeList));
        }
        hCNodeList2 = iRole.attrs();
        hCNodeList = this.onShowSelectedObjectCustomAttrs(WPECTYPE, iRole, (Map<String, String>)hCNodeList2, bootstrapViewForm);
        if (hCNodeList2.isNotEmpty()) {
            commonsArrayList = new BootstrapTable(new IHCCol[]{new HCCol(170), HCCol.star()});
            commonsArrayList.addHeaderRow().addCells(new String[]{EText.HEADER_NAME.getDisplayText(locale), EText.HEADER_VALUE.getDisplayText(locale)});
            for (Object object : hCNodeList2.entrySet()) {
                Object object2;
                object2 = (String)object.getKey();
                if (hCNodeList != null && hCNodeList.contains(object2)) continue;
                String string = (String)object.getValue();
                commonsArrayList.addBodyRow().addCells(new String[]{object2, string});
            }
            if (commonsArrayList.hasBodyRows()) {
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ATTRIBUTES.getDisplayText(locale)).setCtrl((IHCNode)commonsArrayList));
            }
        }
        this.onShowSelectedObjectTableEnd(WPECTYPE, bootstrapViewForm, iRole);
    }

    protected void validateAndSaveInputParameters(@Nonnull WPECTYPE WPECTYPE, @Nullable IRole iRole, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        throw new UnsupportedOperationException();
    }

    protected void showInputForm(@Nonnull WPECTYPE WPECTYPE, @Nullable IRole iRole, @Nonnull BootstrapForm bootstrapForm, boolean bl, @Nonnull EWebPageFormAction eWebPageFormAction, @Nonnull FormErrorList formErrorList) {
        throw new UnsupportedOperationException();
    }

    protected static boolean canDeleteRole(@Nullable IRole iRole) {
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        return iRole != null && !iRole.isDeleted() && !((String)iRole.getID()).equals("radmin") && !iUserGroupManager.containsUserGroupWithAssignedRole((String)iRole.getID());
    }

    @Nonnull
    protected IHCNode getTabWithRoles(@Nonnull WPECTYPE WPECTYPE, @Nonnull ICommonsList<IRole> iCommonsList, @Nonnull @Nonempty String string) {
        Locale locale = WPECTYPE.getDisplayLocale();
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol().setVisible(false), new DTCol(EText.HEADER_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.HEADER_IN_USE.getDisplayText(locale)), new BootstrapDTColAction(locale)}).setID(string);
        for (IRole iRole : iCommonsList) {
            SimpleURL simpleURL = BasePageSecurityRoleManagement.createViewURL(WPECTYPE, (IHasID)iRole);
            ICommonsList iCommonsList2 = iUserGroupManager.getAllUserGroupsWithAssignedRole((String)iRole.getID());
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((String)iRole.getID());
            hCRow.addCell((IHCNode)new HCA((ISimpleURL)simpleURL).addChild(iRole.getName()));
            hCRow.addCell(EPhotonCoreText.getYesOrNo((!iCommonsList2.isEmpty() ? 1 : 0) != 0, (Locale)locale));
            IHCCell iHCCell = hCRow.addCell();
            if (BasePageSecurityRoleManagement.canDeleteRole(iRole)) {
                iHCCell.addChild((IHCNode)BasePageSecurityRoleManagement.createDeleteLink(WPECTYPE, (IHasID)iRole, (String)EWebPageText.OBJECT_DELETE.getDisplayTextWithArgs(locale, new Object[]{iRole.getName()})));
                continue;
            }
            iHCCell.addChild((IHCNode)BasePageSecurityRoleManagement.createEmptyAction());
        }
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        return ((HCNodeList)new HCNodeList().addChild((IHCNode)hCTable)).addChild((IHCNode)iterator);
    }

    protected void showListOfExistingObjects(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        IRoleManager iRoleManager = PhotonSecurityManager.getRoleMgr();
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        ICommonsList iCommonsList = iRoleManager.getAll();
        bootstrapTabBox.addTab("active", EText.TAB_ACTIVE.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList.size())}), this.getTabWithRoles(WPECTYPE, (ICommonsList<IRole>)iCommonsList, this.getID() + "1"));
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        TAB_ACTIVE("Aktive Rollen ({0})", "Active roles ({0})"),
        HEADER_NAME("Name", "Name"),
        HEADER_IN_USE("Verwendet?", "In use?"),
        HEADER_VALUE("Wert", "Value"),
        HEADER_DETAILS("Details von Rolle ''{0}''", "Details of role ''{0}''"),
        LABEL_NAME("Name", "Name"),
        LABEL_DESCRIPTION("Beschreibung", "Description"),
        LABEL_USERGROUPS_0("Benutzergruppen", "User groups"),
        LABEL_USERGROUPS_N("Benutzergruppen ({0})", "User groups ({0})"),
        LABEL_USERS_N("Benutzer ({0})", "Users ({0})"),
        LABEL_ATTRIBUTES("Attribute", "Attributes"),
        NONE_ASSIGNED("keine zugeordnet", "none assigned"),
        DELETE_QUERY("Soll die Rolle ''{0}'' wirklich gel\u00f6scht werden?", "Are you sure to delete the role ''{0}''?"),
        DELETE_SUCCESS("Die Rolle ''{0}'' wurden erfolgreich gel\u00f6scht!", "The role ''{0}'' was successfully deleted!"),
        DELETE_ERROR("Fehler beim L\u00f6schen der Rolle ''{0}''!", "Error deleting the role ''{0}''!");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

