/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.security;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.email.EmailAddressHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.id.IHasID;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.name.IHasName;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCA_MailTo;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.forms.HCCheckBox;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.forms.HCEditPassword;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.html.textlevel.HCEM;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.html.request.IHCRequestField;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.photon.bootstrap3.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap3.alert.BootstrapQuestionBox;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandler;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandlerDelete;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandlerUndelete;
import com.helger.photon.bootstrap3.pages.security.AbstractWebPageSecurityObjectWithAttributes;
import com.helger.photon.bootstrap3.pages.security.SecurityUIHelper;
import com.helger.photon.bootstrap3.table.BootstrapTable;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDTColAction;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.bootstrap3.uictrls.ext.BootstrapSecurityUI;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.core.form.RequestFieldBoolean;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.password.GlobalPasswordSettings;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.usergroup.IUserGroupManager;
import com.helger.photon.security.util.SecurityHelper;
import com.helger.photon.uicore.html.formlabel.ELabelType;
import com.helger.photon.uicore.html.select.HCUserGroupForUserSelect;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.handler.IWebPageActionHandler;
import com.helger.photon.uictrls.autosize.HCTextAreaAutosize;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSecurityUserManagement<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPageSecurityObjectWithAttributes<IUser, WPECTYPE> {
    public static final boolean DEFAULT_USER_ENABLED = true;
    public static final String FIELD_FIRSTNAME = "firstname";
    public static final String FIELD_LASTNAME = "lastname";
    public static final String FIELD_LOGINNAME = "loginname";
    public static final String FIELD_EMAILADDRESS = "emailaddress";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_PASSWORD_CONFIRM = "passwordconf";
    public static final String FIELD_ENABLED = "enabled";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_USERGROUPS = "usergroups";
    public static final String ACTION_RESET_PASSWORD = "resetpw";
    private Locale m_aDefaultUserLocale;

    private void _init() {
        this.setDeleteHandler((IWebPageActionHandler)new AbstractBootstrapWebPageActionHandlerDelete<IUser, WPECTYPE>(){

            @OverrideOnDemand
            protected void showQuery(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapForm bootstrapForm, @Nonnull IUser iUser) {
                Locale locale = WPECTYPE.getDisplayLocale();
                bootstrapForm.addChild((IHCNode)new BootstrapQuestionBox().addChild(EText.DELETE_QUERY.getDisplayTextWithArgs(locale, new Object[]{iUser.getDisplayName()})));
            }

            @OverrideOnDemand
            protected void performAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUser iUser) {
                Locale locale = WPECTYPE.getDisplayLocale();
                IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
                if (iUserManager.deleteUser((String)iUser.getID()).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.DELETE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUser.getDisplayName()})));
                } else {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapErrorBox().addChild(EText.DELETE_ERROR.getDisplayTextWithArgs(locale, new Object[]{iUser.getDisplayName()})));
                }
            }
        });
        this.setUndeleteHandler((IWebPageActionHandler)new AbstractBootstrapWebPageActionHandlerUndelete<IUser, WPECTYPE>(){

            @OverrideOnDemand
            protected void showQuery(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapForm bootstrapForm, @Nonnull IUser iUser) {
                Locale locale = WPECTYPE.getDisplayLocale();
                bootstrapForm.addChild((IHCNode)new BootstrapQuestionBox().addChild(EText.UNDELETE_QUERY.getDisplayTextWithArgs(locale, new Object[]{iUser.getDisplayName()})));
            }

            @OverrideOnDemand
            protected void performAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUser iUser) {
                Locale locale = WPECTYPE.getDisplayLocale();
                IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
                if (iUserManager.undeleteUser((String)iUser.getID()).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.UNDELETE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUser.getDisplayName()})));
                } else {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapErrorBox().addChild(EText.UNDELETE_ERROR.getDisplayTextWithArgs(locale, new Object[]{iUser.getDisplayName()})));
                }
            }
        });
        this.addCustomHandler(ACTION_RESET_PASSWORD, (IWebPageActionHandler)new AbstractBootstrapWebPageActionHandler<IUser, WPECTYPE>(true){

            public boolean canHandleAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUser iUser) {
                return SecurityUIHelper.canResetPassword(iUser);
            }

            @Nonnull
            public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUser iUser) {
                String string3;
                Object object;
                Object object2;
                HCNodeList hCNodeList = WPECTYPE.getNodeList();
                Locale locale = WPECTYPE.getDisplayLocale();
                FormErrorList formErrorList = new FormErrorList();
                IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
                if (WPECTYPE.hasSubAction("perform") && BasePageSecurityUserManagement.this.getCSRFHandler().checkCSRFNonce(WPECTYPE).isContinue()) {
                    String string2 = WPECTYPE.params().getAsString((Object)BasePageSecurityUserManagement.FIELD_PASSWORD);
                    object2 = WPECTYPE.params().getAsString((Object)BasePageSecurityUserManagement.FIELD_PASSWORD_CONFIRM);
                    object = GlobalPasswordSettings.getPasswordConstraintList().getInvalidPasswordDescriptions(string2, locale);
                    for (String string3 : object) {
                        formErrorList.addFieldError(BasePageSecurityUserManagement.FIELD_PASSWORD, string3);
                    }
                    if (!EqualsHelper.equals((Object)string2, (Object)object2)) {
                        formErrorList.addFieldError(BasePageSecurityUserManagement.FIELD_PASSWORD_CONFIRM, EText.ERROR_PASSWORDS_DONT_MATCH.getDisplayText(locale));
                    }
                    if (formErrorList.isEmpty()) {
                        iUserManager.setUserPassword((String)iUser.getID(), string2);
                        WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.SUCCESS_RESET_PASSWORD.getDisplayTextWithArgs(locale, new Object[]{SecurityHelper.getUserDisplayName((IUser)iUser, (Locale)locale)})));
                        return EShowList.SHOW_LIST;
                    }
                }
                boolean bl = GlobalPasswordSettings.getPasswordConstraintList().hasConstraints();
                object2 = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)this.getUIHandler().createFormSelf(WPECTYPE));
                object2.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.TITLE_RESET_PASSWORD.getDisplayTextWithArgs(locale, new Object[]{SecurityHelper.getUserDisplayName((IUser)iUser, (Locale)locale)})));
                object = EText.LABEL_PASSWORD.getDisplayText(locale);
                object2.addFormGroup(new BootstrapFormGroup().setLabel((String)object, bl ? ELabelType.MANDATORY : ELabelType.OPTIONAL).setCtrl((IHCNode)new HCEditPassword(BasePageSecurityUserManagement.FIELD_PASSWORD).setPlaceholder((String)object)).setHelpText((Iterable)BootstrapSecurityUI.createPasswordConstraintTip((Locale)locale)).setErrorList(formErrorList.getListOfField(BasePageSecurityUserManagement.FIELD_PASSWORD)));
                String string4 = EText.LABEL_PASSWORD_CONFIRM.getDisplayText(locale);
                object2.addFormGroup(new BootstrapFormGroup().setLabel(string4, bl ? ELabelType.MANDATORY : ELabelType.OPTIONAL).setCtrl((IHCNode)new HCEditPassword(BasePageSecurityUserManagement.FIELD_PASSWORD_CONFIRM).setPlaceholder(string4)).setHelpText((Iterable)BootstrapSecurityUI.createPasswordConstraintTip((Locale)locale)).setErrorList(formErrorList.getListOfField(BasePageSecurityUserManagement.FIELD_PASSWORD_CONFIRM)));
                string3 = (BootstrapButtonToolbar)object2.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
                string3.addHiddenField("action", BasePageSecurityUserManagement.ACTION_RESET_PASSWORD);
                string3.addHiddenField("object", (String)iUser.getID());
                string3.addHiddenField("action2", "perform");
                string3.addChild((IHCNode)BasePageSecurityUserManagement.this.getCSRFHandler().createCSRFNonceField());
                string3.addSubmitButtonSave(locale);
                string3.addButtonCancel(locale);
                return EShowList.DONT_SHOW_LIST;
            }
        });
    }

    public BasePageSecurityUserManagement(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SECURITY_USERS.getAsMLT());
        this._init();
    }

    public BasePageSecurityUserManagement(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
        this._init();
    }

    public BasePageSecurityUserManagement(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
        this._init();
    }

    public BasePageSecurityUserManagement(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
        this._init();
    }

    @Nonnull
    public BasePageSecurityUserManagement<WPECTYPE> setDefaultUserLocale(@Nullable Locale locale) {
        this.m_aDefaultUserLocale = locale;
        return this;
    }

    @OverrideOnDemand
    protected boolean useEmailAddressAsLoginName() {
        return true;
    }

    @OverrideOnDemand
    protected boolean isLastNameMandatory() {
        return true;
    }

    @OverrideOnDemand
    protected boolean isEmailMandatory() {
        return true;
    }

    @Nullable
    protected String getObjectDisplayName(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUser iUser) {
        Locale locale = WPECTYPE.getDisplayLocale();
        return SecurityHelper.getUserDisplayName((IUser)iUser, (Locale)locale);
    }

    @Nullable
    protected IUser getSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nullable String string) {
        IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
        return iUserManager.getUserOfID(string);
    }

    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable IUser iUser) {
        if (eWebPageFormAction.isEdit()) {
            return SecurityUIHelper.canBeEdited(iUser);
        }
        if (eWebPageFormAction.isDelete()) {
            return SecurityUIHelper.canBeDeleted(iUser);
        }
        if (eWebPageFormAction.isUndelete()) {
            return SecurityUIHelper.canBeUndeleted(iUser);
        }
        return true;
    }

    @Override
    @OverrideOnDemand
    protected void onShowSelectedObjectTableStart(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapViewForm bootstrapViewForm, @Nonnull IUser iUser) {
        Locale locale = WPECTYPE.getDisplayLocale();
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_CREATIONDATE.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)iUser.getCreationDateTime(), (Locale)locale)));
        if (iUser.hasLastModificationDateTime()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_LASTMODIFICATIONDATE.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)iUser.getLastModificationDateTime(), (Locale)locale)));
        }
        if (iUser.hasDeletionDateTime()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_DELETIONDATE.getDisplayText(locale)).setCtrl(PDTToString.getAsString((LocalDateTime)iUser.getDeletionDateTime(), (Locale)locale)));
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    protected void showSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUser iUser) {
        HCNodeList hCNodeList;
        HCNodeList hCNodeList2;
        HCNodeList hCNodeList3 = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        hCNodeList3.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.HEADER_DETAILS.getDisplayTextWithArgs(locale, new Object[]{SecurityHelper.getUserDisplayName((IUser)iUser, (Locale)locale)})));
        BootstrapViewForm bootstrapViewForm = (BootstrapViewForm)hCNodeList3.addAndReturnChild((IHCNode)new BootstrapViewForm());
        bootstrapViewForm.setCondensed(true);
        this.onShowSelectedObjectTableStart(WPECTYPE, bootstrapViewForm, iUser);
        if (!this.useEmailAddressAsLoginName()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_LOGINNAME.getDisplayText(locale)).setCtrl(iUser.getLoginName()));
        }
        if (iUser.hasFirstName()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_FIRSTNAME.getDisplayText(locale)).setCtrl(iUser.getFirstName()));
        }
        if (iUser.hasLastName()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_LASTNAME.getDisplayText(locale)).setCtrl(iUser.getLastName()));
        }
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_EMAIL.getDisplayText(locale)).setCtrl((IHCNode)HCA_MailTo.createLinkedEmail((String)iUser.getEmailAddress())));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ENABLED.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iUser.isEnabled(), (Locale)locale)));
        if (StringHelper.hasText((String)iUser.getDescription())) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_DESCRIPTION.getDisplayText(locale)).setCtrl((Iterable)HCExtHelper.nl2divList((String)iUser.getDescription())));
        }
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_DELETED.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iUser.isDeleted(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_LAST_LOGIN.getDisplayText(locale)).setCtrl((IHCNode)(iUser.getLastLoginDateTime() != null ? new HCTextNode(PDTToString.getAsString((LocalDateTime)iUser.getLastLoginDateTime(), (Locale)locale)) : new HCEM().addChild(EText.LABEL_LAST_LOGIN_NEVER.getDisplayText(locale)))));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_LOGIN_COUNT.getDisplayText(locale)).setCtrl(Integer.toString(iUser.getLoginCount())));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_CONSECUTIVE_FAILED_LOGIN_COUNT.getDisplayText(locale)).setCtrl(Integer.toString(iUser.getConsecutiveFailedLoginCount())));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_PASSWORD_HASH_ALGORITHM.getDisplayText(locale)).setCtrl(iUser.getPasswordHash().getAlgorithmName()));
        ICommonsList iCommonsList = iUserGroupManager.getAllUserGroupsWithAssignedUser((String)iUser.getID());
        if (iCommonsList.isEmpty()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USERGROUPS_0.getDisplayText(locale)).setCtrl((IHCNode)new HCEM().addChild(EText.NONE_DEFINED.getDisplayText(locale))));
        } else {
            hCNodeList2 = new HCNodeList();
            CollectionHelper.getSorted((Collection)iCommonsList, (Comparator)IHasName.getComparatorCollating((Locale)locale)).forEach(iUserGroup -> {
                HCNodeList cfr_ignored_0 = (HCNodeList)hCNodeList2.addChild((IHCNode)new HCDiv().addChild((IHCNode)new HCA((ISimpleURL)BasePageSecurityUserManagement.createViewURL((ILayoutExecutionContext)WPECTYPE, (String)"admin_security_usergroup", (String)((String)iUserGroup.getID()), null)).addChild(iUserGroup.getName())));
            });
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USERGROUPS_N.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList.size())})).setCtrl((IHCNode)hCNodeList2));
        }
        hCNodeList2 = SecurityHelper.getAllUserRoles((String)((String)iUser.getID()));
        if (hCNodeList2.isEmpty()) {
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ROLES_0.getDisplayText(locale)).setCtrl((IHCNode)new HCEM().addChild(EText.NONE_DEFINED.getDisplayText(locale))));
        } else {
            hCNodeList = new HCNodeList();
            CollectionHelper.getSorted((Collection)hCNodeList2, (Comparator)IHasName.getComparatorCollating((Locale)locale)).forEach(iRole -> {
                HCNodeList cfr_ignored_0 = (HCNodeList)hCNodeList.addChild((IHCNode)new HCDiv().addChild((IHCNode)new HCA((ISimpleURL)BasePageSecurityUserManagement.createViewURL((ILayoutExecutionContext)WPECTYPE, (String)"admin_security_role", (String)((String)iRole.getID()), null)).addChild(iRole.getName())));
            });
            bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ROLES_N.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(hCNodeList2.size())})).setCtrl((IHCNode)hCNodeList));
        }
        hCNodeList = iUser.attrs();
        ICommonsSet<String> iCommonsSet = this.onShowSelectedObjectCustomAttrs(WPECTYPE, iUser, (Map<String, String>)hCNodeList, bootstrapViewForm);
        if (hCNodeList.isNotEmpty()) {
            BootstrapTable bootstrapTable = new BootstrapTable(new IHCCol[]{new HCCol(170), HCCol.star()});
            bootstrapTable.addHeaderRow().addCells(new String[]{EText.HEADER_NAME.getDisplayText(locale), EText.HEADER_VALUE.getDisplayText(locale)});
            for (Map.Entry entry : hCNodeList.entrySet()) {
                String string = (String)entry.getKey();
                if (iCommonsSet != null && iCommonsSet.contains((Object)string)) continue;
                String string2 = (String)entry.getValue();
                bootstrapTable.addBodyRow().addCells(new String[]{string, string2});
            }
            if (bootstrapTable.hasBodyRows()) {
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ATTRIBUTES.getDisplayText(locale)).setCtrl((IHCNode)bootstrapTable));
            }
        }
        this.onShowSelectedObjectTableEnd(WPECTYPE, bootstrapViewForm, iUser);
    }

    protected void validateAndSaveInputParameters(@Nonnull WPECTYPE WPECTYPE, @Nullable IUser iUser, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        ICommonsMap<String, String> iCommonsMap;
        ICommonsList iCommonsList;
        boolean bl = eWebPageFormAction.isEdit();
        Locale locale = WPECTYPE.getDisplayLocale();
        boolean bl2 = bl && iUser != null && iUser.isAdministrator();
        IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        String string = WPECTYPE.params().getAsString((Object)FIELD_LOGINNAME);
        String string2 = WPECTYPE.params().getAsString((Object)FIELD_FIRSTNAME);
        String string3 = WPECTYPE.params().getAsString((Object)FIELD_LASTNAME);
        String string4 = WPECTYPE.params().getAsString((Object)FIELD_EMAILADDRESS);
        String string5 = WPECTYPE.params().getAsString((Object)FIELD_PASSWORD);
        String string6 = WPECTYPE.params().getAsString((Object)FIELD_PASSWORD_CONFIRM);
        boolean bl3 = bl2 ? true : WPECTYPE.params().isCheckBoxChecked(FIELD_ENABLED, true);
        String string7 = WPECTYPE.params().getAsString((Object)FIELD_DESCRIPTION);
        ICommonsList iCommonsList2 = iCommonsList = bl2 ? iUserGroupManager.getAllUserGroupIDsWithAssignedUser((String)iUser.getID()) : WPECTYPE.params().getAsStringList((Object)FIELD_USERGROUPS);
        if (this.useEmailAddressAsLoginName()) {
            string = string4;
        } else if (StringHelper.hasNoText((String)string)) {
            formErrorList.addFieldError(FIELD_LOGINNAME, EText.ERROR_LOGINNAME_REQUIRED.getDisplayText(locale));
        }
        if (StringHelper.hasNoText((String)string3) && this.isLastNameMandatory()) {
            formErrorList.addFieldError(FIELD_LASTNAME, EText.ERROR_LASTNAME_REQUIRED.getDisplayText(locale));
        }
        if (StringHelper.hasNoText((String)string4)) {
            if (this.isEmailMandatory()) {
                formErrorList.addFieldError(FIELD_EMAILADDRESS, EText.ERROR_EMAIL_REQUIRED.getDisplayText(locale));
            }
        } else if (!EmailAddressHelper.isValid((String)string4)) {
            formErrorList.addFieldError(FIELD_EMAILADDRESS, EText.ERROR_EMAIL_INVALID.getDisplayText(locale));
        } else {
            iCommonsMap = iUserManager.getUserOfLoginName(string4);
            if (!(iCommonsMap == null || bl && iCommonsMap.equals((Object)iUser))) {
                formErrorList.addFieldError(FIELD_EMAILADDRESS, EText.ERROR_EMAIL_IN_USE.getDisplayText(locale));
            }
        }
        if (!bl) {
            iCommonsMap = GlobalPasswordSettings.getPasswordConstraintList().getInvalidPasswordDescriptions(string5, locale);
            for (Object object3 : iCommonsMap) {
                formErrorList.addFieldError(FIELD_PASSWORD, (String)object3);
            }
            if (!EqualsHelper.equals((Object)string5, (Object)string6)) {
                formErrorList.addFieldError(FIELD_PASSWORD_CONFIRM, EText.ERROR_PASSWORDS_DONT_MATCH.getDisplayText(locale));
            }
        }
        if (CollectionHelper.isEmpty((Collection)iCommonsList)) {
            formErrorList.addFieldError(FIELD_USERGROUPS, EText.ERROR_NO_USERGROUP.getDisplayText(locale));
        } else if (!iUserGroupManager.containsAllIDs((Iterable)iCommonsList)) {
            formErrorList.addFieldError(FIELD_USERGROUPS, EText.ERROR_INVALID_USERGROUPS.getDisplayText(locale));
        }
        iCommonsMap = this.validateCustomInputParameters(WPECTYPE, iUser, formErrorList, eWebPageFormAction);
        if (formErrorList.isEmpty()) {
            Object object;
            if (bl) {
                Object object22;
                Object object3;
                object = (String)iUser.getID();
                object3 = iUser.attrs().getClone();
                if (iCommonsMap != null) {
                    object3.putAll(iCommonsMap);
                }
                iUserManager.setUserData((String)object, string, string4, string2, string3, string7, this.m_aDefaultUserLocale, (Map)object3, !bl3);
                ICommonsList iCommonsList3 = iUserGroupManager.getAllUserGroupIDsWithAssignedUser((String)object);
                ICommonsSet iCommonsSet = CollectionHelper.getDifference((Collection)iCommonsList, (Collection)iCommonsList3);
                for (Object object22 : iCommonsSet) {
                    iUserGroupManager.assignUserToUserGroup((String)object22, (String)object);
                }
                Iterator iterator = CollectionHelper.getDifference((Collection)iCommonsList3, (Collection)iCommonsList);
                object22 = iterator.iterator();
                while (object22.hasNext()) {
                    String string8 = (String)object22.next();
                    iUserGroupManager.unassignUserFromUserGroup(string8, (String)object);
                }
                WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.SUCCESS_EDIT.getDisplayText(locale)));
            } else {
                object = iUserManager.createNewUser(string, string4, string5, string2, string3, string7, this.m_aDefaultUserLocale, iCommonsMap, !bl3);
                if (object != null) {
                    for (String string9 : iCommonsList) {
                        iUserGroupManager.assignUserToUserGroup(string9, (String)object.getID());
                    }
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.SUCCESS_CREATE.getDisplayText(locale)));
                } else {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapErrorBox().addChild(EText.FAILURE_CREATE.getDisplayText(locale)));
                }
            }
        }
    }

    @OverrideOnDemand
    protected void showInputFormModifyUserGroupSelect(@Nonnull HCUserGroupForUserSelect hCUserGroupForUserSelect) {
    }

    protected void showInputForm(@Nonnull WPECTYPE WPECTYPE, @Nullable IUser iUser, @Nonnull BootstrapForm bootstrapForm, boolean bl, @Nonnull EWebPageFormAction eWebPageFormAction, @Nonnull FormErrorList formErrorList) {
        String string;
        String string2;
        boolean bl2 = eWebPageFormAction.isEdit();
        boolean bl3 = bl2 && iUser != null && iUser.isAdministrator();
        Locale locale = WPECTYPE.getDisplayLocale();
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        bootstrapForm.addChild((IHCNode)this.getUIHandler().createActionHeader(bl2 ? EText.TITLE_EDIT.getDisplayTextWithArgs(locale, new Object[]{SecurityHelper.getUserDisplayName((IUser)iUser, (Locale)locale)}) : EText.TITLE_CREATE.getDisplayText(locale)));
        if (!this.useEmailAddressAsLoginName()) {
            string2 = EText.LABEL_LOGINNAME.getDisplayText(locale);
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(string2).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_LOGINNAME, iUser == null ? null : iUser.getLoginName())).setPlaceholder(string2)).setErrorList(formErrorList.getListOfField(FIELD_LOGINNAME)));
        }
        string2 = EText.LABEL_FIRSTNAME.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string2).setCtrl((IHCNode)((HCEdit)new HCEdit((IHCRequestField)new RequestField(FIELD_FIRSTNAME, iUser == null ? null : iUser.getFirstName())).setPlaceholder(string2)).setAutoFocus(eWebPageFormAction.isCreate())).setErrorList(formErrorList.getListOfField(FIELD_FIRSTNAME)));
        string2 = EText.LABEL_LASTNAME.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string2, this.isLastNameMandatory() ? ELabelType.MANDATORY : ELabelType.OPTIONAL).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_LASTNAME, iUser == null ? null : iUser.getLastName())).setPlaceholder(string2)).setErrorList(formErrorList.getListOfField(FIELD_LASTNAME)));
        string2 = EText.LABEL_EMAIL.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string2, this.isEmailMandatory() ? ELabelType.MANDATORY : ELabelType.OPTIONAL).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_EMAILADDRESS, iUser == null ? null : iUser.getEmailAddress())).setPlaceholder(string2)).setErrorList(formErrorList.getListOfField(FIELD_EMAILADDRESS)));
        if (!bl2) {
            boolean bl4 = GlobalPasswordSettings.getPasswordConstraintList().hasConstraints();
            string = EText.LABEL_PASSWORD.getDisplayText(locale);
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string, bl4 ? ELabelType.MANDATORY : ELabelType.OPTIONAL).setCtrl((IHCNode)new HCEditPassword(FIELD_PASSWORD).setPlaceholder(string)).setHelpText((Iterable)BootstrapSecurityUI.createPasswordConstraintTip((Locale)locale)).setErrorList(formErrorList.getListOfField(FIELD_PASSWORD)));
            String string3 = EText.LABEL_PASSWORD_CONFIRM.getDisplayText(locale);
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string3, bl4 ? ELabelType.MANDATORY : ELabelType.OPTIONAL).setCtrl((IHCNode)new HCEditPassword(FIELD_PASSWORD_CONFIRM).setPlaceholder(string3)).setHelpText((Iterable)BootstrapSecurityUI.createPasswordConstraintTip((Locale)locale)).setErrorList(formErrorList.getListOfField(FIELD_PASSWORD_CONFIRM)));
        }
        if (bl3) {
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ENABLED.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iUser.isEnabled(), (Locale)locale)));
        } else {
            bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(EText.LABEL_ENABLED.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_ENABLED, iUser == null ? true : iUser.isEnabled()))).setErrorList(formErrorList.getListOfField(FIELD_ENABLED)));
        }
        String string4 = EText.LABEL_DESCRIPTION.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string4).setCtrl((IHCNode)new HCTextAreaAutosize((IHCRequestField)new RequestField(FIELD_DESCRIPTION, iUser == null ? null : iUser.getDescription())).setPlaceholder(string4)).setErrorList(formErrorList.getListOfField(FIELD_DESCRIPTION)));
        string4 = iUser == null ? WPECTYPE.params().getAsStringList((Object)FIELD_USERGROUPS) : iUserGroupManager.getAllUserGroupIDsWithAssignedUser((String)iUser.getID());
        string = new HCUserGroupForUserSelect(new RequestField(FIELD_USERGROUPS), (Collection)((Object)string4));
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(EText.LABEL_USERGROUPS_0.getDisplayText(locale)).setCtrl((IHCNode)string).setErrorList(formErrorList.getListOfField(FIELD_USERGROUPS)));
        if (bl3) {
            string.setReadOnly(true);
        }
        this.showInputFormModifyUserGroupSelect((HCUserGroupForUserSelect)string);
        this.onShowInputFormEnd(WPECTYPE, iUser, bootstrapForm, eWebPageFormAction, formErrorList);
    }

    @Nullable
    @OverrideOnDemand
    protected IHCNode getResetPasswordIcon() {
        return EDefaultIcon.KEY.getIcon().getAsNode();
    }

    @Nonnull
    protected IHCNode getTabWithUsers(@Nonnull WPECTYPE WPECTYPE, @Nonnull ICommonsList<IUser> iCommonsList, @Nonnull @Nonempty String string) {
        Locale locale = WPECTYPE.getDisplayLocale();
        boolean bl = !this.useEmailAddressAsLoginName();
        IUserGroupManager iUserGroupManager = PhotonSecurityManager.getUserGroupMgr();
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol().setVisible(false), new DTCol(EText.HEADER_NAME.getDisplayText(locale)), bl ? new DTCol(EText.HEADER_LOGINNAME.getDisplayText(locale)) : null, new DTCol(EText.HEADER_EMAIL.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.HEADER_USERGROUPS.getDisplayText(locale)), new DTCol(EText.HEADER_LAST_LOGIN.getDisplayText(locale)).setDisplayType(EDTColType.DATETIME, locale), new BootstrapDTColAction(locale)}).setID(string);
        for (IUser iUser : iCommonsList) {
            SimpleURL simpleURL = BasePageSecurityUserManagement.createViewURL(WPECTYPE, (IHasID)iUser);
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((String)iUser.getID());
            hCRow.addCell((IHCNode)new HCA((ISimpleURL)simpleURL).addChild(SecurityHelper.getUserDisplayName((IUser)iUser, (Locale)locale)));
            if (bl) {
                hCRow.addCell(iUser.getLoginName());
            }
            hCRow.addCell((IHCNode)HCA_MailTo.createLinkedEmail((String)iUser.getEmailAddress()));
            IHCCell iHCCell = hCRow.addCell();
            iUserGroupManager.getAllUserGroupsWithAssignedUser((String)iUser.getID()).getSorted(IHasName.getComparatorCollating((Locale)locale)).forEach(iUserGroup -> {
                IHCCell cfr_ignored_0 = (IHCCell)iHCCell.addChild((IHCNode)new HCDiv().addChild((IHCNode)new HCA((ISimpleURL)BasePageSecurityUserManagement.createViewURL((ILayoutExecutionContext)WPECTYPE, (String)"admin_security_usergroup", (String)((String)iUserGroup.getID()), null)).addChild(iUserGroup.getName())));
            });
            hCRow.addCell(PDTToString.getAsString((LocalDateTime)iUser.getLastLoginDateTime(), (Locale)locale));
            iHCCell = hCRow.addCell();
            if (this.isActionAllowed(WPECTYPE, EWebPageFormAction.EDIT, iUser)) {
                iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createEditLink(WPECTYPE, (IHasDisplayName)iUser));
            } else {
                iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createEmptyAction());
            }
            iHCCell.addChild(" ");
            if (this.isActionAllowed(WPECTYPE, EWebPageFormAction.COPY, iUser)) {
                iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createCopyLink(WPECTYPE, (IHasDisplayName)iUser));
            } else {
                iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createEmptyAction());
            }
            iHCCell.addChild(" ");
            if (SecurityUIHelper.canResetPassword(iUser)) {
                iHCCell.addChild((IHCNode)((HCA)new HCA((ISimpleURL)((SimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_RESET_PASSWORD)).add("object", (String)iUser.getID())).setTitle(EText.TITLE_RESET_PASSWORD.getDisplayTextWithArgs(locale, new Object[]{SecurityHelper.getUserDisplayName((IUser)iUser, (Locale)locale)}))).addChild(this.getResetPasswordIcon()));
            } else {
                iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createEmptyAction());
            }
            if (this.isActionAllowed(WPECTYPE, EWebPageFormAction.DELETE, iUser)) {
                iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createDeleteLink(WPECTYPE, (IHasDisplayName)iUser));
            } else {
                iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createEmptyAction());
            }
            if (this.isActionAllowed(WPECTYPE, EWebPageFormAction.UNDELETE, iUser)) {
                iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createUndeleteLink(WPECTYPE, (IHasDisplayName)iUser));
                continue;
            }
            iHCCell.addChild((IHCNode)BasePageSecurityUserManagement.createEmptyAction());
        }
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        return ((HCNodeList)new HCNodeList().addChild((IHCNode)hCTable)).addChild((IHCNode)iterator);
    }

    protected void showListOfExistingObjects(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
        BootstrapButtonToolbar bootstrapButtonToolbar = (BootstrapButtonToolbar)hCNodeList.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
        bootstrapButtonToolbar.addButtonNew(EText.BUTTON_CREATE_NEW_USER.getDisplayText(locale), (ISimpleURL)BasePageSecurityUserManagement.createCreateURL(WPECTYPE));
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        ICommonsList iCommonsList = iUserManager.getAllActiveUsers();
        bootstrapTabBox.addTab("active", EText.TAB_ACTIVE.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList.size())}), this.getTabWithUsers(WPECTYPE, (ICommonsList<IUser>)iCommonsList, this.getID() + "1"));
        ICommonsList iCommonsList2 = iUserManager.getAllDisabledUsers();
        bootstrapTabBox.addTab("disabled", EText.TAB_DISABLED.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList2.size())}), this.getTabWithUsers(WPECTYPE, (ICommonsList<IUser>)iCommonsList2, this.getID() + "2"));
        ICommonsList iCommonsList3 = iUserManager.getAllDeletedUsers();
        bootstrapTabBox.addTab("deleted", EText.TAB_DELETED.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(iCommonsList3.size())}), this.getTabWithUsers(WPECTYPE, (ICommonsList<IUser>)iCommonsList3, this.getID() + "3"));
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        BUTTON_CREATE_NEW_USER("Neuen Benutzer anlegen", "Create new user"),
        TAB_ACTIVE("Aktive Benutzer ({0})", "Active users ({0})"),
        TAB_DISABLED("Deaktivierte Benutzer ({0})", "Disabled users ({0})"),
        TAB_DELETED("Gel\u00f6schte Benutzer ({0})", "Deleted users ({0})"),
        HEADER_NAME("Name", "Name"),
        HEADER_LOGINNAME("Benutzername", "User name"),
        HEADER_EMAIL("E-Mail", "Email"),
        HEADER_USERGROUPS("Benutzergruppen", "User groups"),
        HEADER_LAST_LOGIN("Letzter Login", "Last login"),
        HEADER_VALUE("Wert", "Value"),
        TITLE_CREATE("Neuen Benutzer anlegen", "Create new user"),
        TITLE_EDIT("Benutzer ''{0}'' bearbeiten", "Edit user ''{0}''"),
        TITLE_RESET_PASSWORD("Passwort von ''{0}'' zur\u00fccksetzen", "Reset password of user ''{0}''"),
        NONE_DEFINED("keine definiert", "none defined"),
        HEADER_DETAILS("Details von Benutzer ''{0}''", "Details of user ''{0}''"),
        LABEL_CREATIONDATE("Angelegt am", "Created on"),
        LABEL_LASTMODIFICATIONDATE("Letzte \u00c4nderung am", "Last modification on"),
        LABEL_DELETIONDATE("Gel\u00f6scht am", "Deleted on"),
        LABEL_LOGINNAME("Benutzername", "User name"),
        LABEL_FIRSTNAME("Vorname", "First name"),
        LABEL_LASTNAME("Nachname", "Last name"),
        LABEL_EMAIL("E-Mail-Adresse", "Email address"),
        LABEL_PASSWORD("Passwort", "Password"),
        LABEL_PASSWORD_CONFIRM("Passwort (Best\u00e4tigung)", "Password (confirmation)"),
        LABEL_ENABLED("Aktiv?", "Enabled?"),
        LABEL_DESCRIPTION("Beschreibung", "Description"),
        LABEL_DELETED("Gel\u00f6scht?", "Deleted?"),
        LABEL_LAST_LOGIN("Letzter Login", "Last login"),
        LABEL_LAST_LOGIN_NEVER("noch nie", "never"),
        LABEL_LOGIN_COUNT("Login-Anzahl", "Login count"),
        LABEL_CONSECUTIVE_FAILED_LOGIN_COUNT("Fehlgeschlagene Logins", "Failed logins"),
        LABEL_PASSWORD_HASH_ALGORITHM("Passwort Hash-Algorithmus", "Password hash algorithm"),
        LABEL_USERGROUPS_0("Benutzergruppen", "User groups"),
        LABEL_USERGROUPS_N("Benutzergruppen ({0})", "User groups ({0})"),
        LABEL_ROLES_0("Rollen", "Roles"),
        LABEL_ROLES_N("Rollen ({0})", "Roles ({0})"),
        LABEL_ATTRIBUTES("Attribute", "Attributes"),
        ERROR_LOGINNAME_REQUIRED("Es muss ein Benutzername angegeben werden!", "A user name must be specified!"),
        ERROR_LASTNAME_REQUIRED("Es muss ein Nachname angegeben werden!", "A last name must be specified!"),
        ERROR_EMAIL_REQUIRED("Es muss eine E-Mail-Adresse angegeben werden!", "An email address must be specified!"),
        ERROR_EMAIL_INVALID("Es muss eine g\u00fcltige E-Mail-Adresse angegeben werden!", "A valid email address must be specified!"),
        ERROR_EMAIL_IN_USE("Ein anderer Benutzer mit dieser E-Mail-Adresse existiert bereits!", "Another user with this email address already exists!"),
        ERROR_PASSWORDS_DONT_MATCH("Die Passw\u00f6rter stimmen nicht \u00fcberein!", "Passwords don't match"),
        ERROR_NO_USERGROUP("Es muss mindestens eine Benutzergruppe ausgew\u00e4hlt werden!", "At least one user group must be selected!"),
        ERROR_INVALID_USERGROUPS("Mindestens eine der angegebenen Benutzergruppen ist ung\u00fcltig!", "At least one selected user group is invalid!"),
        SUCCESS_CREATE("Der neue Benutzer wurde erfolgreich angelegt!", "Successfully created the new user!"),
        SUCCESS_EDIT("Der Benutzer wurde erfolgreich bearbeitet!", "Sucessfully edited the user!"),
        FAILURE_CREATE("Fehler beim Anlegen des Benutzers!", "Error creating the new user!"),
        SUCCESS_RESET_PASSWORD("Das neue Passwort vom Benutzer ''{0}'' wurde gespeichert!", "Successfully saved the new password of user ''{0}''!"),
        DELETE_QUERY("Sind Sie sicher, dass Sie den Benutzer ''{0}'' l\u00f6schen wollen?", "Are you sure you want to delete user ''{0}''?"),
        DELETE_SUCCESS("Der Benutzer ''{0}'' wurde erfolgreich gel\u00f6scht!", "User ''{0}'' was successfully deleted!"),
        DELETE_ERROR("Beim L\u00f6schen des Benutzers ''{0}'' ist ein Fehler aufgetreten!", "An error occurred while deleting user ''{0}''!"),
        UNDELETE_QUERY("Sind Sie sicher, dass Sie den Benutzer ''{0}'' wiederherstellen wollen?", "Are you sure you want to undelete user ''{0}''?"),
        UNDELETE_SUCCESS("Der Benutzer ''{0}'' wurde erfolgreich wiederhergestellt!", "User ''{0}'' was successfully undeleted!"),
        UNDELETE_ERROR("Beim Wiederherstellen des Benutzers ''{0}'' ist ein Fehler aufgetreten!", "An error occurred while undeleting user ''{0}''!");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

