/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.security;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.IValidityIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.forms.HCTextArea;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.html.request.IHCRequestField;
import com.helger.photon.bootstrap3.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap3.alert.BootstrapQuestionBox;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandler;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandlerDelete;
import com.helger.photon.bootstrap3.pages.security.AbstractWebPageSecurityToken;
import com.helger.photon.bootstrap3.table.BootstrapTable;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDTColAction;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.user.IUserToken;
import com.helger.photon.security.token.user.IUserTokenManager;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.uicore.html.select.HCUserSelect;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.handler.IWebPageActionHandler;
import com.helger.photon.uictrls.datatables.column.DTCol;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSecurityUserTokenManagement<WPECTYPE extends IWebPageExecutionContext>
extends AbstractWebPageSecurityToken<IUserToken, WPECTYPE> {
    public static final String ACTION_REVOKE_ACCESS_TOKEN = "revokeaccesstoken";
    public static final String ACTION_CREATE_NEW_ACCESS_TOKEN = "createnewaccesstoken";
    public static final String FIELD_USER = "user";
    public static final String FIELD_TOKEN_STRING = "tokenstring";
    public static final String FIELD_REVOCATION_REASON = "revocationreason";

    public static boolean canCreateNewAccessToken(@Nullable IUserToken iUserToken) {
        return iUserToken != null && !iUserToken.isDeleted();
    }

    public static boolean canRevokeAccessToken(@Nullable IUserToken iUserToken) {
        return iUserToken != null && !iUserToken.isDeleted() && iUserToken.getActiveAccessToken() != null;
    }

    private void _init() {
        this.setDeleteHandler((IWebPageActionHandler)new AbstractBootstrapWebPageActionHandlerDelete<IUserToken, WPECTYPE>(){

            @OverrideOnDemand
            protected void showQuery(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapForm bootstrapForm, @Nonnull IUserToken iUserToken) {
                Locale locale = WPECTYPE.getDisplayLocale();
                bootstrapForm.addChild((IHCNode)new BootstrapQuestionBox().addChild(EText.DELETE_QUERY.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
            }

            @OverrideOnDemand
            protected void performAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUserToken iUserToken) {
                Locale locale = WPECTYPE.getDisplayLocale();
                IUserTokenManager iUserTokenManager = PhotonSecurityManager.getUserTokenMgr();
                if (iUserTokenManager.deleteUserToken((String)iUserToken.getID()).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.DELETE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
                } else {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapErrorBox().addChild(EText.DELETE_ERROR.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
                }
            }
        });
        this.addCustomHandler(ACTION_CREATE_NEW_ACCESS_TOKEN, (IWebPageActionHandler)new AbstractBootstrapWebPageActionHandler<IUserToken, WPECTYPE>(true){

            public boolean canHandleAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUserToken iUserToken) {
                return BasePageSecurityUserTokenManagement.canCreateNewAccessToken(iUserToken);
            }

            @Nonnull
            public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUserToken iUserToken) {
                String string;
                IUserTokenManager iUserTokenManager;
                Locale locale = WPECTYPE.getDisplayLocale();
                HCNodeList hCNodeList = WPECTYPE.getNodeList();
                boolean bl = iUserToken.getActiveAccessToken() != null;
                FormErrorList formErrorList = new FormErrorList();
                if (WPECTYPE.hasSubAction("perform")) {
                    iUserTokenManager = PhotonSecurityManager.getUserTokenMgr();
                    string = WPECTYPE.params().getAsString((Object)BasePageSecurityUserTokenManagement.FIELD_REVOCATION_REASON);
                    String string2 = WPECTYPE.params().getAsString((Object)BasePageSecurityUserTokenManagement.FIELD_TOKEN_STRING);
                    if (bl && StringHelper.hasNoText((String)string)) {
                        formErrorList.addFieldError(BasePageSecurityUserTokenManagement.FIELD_REVOCATION_REASON, AbstractWebPageSecurityToken.EBaseText.ERR_REASON_EMPTY.getDisplayText(locale));
                    }
                    if (StringHelper.hasText((String)string2)) {
                        if (string2.length() < 16) {
                            formErrorList.addFieldError(BasePageSecurityUserTokenManagement.FIELD_TOKEN_STRING, AbstractWebPageSecurityToken.EBaseText.ERR_TOKEN_STRING_TOO_SHORT.getDisplayText(locale));
                        } else if (iUserTokenManager.isAccessTokenUsed(string2)) {
                            formErrorList.addFieldError(BasePageSecurityUserTokenManagement.FIELD_TOKEN_STRING, AbstractWebPageSecurityToken.EBaseText.ERR_TOKEN_STRING_IN_USE.getDisplayText(locale));
                        }
                    }
                    if (formErrorList.isEmpty()) {
                        iUserTokenManager.createNewAccessToken((String)iUserToken.getID(), LoggedInUserManager.getInstance().getCurrentUserID(), PDTFactory.getCurrentLocalDateTime(), string, string2);
                        WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(bl ? AbstractWebPageSecurityToken.EBaseText.REVOKE_AND_CREATE_NEW_ACCESS_TOKEN_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()}) : AbstractWebPageSecurityToken.EBaseText.CREATE_NEW_ACCESS_TOKEN_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
                        return EShowList.SHOW_LIST;
                    }
                    hCNodeList.addChild(this.getUIHandler().createIncorrectInputBox(WPECTYPE));
                }
                iUserTokenManager = (BootstrapForm)this.getUIHandler().createFormSelf(WPECTYPE);
                if (bl) {
                    iUserTokenManager.addChild((IHCNode)this.getUIHandler().createActionHeader(AbstractWebPageSecurityToken.EBaseText.REVOKE_AND_CREATE_NEW_ACCESS_TOKEN_HEADER.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
                    iUserTokenManager.addFormGroup(new BootstrapFormGroup().setLabelMandatory(AbstractWebPageSecurityToken.EBaseText.LABEL_REASON.getDisplayText(locale)).setCtrl((IHCNode)new HCTextArea((IHCRequestField)new RequestField(BasePageSecurityUserTokenManagement.FIELD_REVOCATION_REASON))).setErrorList(formErrorList.getListOfField(BasePageSecurityUserTokenManagement.FIELD_REVOCATION_REASON)));
                } else {
                    iUserTokenManager.addChild((IHCNode)this.getUIHandler().createActionHeader(AbstractWebPageSecurityToken.EBaseText.CREATE_NEW_ACCESS_TOKEN_HEADER.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
                }
                iUserTokenManager.addFormGroup(new BootstrapFormGroup().setLabel(AbstractWebPageSecurityToken.EBaseText.LABEL_TOKEN_STRING.getDisplayText(locale)).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(BasePageSecurityUserTokenManagement.FIELD_TOKEN_STRING))).setHelpText(AbstractWebPageSecurityToken.EBaseText.HELPTEXT_TOKEN_STRING.getDisplayText(locale)).setErrorList(formErrorList.getListOfField(BasePageSecurityUserTokenManagement.FIELD_TOKEN_STRING)));
                string = (BootstrapButtonToolbar)iUserTokenManager.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
                string.addHiddenField("action", BasePageSecurityUserTokenManagement.ACTION_CREATE_NEW_ACCESS_TOKEN);
                string.addHiddenField("action2", "perform");
                string.addHiddenField("object", (String)iUserToken.getID());
                if (bl) {
                    string.addSubmitButton(EPhotonCoreText.BUTTON_SAVE.getDisplayText(locale), (IIcon)EDefaultIcon.SAVE);
                    string.addButtonCancel(locale);
                } else {
                    string.addSubmitButton(EPhotonCoreText.BUTTON_YES.getDisplayText(locale), (IIcon)EDefaultIcon.YES);
                    string.addButtonNo(locale);
                }
                hCNodeList.addChild((IHCNode)iUserTokenManager);
                return EShowList.DONT_SHOW_LIST;
            }
        });
        this.addCustomHandler(ACTION_REVOKE_ACCESS_TOKEN, (IWebPageActionHandler)new AbstractBootstrapWebPageActionHandler<IUserToken, WPECTYPE>(true){

            public boolean canHandleAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUserToken iUserToken) {
                return BasePageSecurityUserTokenManagement.canRevokeAccessToken(iUserToken);
            }

            @Nonnull
            public EShowList handleAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUserToken iUserToken) {
                String string;
                Locale locale = WPECTYPE.getDisplayLocale();
                HCNodeList hCNodeList = WPECTYPE.getNodeList();
                FormErrorList formErrorList = new FormErrorList();
                if (WPECTYPE.hasSubAction("perform")) {
                    string = WPECTYPE.params().getAsString((Object)BasePageSecurityUserTokenManagement.FIELD_REVOCATION_REASON);
                    if (StringHelper.hasNoText((String)string)) {
                        formErrorList.addFieldError(BasePageSecurityUserTokenManagement.FIELD_REVOCATION_REASON, AbstractWebPageSecurityToken.EBaseText.ERR_REASON_EMPTY.getDisplayText(locale));
                    }
                    if (formErrorList.isEmpty()) {
                        IUserTokenManager iUserTokenManager = PhotonSecurityManager.getUserTokenMgr();
                        iUserTokenManager.revokeAccessToken((String)iUserToken.getID(), LoggedInUserManager.getInstance().getCurrentUserID(), PDTFactory.getCurrentLocalDateTime(), string);
                        WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(AbstractWebPageSecurityToken.EBaseText.REVOKE_ACCESS_TOKEN_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
                        return EShowList.SHOW_LIST;
                    }
                    hCNodeList.addChild(this.getUIHandler().createIncorrectInputBox(WPECTYPE));
                }
                string = (BootstrapForm)this.getUIHandler().createFormSelf(WPECTYPE);
                string.addChild((IHCNode)this.getUIHandler().createActionHeader(AbstractWebPageSecurityToken.EBaseText.REVOKE_ACCESS_TOKEN_HEADER.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
                string.addFormGroup(new BootstrapFormGroup().setLabelMandatory(AbstractWebPageSecurityToken.EBaseText.LABEL_REASON.getDisplayText(locale)).setCtrl((IHCNode)new HCTextArea((IHCRequestField)new RequestField(BasePageSecurityUserTokenManagement.FIELD_REVOCATION_REASON))).setErrorList(formErrorList.getListOfField(BasePageSecurityUserTokenManagement.FIELD_REVOCATION_REASON)));
                BootstrapButtonToolbar bootstrapButtonToolbar = (BootstrapButtonToolbar)string.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
                bootstrapButtonToolbar.addHiddenField("action", BasePageSecurityUserTokenManagement.ACTION_REVOKE_ACCESS_TOKEN);
                bootstrapButtonToolbar.addHiddenField("action2", "perform");
                bootstrapButtonToolbar.addHiddenField("object", (String)iUserToken.getID());
                bootstrapButtonToolbar.addSubmitButton(EPhotonCoreText.BUTTON_SAVE.getDisplayText(locale), (IIcon)EDefaultIcon.SAVE);
                bootstrapButtonToolbar.addButtonCancel(locale);
                hCNodeList.addChild((IHCNode)string);
                return EShowList.DONT_SHOW_LIST;
            }
        });
    }

    public BasePageSecurityUserTokenManagement(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SECURITY_USER_TOKENS.getAsMLT());
        this._init();
    }

    public BasePageSecurityUserTokenManagement(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
        this._init();
    }

    public BasePageSecurityUserTokenManagement(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
        this._init();
    }

    public BasePageSecurityUserTokenManagement(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
        this._init();
    }

    protected IValidityIndicator isValidToDisplayPage(@Nonnull WPECTYPE WPECTYPE) {
        return super.isValidToDisplayPage(WPECTYPE);
    }

    @Nullable
    protected IUserToken getSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nullable String string) {
        IUserTokenManager iUserTokenManager = PhotonSecurityManager.getUserTokenMgr();
        return iUserTokenManager.getUserTokenOfID(string);
    }

    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable IUserToken iUserToken) {
        if (eWebPageFormAction.isEdit()) {
            return !iUserToken.isDeleted();
        }
        if (eWebPageFormAction.isDelete()) {
            return !iUserToken.isDeleted();
        }
        return true;
    }

    @Nonnull
    public static IHCNode createUserLink(@Nonnull IWebPageExecutionContext iWebPageExecutionContext, @Nonnull IUser iUser) {
        if (iWebPageExecutionContext.getMenuTree().containsItemWithID((Object)"admin_security_user")) {
            return new HCA((ISimpleURL)BasePageSecurityUserTokenManagement.createViewURL((ILayoutExecutionContext)iWebPageExecutionContext, (String)"admin_security_user", (IHasID)iUser)).addChild(iUser.getDisplayName());
        }
        return new HCTextNode(iUser.getDisplayName());
    }

    protected void showSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull IUserToken iUserToken) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.HEADER_SHOW.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()})));
        BootstrapViewForm bootstrapViewForm = (BootstrapViewForm)hCNodeList.addAndReturnChild((IHCNode)new BootstrapViewForm());
        bootstrapViewForm.setCondensed(true);
        this.onShowSelectedObjectTableStart(WPECTYPE, bootstrapViewForm, iUserToken);
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USER.getDisplayText(locale)).setCtrl(BasePageSecurityUserTokenManagement.createUserLink(WPECTYPE, iUserToken.getUser())));
        IHCNode iHCNode = BasePageSecurityUserTokenManagement.createAccessTokenListUI((List<? extends IAccessToken>)iUserToken.getAllAccessTokens(), locale);
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(AbstractWebPageSecurityToken.EBaseText.LABEL_ACCESS_TOKENS.getDisplayText(locale)).setCtrl(iHCNode));
        iHCNode = iUserToken.attrs();
        ICommonsSet<String> iCommonsSet = this.onShowSelectedObjectCustomAttrs(WPECTYPE, iUserToken, (Map<String, String>)iHCNode, bootstrapViewForm);
        if (iHCNode.isNotEmpty()) {
            BootstrapTable bootstrapTable = new BootstrapTable(new IHCCol[]{new HCCol(170), HCCol.star()});
            bootstrapTable.addHeaderRow().addCells(new String[]{EText.HEADER_NAME.getDisplayText(locale), EText.HEADER_VALUE.getDisplayText(locale)});
            for (Map.Entry entry : iHCNode.entrySet()) {
                String string = (String)entry.getKey();
                if (iCommonsSet != null && iCommonsSet.contains((Object)string)) continue;
                String string2 = (String)entry.getValue();
                bootstrapTable.addBodyRow().addCells(new String[]{string, string2});
            }
            if (bootstrapTable.hasBodyRows()) {
                bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_ATTRIBUTES.getDisplayText(locale)).setCtrl((IHCNode)bootstrapTable));
            }
        }
        this.onShowSelectedObjectTableEnd(WPECTYPE, bootstrapViewForm, iUserToken);
    }

    protected void showInputForm(@Nonnull WPECTYPE WPECTYPE, @Nullable IUserToken iUserToken, @Nonnull BootstrapForm bootstrapForm, boolean bl, @Nonnull EWebPageFormAction eWebPageFormAction, @Nonnull FormErrorList formErrorList) {
        Locale locale = WPECTYPE.getDisplayLocale();
        boolean bl2 = eWebPageFormAction.isEdit();
        bootstrapForm.addChild((IHCNode)this.getUIHandler().createActionHeader(bl2 ? EText.HEADER_EDIT.getDisplayTextWithArgs(locale, new Object[]{iUserToken.getDisplayName()}) : EText.HEADER_CREATE.getDisplayText(locale)));
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(EText.LABEL_USER.getDisplayText(locale)).setCtrl((IHCNode)new HCUserSelect((IHCRequestField)new RequestField(FIELD_USER, iUserToken == null ? null : iUserToken.getUserID()), locale, iUser -> !iUser.isDeleted() && iUser.isEnabled()).setReadOnly(bl2)).setErrorList(formErrorList.getListOfField(FIELD_USER)));
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(AbstractWebPageSecurityToken.EBaseText.LABEL_TOKEN_STRING.getDisplayText(locale)).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_TOKEN_STRING, iUserToken == null ? null : iUserToken.getActiveTokenString())).setReadOnly(bl2)).setHelpText(AbstractWebPageSecurityToken.EBaseText.HELPTEXT_TOKEN_STRING.getDisplayText(locale)).setErrorList(formErrorList.getListOfField(FIELD_TOKEN_STRING)));
        this.onShowInputFormEnd(WPECTYPE, iUserToken, bootstrapForm, eWebPageFormAction, formErrorList);
    }

    protected void validateAndSaveInputParameters(@Nonnull WPECTYPE WPECTYPE, @Nullable IUserToken iUserToken, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        String string;
        Locale locale = WPECTYPE.getDisplayLocale();
        IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
        IUserTokenManager iUserTokenManager = PhotonSecurityManager.getUserTokenMgr();
        boolean bl = eWebPageFormAction.isEdit();
        String string2 = WPECTYPE.params().getAsString((Object)FIELD_USER);
        IUser iUser = bl ? iUserToken.getUser() : iUserManager.getActiveUserOfID(string2);
        String string3 = string = bl ? null : WPECTYPE.params().getAsString((Object)FIELD_TOKEN_STRING);
        if (iUser == null) {
            formErrorList.addFieldError(FIELD_USER, EText.ERR_USER_EMPTY.getDisplayText(locale));
        }
        if (StringHelper.hasText((String)string)) {
            if (string.length() < 16) {
                formErrorList.addFieldError(FIELD_TOKEN_STRING, AbstractWebPageSecurityToken.EBaseText.ERR_TOKEN_STRING_TOO_SHORT.getDisplayText(locale));
            } else if (iUserTokenManager.isAccessTokenUsed(string)) {
                formErrorList.addFieldError(FIELD_TOKEN_STRING, AbstractWebPageSecurityToken.EBaseText.ERR_TOKEN_STRING_IN_USE.getDisplayText(locale));
            }
        }
        ICommonsMap<String, String> iCommonsMap = this.validateCustomInputParameters(WPECTYPE, iUserToken, formErrorList, eWebPageFormAction);
        if (formErrorList.isEmpty()) {
            if (bl) {
                iUserTokenManager.updateUserToken((String)iUserToken.getID(), iCommonsMap);
                WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.EDIT_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUser.getDisplayName()})));
            } else {
                iUserTokenManager.createUserToken(string, iCommonsMap, iUser);
                WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.CREATE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{iUser.getDisplayName()})));
            }
        }
    }

    @Nonnull
    private IHCNode _createList(@Nonnull WPECTYPE WPECTYPE, @Nonnull String string, @Nullable Predicate<? super IUserToken> predicate) {
        Locale locale = WPECTYPE.getDisplayLocale();
        IUserTokenManager iUserTokenManager = PhotonSecurityManager.getUserTokenMgr();
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.HEADER_USER.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.HEADER_USABLE.getDisplayText(locale)), new BootstrapDTColAction(locale)}).setID(this.getID() + string);
        for (IUserToken iUserToken : iUserTokenManager.getAll()) {
            if (predicate != null && !predicate.test((IUserToken)iUserToken)) continue;
            SimpleURL simpleURL = BasePageSecurityUserTokenManagement.createViewURL(WPECTYPE, (IHasID)iUserToken);
            String string2 = iUserToken.getDisplayName();
            boolean bl = !iUserToken.isDeleted() && iUserToken.getActiveAccessToken() != null && iUserToken.getActiveAccessToken().isValidNow();
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((IHCNode)new HCA((ISimpleURL)simpleURL).addChild(string2));
            hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)bl, (Locale)locale));
            IHCCell iHCCell = hCRow.addCell();
            if (this.isActionAllowed(WPECTYPE, EWebPageFormAction.EDIT, iUserToken)) {
                iHCCell.addChild((IHCNode)BasePageSecurityUserTokenManagement.createEditLink(WPECTYPE, (IHasID)iUserToken, (String)EText.ACTION_EDIT.getDisplayTextWithArgs(locale, new Object[]{string2})));
            } else {
                iHCCell.addChild((IHCNode)BasePageSecurityUserTokenManagement.createEmptyAction());
            }
            iHCCell.addChild(" ");
            iHCCell.addChild((IHCNode)BasePageSecurityUserTokenManagement.createCopyLink(WPECTYPE, (IHasID)iUserToken, (String)EText.ACTION_COPY.getDisplayTextWithArgs(locale, new Object[]{string2})));
            iHCCell.addChild(" ");
            if (this.isActionAllowed(WPECTYPE, EWebPageFormAction.DELETE, iUserToken)) {
                iHCCell.addChild((IHCNode)BasePageSecurityUserTokenManagement.createDeleteLink(WPECTYPE, (IHasID)iUserToken, (String)EText.ACTION_DELETE.getDisplayTextWithArgs(locale, new Object[]{string2})));
            } else {
                iHCCell.addChild((IHCNode)BasePageSecurityUserTokenManagement.createEmptyAction());
            }
            iHCCell.addChild(" ");
            if (BasePageSecurityUserTokenManagement.canCreateNewAccessToken(iUserToken)) {
                iHCCell.addChild((IHCNode)((HCA)new HCA((ISimpleURL)((SimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_CREATE_NEW_ACCESS_TOKEN)).add("object", (String)iUserToken.getID())).addChild((IHCNode)EDefaultIcon.REFRESH.getAsNode())).setTitle(AbstractWebPageSecurityToken.EBaseText.TITLE_ACTION_CREATE_NEW_ACCESS_TOKEN.getDisplayTextWithArgs(locale, new Object[]{string2})));
            } else {
                iHCCell.addChild((IHCNode)BasePageSecurityUserTokenManagement.createEmptyAction());
            }
            iHCCell.addChild(" ");
            if (BasePageSecurityUserTokenManagement.canRevokeAccessToken(iUserToken)) {
                iHCCell.addChild((IHCNode)((HCA)new HCA((ISimpleURL)((SimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_REVOKE_ACCESS_TOKEN)).add("object", (String)iUserToken.getID())).addChild((IHCNode)EDefaultIcon.CANCEL.getAsNode())).setTitle(AbstractWebPageSecurityToken.EBaseText.TITLE_ACTION_REVOKE_ACCESS_TOKEN.getDisplayTextWithArgs(locale, new Object[]{string2})));
                continue;
            }
            iHCCell.addChild((IHCNode)BasePageSecurityUserTokenManagement.createEmptyAction());
        }
        Iterator iterator = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        return new HCNodeList().addChildren(new IHCNode[]{hCTable, iterator});
    }

    protected void showListOfExistingObjects(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        BootstrapButtonToolbar bootstrapButtonToolbar = (BootstrapButtonToolbar)hCNodeList.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
        bootstrapButtonToolbar.addButtonNew(EText.BUTTON_CREATE_NEW.getDisplayText(locale), (ISimpleURL)BasePageSecurityUserTokenManagement.createCreateURL(WPECTYPE));
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        bootstrapTabBox.addTab("active", EText.TAB_LABEL_ACTIVE.getDisplayText(locale), this._createList(WPECTYPE, "active", iUserToken -> !iUserToken.isDeleted()));
        bootstrapTabBox.addTab("deleted", EText.TAB_LABEL_DELETED.getDisplayText(locale), this._createList(WPECTYPE, "deleted", iUserToken -> iUserToken.isDeleted()));
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        BUTTON_CREATE_NEW("Neues Benutzer-Token anlegen", "Create new user token"),
        HEADER_EDIT("Benutzer-Token von ''{0}'' bearbeiten", "Edit user token of ''{0}''"),
        HEADER_CREATE("Neues Benutzer-Token anlegen", "Create a new user token"),
        HEADER_SHOW("Details von Benutzer-Token f\u00fcr {0}", "Details of user token for {0}"),
        HEADER_NAME("Name", "Name"),
        HEADER_VALUE("Wert", "Value"),
        LABEL_ATTRIBUTES("Attribute", "Attributes"),
        LABEL_USER("Benutzer", "User"),
        ERR_USER_EMPTY("Es muss ein Benutzer ausgew\u00e4hlt werden!", "A user must be selected!"),
        CREATE_SUCCESS("Das Benutzer-Token f\u00fcr ''{0}'' wurde erfolgreich erstellt.", "The user token for ''{0}'' was successfully created."),
        EDIT_SUCCESS("Das Benutzer-Token f\u00fcr ''{0}'' wurde erfolgreich bearbeitet.", "The user token for ''{0}'' was successfully edited."),
        DELETE_QUERY("Sind Sie sicher, dass Sie das Benutzer-Token f\u00fcr ''{0}'' l\u00f6schen wollen?", "Are you sure you want to delete the user token of ''{0}''?"),
        DELETE_SUCCESS("Das Benutzer-Token f\u00fcr ''{0}'' wurde erfolgreich gel\u00f6scht!", "User token of ''{0}'' was successfully deleted!"),
        DELETE_ERROR("Beim L\u00f6schen des Benutzer-Token f\u00fcr ''{0}'' ist ein Fehler aufgetreten!", "An error occurred while deleting user token of ''{0}''!"),
        TAB_LABEL_ACTIVE("Aktiv", "Active"),
        TAB_LABEL_DELETED("Gel\u00f6scht", "Deleted"),
        HEADER_USER("Benutzer", "User"),
        HEADER_USABLE("Verwendbar?", "Usable?"),
        ACTION_EDIT("Benutzer-Token f\u00fcr ''{0}'' bearbeiten", "Edit user token of ''{0}''"),
        ACTION_COPY("Benutzer-Token f\u00fcr ''{0}'' kopieren", "Copy user token of ''{0}''"),
        ACTION_DELETE("Benutzer-Token f\u00fcr ''{0}'' l\u00f6schen", "Delete user token of ''{0}''");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

