/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.security;

import com.helger.commons.string.StringHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.textlevel.HCCode;
import com.helger.photon.security.user.IUser;
import com.helger.photon.uicore.css.CUICoreCSS;
import javax.annotation.Nullable;

public final class SecurityUIHelper {
    private static final SecurityUIHelper s_aInstance = new SecurityUIHelper();

    private SecurityUIHelper() {
    }

    public static boolean canBeEdited(@Nullable IUser iUser) {
        return iUser != null && !iUser.isDeleted();
    }

    public static boolean canBeDeleted(@Nullable IUser iUser) {
        return iUser != null && !iUser.isDeleted() && !iUser.isAdministrator();
    }

    public static boolean canBeUndeleted(@Nullable IUser iUser) {
        return iUser != null && iUser.isDeleted();
    }

    public static boolean canResetPassword(@Nullable IUser iUser) {
        return iUser != null && !iUser.isDeleted();
    }

    @Nullable
    public static IHCNode createAccessTokenNode(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return ((HCCode)new HCCode().addClass(CUICoreCSS.CSS_CLASS_NOWRAP)).addChild(string);
    }
}

