/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.settings;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCCheckBox;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.textlevel.HCEM;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.RequestFieldBoolean;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.smtp.EmailGlobalSettings;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.event.ConnectionListener;

public class BasePageSettingsGlobal<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final String FIELD_GLOBAL_DEBUG = "global-debug";
    private static final String FIELD_GLOBAL_PRODUCTION = "global-production";

    public BasePageSettingsGlobal(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SETTINGS_GLOBAL.getAsMLT());
    }

    public BasePageSettingsGlobal(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSettingsGlobal(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSettingsGlobal(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        if (WPECTYPE.hasAction("save")) {
            boolean bl = WPECTYPE.params().isCheckBoxChecked(FIELD_GLOBAL_DEBUG, GlobalDebug.isDebugMode());
            boolean bl2 = WPECTYPE.params().isCheckBoxChecked(FIELD_GLOBAL_PRODUCTION, GlobalDebug.isProductionMode());
            GlobalDebug.setDebugModeDirect((boolean)bl);
            GlobalDebug.setProductionModeDirect((boolean)bl2);
            WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.MSG_CHANGE_SUCCESS.getDisplayText(locale)));
        }
        BootstrapForm bootstrapForm = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE));
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        BootstrapViewForm bootstrapViewForm = new BootstrapViewForm();
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_GLOBAL_DEBUG.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_GLOBAL_DEBUG, GlobalDebug.isDebugMode()))));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_GLOBAL_PRODUCTION.getDisplayText(locale)).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_GLOBAL_PRODUCTION, GlobalDebug.isProductionMode()))));
        bootstrapTabBox.addTab("global", EText.MSG_HEADER_GLOBAL.getDisplayText(locale), (IHCNode)bootstrapViewForm);
        bootstrapViewForm = new BootstrapViewForm();
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_MAILQUEUE_LENGTH.getDisplayText(locale)).setCtrl(Long.toString(EmailGlobalSettings.getMaxMailQueueLength())));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_MAX_SEND_COUNT.getDisplayText(locale)).setCtrl(Long.toString(EmailGlobalSettings.getMaxMailSendCount())));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_USE_SSL.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)EmailGlobalSettings.isUseSSL(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_USE_STARTTLS.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)EmailGlobalSettings.isUseSTARTTLS(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_CONNECTION_TIMEOUT.getDisplayText(locale)).setCtrl(Long.toString(EmailGlobalSettings.getConnectionTimeoutMilliSecs()) + "ms"));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_SOCKET_TIMEOUT.getDisplayText(locale)).setCtrl(Long.toString(EmailGlobalSettings.getTimeoutMilliSecs()) + "ms"));
        HCNodeList hCNodeList2 = new HCNodeList();
        for (ConnectionListener connectionListener : EmailGlobalSettings.getAllConnectionListeners()) {
            hCNodeList2.addChild((IHCNode)new HCDiv().addChild(String.valueOf(connectionListener)));
        }
        if (!hCNodeList2.hasChildren()) {
            hCNodeList2.addChild((IHCNode)new HCEM().addChild(EText.MSG_NONE.getDisplayText(locale)));
        }
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_CONNECTION_LISTENER.getDisplayText(locale)).setCtrl((IHCNode)hCNodeList2));
        hCNodeList2 = new HCNodeList();
        for (ConnectionListener connectionListener : EmailGlobalSettings.getAllEmailDataTransportListeners()) {
            hCNodeList2.addChild((IHCNode)new HCDiv().addChild(String.valueOf(connectionListener)));
        }
        if (!hCNodeList2.hasChildren()) {
            hCNodeList2.addChild((IHCNode)new HCEM().addChild(EText.MSG_NONE.getDisplayText(locale)));
        }
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.MSG_EMAIL_EMAILDATA_TRANSPORT_LISTENER.getDisplayText(locale)).setCtrl((IHCNode)hCNodeList2));
        bootstrapTabBox.addTab("email", EText.MSG_HEADER_EMAIL.getDisplayText(locale), (IHCNode)bootstrapViewForm);
        bootstrapForm.addChild((IHCNode)bootstrapTabBox);
        bootstrapViewForm = (BootstrapButtonToolbar)bootstrapForm.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
        bootstrapViewForm.addHiddenField("action", "save");
        bootstrapViewForm.addSubmitButtonSave(locale);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_HEADER_GLOBAL("Globale Einstellungen", "Global settings"),
        MSG_GLOBAL_DEBUG("Debug-Modus", "Debug mode"),
        MSG_GLOBAL_PRODUCTION("Produktions-Modus", "Production mode"),
        MSG_HEADER_EMAIL("E-Mail Standard Einstellungen", "Email default settings"),
        MSG_EMAIL_MAILQUEUE_LENGTH("E-Mail Queue L\u00e4nge", "Email queue length"),
        MSG_EMAIL_MAX_SEND_COUNT("Maximal versendete Mails", "Maximum send count"),
        MSG_EMAIL_USE_SSL("SSL", "SSL"),
        MSG_EMAIL_USE_STARTTLS("STARTTLS", "STARTTLS"),
        MSG_EMAIL_CONNECTION_TIMEOUT("Verbindungs-Timeout", "Connection timeout"),
        MSG_EMAIL_SOCKET_TIMEOUT("Socket-Timeout", "Socket timeout"),
        MSG_EMAIL_CONNECTION_LISTENER("ConnectionListener", "ConnectionListener"),
        MSG_EMAIL_EMAILDATA_TRANSPORT_LISTENER("EmailDataTransportListener", "EmailDataTransportListener"),
        MSG_NONE("keiner", "none"),
        MSG_CHANGE_SUCCESS("Die Einstellungen wurden erfolgreich gespeichert.", "Changes were changed successfully.");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

