/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.email.EmailAddress;
import com.helger.commons.email.EmailAddressHelper;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.id.IHasID;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.commons.vendor.VendorInfo;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.HCCheckBox;
import com.helger.html.hc.html.forms.HCEdit;
import com.helger.html.hc.html.forms.HCEditPassword;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.request.IHCRequestField;
import com.helger.html.request.IHCRequestFieldBoolean;
import com.helger.photon.bootstrap3.EBootstrapIcon;
import com.helger.photon.bootstrap3.alert.BootstrapErrorBox;
import com.helger.photon.bootstrap3.alert.BootstrapQuestionBox;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.button.BootstrapButton;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.form.BootstrapFormGroup;
import com.helger.photon.bootstrap3.form.BootstrapViewForm;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPageForm;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandler;
import com.helger.photon.bootstrap3.pages.handler.AbstractBootstrapWebPageActionHandlerDelete;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDTColAction;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.form.FormErrorList;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.core.form.RequestFieldBoolean;
import com.helger.photon.core.smtp.NamedSMTPSettings;
import com.helger.photon.core.smtp.NamedSMTPSettingsManager;
import com.helger.photon.uicore.html.select.HCCharsetSelect;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EShowList;
import com.helger.photon.uicore.page.EWebPageFormAction;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uicore.page.handler.IWebPageActionHandler;
import com.helger.photon.uictrls.autonumeric.HCAutoNumericInt;
import com.helger.photon.uictrls.autosize.HCTextAreaAutosize;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.famfam.EFamFamIcon;
import com.helger.smtp.CSMTP;
import com.helger.smtp.EmailGlobalSettings;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.scope.ScopedMailAPI;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.settings.SMTPSettings;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSettingsSMTP<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPageForm<NamedSMTPSettings, WPECTYPE> {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_HOSTNAME = "hostname";
    private static final String FIELD_PORT = "port";
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_PASSWORD = "password";
    private static final String FIELD_CHARSET = "charset";
    private static final String FIELD_SSL = "ssl";
    private static final String FIELD_STARTTLS = "starttls";
    private static final String FIELD_CONNECTION_TIMEOUT = "ctimeout";
    private static final String FIELD_SOCKET_TIMEOUT = "stimeout";
    private static final String FIELD_DEBUG_SMTP = "debugsmtp";
    private static final String FIELD_TEST_SENDER = "tsender";
    private static final String FIELD_TEST_RECEIVER = "treceiver";
    private static final String FIELD_TEST_SUBJECT = "tsubject";
    private static final String FIELD_TEST_BODY = "tbody";
    private static final String DEFAULT_CHARSET_NAME = CSMTP.CHARSET_SMTP_OBJ.name();
    private static final String ACTION_TEST_MAIL = "testmail";
    private final transient NamedSMTPSettingsManager m_aMgr;

    private void _init() {
        this.setDeleteHandler((IWebPageActionHandler)new AbstractBootstrapWebPageActionHandlerDelete<NamedSMTPSettings, WPECTYPE>(){

            protected void showQuery(@Nonnull WPECTYPE WPECTYPE, @Nonnull BootstrapForm bootstrapForm, @Nonnull NamedSMTPSettings namedSMTPSettings) {
                Locale locale = WPECTYPE.getDisplayLocale();
                bootstrapForm.addChild((IHCNode)new BootstrapQuestionBox().addChild(EText.DELETE_QUERY.getDisplayTextWithArgs(locale, new Object[]{namedSMTPSettings.getName()})));
            }

            protected void performAction(@Nonnull WPECTYPE WPECTYPE, @Nonnull NamedSMTPSettings namedSMTPSettings) {
                Locale locale = WPECTYPE.getDisplayLocale();
                if (BasePageSettingsSMTP.this.m_aMgr.removeSettings(namedSMTPSettings.getID()).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.DELETE_SUCCESS.getDisplayTextWithArgs(locale, new Object[]{namedSMTPSettings.getName()})));
                } else {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapErrorBox().addChild(EText.DELETE_ERROR.getDisplayTextWithArgs(locale, new Object[]{namedSMTPSettings.getName()})));
                }
            }
        });
        this.addCustomHandler(ACTION_TEST_MAIL, (IWebPageActionHandler)new AbstractBootstrapWebPageActionHandler<NamedSMTPSettings, WPECTYPE>(true){

            @Nonnull
            public EShowList handleAction(WPECTYPE WPECTYPE, NamedSMTPSettings namedSMTPSettings) {
                String string;
                String string2;
                Locale locale = WPECTYPE.getDisplayLocale();
                HCNodeList hCNodeList = WPECTYPE.getNodeList();
                FormErrorList formErrorList = new FormErrorList();
                if (WPECTYPE.hasSubAction("perform")) {
                    string2 = WPECTYPE.params().getAsString((Object)BasePageSettingsSMTP.FIELD_TEST_SENDER);
                    string = WPECTYPE.params().getAsString((Object)BasePageSettingsSMTP.FIELD_TEST_RECEIVER);
                    String string3 = WPECTYPE.params().getAsString((Object)BasePageSettingsSMTP.FIELD_TEST_SUBJECT);
                    String string4 = WPECTYPE.params().getAsString((Object)BasePageSettingsSMTP.FIELD_TEST_BODY);
                    if (!EmailAddressHelper.isValid((String)string2)) {
                        formErrorList.addFieldError(BasePageSettingsSMTP.FIELD_TEST_SENDER, EText.ERR_SENDER_INVALID.getDisplayText(locale));
                    }
                    if (!EmailAddressHelper.isValid((String)string)) {
                        formErrorList.addFieldError(BasePageSettingsSMTP.FIELD_TEST_RECEIVER, EText.ERR_RECEIVER_INVALID.getDisplayText(locale));
                    }
                    if (StringHelper.hasNoText((String)string3)) {
                        formErrorList.addFieldError(BasePageSettingsSMTP.FIELD_TEST_SUBJECT, EText.ERR_SUBJECT_INVALID.getDisplayText(locale));
                    }
                    if (StringHelper.hasNoText((String)string4)) {
                        formErrorList.addFieldError(BasePageSettingsSMTP.FIELD_TEST_BODY, EText.ERR_BODY_INVALID.getDisplayText(locale));
                    }
                    if (formErrorList.isEmpty()) {
                        EmailData emailData = new EmailData(EEmailType.TEXT);
                        emailData.setFrom((IEmailAddress)new EmailAddress(string2));
                        emailData.to().add((Object)new EmailAddress(string));
                        emailData.setSubject(string3);
                        emailData.setBody(string4);
                        ScopedMailAPI.getInstance().queueMail(namedSMTPSettings.getSMTPSettings(), (IMutableEmailData)emailData);
                        WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.SUCCESS_TEST_MAIL.getDisplayText(locale)));
                        return EShowList.SHOW_LIST;
                    }
                }
                string2 = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)this.getUIHandler().createFormSelf(WPECTYPE));
                string2.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.TITLE_TEST_MAIL.getDisplayTextWithArgs(locale, new Object[]{namedSMTPSettings.getName()})));
                string2.addFormGroup(new BootstrapFormGroup().setLabelMandatory(EText.MSG_SENDER.getDisplayText(locale)).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(BasePageSettingsSMTP.FIELD_TEST_SENDER, VendorInfo.getVendorEmail()))).setErrorList(formErrorList.getListOfField(BasePageSettingsSMTP.FIELD_TEST_SENDER)));
                string2.addFormGroup(new BootstrapFormGroup().setLabelMandatory(EText.MSG_RECEIVER.getDisplayText(locale)).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(BasePageSettingsSMTP.FIELD_TEST_RECEIVER, VendorInfo.getVendorEmail()))).setErrorList(formErrorList.getListOfField(BasePageSettingsSMTP.FIELD_TEST_RECEIVER)));
                string2.addFormGroup(new BootstrapFormGroup().setLabelMandatory(EText.MSG_SUBJECT.getDisplayText(locale)).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(BasePageSettingsSMTP.FIELD_TEST_SUBJECT, EText.TEST_SUBJECT.getDisplayText(locale)))).setErrorList(formErrorList.getListOfField(BasePageSettingsSMTP.FIELD_TEST_SUBJECT)));
                string2.addFormGroup(new BootstrapFormGroup().setLabelMandatory(EText.MSG_BODY.getDisplayText(locale)).setCtrl((IHCNode)new HCTextAreaAutosize((IHCRequestField)new RequestField(BasePageSettingsSMTP.FIELD_TEST_BODY, EText.TEST_BODY.getDisplayText(locale))).setRows(5)).setErrorList(formErrorList.getListOfField(BasePageSettingsSMTP.FIELD_TEST_BODY)));
                string = (BootstrapButtonToolbar)string2.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
                string.addHiddenField("action", BasePageSettingsSMTP.ACTION_TEST_MAIL);
                string.addHiddenField("object", namedSMTPSettings.getID());
                string.addHiddenField("action2", "perform");
                string.addSubmitButton(EText.BUTTON_SEND_TEST_MAIL.getDisplayText(locale), (IIcon)EDefaultIcon.YES);
                string.addButtonCancel(locale);
                return EShowList.DONT_SHOW_LIST;
            }
        });
        this.setObjectLockingEnabled(true);
    }

    public BasePageSettingsSMTP(@Nonnull NamedSMTPSettingsManager namedSMTPSettingsManager, @Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SETTINGS_SMTP.getAsMLT());
        this.m_aMgr = (NamedSMTPSettingsManager)ValueEnforcer.notNull((Object)namedSMTPSettingsManager, (String)"NamedSMTPSettingsManager");
        this._init();
    }

    public BasePageSettingsSMTP(@Nonnull NamedSMTPSettingsManager namedSMTPSettingsManager, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
        this.m_aMgr = (NamedSMTPSettingsManager)ValueEnforcer.notNull((Object)namedSMTPSettingsManager, (String)"NamedSMTPSettingsManager");
        this._init();
    }

    public BasePageSettingsSMTP(@Nonnull NamedSMTPSettingsManager namedSMTPSettingsManager, @Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
        this.m_aMgr = (NamedSMTPSettingsManager)ValueEnforcer.notNull((Object)namedSMTPSettingsManager, (String)"NamedSMTPSettingsManager");
        this._init();
    }

    public BasePageSettingsSMTP(@Nonnull NamedSMTPSettingsManager namedSMTPSettingsManager, @Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
        this.m_aMgr = (NamedSMTPSettingsManager)ValueEnforcer.notNull((Object)namedSMTPSettingsManager, (String)"NamedSMTPSettingsManager");
        this._init();
    }

    @Nullable
    protected String getObjectDisplayName(@Nonnull WPECTYPE WPECTYPE, @Nonnull NamedSMTPSettings namedSMTPSettings) {
        return namedSMTPSettings.getName();
    }

    @Nullable
    protected NamedSMTPSettings getSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nullable String string) {
        return this.m_aMgr.getSettings(string);
    }

    private static boolean _canDelete(@Nullable NamedSMTPSettings namedSMTPSettings) {
        return namedSMTPSettings != null && !namedSMTPSettings.getID().equals("default");
    }

    protected boolean isActionAllowed(@Nonnull WPECTYPE WPECTYPE, @Nonnull EWebPageFormAction eWebPageFormAction, @Nullable NamedSMTPSettings namedSMTPSettings) {
        if (eWebPageFormAction.isDelete()) {
            return BasePageSettingsSMTP._canDelete(namedSMTPSettings);
        }
        return true;
    }

    protected void showSelectedObject(@Nonnull WPECTYPE WPECTYPE, @Nonnull NamedSMTPSettings namedSMTPSettings) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        ISMTPSettings iSMTPSettings = namedSMTPSettings.getSMTPSettings();
        hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.HEADER_DETAILS.getDisplayTextWithArgs(locale, new Object[]{namedSMTPSettings.getName()})));
        BootstrapViewForm bootstrapViewForm = (BootstrapViewForm)hCNodeList.addAndReturnChild((IHCNode)new BootstrapViewForm());
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_NAME.getDisplayText(locale)).setCtrl(namedSMTPSettings.getName()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_HOSTNAME.getDisplayText(locale)).setCtrl(iSMTPSettings.getHostName()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_PORT.getDisplayText(locale)).setCtrl(iSMTPSettings.hasPort() ? Integer.toString(iSMTPSettings.getPort()) : EText.PORT_DEFAULT.getDisplayText(locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_USERNAME.getDisplayText(locale)).setCtrl(iSMTPSettings.getUserName()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_PASSWORD.getDisplayText(locale)).setCtrl(iSMTPSettings.hasPassword() ? "***" : EText.MSG_NO_PASSWORD_SET.getDisplayText(locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_CHARSET.getDisplayText(locale)).setCtrl(iSMTPSettings.getCharsetName()));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_SSL.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iSMTPSettings.isSSLEnabled(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_STARTTLS.getDisplayText(locale)).setCtrl(EPhotonCoreText.getYesOrNo((boolean)iSMTPSettings.isSTARTTLSEnabled(), (Locale)locale)));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_CONNECTION_TIMEOUT.getDisplayText(locale)).setCtrl(Long.toString(iSMTPSettings.getConnectionTimeoutMilliSecs())));
        bootstrapViewForm.addFormGroup(new BootstrapFormGroup().setLabel(EText.LABEL_SOCKET_TIMEOUT.getDisplayText(locale)).setCtrl(Long.toString(iSMTPSettings.getTimeoutMilliSecs())));
    }

    protected void validateAndSaveInputParameters(@Nonnull WPECTYPE WPECTYPE, @Nullable NamedSMTPSettings namedSMTPSettings, @Nonnull FormErrorList formErrorList, @Nonnull EWebPageFormAction eWebPageFormAction) {
        Locale locale = WPECTYPE.getDisplayLocale();
        String string = WPECTYPE.params().getAsString((Object)FIELD_NAME);
        String string2 = WPECTYPE.params().getAsString((Object)FIELD_HOSTNAME);
        String string3 = WPECTYPE.params().getAsString((Object)FIELD_PORT);
        int n = StringParser.parseInt((String)string3, (int)-1);
        String string4 = WPECTYPE.params().getAsString((Object)FIELD_USERNAME);
        String string5 = WPECTYPE.params().getAsString((Object)FIELD_PASSWORD);
        if (string5 == null && namedSMTPSettings != null) {
            string5 = namedSMTPSettings.getSMTPSettings().getPassword();
        }
        String string6 = WPECTYPE.params().getAsString((Object)FIELD_CHARSET);
        Charset charset = CharsetHelper.getCharsetFromNameOrNull((String)string6);
        boolean bl = WPECTYPE.params().isCheckBoxChecked(FIELD_SSL, EmailGlobalSettings.isUseSSL());
        boolean bl2 = WPECTYPE.params().isCheckBoxChecked(FIELD_STARTTLS, EmailGlobalSettings.isUseSTARTTLS());
        long l = WPECTYPE.params().getAsLong((Object)FIELD_CONNECTION_TIMEOUT, -1L);
        long l2 = WPECTYPE.params().getAsLong((Object)FIELD_SOCKET_TIMEOUT, -1L);
        boolean bl3 = WPECTYPE.params().isCheckBoxChecked(FIELD_DEBUG_SMTP, EmailGlobalSettings.isDebugSMTP());
        if (StringHelper.hasNoText((String)string)) {
            formErrorList.addFieldError(FIELD_NAME, EText.ERROR_NAME_EMPTY.getDisplayText(locale));
        }
        if (StringHelper.hasNoText((String)string2)) {
            formErrorList.addFieldError(FIELD_HOSTNAME, EText.ERROR_HOSTNAME_EMPTY.getDisplayText(locale));
        }
        if (n < 0 || n > 65535) {
            formErrorList.addFieldError(FIELD_PORT, EText.ERROR_PORT_INVALID.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(0), Integer.toString(65535)}));
        }
        if (charset == null) {
            formErrorList.addFieldError(FIELD_CHARSET, EText.ERROR_CHARSET_INVALID.getDisplayText(locale));
        }
        if (l < 0L) {
            formErrorList.addFieldError(FIELD_CONNECTION_TIMEOUT, EText.ERROR_CONNECTION_TIMEOUT_INVALID.getDisplayText(locale));
        }
        if (l2 < 0L) {
            formErrorList.addFieldError(FIELD_SOCKET_TIMEOUT, EText.ERROR_CONNECTION_TIMEOUT_INVALID.getDisplayText(locale));
        }
        if (formErrorList.isEmpty()) {
            SMTPSettings sMTPSettings = new SMTPSettings(string2, n, string4, string5, charset, bl, bl2, l, l2, bl3);
            if (eWebPageFormAction.isEdit()) {
                if (this.m_aMgr.updateSettings(namedSMTPSettings.getID(), string, (ISMTPSettings)sMTPSettings).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.SUCCESS_EDIT.getDisplayText(locale)));
                }
            } else {
                this.m_aMgr.addSettings(string, (ISMTPSettings)sMTPSettings);
                WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.SUCCESS_CREATE.getDisplayText(locale)));
            }
        }
    }

    protected void showInputForm(@Nonnull WPECTYPE WPECTYPE, @Nullable NamedSMTPSettings namedSMTPSettings, @Nonnull BootstrapForm bootstrapForm, boolean bl, @Nonnull EWebPageFormAction eWebPageFormAction, @Nonnull FormErrorList formErrorList) {
        Locale locale = WPECTYPE.getDisplayLocale();
        ISMTPSettings iSMTPSettings = namedSMTPSettings == null ? null : namedSMTPSettings.getSMTPSettings();
        bootstrapForm.addChild((IHCNode)this.getUIHandler().createActionHeader(eWebPageFormAction.isEdit() ? EText.TITLE_EDIT.getDisplayTextWithArgs(locale, new Object[]{namedSMTPSettings.getName()}) : EText.TITLE_CREATE.getDisplayText(locale)));
        String string = EText.LABEL_NAME.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(string).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_NAME, namedSMTPSettings == null ? null : namedSMTPSettings.getName())).setPlaceholder(string)).setErrorList(formErrorList.getListOfField(FIELD_NAME)));
        string = EText.LABEL_HOSTNAME.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(string).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_HOSTNAME, iSMTPSettings == null ? null : iSMTPSettings.getHostName())).setPlaceholder(string)).setErrorList(formErrorList.getListOfField(FIELD_HOSTNAME)));
        string = EText.LABEL_PORT.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(string).setCtrl((IHCNode)((HCAutoNumericInt)((HCAutoNumericInt)new HCAutoNumericInt((IHCRequestField)new RequestField(FIELD_PORT, iSMTPSettings != null && iSMTPSettings.hasPort() ? Integer.toString(iSMTPSettings.getPort()) : ""), locale).setMin(0L)).setMax(65535L)).setThousandSeparator("")).setErrorList(formErrorList.getListOfField(FIELD_PORT)));
        string = EText.LABEL_USERNAME.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string).setCtrl((IHCNode)new HCEdit((IHCRequestField)new RequestField(FIELD_USERNAME, iSMTPSettings == null ? null : iSMTPSettings.getUserName())).setPlaceholder(string)).setErrorList(formErrorList.getListOfField(FIELD_USERNAME)));
        string = EText.LABEL_PASSWORD.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string).setCtrl((IHCNode)new HCEditPassword(FIELD_PASSWORD).setPlaceholder(string)).setErrorList(formErrorList.getListOfField(FIELD_PASSWORD)));
        string = EText.LABEL_CHARSET.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(string).setCtrl((IHCNode)new HCCharsetSelect((IHCRequestField)new RequestField(FIELD_CHARSET, iSMTPSettings == null ? DEFAULT_CHARSET_NAME : iSMTPSettings.getCharsetName()), true, locale)).setErrorList(formErrorList.getListOfField(FIELD_CHARSET)));
        string = EText.LABEL_SSL.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_SSL, iSMTPSettings == null ? EmailGlobalSettings.isUseSSL() : iSMTPSettings.isSSLEnabled()))).setErrorList(formErrorList.getListOfField(FIELD_SSL)));
        string = EText.LABEL_STARTTLS.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_STARTTLS, iSMTPSettings == null ? EmailGlobalSettings.isUseSTARTTLS() : iSMTPSettings.isSTARTTLSEnabled()))).setErrorList(formErrorList.getListOfField(FIELD_STARTTLS)));
        string = EText.LABEL_CONNECTION_TIMEOUT.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(string).setCtrl((IHCNode)((HCAutoNumericInt)new HCAutoNumericInt((IHCRequestField)new RequestField(FIELD_CONNECTION_TIMEOUT, iSMTPSettings == null ? EmailGlobalSettings.getConnectionTimeoutMilliSecs() : iSMTPSettings.getConnectionTimeoutMilliSecs()), locale).setMin(0L)).setThousandSeparator("")).setErrorList(formErrorList.getListOfField(FIELD_CONNECTION_TIMEOUT)));
        string = EText.LABEL_SOCKET_TIMEOUT.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabelMandatory(string).setCtrl((IHCNode)((HCAutoNumericInt)new HCAutoNumericInt((IHCRequestField)new RequestField(FIELD_SOCKET_TIMEOUT, iSMTPSettings == null ? EmailGlobalSettings.getTimeoutMilliSecs() : iSMTPSettings.getTimeoutMilliSecs()), locale).setMin(0L)).setThousandSeparator("")).setErrorList(formErrorList.getListOfField(FIELD_SOCKET_TIMEOUT)));
        string = EText.LABEL_DEBUG_SMTP.getDisplayText(locale);
        bootstrapForm.addFormGroup(new BootstrapFormGroup().setLabel(string).setCtrl((IHCNode)new HCCheckBox((IHCRequestFieldBoolean)new RequestFieldBoolean(FIELD_DEBUG_SMTP, iSMTPSettings == null ? EmailGlobalSettings.isDebugSMTP() : iSMTPSettings.isDebugSMTP()))).setErrorList(formErrorList.getListOfField(FIELD_DEBUG_SMTP)));
    }

    @Nullable
    @OverrideOnDemand
    protected IHCNode getTestMailIcon() {
        return EFamFamIcon.EMAIL_GO.getAsNode();
    }

    protected void showListOfExistingObjects(@Nonnull WPECTYPE WPECTYPE) {
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        BootstrapButtonToolbar bootstrapButtonToolbar = (BootstrapButtonToolbar)hCNodeList.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
        bootstrapButtonToolbar.addButtonNew(EText.BUTTON_CREATE_NEW.getDisplayText(locale), (ISimpleURL)BasePageSettingsSMTP.createCreateURL(WPECTYPE));
        if (WPECTYPE.getMenuTree().containsItemWithID((Object)"admin_monitoring_failedmails")) {
            bootstrapButtonToolbar.addChild((IHCNode)((BootstrapButton)((BootstrapButton)new BootstrapButton().addChild(EWebPageText.PAGE_NAME_MONITORING_FAILED_MAILS.getDisplayText(locale))).setOnClick((ISimpleURL)WPECTYPE.getLinkToMenuItem("admin_monitoring_failedmails"))).setIcon((IIcon)EBootstrapIcon.ARROW_RIGHT));
        }
        HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.HEADER_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.HEADER_HOST.getDisplayText(locale)), new DTCol(EText.HEADER_USERNAME.getDisplayText(locale)), new BootstrapDTColAction(locale)}).setID(this.getID());
        for (NamedSMTPSettings namedSMTPSettings : this.m_aMgr.getAllSettings().values()) {
            ISMTPSettings iSMTPSettings = namedSMTPSettings.getSMTPSettings();
            SimpleURL simpleURL = BasePageSettingsSMTP.createViewURL(WPECTYPE, (IHasID)namedSMTPSettings);
            HCRow hCRow = hCTable.addBodyRow();
            hCRow.addCell((IHCNode)new HCA((ISimpleURL)simpleURL).addChild(namedSMTPSettings.getName()));
            hCRow.addCell(iSMTPSettings.getHostName() + (iSMTPSettings.hasPort() ? ":" + iSMTPSettings.getPort() : ""));
            hCRow.addCell(iSMTPSettings.getUserName());
            IHCCell iHCCell = hCRow.addCell();
            iHCCell.addChild((IHCNode)BasePageSettingsSMTP.createEditLink(WPECTYPE, (IHasID)namedSMTPSettings, (String)EWebPageText.OBJECT_EDIT.getDisplayTextWithArgs(locale, new Object[]{namedSMTPSettings.getName()})));
            if (BasePageSettingsSMTP._canDelete(namedSMTPSettings)) {
                iHCCell.addChild((IHCNode)BasePageSettingsSMTP.createDeleteLink(WPECTYPE, (IHasID)namedSMTPSettings, (String)EWebPageText.OBJECT_DELETE.getDisplayTextWithArgs(locale, new Object[]{namedSMTPSettings.getName()})));
            } else {
                iHCCell.addChild((IHCNode)BasePageSettingsSMTP.createEmptyAction());
            }
            iHCCell.addChild((IHCNode)((HCA)new HCA((ISimpleURL)((SimpleURL)WPECTYPE.getSelfHref().add("action", ACTION_TEST_MAIL)).add("object", namedSMTPSettings.getID())).setTitle(EText.MSG_SEND_TEST_MAIL.getDisplayText(locale))).addChild(this.getTestMailIcon()));
        }
        hCNodeList.addChild((IHCNode)hCTable);
        BootstrapDataTables bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        hCNodeList.addChild((IHCNode)bootstrapDataTables);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        BUTTON_CREATE_NEW("Neue SMTP-Einstellungen anlegen", "Create new SMTP settings"),
        HEADER_NAME("Name", "Name"),
        HEADER_HOST("Host-Name", "Host name"),
        HEADER_USERNAME("Benutzername", "User name"),
        HEADER_DETAILS("Details von SMTP-Einstellungen ''{0}''", "Details of SMTP settings ''{0}''"),
        LABEL_NAME("Name", "Name"),
        LABEL_HOSTNAME("Host", "Host name"),
        LABEL_PORT("Port", "Port"),
        PORT_DEFAULT("[Standard Port]", "[default port]"),
        LABEL_USERNAME("Benutzername", "User name"),
        LABEL_PASSWORD("Passwort", "Password"),
        LABEL_CHARSET("Zeichensatz", "Character set"),
        LABEL_SSL("Verwende SSL?", "Use SSL?"),
        LABEL_STARTTLS("Verwende STARTTLS?", "Use STARTTLS?"),
        LABEL_CONNECTION_TIMEOUT("Verbindungs-Timeout (ms)", "Connection timeout (ms)"),
        LABEL_SOCKET_TIMEOUT("Sende-Timeout (ms)", "Socket timeout (ms)"),
        LABEL_DEBUG_SMTP("SMTP Debug", "Debug SMTP"),
        MSG_NO_PASSWORD_SET("keines gesetzt", "none defined"),
        TITLE_CREATE("Neue SMTP-Einstellungen anlegen", "Create new SMTP settings"),
        TITLE_EDIT("SMTP-Einstellungen ''{0}'' bearbeiten", "Edit SMTP settings ''{0}''"),
        ERROR_NAME_EMPTY("Es muss ein Name f\u00fcr diese SMTP-Einstellungen angegeben werden!", "A name must be provided for these SMTP settings!"),
        ERROR_HOSTNAME_EMPTY("Es muss ein Host-Name oder eine IP-Adresse des SMTP-Servers angegeben werden!", "A name or IP address of the SMTP server must be provided!"),
        ERROR_PORT_INVALID("Der angegebene Port ist ung\u00fcltig. G\u00fcltige Ports liegen zwischen {0} und {1}!", "The provided port is invalid. Valid ports must be between {0} and {1}!"),
        ERROR_CHARSET_INVALID("Der ausgew\u00e4hlte Zeichensatz ist ung\u00fcltig!", "The selected character set is invalid!"),
        ERROR_CONNECTION_TIMEOUT_INVALID("Das Verbindungs-Timeout muss gr\u00f6\u00dfer oder gleich 0 sein!", "The connection timeout must be greater or equal to 0!"),
        ERROR_SOCKET_TIMEOUT_INVALID("Das Verbindungs-Timeout muss gr\u00f6\u00dfer oder gleich 0 sein!", "The connection timeout must be greater or equal to 0!"),
        SUCCESS_CREATE("Die neue SMTP-Einstellungen wurden erfolgreich angelegt!", "Successfully created the new SMTP settings!"),
        SUCCESS_EDIT("Die SMTP-Einstellungen wurde erfolgreich bearbeitet!", "Sucessfully edited the SMTP settings!"),
        DELETE_QUERY("Sollen die SMTP-Einstellungen ''{0}'' wirklich gel\u00f6scht werden?", "Are you sure to delete the SMTP settings ''{0}''?"),
        DELETE_SUCCESS("Die SMTP-Einstellungen ''{0}'' wurden erfolgreich gel\u00f6scht!", "The SMTP settings ''{0}'' were successfully deleted!"),
        DELETE_ERROR("Fehler beim L\u00f6schen der SMTP-Einstellungen ''{0}''!", "Error deleting the SMTP settings ''{0}''!"),
        TITLE_TEST_MAIL("Test-E-Mail mit den SMTP-Einstellungen ''{0}'' versenden", "Send test email with SMTP settings ''{0}''"),
        MSG_SEND_TEST_MAIL("Test-E-Mail senden", "Send test mail"),
        BUTTON_SEND_TEST_MAIL("Test-E-Mail senden", "Send test mail"),
        MSG_SENDER("Absender", "Sender"),
        MSG_RECEIVER("Empf\u00e4nger", "Receiver"),
        MSG_SUBJECT("Betreff", "Subject"),
        MSG_BODY("Inhalt", "Body"),
        TEST_SUBJECT("Test-E-Mail", "Test email"),
        TEST_BODY("Das ist eine automatisch generierte Test-E-Mail", "This is an automatically generated test email"),
        ERR_SENDER_INVALID("Es muss eine g\u00fcltige E-Mail-Adresse angegeben werden.", "A valid email address must be provided"),
        ERR_RECEIVER_INVALID("Es muss eine g\u00fcltige E-Mail-Adresse angegeben werden.", "A valid email address must be provided"),
        ERR_SUBJECT_INVALID("Es muss Betreff angegeben werden.", "An email subject must be provided"),
        ERR_BODY_INVALID("Es muss eine g\u00fcltige Nachricht angegeben werden.", "A valid email message must be provided"),
        SUCCESS_TEST_MAIL("Die Test-Nachricht wurde zum Versand \u00fcbermittelt.", "The test email message was scheduled for sending.");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

