/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.settings;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.state.EChange;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.forms.HCHiddenField;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.request.IHCRequestField;
import com.helger.photon.bootstrap3.alert.BootstrapInfoBox;
import com.helger.photon.bootstrap3.alert.BootstrapSuccessBox;
import com.helger.photon.bootstrap3.button.BootstrapButtonToolbar;
import com.helger.photon.bootstrap3.ext.BootstrapSystemMessage;
import com.helger.photon.bootstrap3.form.BootstrapForm;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.core.execcontext.ILayoutExecutionContext;
import com.helger.photon.core.form.RequestField;
import com.helger.photon.core.mgr.PhotonBasicManager;
import com.helger.photon.core.systemmsg.ESystemMessageType;
import com.helger.photon.core.systemmsg.SystemMessageManager;
import com.helger.photon.uicore.html.select.HCSystemMessageTypeSelect;
import com.helger.photon.uicore.icon.EDefaultIcon;
import com.helger.photon.uicore.icon.IIcon;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.autosize.HCTextAreaAutosize;
import java.time.LocalDateTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSettingsSystemMessage<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    private static final String FIELD_MESSAGE_TYPE = "msgtype";
    private static final String FIELD_MESSAGE = "msg";

    public BasePageSettingsSystemMessage(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SETTINGS_SYSTEMMESSAGE.getAsMLT());
    }

    public BasePageSettingsSystemMessage(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSettingsSystemMessage(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSettingsSystemMessage(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    @Nullable
    @OverrideOnDemand
    protected IHCElementWithChildren<?> renderCurrentSystemMessage(@Nonnull WPECTYPE WPECTYPE) {
        return BootstrapSystemMessage.createDefault();
    }

    public void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        String string;
        LocalDateTime localDateTime;
        EChange eChange;
        Locale locale = WPECTYPE.getDisplayLocale();
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        SystemMessageManager systemMessageManager = PhotonBasicManager.getSystemMessageMgr();
        boolean bl = true;
        if (WPECTYPE.hasAction("edit")) {
            if (WPECTYPE.hasSubAction("save")) {
                if (this.getCSRFHandler().checkCSRFNonce(WPECTYPE).isContinue() && (eChange = systemMessageManager.setSystemMessage((ESystemMessageType)(localDateTime = ESystemMessageType.getFromIDOrDefault((String)WPECTYPE.params().getAsString((Object)FIELD_MESSAGE_TYPE))), string = WPECTYPE.params().getAsString((Object)FIELD_MESSAGE))).isChanged()) {
                    WPECTYPE.postRedirectGetInternal((IHCNode)new BootstrapSuccessBox().addChild(EText.SAVE_SUCCESS.getDisplayText(locale)));
                }
            } else {
                localDateTime = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE));
                string = systemMessageManager.getSystemMessage();
                localDateTime.addChild((IHCNode)new HCSystemMessageTypeSelect(new RequestField(FIELD_MESSAGE_TYPE, systemMessageManager.getMessageType().getID()), locale));
                localDateTime.addChild((IHCNode)new HCTextAreaAutosize((IHCRequestField)new RequestField(FIELD_MESSAGE, string)));
                localDateTime.addChild((IHCNode)new HCHiddenField("action", "edit"));
                localDateTime.addChild((IHCNode)new HCHiddenField("action2", "save"));
                localDateTime.addChild((IHCNode)this.getCSRFHandler().createCSRFNonceField());
                eChange = (BootstrapButtonToolbar)localDateTime.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
                eChange.addSubmitButtonSave(locale);
                eChange.addButtonCancel(locale);
                bl = false;
            }
        }
        if (bl) {
            localDateTime = systemMessageManager.getLastUpdateDT();
            if (localDateTime != null) {
                hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.LAST_UPDATE.getDisplayTextWithArgs(locale, new Object[]{PDTToString.getAsString((LocalDateTime)localDateTime, (Locale)locale)})));
            }
            string = (BootstrapForm)hCNodeList.addAndReturnChild((IHCNode)this.getUIHandler().createFormSelf((ILayoutExecutionContext)WPECTYPE));
            if (systemMessageManager.hasSystemMessage()) {
                string.addChild((IHCNode)this.getUIHandler().createDataGroupHeader(EText.CURRENT_MESSAGE_TYPE.getDisplayTextWithArgs(locale, new Object[]{systemMessageManager.getMessageType().getDisplayText(locale)})));
                string.addChild((IHCNode)new HCDiv().addChild(this.renderCurrentSystemMessage(WPECTYPE)));
            } else {
                string.addChild((IHCNode)new BootstrapInfoBox().addChild(EText.NO_SYSTEM_MESSAGE.getDisplayText(locale)));
            }
            string.addChild((IHCNode)new HCHiddenField("action", "edit"));
            eChange = (BootstrapButtonToolbar)string.addAndReturnChild((IHCNode)new BootstrapButtonToolbar(WPECTYPE));
            eChange.addSubmitButton(EPhotonCoreText.BUTTON_EDIT.getDisplayText(locale), (IIcon)EDefaultIcon.EDIT);
        }
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        SAVE_SUCCESS("Die neue Systemnachricht wurde erfolgreich gespeichert", "The new system message was saved successfully."),
        LAST_UPDATE("Letzte Aktualisierung: {0}", "Last update: {0}"),
        CURRENT_MESSAGE_TYPE("Aktuelle Systemnachricht vom Typ ''{0}''", "Current system message of type ''{0}''"),
        NO_SYSTEM_MESSAGE("Keine Systemnachricht gesetzt.", "No system message present.");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

