/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.sysinfo;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.css.ECSSUnit;
import com.helger.css.property.CCSSProperties;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCell;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCEM;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.pages.sysinfo.NetworkInterfaceHelper;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.photon.uictrls.datatables.column.EDTColType;
import com.helger.tree.sort.TreeWithIDSorter;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.DefaultTreeItemWithID;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSysInfoNetwork<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageSysInfoNetwork(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SYSINFO_NETWORK.getAsMLT());
    }

    public BasePageSysInfoNetwork(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSysInfoNetwork(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSysInfoNetwork(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        BootstrapDataTables bootstrapDataTables;
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        final Locale locale = WPECTYPE.getDisplayLocale();
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        final HCTable hCTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_ID.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_NAME.getDisplayText(locale)), new DTCol(EText.MSG_MAC.getDisplayText(locale)), new DTCol(EText.MSG_IS_UP.getDisplayText(locale)), new DTCol(EText.MSG_IS_LOOPBACK.getDisplayText(locale)), new DTCol(EText.MSG_IS_POINT_TO_POINT.getDisplayText(locale)), new DTCol(EText.MSG_IS_MULTICAST.getDisplayText(locale)), new DTCol(EText.MSG_MTU.getDisplayText(locale)).setDisplayType(EDTColType.INT, locale), new DTCol(EText.MSG_IS_VIRTUAL.getDisplayText(locale))}).setID(this.getID() + "-ni");
        try {
            bootstrapDataTables = NetworkInterfaceHelper.createNetworkInterfaceTree();
            TreeWithIDSorter.sortByValue(bootstrapDataTables, Comparator.comparing(NetworkInterface::getDisplayName));
            TreeVisitor.visitTree(bootstrapDataTables, (IHierarchyVisitorCallback)new DefaultHierarchyVisitorCallback<DefaultTreeItemWithID<String, NetworkInterface>>(){

                public EHierarchyVisitorReturn onItemBeforeChildren(@Nonnull DefaultTreeItemWithID<String, NetworkInterface> defaultTreeItemWithID) {
                    NetworkInterface networkInterface = (NetworkInterface)defaultTreeItemWithID.getData();
                    int n = this.getLevel();
                    HCRow hCRow = hCTable.addBodyRow();
                    hCRow.addCell(networkInterface.getName());
                    IHCCell iHCCell = hCRow.addAndReturnCell(networkInterface.getDisplayName());
                    if (n > 0) {
                        iHCCell.addStyle(CCSSProperties.PADDING_LEFT.newValue(ECSSUnit.em((int)n)));
                    }
                    try {
                        byte[] byArray = networkInterface.getHardwareAddress();
                        hCRow.addCell(byArray == null ? "" : StringHelper.getHexEncoded((byte[])byArray));
                    }
                    catch (SocketException socketException) {
                        hCRow.addCell((IHCNode)new HCEM().addChild(EText.MSG_ERROR.getDisplayText(locale)));
                    }
                    try {
                        hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)networkInterface.isUp(), (Locale)locale));
                    }
                    catch (SocketException socketException) {
                        hCRow.addCell((IHCNode)new HCEM().addChild(EText.MSG_ERROR.getDisplayText(locale)));
                    }
                    try {
                        hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)networkInterface.isLoopback(), (Locale)locale));
                    }
                    catch (SocketException socketException) {
                        hCRow.addCell((IHCNode)new HCEM().addChild(EText.MSG_ERROR.getDisplayText(locale)));
                    }
                    try {
                        hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)networkInterface.isPointToPoint(), (Locale)locale));
                    }
                    catch (SocketException socketException) {
                        hCRow.addCell((IHCNode)new HCEM().addChild(EText.MSG_ERROR.getDisplayText(locale)));
                    }
                    try {
                        hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)networkInterface.supportsMulticast(), (Locale)locale));
                    }
                    catch (SocketException socketException) {
                        hCRow.addCell((IHCNode)new HCEM().addChild(EText.MSG_ERROR.getDisplayText(locale)));
                    }
                    int n2 = -1;
                    try {
                        n2 = networkInterface.getMTU();
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    if (n2 > 0) {
                        hCRow.addCell(Integer.toString(n2));
                    } else {
                        hCRow.addCell();
                    }
                    hCRow.addCell(EPhotonCoreText.getYesOrNo((boolean)networkInterface.isVirtual(), (Locale)locale));
                    return EHierarchyVisitorReturn.CONTINUE;
                }
            });
        }
        catch (Throwable throwable) {
            hCTable.addSpanningBodyContent(EText.MSG_ERROR_FINDING.getDisplayText(locale) + (GlobalDebug.isDebugMode() ? ": " + throwable.getMessage() : ""));
        }
        bootstrapDataTables = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)hCTable);
        bootstrapDataTables.setPageLengthAll();
        bootstrapTabBox.addTab("network", EText.MSG_NETWORK_INTERFACES.getDisplayText(locale), (IHCNode)((HCNodeList)new HCNodeList().addChild((IHCNode)hCTable)).addChild((IHCNode)bootstrapDataTables));
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_NETWORK_INTERFACES("Netzwerkkarten", "Network interfaces"),
        MSG_ERROR_FINDING("Fehler beim Ermitteln der Netzwerkkarten", "Error determining network interfaces"),
        MSG_ID("ID", "id"),
        MSG_NAME("Name", "Name"),
        MSG_MAC("MAC Adresse", "MAC address"),
        MSG_IS_UP("Up?", "Up?"),
        MSG_IS_LOOPBACK("Lb?", "Lb?"),
        MSG_IS_POINT_TO_POINT("P2P?", "P2P?"),
        MSG_IS_MULTICAST("MC?", "MC?"),
        MSG_MTU("MTU", "MTU"),
        MSG_IS_VIRTUAL("Virt?", "Virt?"),
        MSG_ERROR("Fehler!", "Error!");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

