/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.sysinfo;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.compare.IComparator;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.nav.BootstrapTabBox;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.table.BootstrapTable;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.servlet.cookie.CookieHelper;
import com.helger.servlet.request.RequestLogger;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class BasePageSysInfoRequest<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageSysInfoRequest(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SYSINFO_REQUEST.getAsMLT());
    }

    public BasePageSysInfoRequest(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSysInfoRequest(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSysInfoRequest(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse = WPECTYPE.getRequestScope();
        HttpServletRequest httpServletRequest = iRequestWebScopeWithoutResponse.getRequest();
        BootstrapTabBox bootstrapTabBox = new BootstrapTabBox();
        BootstrapTable bootstrapTable = new BootstrapTable(new IHCCol[]{new HCCol(250), HCCol.star()});
        bootstrapTable.setID(this.getID() + "http");
        bootstrapTable.addHeaderRow().addCells(new String[]{EText.MSG_NAME.getDisplayText(locale), EText.MSG_VALUE.getDisplayText(locale)});
        for (Map.Entry entry : iRequestWebScopeWithoutResponse.headers().getAllHeaders().getSortedByKey(IComparator.getComparatorCollating((Locale)locale)).entrySet()) {
            bootstrapTable.addBodyRow().addCell((String)entry.getKey()).addCell((Iterable)HCExtHelper.list2divList((Iterable)((Iterable)entry.getValue())));
        }
        Object object = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)bootstrapTable);
        bootstrapTabBox.addTab("http", EText.MSG_HTTP_HEADERS.getDisplayText(locale), (IHCNode)new HCNodeList().addChildren(new IHCNode[]{bootstrapTable, object}));
        bootstrapTable = new BootstrapTable(new IHCCol[]{new HCCol(), new HCCol(), new HCCol()});
        bootstrapTable.setID(this.getID() + "cookies");
        bootstrapTable.addHeaderRow().addCells(new String[]{EText.MSG_NAME.getDisplayText(locale), EText.MSG_VALUE.getDisplayText(locale), EText.MSG_DETAILS.getDisplayText(locale)});
        for (Map.Entry entry : CookieHelper.getAllCookies((HttpServletRequest)httpServletRequest).getSortedByKey(IComparator.getComparatorCollating((Locale)locale)).entrySet()) {
            Cookie cookie = (Cookie)entry.getValue();
            String string = "";
            if (StringHelper.hasText((String)cookie.getPath())) {
                string = string + "[path: " + cookie.getPath() + "]";
            }
            if (StringHelper.hasText((String)cookie.getDomain())) {
                string = string + "[domain: " + cookie.getDomain() + "]";
            }
            if (cookie.getSecure()) {
                string = string + "[secure]";
            }
            string = string + "[maxage: " + cookie.getMaxAge() + "]";
            bootstrapTable.addBodyRow().addCell((String)entry.getKey()).addCell(cookie.getValue()).addCell(string);
        }
        object = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)bootstrapTable);
        bootstrapTabBox.addTab("cookies", EText.MSG_COOKIES.getDisplayText(locale), (IHCNode)new HCNodeList().addChildren(new IHCNode[]{bootstrapTable, object}));
        bootstrapTable = new BootstrapTable(new IHCCol[]{new HCCol(250), HCCol.star()});
        bootstrapTable.setID(this.getID() + "params");
        bootstrapTable.addHeaderRow().addCells(new String[]{EText.MSG_NAME.getDisplayText(locale), EText.MSG_VALUE.getDisplayText(locale)});
        for (Map.Entry entry : RequestLogger.getRequestParameterMap((HttpServletRequest)httpServletRequest).entrySet()) {
            bootstrapTable.addBodyRow().addCell((String)entry.getKey()).addCell((String)entry.getValue());
        }
        object = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)bootstrapTable);
        bootstrapTabBox.addTab("params", EText.MSG_PARAMETERS.getDisplayText(locale), (IHCNode)new HCNodeList().addChildren(new IHCNode[]{bootstrapTable, object}));
        bootstrapTable = new BootstrapTable(new IHCCol[]{new HCCol(250), HCCol.star(), HCCol.star()});
        bootstrapTable.setID(this.getID() + "attrs");
        bootstrapTable.addHeaderRow().addCells(new String[]{EText.MSG_NAME.getDisplayText(locale), EText.MSG_TYPE.getDisplayText(locale), EText.MSG_VALUE.getDisplayText(locale)});
        for (Map.Entry entry : iRequestWebScopeWithoutResponse.attrs().getSortedByKey(IComparator.getComparatorCollating((Locale)locale)).entrySet()) {
            bootstrapTable.addBodyRow().addCell((String)entry.getKey()).addCell(ClassHelper.getClassLocalName(entry.getValue())).addCell(String.valueOf(entry.getValue()));
        }
        object = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)bootstrapTable);
        bootstrapTabBox.addTab("attrs", EText.MSG_ATTRIBUTES.getDisplayText(locale), (IHCNode)new HCNodeList().addChildren(new IHCNode[]{bootstrapTable, object}));
        bootstrapTable = new BootstrapTable(new IHCCol[]{new HCCol(250), HCCol.star()});
        bootstrapTable.setID(this.getID() + "props");
        bootstrapTable.addHeaderRow().addCells(new String[]{EText.MSG_NAME.getDisplayText(locale), EText.MSG_VALUE.getDisplayText(locale)});
        for (Map.Entry entry : RequestLogger.getRequestFieldMap((HttpServletRequest)httpServletRequest).entrySet()) {
            bootstrapTable.addBodyRow().addCell((String)entry.getKey()).addCell((String)entry.getValue());
        }
        object = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)bootstrapTable);
        bootstrapTabBox.addTab("props", EText.MSG_PROPERTIES.getDisplayText(locale), (IHCNode)new HCNodeList().addChildren(new IHCNode[]{bootstrapTable, object}));
        hCNodeList.addChild((IHCNode)bootstrapTabBox);
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_HTTP_HEADERS("HTTP Header", "HTTP header"),
        MSG_COOKIES("Cookies", "Cookies"),
        MSG_PARAMETERS("Request-Parameter", "Request parameters"),
        MSG_PROPERTIES("Request-Eigenschaften", "Request properties"),
        MSG_ATTRIBUTES("Request-Attribute", "Request attributes"),
        MSG_NAME("Name", "Name"),
        MSG_TYPE("Typ", "Type"),
        MSG_VALUE("Wert", "Value"),
        MSG_DETAILS("Details", "Details");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

