/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.sysinfo;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.compare.ESortOrder;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.io.file.FileSystemIterator;
import com.helger.commons.io.misc.SizeHelper;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.CryptoPolicy;
import com.helger.commons.system.SystemHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.grouping.HCUL;
import com.helger.html.hc.html.tabular.HCCol;
import com.helger.html.hc.html.tabular.HCRow;
import com.helger.html.hc.html.tabular.HCTable;
import com.helger.html.hc.html.tabular.IHCCol;
import com.helger.html.hc.html.tabular.IHCTable;
import com.helger.html.hc.html.textlevel.HCEM;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.app.io.WebFileIO;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.bootstrap3.table.BootstrapTable;
import com.helger.photon.bootstrap3.uictrls.datatables.BootstrapDataTables;
import com.helger.photon.core.EPhotonCoreText;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import com.helger.photon.uictrls.datatables.column.DTCol;
import com.helger.web.scope.mgr.WebScopeManager;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSysInfoSystemProperties<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageSysInfoSystemProperties(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SYSINFO_SYSPROPS.getAsMLT());
    }

    public BasePageSysInfoSystemProperties(@Nonnull @Nonempty String string, @Nonnull String string2) {
        super(string, string2);
    }

    public BasePageSysInfoSystemProperties(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSysInfoSystemProperties(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    private static void _addDirectoryContent(@Nonnull BootstrapTable bootstrapTable, @Nonnull String string, @Nonnull IHCNode iHCNode, @Nonnull SizeHelper sizeHelper, @Nonnull Locale locale) {
        String string2 = SystemProperties.getPropertyValue((String)string);
        if (string2 != null) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (String string3 : StringHelper.getExploded((String)SystemProperties.getPathSeparator(), (String)string2)) {
                commonsArrayList.add((Object)new HCDiv().addChild(string3));
                HCUL hCUL = new HCUL();
                commonsArrayList.add((Object)hCUL);
                File file = new File(string3);
                if (!file.exists()) {
                    hCUL.addItem((IHCNode)new HCEM().addChild(EText.MSG_DIR_NOT_EXISTING.getDisplayText(locale)));
                    continue;
                }
                CommonsArrayList commonsArrayList2 = new CommonsArrayList((Iterable)new FileSystemIterator(file));
                if (commonsArrayList2.isEmpty()) {
                    hCUL.addItem((IHCNode)new HCEM().addChild(EText.MSG_DIR_EMPTY.getDisplayText(locale)));
                    continue;
                }
                for (File file2 : commonsArrayList2) {
                    hCUL.addItem(EText.MSG_DIR_FILE_ENTRY.getDisplayTextWithArgs(locale, new Object[]{file2.getName(), file2.length(), sizeHelper.getAsMatching(file2.length(), 2)}));
                }
            }
            bootstrapTable.addBodyRow().addCell(iHCNode).addCell((Iterable)commonsArrayList);
        }
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        Object object;
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.MSG_HEADER_SPECIAL_SYSPROPS.getDisplayText(locale)));
        BootstrapTable bootstrapTable = new BootstrapTable(new IHCCol[]{new HCCol(250), HCCol.star()});
        bootstrapTable.setID(this.getID() + "$special");
        bootstrapTable.addHeaderRow().addCells(new String[]{EText.MSG_HEADER_NAME.getDisplayText(locale), EText.MSG_HEADER_VALUE.getDisplayText(locale)});
        Object object2 = SizeHelper.getSizeHelperOfLocale((Locale)locale);
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_OS.getDisplayText(locale), SystemHelper.getOperatingSystem().getDisplayName() + " / " + SystemHelper.getOperatingSystemName()});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_NUM_PROCESSORS.getDisplayText(locale), Integer.toString(SystemHelper.getNumberOfProcessors())});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_CHARSET.getDisplayText(locale), SystemHelper.getSystemCharset().toString()});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_LOCALE.getDisplayText(locale), SystemHelper.getSystemLocale().toString()});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_MEM_FREE.getDisplayText(locale), Long.toString(SystemHelper.getFreeMemory()) + " / " + object2.getAsMatching(SystemHelper.getFreeMemory(), 2)});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_MEM_MAX.getDisplayText(locale), Long.toString(SystemHelper.getMaxMemory()) + " / " + object2.getAsMatching(SystemHelper.getMaxMemory(), 2)});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_MEM_TOTAL.getDisplayText(locale), Long.toString(SystemHelper.getTotalMemory()) + " / " + object2.getAsMatching(SystemHelper.getTotalMemory(), 2)});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_CONTEXT_CLASSLOADER.getDisplayText(locale), ClassLoaderHelper.getContextClassLoader().toString()});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_CLASSLOADER.getDisplayText(locale), ClassLoaderHelper.getSystemClassLoader().toString()});
        Object object3 = WebFileIO.getDataIO().getBasePathFile();
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_BASEDIR.getDisplayText(locale), ((File)object3).toString()});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_BASEDIR_TOTAL.getDisplayText(locale), object2.getAsMatching(((File)object3).getTotalSpace(), 2)});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_BASEDIR_FREE.getDisplayText(locale), object2.getAsMatching(((File)object3).getFreeSpace(), 2)});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_BASEDIR_USABLE.getDisplayText(locale), object2.getAsMatching(((File)object3).getUsableSpace(), 2)});
        Object object42 = WebFileIO.getServletContextIO().getBasePath();
        Object object5 = new File((String)object42);
        if (((File)object5).exists()) {
            object = ((File)object5).getAbsolutePath();
            if (!((String)object).equals(object42)) {
                object42 = (String)object42 + " (" + (String)object + ")";
            }
            bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_SC_DIR.getDisplayText(locale), object42});
            bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_SC_DIR_TOTAL.getDisplayText(locale), object2.getAsMatching(((File)object5).getTotalSpace(), 2)});
            bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_SC_DIR_FREE.getDisplayText(locale), object2.getAsMatching(((File)object5).getFreeSpace(), 2)});
            bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_SC_DIR_USABLE.getDisplayText(locale), object2.getAsMatching(((File)object5).getUsableSpace(), 2)});
        } else {
            bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_SYSTEM_SC_DIR.getDisplayText(locale), EText.MSG_SYSTEM_SC_NO_DIR.getDisplayTextWithArgs(locale, new Object[]{object42})});
        }
        object = WebScopeManager.getGlobalScope().getCreationDateTime();
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_STARTUP_DATE_TIME.getDisplayText(locale), PDTToString.getAsString((LocalDateTime)object, (Locale)locale)});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_UPTIME.getDisplayText(locale), Duration.between((Temporal)object, PDTFactory.getCurrentLocalDateTime()).toString()});
        bootstrapTable.addBodyRow().addCells(new String[]{EText.MSG_JCE_UNLIMITED_STRENGTH.getDisplayText(locale), EPhotonCoreText.getYesOrNo((boolean)CryptoPolicy.isUnlimitedStrengthCryptoAvailable(), (Locale)locale)});
        BasePageSysInfoSystemProperties._addDirectoryContent(bootstrapTable, "java.endorsed.dirs", (IHCNode)new HCTextNode(EText.MSG_ENDORSED_DIR.getDisplayText(locale)), object2, locale);
        BasePageSysInfoSystemProperties._addDirectoryContent(bootstrapTable, "java.ext.dirs", (IHCNode)new HCTextNode(EText.MSG_EXT_DIR.getDisplayText(locale)), object2, locale);
        hCNodeList.addChild((IHCNode)bootstrapTable);
        hCNodeList.addChild((IHCNode)this.getUIHandler().createActionHeader(EText.MSG_HEADER_SYSPROPS.getDisplayText(locale)));
        bootstrapTable = (HCTable)new HCTable(new IHCCol[]{new DTCol(EText.MSG_HEADER_NAME.getDisplayText(locale)).setInitialSorting(ESortOrder.ASCENDING), new DTCol(EText.MSG_HEADER_VALUE.getDisplayText(locale))}).setID(this.getID());
        object2 = SystemProperties.getPathSeparator();
        for (Object object42 : CollectionHelper.getSortedByKey((Map)SystemProperties.getAllProperties()).entrySet()) {
            object5 = (String)object42.getKey();
            object = (String)object42.getValue();
            HCRow hCRow = bootstrapTable.addBodyRow();
            if ((((String)object5).endsWith(".path") || ((String)object5).endsWith(".dirs")) && ((String)object).contains((CharSequence)object2)) {
                hCRow.addCell((String)object5);
                hCRow.addCell((Iterable)HCExtHelper.nl2brList((String)StringHelper.replaceAll((String)object, (String)object2, (CharSequence)"\n")));
                continue;
            }
            hCRow.addCells(new String[]{object5, object});
        }
        hCNodeList.addChild((IHCNode)bootstrapTable);
        object3 = BootstrapDataTables.createDefaultDataTables(WPECTYPE, (IHCTable)bootstrapTable);
        hCNodeList.addChild((IHCNode)object3);
    }

    @Translatable
    protected static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_HEADER_SPECIAL_SYSPROPS("Spezielle System-Eigenschaften:", "Special system properties:"),
        MSG_HEADER_SYSPROPS("Alle System-Eigenschaften:", "All system properties:"),
        MSG_HEADER_NAME("Name", "Name"),
        MSG_HEADER_VALUE("Wert", "Value"),
        MSG_SYSTEM_OS("Betriebssystem", "Operating system"),
        MSG_SYSTEM_NUM_PROCESSORS("Anzahl Prozessoren", "Number of processors"),
        MSG_SYSTEM_CHARSET("System-Zeichensatz", "System charset"),
        MSG_SYSTEM_LOCALE("System-Sprache", "System locale"),
        MSG_SYSTEM_MEM_FREE("Freier Speicher", "Free memory"),
        MSG_SYSTEM_MEM_MAX("Max Speicher", "Max memory"),
        MSG_SYSTEM_MEM_TOTAL("Totaler Speicher", "Total memory"),
        MSG_CONTEXT_CLASSLOADER("Context Classloader", "Context classloader"),
        MSG_SYSTEM_CLASSLOADER("System Classloader", "System classloader"),
        MSG_SYSTEM_BASEDIR("Datenverzeichnis", "Data directory"),
        MSG_SYSTEM_BASEDIR_TOTAL("Speicherplatz im Datenverzeichnis", "Total space in the data directory"),
        MSG_SYSTEM_BASEDIR_FREE("Freier Speicherplatz im Datenverzeichnis", "Free space in the data directory"),
        MSG_SYSTEM_BASEDIR_USABLE("Verwendbarer Speicherplatz im Datenverzeichnis", "Usable space in the data directory"),
        MSG_SYSTEM_SC_DIR("WebApp-Verzeichnis", "WebApp directory"),
        MSG_SYSTEM_SC_DIR_TOTAL("Speicherplatz im WebApp-Verzeichnis", "Total space in the WebApp directory"),
        MSG_SYSTEM_SC_DIR_FREE("Freier Speicherplatz im WebApp-Verzeichnis", "Free space in the WebApp directory"),
        MSG_SYSTEM_SC_DIR_USABLE("Verwendbarer Speicherplatz im WebApp-Verzeichnis", "Usable space in the WebApp directory"),
        MSG_SYSTEM_SC_NO_DIR("Kein Verzeichnis: {0}", "Not a directory: {0}"),
        MSG_STARTUP_DATE_TIME("Startzeit der Anwendung", "Application startup time"),
        MSG_UPTIME("Uptime", "Uptime"),
        MSG_JCE_UNLIMITED_STRENGTH("JCE Unlimited Strength Policy", "JCE Unlimited Strength Policy"),
        MSG_ENDORSED_DIR("Endorsed Verzeichnis", "Endorsed directory"),
        MSG_EXT_DIR("Extension Verzeichnis", "Extension directory"),
        MSG_DIR_NOT_EXISTING("Das Verzeichnis existiert nicht", "The directory does not exist"),
        MSG_DIR_EMPTY("Das Verzeichnis ist leer", "The directory is empty"),
        MSG_DIR_FILE_ENTRY("{0} ({1} Bytes - {2})", "{0} ({1} bytes - {2})");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

