/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.sysinfo;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.commons.thirdparty.IThirdPartyModule;
import com.helger.commons.thirdparty.ThirdPartyModuleRegistry;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.HCUL;
import com.helger.html.hc.html.sections.HCH4;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap3.pages.AbstractBootstrapWebPage;
import com.helger.photon.uicore.page.EWebPageText;
import com.helger.photon.uicore.page.IWebPageExecutionContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePageSysInfoThirdPartyLibraries<WPECTYPE extends IWebPageExecutionContext>
extends AbstractBootstrapWebPage<WPECTYPE> {
    public BasePageSysInfoThirdPartyLibraries(@Nonnull @Nonempty String string) {
        super(string, EWebPageText.PAGE_NAME_SYSINFO_THIRDPARTYLIBS.getAsMLT());
    }

    public BasePageSysInfoThirdPartyLibraries(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string, string2);
    }

    public BasePageSysInfoThirdPartyLibraries(@Nonnull @Nonempty String string, @Nonnull String string2, @Nullable String string3) {
        super(string, string2, string3);
    }

    public BasePageSysInfoThirdPartyLibraries(@Nonnull @Nonempty String string, @Nonnull IMultilingualText iMultilingualText, @Nullable IMultilingualText iMultilingualText2) {
        super(string, iMultilingualText, iMultilingualText2);
    }

    @Nonnull
    private static IHCNode _getModuleHCNode(@Nonnull IThirdPartyModule iThirdPartyModule, @Nonnull Locale locale) {
        HCNodeList hCNodeList = new HCNodeList();
        String string = iThirdPartyModule.getDisplayName();
        if (iThirdPartyModule.getVersion() != null) {
            string = string + ' ' + iThirdPartyModule.getVersion().getAsString();
        }
        if (iThirdPartyModule.getWebSiteURL() == null) {
            hCNodeList.addChild(string);
        } else {
            hCNodeList.addChild((IHCNode)((HCA)new HCA((ISimpleURL)new SimpleURL(iThirdPartyModule.getWebSiteURL())).setTargetBlank()).addChild(string));
        }
        hCNodeList.addChild(EText.MSG_LICENSED_UNDER.getDisplayText(locale));
        String string2 = iThirdPartyModule.getLicense().getDisplayName();
        if (iThirdPartyModule.getLicense().getVersion() != null) {
            string2 = string2 + ' ' + iThirdPartyModule.getLicense().getVersion().getAsString();
        }
        if (iThirdPartyModule.getLicense().getURL() == null) {
            hCNodeList.addChild(string2);
        } else {
            hCNodeList.addChild((IHCNode)((HCA)new HCA((ISimpleURL)new SimpleURL(iThirdPartyModule.getLicense().getURL())).setTargetBlank()).addChild(string2));
        }
        return hCNodeList;
    }

    protected void fillContent(@Nonnull WPECTYPE WPECTYPE) {
        HCNodeList hCNodeList = WPECTYPE.getNodeList();
        Locale locale = WPECTYPE.getDisplayLocale();
        hCNodeList.addChild((IHCNode)new HCH4().addChild(EText.MSG_TPM_HEADER.getDisplayText(locale)));
        ICommonsOrderedSet iCommonsOrderedSet = ThirdPartyModuleRegistry.getInstance().getAllRegisteredThirdPartyModules();
        HCUL hCUL = (HCUL)hCNodeList.addAndReturnChild((IHCNode)new HCUL());
        for (IThirdPartyModule iThirdPartyModule : CollectionHelper.getSorted((Collection)iCommonsOrderedSet, (Comparator)IHasDisplayName.getComparatorCollating((Locale)locale))) {
            if (iThirdPartyModule.isOptional()) continue;
            hCUL.addItem(BasePageSysInfoThirdPartyLibraries._getModuleHCNode(iThirdPartyModule, locale));
        }
    }

    @Translatable
    protected static enum EText implements IHasDisplayText
    {
        MSG_TPM_HEADER("Folgende externen Module werden verwendet", "The following external libraries are used"),
        MSG_LICENSED_UNDER(" lizensiert unter ", " licensed under ");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

