/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap3.pages.sysinfo;

import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.hierarchy.IParentProvider;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.tree.withid.unique.DefaultTreeWithGlobalUniqueID;
import java.net.NetworkInterface;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class NetworkInterfaceHelper {
    private static final NetworkInterfaceHelper s_aInstance = new NetworkInterfaceHelper();

    private NetworkInterfaceHelper() {
    }

    @Nonnull
    public static DefaultTreeWithGlobalUniqueID<String, NetworkInterface> createNetworkInterfaceTree() {
        DefaultTreeWithGlobalUniqueID defaultTreeWithGlobalUniqueID = new DefaultTreeWithGlobalUniqueID();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        try {
            for (NetworkInterface networkInterface : IteratorHelper.getIterator(NetworkInterface.getNetworkInterfaces())) {
                if (networkInterface.getParent() == null) {
                    ((DefaultTreeItemWithID)defaultTreeWithGlobalUniqueID.getRootItem()).createChildItem((Object)networkInterface.getName(), (Object)networkInterface);
                    continue;
                }
                commonsArrayList.add((Object)networkInterface);
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to get all network interfaces", throwable);
        }
        int n = 0;
        while (commonsArrayList.isNotEmpty()) {
            NetworkInterface networkInterface;
            networkInterface = (NetworkInterface)commonsArrayList.removeFirst();
            DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)defaultTreeWithGlobalUniqueID.getItemWithID((Object)networkInterface.getParent().getName());
            if (defaultTreeItemWithID != null) {
                defaultTreeItemWithID.createChildItem((Object)networkInterface.getName(), (Object)networkInterface);
                n = 0;
                continue;
            }
            commonsArrayList.add((Object)networkInterface);
            if (++n <= commonsArrayList.size()) continue;
            throw new IllegalStateException("Seems like we have a data structure inconsistency! Remaining are: " + commonsArrayList);
        }
        return defaultTreeWithGlobalUniqueID;
    }

    @Nonnull
    public static IParentProvider<NetworkInterface> parentProvider() {
        return networkInterface -> networkInterface.getParent();
    }
}

