/**
 * Copyright (C) 2018-2020 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.photon.bootstrap4;

import javax.annotation.concurrent.Immutable;

import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;

/**
 * CSS Constants for the Bootstrap4 framework
 *
 * @author Philip Helger
 */
@Immutable
public final class CBootstrapCSS
{
  // Note: all CSS classes were created via MainExtractBootstrap4CSSClasses for
  // 4.5.0
  public static final ICSSClassProvider ACCORDION = DefaultCSSClassProvider.create ("accordion");
  public static final ICSSClassProvider ACTIVE = DefaultCSSClassProvider.create ("active");
  public static final ICSSClassProvider ALERT = DefaultCSSClassProvider.create ("alert");
  public static final ICSSClassProvider ALERT_DANGER = DefaultCSSClassProvider.create ("alert-danger");
  public static final ICSSClassProvider ALERT_DARK = DefaultCSSClassProvider.create ("alert-dark");
  public static final ICSSClassProvider ALERT_DISMISSIBLE = DefaultCSSClassProvider.create ("alert-dismissible");
  public static final ICSSClassProvider ALERT_HEADING = DefaultCSSClassProvider.create ("alert-heading");
  public static final ICSSClassProvider ALERT_INFO = DefaultCSSClassProvider.create ("alert-info");
  public static final ICSSClassProvider ALERT_LIGHT = DefaultCSSClassProvider.create ("alert-light");
  public static final ICSSClassProvider ALERT_LINK = DefaultCSSClassProvider.create ("alert-link");
  public static final ICSSClassProvider ALERT_PRIMARY = DefaultCSSClassProvider.create ("alert-primary");
  public static final ICSSClassProvider ALERT_SECONDARY = DefaultCSSClassProvider.create ("alert-secondary");
  public static final ICSSClassProvider ALERT_SUCCESS = DefaultCSSClassProvider.create ("alert-success");
  public static final ICSSClassProvider ALERT_WARNING = DefaultCSSClassProvider.create ("alert-warning");
  public static final ICSSClassProvider ALIGN_BASELINE = DefaultCSSClassProvider.create ("align-baseline");
  public static final ICSSClassProvider ALIGN_BOTTOM = DefaultCSSClassProvider.create ("align-bottom");
  public static final ICSSClassProvider ALIGN_CONTENT_AROUND = DefaultCSSClassProvider.create ("align-content-around");
  public static final ICSSClassProvider ALIGN_CONTENT_BETWEEN = DefaultCSSClassProvider.create ("align-content-between");
  public static final ICSSClassProvider ALIGN_CONTENT_CENTER = DefaultCSSClassProvider.create ("align-content-center");
  public static final ICSSClassProvider ALIGN_CONTENT_END = DefaultCSSClassProvider.create ("align-content-end");
  public static final ICSSClassProvider ALIGN_CONTENT_LG_AROUND = DefaultCSSClassProvider.create ("align-content-lg-around");
  public static final ICSSClassProvider ALIGN_CONTENT_LG_BETWEEN = DefaultCSSClassProvider.create ("align-content-lg-between");
  public static final ICSSClassProvider ALIGN_CONTENT_LG_CENTER = DefaultCSSClassProvider.create ("align-content-lg-center");
  public static final ICSSClassProvider ALIGN_CONTENT_LG_END = DefaultCSSClassProvider.create ("align-content-lg-end");
  public static final ICSSClassProvider ALIGN_CONTENT_LG_START = DefaultCSSClassProvider.create ("align-content-lg-start");
  public static final ICSSClassProvider ALIGN_CONTENT_LG_STRETCH = DefaultCSSClassProvider.create ("align-content-lg-stretch");
  public static final ICSSClassProvider ALIGN_CONTENT_MD_AROUND = DefaultCSSClassProvider.create ("align-content-md-around");
  public static final ICSSClassProvider ALIGN_CONTENT_MD_BETWEEN = DefaultCSSClassProvider.create ("align-content-md-between");
  public static final ICSSClassProvider ALIGN_CONTENT_MD_CENTER = DefaultCSSClassProvider.create ("align-content-md-center");
  public static final ICSSClassProvider ALIGN_CONTENT_MD_END = DefaultCSSClassProvider.create ("align-content-md-end");
  public static final ICSSClassProvider ALIGN_CONTENT_MD_START = DefaultCSSClassProvider.create ("align-content-md-start");
  public static final ICSSClassProvider ALIGN_CONTENT_MD_STRETCH = DefaultCSSClassProvider.create ("align-content-md-stretch");
  public static final ICSSClassProvider ALIGN_CONTENT_SM_AROUND = DefaultCSSClassProvider.create ("align-content-sm-around");
  public static final ICSSClassProvider ALIGN_CONTENT_SM_BETWEEN = DefaultCSSClassProvider.create ("align-content-sm-between");
  public static final ICSSClassProvider ALIGN_CONTENT_SM_CENTER = DefaultCSSClassProvider.create ("align-content-sm-center");
  public static final ICSSClassProvider ALIGN_CONTENT_SM_END = DefaultCSSClassProvider.create ("align-content-sm-end");
  public static final ICSSClassProvider ALIGN_CONTENT_SM_START = DefaultCSSClassProvider.create ("align-content-sm-start");
  public static final ICSSClassProvider ALIGN_CONTENT_SM_STRETCH = DefaultCSSClassProvider.create ("align-content-sm-stretch");
  public static final ICSSClassProvider ALIGN_CONTENT_START = DefaultCSSClassProvider.create ("align-content-start");
  public static final ICSSClassProvider ALIGN_CONTENT_STRETCH = DefaultCSSClassProvider.create ("align-content-stretch");
  public static final ICSSClassProvider ALIGN_CONTENT_XL_AROUND = DefaultCSSClassProvider.create ("align-content-xl-around");
  public static final ICSSClassProvider ALIGN_CONTENT_XL_BETWEEN = DefaultCSSClassProvider.create ("align-content-xl-between");
  public static final ICSSClassProvider ALIGN_CONTENT_XL_CENTER = DefaultCSSClassProvider.create ("align-content-xl-center");
  public static final ICSSClassProvider ALIGN_CONTENT_XL_END = DefaultCSSClassProvider.create ("align-content-xl-end");
  public static final ICSSClassProvider ALIGN_CONTENT_XL_START = DefaultCSSClassProvider.create ("align-content-xl-start");
  public static final ICSSClassProvider ALIGN_CONTENT_XL_STRETCH = DefaultCSSClassProvider.create ("align-content-xl-stretch");
  public static final ICSSClassProvider ALIGN_ITEMS_BASELINE = DefaultCSSClassProvider.create ("align-items-baseline");
  public static final ICSSClassProvider ALIGN_ITEMS_CENTER = DefaultCSSClassProvider.create ("align-items-center");
  public static final ICSSClassProvider ALIGN_ITEMS_END = DefaultCSSClassProvider.create ("align-items-end");
  public static final ICSSClassProvider ALIGN_ITEMS_LG_BASELINE = DefaultCSSClassProvider.create ("align-items-lg-baseline");
  public static final ICSSClassProvider ALIGN_ITEMS_LG_CENTER = DefaultCSSClassProvider.create ("align-items-lg-center");
  public static final ICSSClassProvider ALIGN_ITEMS_LG_END = DefaultCSSClassProvider.create ("align-items-lg-end");
  public static final ICSSClassProvider ALIGN_ITEMS_LG_START = DefaultCSSClassProvider.create ("align-items-lg-start");
  public static final ICSSClassProvider ALIGN_ITEMS_LG_STRETCH = DefaultCSSClassProvider.create ("align-items-lg-stretch");
  public static final ICSSClassProvider ALIGN_ITEMS_MD_BASELINE = DefaultCSSClassProvider.create ("align-items-md-baseline");
  public static final ICSSClassProvider ALIGN_ITEMS_MD_CENTER = DefaultCSSClassProvider.create ("align-items-md-center");
  public static final ICSSClassProvider ALIGN_ITEMS_MD_END = DefaultCSSClassProvider.create ("align-items-md-end");
  public static final ICSSClassProvider ALIGN_ITEMS_MD_START = DefaultCSSClassProvider.create ("align-items-md-start");
  public static final ICSSClassProvider ALIGN_ITEMS_MD_STRETCH = DefaultCSSClassProvider.create ("align-items-md-stretch");
  public static final ICSSClassProvider ALIGN_ITEMS_SM_BASELINE = DefaultCSSClassProvider.create ("align-items-sm-baseline");
  public static final ICSSClassProvider ALIGN_ITEMS_SM_CENTER = DefaultCSSClassProvider.create ("align-items-sm-center");
  public static final ICSSClassProvider ALIGN_ITEMS_SM_END = DefaultCSSClassProvider.create ("align-items-sm-end");
  public static final ICSSClassProvider ALIGN_ITEMS_SM_START = DefaultCSSClassProvider.create ("align-items-sm-start");
  public static final ICSSClassProvider ALIGN_ITEMS_SM_STRETCH = DefaultCSSClassProvider.create ("align-items-sm-stretch");
  public static final ICSSClassProvider ALIGN_ITEMS_START = DefaultCSSClassProvider.create ("align-items-start");
  public static final ICSSClassProvider ALIGN_ITEMS_STRETCH = DefaultCSSClassProvider.create ("align-items-stretch");
  public static final ICSSClassProvider ALIGN_ITEMS_XL_BASELINE = DefaultCSSClassProvider.create ("align-items-xl-baseline");
  public static final ICSSClassProvider ALIGN_ITEMS_XL_CENTER = DefaultCSSClassProvider.create ("align-items-xl-center");
  public static final ICSSClassProvider ALIGN_ITEMS_XL_END = DefaultCSSClassProvider.create ("align-items-xl-end");
  public static final ICSSClassProvider ALIGN_ITEMS_XL_START = DefaultCSSClassProvider.create ("align-items-xl-start");
  public static final ICSSClassProvider ALIGN_ITEMS_XL_STRETCH = DefaultCSSClassProvider.create ("align-items-xl-stretch");
  public static final ICSSClassProvider ALIGN_MIDDLE = DefaultCSSClassProvider.create ("align-middle");
  public static final ICSSClassProvider ALIGN_SELF_AUTO = DefaultCSSClassProvider.create ("align-self-auto");
  public static final ICSSClassProvider ALIGN_SELF_BASELINE = DefaultCSSClassProvider.create ("align-self-baseline");
  public static final ICSSClassProvider ALIGN_SELF_CENTER = DefaultCSSClassProvider.create ("align-self-center");
  public static final ICSSClassProvider ALIGN_SELF_END = DefaultCSSClassProvider.create ("align-self-end");
  public static final ICSSClassProvider ALIGN_SELF_LG_AUTO = DefaultCSSClassProvider.create ("align-self-lg-auto");
  public static final ICSSClassProvider ALIGN_SELF_LG_BASELINE = DefaultCSSClassProvider.create ("align-self-lg-baseline");
  public static final ICSSClassProvider ALIGN_SELF_LG_CENTER = DefaultCSSClassProvider.create ("align-self-lg-center");
  public static final ICSSClassProvider ALIGN_SELF_LG_END = DefaultCSSClassProvider.create ("align-self-lg-end");
  public static final ICSSClassProvider ALIGN_SELF_LG_START = DefaultCSSClassProvider.create ("align-self-lg-start");
  public static final ICSSClassProvider ALIGN_SELF_LG_STRETCH = DefaultCSSClassProvider.create ("align-self-lg-stretch");
  public static final ICSSClassProvider ALIGN_SELF_MD_AUTO = DefaultCSSClassProvider.create ("align-self-md-auto");
  public static final ICSSClassProvider ALIGN_SELF_MD_BASELINE = DefaultCSSClassProvider.create ("align-self-md-baseline");
  public static final ICSSClassProvider ALIGN_SELF_MD_CENTER = DefaultCSSClassProvider.create ("align-self-md-center");
  public static final ICSSClassProvider ALIGN_SELF_MD_END = DefaultCSSClassProvider.create ("align-self-md-end");
  public static final ICSSClassProvider ALIGN_SELF_MD_START = DefaultCSSClassProvider.create ("align-self-md-start");
  public static final ICSSClassProvider ALIGN_SELF_MD_STRETCH = DefaultCSSClassProvider.create ("align-self-md-stretch");
  public static final ICSSClassProvider ALIGN_SELF_SM_AUTO = DefaultCSSClassProvider.create ("align-self-sm-auto");
  public static final ICSSClassProvider ALIGN_SELF_SM_BASELINE = DefaultCSSClassProvider.create ("align-self-sm-baseline");
  public static final ICSSClassProvider ALIGN_SELF_SM_CENTER = DefaultCSSClassProvider.create ("align-self-sm-center");
  public static final ICSSClassProvider ALIGN_SELF_SM_END = DefaultCSSClassProvider.create ("align-self-sm-end");
  public static final ICSSClassProvider ALIGN_SELF_SM_START = DefaultCSSClassProvider.create ("align-self-sm-start");
  public static final ICSSClassProvider ALIGN_SELF_SM_STRETCH = DefaultCSSClassProvider.create ("align-self-sm-stretch");
  public static final ICSSClassProvider ALIGN_SELF_START = DefaultCSSClassProvider.create ("align-self-start");
  public static final ICSSClassProvider ALIGN_SELF_STRETCH = DefaultCSSClassProvider.create ("align-self-stretch");
  public static final ICSSClassProvider ALIGN_SELF_XL_AUTO = DefaultCSSClassProvider.create ("align-self-xl-auto");
  public static final ICSSClassProvider ALIGN_SELF_XL_BASELINE = DefaultCSSClassProvider.create ("align-self-xl-baseline");
  public static final ICSSClassProvider ALIGN_SELF_XL_CENTER = DefaultCSSClassProvider.create ("align-self-xl-center");
  public static final ICSSClassProvider ALIGN_SELF_XL_END = DefaultCSSClassProvider.create ("align-self-xl-end");
  public static final ICSSClassProvider ALIGN_SELF_XL_START = DefaultCSSClassProvider.create ("align-self-xl-start");
  public static final ICSSClassProvider ALIGN_SELF_XL_STRETCH = DefaultCSSClassProvider.create ("align-self-xl-stretch");
  public static final ICSSClassProvider ALIGN_TEXT_BOTTOM = DefaultCSSClassProvider.create ("align-text-bottom");
  public static final ICSSClassProvider ALIGN_TEXT_TOP = DefaultCSSClassProvider.create ("align-text-top");
  public static final ICSSClassProvider ALIGN_TOP = DefaultCSSClassProvider.create ("align-top");
  public static final ICSSClassProvider ARROW = DefaultCSSClassProvider.create ("arrow");
  public static final ICSSClassProvider BADGE = DefaultCSSClassProvider.create ("badge");
  public static final ICSSClassProvider BADGE_DANGER = DefaultCSSClassProvider.create ("badge-danger");
  public static final ICSSClassProvider BADGE_DARK = DefaultCSSClassProvider.create ("badge-dark");
  public static final ICSSClassProvider BADGE_INFO = DefaultCSSClassProvider.create ("badge-info");
  public static final ICSSClassProvider BADGE_LIGHT = DefaultCSSClassProvider.create ("badge-light");
  public static final ICSSClassProvider BADGE_PILL = DefaultCSSClassProvider.create ("badge-pill");
  public static final ICSSClassProvider BADGE_PRIMARY = DefaultCSSClassProvider.create ("badge-primary");
  public static final ICSSClassProvider BADGE_SECONDARY = DefaultCSSClassProvider.create ("badge-secondary");
  public static final ICSSClassProvider BADGE_SUCCESS = DefaultCSSClassProvider.create ("badge-success");
  public static final ICSSClassProvider BADGE_WARNING = DefaultCSSClassProvider.create ("badge-warning");
  public static final ICSSClassProvider BG_DANGER = DefaultCSSClassProvider.create ("bg-danger");
  public static final ICSSClassProvider BG_DARK = DefaultCSSClassProvider.create ("bg-dark");
  public static final ICSSClassProvider BG_INFO = DefaultCSSClassProvider.create ("bg-info");
  public static final ICSSClassProvider BG_LIGHT = DefaultCSSClassProvider.create ("bg-light");
  public static final ICSSClassProvider BG_PRIMARY = DefaultCSSClassProvider.create ("bg-primary");
  public static final ICSSClassProvider BG_SECONDARY = DefaultCSSClassProvider.create ("bg-secondary");
  public static final ICSSClassProvider BG_SUCCESS = DefaultCSSClassProvider.create ("bg-success");
  public static final ICSSClassProvider BG_TRANSPARENT = DefaultCSSClassProvider.create ("bg-transparent");
  public static final ICSSClassProvider BG_WARNING = DefaultCSSClassProvider.create ("bg-warning");
  public static final ICSSClassProvider BG_WHITE = DefaultCSSClassProvider.create ("bg-white");
  public static final ICSSClassProvider BLOCKQUOTE = DefaultCSSClassProvider.create ("blockquote");
  public static final ICSSClassProvider BLOCKQUOTE_FOOTER = DefaultCSSClassProvider.create ("blockquote-footer");
  public static final ICSSClassProvider BORDER = DefaultCSSClassProvider.create ("border");
  public static final ICSSClassProvider BORDER_0 = DefaultCSSClassProvider.create ("border-0");
  public static final ICSSClassProvider BORDER_BOTTOM = DefaultCSSClassProvider.create ("border-bottom");
  public static final ICSSClassProvider BORDER_BOTTOM_0 = DefaultCSSClassProvider.create ("border-bottom-0");
  public static final ICSSClassProvider BORDER_DANGER = DefaultCSSClassProvider.create ("border-danger");
  public static final ICSSClassProvider BORDER_DARK = DefaultCSSClassProvider.create ("border-dark");
  public static final ICSSClassProvider BORDER_INFO = DefaultCSSClassProvider.create ("border-info");
  public static final ICSSClassProvider BORDER_LEFT = DefaultCSSClassProvider.create ("border-left");
  public static final ICSSClassProvider BORDER_LEFT_0 = DefaultCSSClassProvider.create ("border-left-0");
  public static final ICSSClassProvider BORDER_LIGHT = DefaultCSSClassProvider.create ("border-light");
  public static final ICSSClassProvider BORDER_PRIMARY = DefaultCSSClassProvider.create ("border-primary");
  public static final ICSSClassProvider BORDER_RIGHT = DefaultCSSClassProvider.create ("border-right");
  public static final ICSSClassProvider BORDER_RIGHT_0 = DefaultCSSClassProvider.create ("border-right-0");
  public static final ICSSClassProvider BORDER_SECONDARY = DefaultCSSClassProvider.create ("border-secondary");
  public static final ICSSClassProvider BORDER_SUCCESS = DefaultCSSClassProvider.create ("border-success");
  public static final ICSSClassProvider BORDER_TOP = DefaultCSSClassProvider.create ("border-top");
  public static final ICSSClassProvider BORDER_TOP_0 = DefaultCSSClassProvider.create ("border-top-0");
  public static final ICSSClassProvider BORDER_WARNING = DefaultCSSClassProvider.create ("border-warning");
  public static final ICSSClassProvider BORDER_WHITE = DefaultCSSClassProvider.create ("border-white");
  public static final ICSSClassProvider BREADCRUMB = DefaultCSSClassProvider.create ("breadcrumb");
  public static final ICSSClassProvider BREADCRUMB_ITEM = DefaultCSSClassProvider.create ("breadcrumb-item");
  public static final ICSSClassProvider BS_POPOVER_AUTO = DefaultCSSClassProvider.create ("bs-popover-auto");
  public static final ICSSClassProvider BS_POPOVER_BOTTOM = DefaultCSSClassProvider.create ("bs-popover-bottom");
  public static final ICSSClassProvider BS_POPOVER_LEFT = DefaultCSSClassProvider.create ("bs-popover-left");
  public static final ICSSClassProvider BS_POPOVER_RIGHT = DefaultCSSClassProvider.create ("bs-popover-right");
  public static final ICSSClassProvider BS_POPOVER_TOP = DefaultCSSClassProvider.create ("bs-popover-top");
  public static final ICSSClassProvider BS_TOOLTIP_AUTO = DefaultCSSClassProvider.create ("bs-tooltip-auto");
  public static final ICSSClassProvider BS_TOOLTIP_BOTTOM = DefaultCSSClassProvider.create ("bs-tooltip-bottom");
  public static final ICSSClassProvider BS_TOOLTIP_LEFT = DefaultCSSClassProvider.create ("bs-tooltip-left");
  public static final ICSSClassProvider BS_TOOLTIP_RIGHT = DefaultCSSClassProvider.create ("bs-tooltip-right");
  public static final ICSSClassProvider BS_TOOLTIP_TOP = DefaultCSSClassProvider.create ("bs-tooltip-top");
  public static final ICSSClassProvider BTN = DefaultCSSClassProvider.create ("btn");
  public static final ICSSClassProvider BTN_BLOCK = DefaultCSSClassProvider.create ("btn-block");
  public static final ICSSClassProvider BTN_DANGER = DefaultCSSClassProvider.create ("btn-danger");
  public static final ICSSClassProvider BTN_DARK = DefaultCSSClassProvider.create ("btn-dark");
  public static final ICSSClassProvider BTN_GROUP = DefaultCSSClassProvider.create ("btn-group");
  public static final ICSSClassProvider BTN_GROUP_LG = DefaultCSSClassProvider.create ("btn-group-lg");
  public static final ICSSClassProvider BTN_GROUP_SM = DefaultCSSClassProvider.create ("btn-group-sm");
  public static final ICSSClassProvider BTN_GROUP_TOGGLE = DefaultCSSClassProvider.create ("btn-group-toggle");
  public static final ICSSClassProvider BTN_GROUP_VERTICAL = DefaultCSSClassProvider.create ("btn-group-vertical");
  public static final ICSSClassProvider BTN_INFO = DefaultCSSClassProvider.create ("btn-info");
  public static final ICSSClassProvider BTN_LG = DefaultCSSClassProvider.create ("btn-lg");
  public static final ICSSClassProvider BTN_LIGHT = DefaultCSSClassProvider.create ("btn-light");
  public static final ICSSClassProvider BTN_LINK = DefaultCSSClassProvider.create ("btn-link");
  public static final ICSSClassProvider BTN_OUTLINE_DANGER = DefaultCSSClassProvider.create ("btn-outline-danger");
  public static final ICSSClassProvider BTN_OUTLINE_DARK = DefaultCSSClassProvider.create ("btn-outline-dark");
  public static final ICSSClassProvider BTN_OUTLINE_INFO = DefaultCSSClassProvider.create ("btn-outline-info");
  public static final ICSSClassProvider BTN_OUTLINE_LIGHT = DefaultCSSClassProvider.create ("btn-outline-light");
  public static final ICSSClassProvider BTN_OUTLINE_PRIMARY = DefaultCSSClassProvider.create ("btn-outline-primary");
  public static final ICSSClassProvider BTN_OUTLINE_SECONDARY = DefaultCSSClassProvider.create ("btn-outline-secondary");
  public static final ICSSClassProvider BTN_OUTLINE_SUCCESS = DefaultCSSClassProvider.create ("btn-outline-success");
  public static final ICSSClassProvider BTN_OUTLINE_WARNING = DefaultCSSClassProvider.create ("btn-outline-warning");
  public static final ICSSClassProvider BTN_PRIMARY = DefaultCSSClassProvider.create ("btn-primary");
  public static final ICSSClassProvider BTN_SECONDARY = DefaultCSSClassProvider.create ("btn-secondary");
  public static final ICSSClassProvider BTN_SM = DefaultCSSClassProvider.create ("btn-sm");
  public static final ICSSClassProvider BTN_SUCCESS = DefaultCSSClassProvider.create ("btn-success");
  public static final ICSSClassProvider BTN_TOOLBAR = DefaultCSSClassProvider.create ("btn-toolbar");
  public static final ICSSClassProvider BTN_WARNING = DefaultCSSClassProvider.create ("btn-warning");
  public static final ICSSClassProvider CARD = DefaultCSSClassProvider.create ("card");
  public static final ICSSClassProvider CARD_BODY = DefaultCSSClassProvider.create ("card-body");
  public static final ICSSClassProvider CARD_COLUMNS = DefaultCSSClassProvider.create ("card-columns");
  public static final ICSSClassProvider CARD_DECK = DefaultCSSClassProvider.create ("card-deck");
  public static final ICSSClassProvider CARD_FOOTER = DefaultCSSClassProvider.create ("card-footer");
  public static final ICSSClassProvider CARD_GROUP = DefaultCSSClassProvider.create ("card-group");
  public static final ICSSClassProvider CARD_HEADER = DefaultCSSClassProvider.create ("card-header");
  public static final ICSSClassProvider CARD_HEADER_PILLS = DefaultCSSClassProvider.create ("card-header-pills");
  public static final ICSSClassProvider CARD_HEADER_TABS = DefaultCSSClassProvider.create ("card-header-tabs");
  public static final ICSSClassProvider CARD_IMG = DefaultCSSClassProvider.create ("card-img");
  public static final ICSSClassProvider CARD_IMG_BOTTOM = DefaultCSSClassProvider.create ("card-img-bottom");
  public static final ICSSClassProvider CARD_IMG_OVERLAY = DefaultCSSClassProvider.create ("card-img-overlay");
  public static final ICSSClassProvider CARD_IMG_TOP = DefaultCSSClassProvider.create ("card-img-top");
  public static final ICSSClassProvider CARD_LINK = DefaultCSSClassProvider.create ("card-link");
  public static final ICSSClassProvider CARD_SUBTITLE = DefaultCSSClassProvider.create ("card-subtitle");
  public static final ICSSClassProvider CARD_TEXT = DefaultCSSClassProvider.create ("card-text");
  public static final ICSSClassProvider CARD_TITLE = DefaultCSSClassProvider.create ("card-title");
  public static final ICSSClassProvider CAROUSEL = DefaultCSSClassProvider.create ("carousel");
  public static final ICSSClassProvider CAROUSEL_CAPTION = DefaultCSSClassProvider.create ("carousel-caption");
  public static final ICSSClassProvider CAROUSEL_CONTROL_NEXT = DefaultCSSClassProvider.create ("carousel-control-next");
  public static final ICSSClassProvider CAROUSEL_CONTROL_NEXT_ICON = DefaultCSSClassProvider.create ("carousel-control-next-icon");
  public static final ICSSClassProvider CAROUSEL_CONTROL_PREV = DefaultCSSClassProvider.create ("carousel-control-prev");
  public static final ICSSClassProvider CAROUSEL_CONTROL_PREV_ICON = DefaultCSSClassProvider.create ("carousel-control-prev-icon");
  public static final ICSSClassProvider CAROUSEL_FADE = DefaultCSSClassProvider.create ("carousel-fade");
  public static final ICSSClassProvider CAROUSEL_INDICATORS = DefaultCSSClassProvider.create ("carousel-indicators");
  public static final ICSSClassProvider CAROUSEL_INNER = DefaultCSSClassProvider.create ("carousel-inner");
  public static final ICSSClassProvider CAROUSEL_ITEM = DefaultCSSClassProvider.create ("carousel-item");
  public static final ICSSClassProvider CAROUSEL_ITEM_LEFT = DefaultCSSClassProvider.create ("carousel-item-left");
  public static final ICSSClassProvider CAROUSEL_ITEM_NEXT = DefaultCSSClassProvider.create ("carousel-item-next");
  public static final ICSSClassProvider CAROUSEL_ITEM_PREV = DefaultCSSClassProvider.create ("carousel-item-prev");
  public static final ICSSClassProvider CAROUSEL_ITEM_RIGHT = DefaultCSSClassProvider.create ("carousel-item-right");
  public static final ICSSClassProvider CLEARFIX = DefaultCSSClassProvider.create ("clearfix");
  public static final ICSSClassProvider CLOSE = DefaultCSSClassProvider.create ("close");
  public static final ICSSClassProvider COL = DefaultCSSClassProvider.create ("col");
  public static final ICSSClassProvider COL_1 = DefaultCSSClassProvider.create ("col-1");
  public static final ICSSClassProvider COL_10 = DefaultCSSClassProvider.create ("col-10");
  public static final ICSSClassProvider COL_11 = DefaultCSSClassProvider.create ("col-11");
  public static final ICSSClassProvider COL_12 = DefaultCSSClassProvider.create ("col-12");
  public static final ICSSClassProvider COL_2 = DefaultCSSClassProvider.create ("col-2");
  public static final ICSSClassProvider COL_3 = DefaultCSSClassProvider.create ("col-3");
  public static final ICSSClassProvider COL_4 = DefaultCSSClassProvider.create ("col-4");
  public static final ICSSClassProvider COL_5 = DefaultCSSClassProvider.create ("col-5");
  public static final ICSSClassProvider COL_6 = DefaultCSSClassProvider.create ("col-6");
  public static final ICSSClassProvider COL_7 = DefaultCSSClassProvider.create ("col-7");
  public static final ICSSClassProvider COL_8 = DefaultCSSClassProvider.create ("col-8");
  public static final ICSSClassProvider COL_9 = DefaultCSSClassProvider.create ("col-9");
  public static final ICSSClassProvider COL_AUTO = DefaultCSSClassProvider.create ("col-auto");
  public static final ICSSClassProvider COL_FORM_LABEL = DefaultCSSClassProvider.create ("col-form-label");
  public static final ICSSClassProvider COL_FORM_LABEL_LG = DefaultCSSClassProvider.create ("col-form-label-lg");
  public static final ICSSClassProvider COL_FORM_LABEL_SM = DefaultCSSClassProvider.create ("col-form-label-sm");
  public static final ICSSClassProvider COL_LG = DefaultCSSClassProvider.create ("col-lg");
  public static final ICSSClassProvider COL_LG_1 = DefaultCSSClassProvider.create ("col-lg-1");
  public static final ICSSClassProvider COL_LG_10 = DefaultCSSClassProvider.create ("col-lg-10");
  public static final ICSSClassProvider COL_LG_11 = DefaultCSSClassProvider.create ("col-lg-11");
  public static final ICSSClassProvider COL_LG_12 = DefaultCSSClassProvider.create ("col-lg-12");
  public static final ICSSClassProvider COL_LG_2 = DefaultCSSClassProvider.create ("col-lg-2");
  public static final ICSSClassProvider COL_LG_3 = DefaultCSSClassProvider.create ("col-lg-3");
  public static final ICSSClassProvider COL_LG_4 = DefaultCSSClassProvider.create ("col-lg-4");
  public static final ICSSClassProvider COL_LG_5 = DefaultCSSClassProvider.create ("col-lg-5");
  public static final ICSSClassProvider COL_LG_6 = DefaultCSSClassProvider.create ("col-lg-6");
  public static final ICSSClassProvider COL_LG_7 = DefaultCSSClassProvider.create ("col-lg-7");
  public static final ICSSClassProvider COL_LG_8 = DefaultCSSClassProvider.create ("col-lg-8");
  public static final ICSSClassProvider COL_LG_9 = DefaultCSSClassProvider.create ("col-lg-9");
  public static final ICSSClassProvider COL_LG_AUTO = DefaultCSSClassProvider.create ("col-lg-auto");
  public static final ICSSClassProvider COL_MD = DefaultCSSClassProvider.create ("col-md");
  public static final ICSSClassProvider COL_MD_1 = DefaultCSSClassProvider.create ("col-md-1");
  public static final ICSSClassProvider COL_MD_10 = DefaultCSSClassProvider.create ("col-md-10");
  public static final ICSSClassProvider COL_MD_11 = DefaultCSSClassProvider.create ("col-md-11");
  public static final ICSSClassProvider COL_MD_12 = DefaultCSSClassProvider.create ("col-md-12");
  public static final ICSSClassProvider COL_MD_2 = DefaultCSSClassProvider.create ("col-md-2");
  public static final ICSSClassProvider COL_MD_3 = DefaultCSSClassProvider.create ("col-md-3");
  public static final ICSSClassProvider COL_MD_4 = DefaultCSSClassProvider.create ("col-md-4");
  public static final ICSSClassProvider COL_MD_5 = DefaultCSSClassProvider.create ("col-md-5");
  public static final ICSSClassProvider COL_MD_6 = DefaultCSSClassProvider.create ("col-md-6");
  public static final ICSSClassProvider COL_MD_7 = DefaultCSSClassProvider.create ("col-md-7");
  public static final ICSSClassProvider COL_MD_8 = DefaultCSSClassProvider.create ("col-md-8");
  public static final ICSSClassProvider COL_MD_9 = DefaultCSSClassProvider.create ("col-md-9");
  public static final ICSSClassProvider COL_MD_AUTO = DefaultCSSClassProvider.create ("col-md-auto");
  public static final ICSSClassProvider COL_SM = DefaultCSSClassProvider.create ("col-sm");
  public static final ICSSClassProvider COL_SM_1 = DefaultCSSClassProvider.create ("col-sm-1");
  public static final ICSSClassProvider COL_SM_10 = DefaultCSSClassProvider.create ("col-sm-10");
  public static final ICSSClassProvider COL_SM_11 = DefaultCSSClassProvider.create ("col-sm-11");
  public static final ICSSClassProvider COL_SM_12 = DefaultCSSClassProvider.create ("col-sm-12");
  public static final ICSSClassProvider COL_SM_2 = DefaultCSSClassProvider.create ("col-sm-2");
  public static final ICSSClassProvider COL_SM_3 = DefaultCSSClassProvider.create ("col-sm-3");
  public static final ICSSClassProvider COL_SM_4 = DefaultCSSClassProvider.create ("col-sm-4");
  public static final ICSSClassProvider COL_SM_5 = DefaultCSSClassProvider.create ("col-sm-5");
  public static final ICSSClassProvider COL_SM_6 = DefaultCSSClassProvider.create ("col-sm-6");
  public static final ICSSClassProvider COL_SM_7 = DefaultCSSClassProvider.create ("col-sm-7");
  public static final ICSSClassProvider COL_SM_8 = DefaultCSSClassProvider.create ("col-sm-8");
  public static final ICSSClassProvider COL_SM_9 = DefaultCSSClassProvider.create ("col-sm-9");
  public static final ICSSClassProvider COL_SM_AUTO = DefaultCSSClassProvider.create ("col-sm-auto");
  public static final ICSSClassProvider COL_XL = DefaultCSSClassProvider.create ("col-xl");
  public static final ICSSClassProvider COL_XL_1 = DefaultCSSClassProvider.create ("col-xl-1");
  public static final ICSSClassProvider COL_XL_10 = DefaultCSSClassProvider.create ("col-xl-10");
  public static final ICSSClassProvider COL_XL_11 = DefaultCSSClassProvider.create ("col-xl-11");
  public static final ICSSClassProvider COL_XL_12 = DefaultCSSClassProvider.create ("col-xl-12");
  public static final ICSSClassProvider COL_XL_2 = DefaultCSSClassProvider.create ("col-xl-2");
  public static final ICSSClassProvider COL_XL_3 = DefaultCSSClassProvider.create ("col-xl-3");
  public static final ICSSClassProvider COL_XL_4 = DefaultCSSClassProvider.create ("col-xl-4");
  public static final ICSSClassProvider COL_XL_5 = DefaultCSSClassProvider.create ("col-xl-5");
  public static final ICSSClassProvider COL_XL_6 = DefaultCSSClassProvider.create ("col-xl-6");
  public static final ICSSClassProvider COL_XL_7 = DefaultCSSClassProvider.create ("col-xl-7");
  public static final ICSSClassProvider COL_XL_8 = DefaultCSSClassProvider.create ("col-xl-8");
  public static final ICSSClassProvider COL_XL_9 = DefaultCSSClassProvider.create ("col-xl-9");
  public static final ICSSClassProvider COL_XL_AUTO = DefaultCSSClassProvider.create ("col-xl-auto");
  public static final ICSSClassProvider COLLAPSE = DefaultCSSClassProvider.create ("collapse");
  public static final ICSSClassProvider COLLAPSING = DefaultCSSClassProvider.create ("collapsing");
  public static final ICSSClassProvider CONTAINER = DefaultCSSClassProvider.create ("container");
  public static final ICSSClassProvider CONTAINER_FLUID = DefaultCSSClassProvider.create ("container-fluid");
  public static final ICSSClassProvider CONTAINER_LG = DefaultCSSClassProvider.create ("container-lg");
  public static final ICSSClassProvider CONTAINER_MD = DefaultCSSClassProvider.create ("container-md");
  public static final ICSSClassProvider CONTAINER_SM = DefaultCSSClassProvider.create ("container-sm");
  public static final ICSSClassProvider CONTAINER_XL = DefaultCSSClassProvider.create ("container-xl");
  public static final ICSSClassProvider CUSTOM_CHECKBOX = DefaultCSSClassProvider.create ("custom-checkbox");
  public static final ICSSClassProvider CUSTOM_CONTROL = DefaultCSSClassProvider.create ("custom-control");
  public static final ICSSClassProvider CUSTOM_CONTROL_INLINE = DefaultCSSClassProvider.create ("custom-control-inline");
  public static final ICSSClassProvider CUSTOM_CONTROL_INPUT = DefaultCSSClassProvider.create ("custom-control-input");
  public static final ICSSClassProvider CUSTOM_CONTROL_LABEL = DefaultCSSClassProvider.create ("custom-control-label");
  public static final ICSSClassProvider CUSTOM_FILE = DefaultCSSClassProvider.create ("custom-file");
  public static final ICSSClassProvider CUSTOM_FILE_INPUT = DefaultCSSClassProvider.create ("custom-file-input");
  public static final ICSSClassProvider CUSTOM_FILE_LABEL = DefaultCSSClassProvider.create ("custom-file-label");
  public static final ICSSClassProvider CUSTOM_RADIO = DefaultCSSClassProvider.create ("custom-radio");
  public static final ICSSClassProvider CUSTOM_RANGE = DefaultCSSClassProvider.create ("custom-range");
  public static final ICSSClassProvider CUSTOM_SELECT = DefaultCSSClassProvider.create ("custom-select");
  public static final ICSSClassProvider CUSTOM_SELECT_LG = DefaultCSSClassProvider.create ("custom-select-lg");
  public static final ICSSClassProvider CUSTOM_SELECT_SM = DefaultCSSClassProvider.create ("custom-select-sm");
  public static final ICSSClassProvider CUSTOM_SWITCH = DefaultCSSClassProvider.create ("custom-switch");
  public static final ICSSClassProvider D_BLOCK = DefaultCSSClassProvider.create ("d-block");
  public static final ICSSClassProvider D_FLEX = DefaultCSSClassProvider.create ("d-flex");
  public static final ICSSClassProvider D_INLINE = DefaultCSSClassProvider.create ("d-inline");
  public static final ICSSClassProvider D_INLINE_BLOCK = DefaultCSSClassProvider.create ("d-inline-block");
  public static final ICSSClassProvider D_INLINE_FLEX = DefaultCSSClassProvider.create ("d-inline-flex");
  public static final ICSSClassProvider D_LG_BLOCK = DefaultCSSClassProvider.create ("d-lg-block");
  public static final ICSSClassProvider D_LG_FLEX = DefaultCSSClassProvider.create ("d-lg-flex");
  public static final ICSSClassProvider D_LG_INLINE = DefaultCSSClassProvider.create ("d-lg-inline");
  public static final ICSSClassProvider D_LG_INLINE_BLOCK = DefaultCSSClassProvider.create ("d-lg-inline-block");
  public static final ICSSClassProvider D_LG_INLINE_FLEX = DefaultCSSClassProvider.create ("d-lg-inline-flex");
  public static final ICSSClassProvider D_LG_NONE = DefaultCSSClassProvider.create ("d-lg-none");
  public static final ICSSClassProvider D_LG_TABLE = DefaultCSSClassProvider.create ("d-lg-table");
  public static final ICSSClassProvider D_LG_TABLE_CELL = DefaultCSSClassProvider.create ("d-lg-table-cell");
  public static final ICSSClassProvider D_LG_TABLE_ROW = DefaultCSSClassProvider.create ("d-lg-table-row");
  public static final ICSSClassProvider D_MD_BLOCK = DefaultCSSClassProvider.create ("d-md-block");
  public static final ICSSClassProvider D_MD_FLEX = DefaultCSSClassProvider.create ("d-md-flex");
  public static final ICSSClassProvider D_MD_INLINE = DefaultCSSClassProvider.create ("d-md-inline");
  public static final ICSSClassProvider D_MD_INLINE_BLOCK = DefaultCSSClassProvider.create ("d-md-inline-block");
  public static final ICSSClassProvider D_MD_INLINE_FLEX = DefaultCSSClassProvider.create ("d-md-inline-flex");
  public static final ICSSClassProvider D_MD_NONE = DefaultCSSClassProvider.create ("d-md-none");
  public static final ICSSClassProvider D_MD_TABLE = DefaultCSSClassProvider.create ("d-md-table");
  public static final ICSSClassProvider D_MD_TABLE_CELL = DefaultCSSClassProvider.create ("d-md-table-cell");
  public static final ICSSClassProvider D_MD_TABLE_ROW = DefaultCSSClassProvider.create ("d-md-table-row");
  public static final ICSSClassProvider D_NONE = DefaultCSSClassProvider.create ("d-none");
  public static final ICSSClassProvider D_PRINT_BLOCK = DefaultCSSClassProvider.create ("d-print-block");
  public static final ICSSClassProvider D_PRINT_FLEX = DefaultCSSClassProvider.create ("d-print-flex");
  public static final ICSSClassProvider D_PRINT_INLINE = DefaultCSSClassProvider.create ("d-print-inline");
  public static final ICSSClassProvider D_PRINT_INLINE_BLOCK = DefaultCSSClassProvider.create ("d-print-inline-block");
  public static final ICSSClassProvider D_PRINT_INLINE_FLEX = DefaultCSSClassProvider.create ("d-print-inline-flex");
  public static final ICSSClassProvider D_PRINT_NONE = DefaultCSSClassProvider.create ("d-print-none");
  public static final ICSSClassProvider D_PRINT_TABLE = DefaultCSSClassProvider.create ("d-print-table");
  public static final ICSSClassProvider D_PRINT_TABLE_CELL = DefaultCSSClassProvider.create ("d-print-table-cell");
  public static final ICSSClassProvider D_PRINT_TABLE_ROW = DefaultCSSClassProvider.create ("d-print-table-row");
  public static final ICSSClassProvider D_SM_BLOCK = DefaultCSSClassProvider.create ("d-sm-block");
  public static final ICSSClassProvider D_SM_FLEX = DefaultCSSClassProvider.create ("d-sm-flex");
  public static final ICSSClassProvider D_SM_INLINE = DefaultCSSClassProvider.create ("d-sm-inline");
  public static final ICSSClassProvider D_SM_INLINE_BLOCK = DefaultCSSClassProvider.create ("d-sm-inline-block");
  public static final ICSSClassProvider D_SM_INLINE_FLEX = DefaultCSSClassProvider.create ("d-sm-inline-flex");
  public static final ICSSClassProvider D_SM_NONE = DefaultCSSClassProvider.create ("d-sm-none");
  public static final ICSSClassProvider D_SM_TABLE = DefaultCSSClassProvider.create ("d-sm-table");
  public static final ICSSClassProvider D_SM_TABLE_CELL = DefaultCSSClassProvider.create ("d-sm-table-cell");
  public static final ICSSClassProvider D_SM_TABLE_ROW = DefaultCSSClassProvider.create ("d-sm-table-row");
  public static final ICSSClassProvider D_TABLE = DefaultCSSClassProvider.create ("d-table");
  public static final ICSSClassProvider D_TABLE_CELL = DefaultCSSClassProvider.create ("d-table-cell");
  public static final ICSSClassProvider D_TABLE_ROW = DefaultCSSClassProvider.create ("d-table-row");
  public static final ICSSClassProvider D_XL_BLOCK = DefaultCSSClassProvider.create ("d-xl-block");
  public static final ICSSClassProvider D_XL_FLEX = DefaultCSSClassProvider.create ("d-xl-flex");
  public static final ICSSClassProvider D_XL_INLINE = DefaultCSSClassProvider.create ("d-xl-inline");
  public static final ICSSClassProvider D_XL_INLINE_BLOCK = DefaultCSSClassProvider.create ("d-xl-inline-block");
  public static final ICSSClassProvider D_XL_INLINE_FLEX = DefaultCSSClassProvider.create ("d-xl-inline-flex");
  public static final ICSSClassProvider D_XL_NONE = DefaultCSSClassProvider.create ("d-xl-none");
  public static final ICSSClassProvider D_XL_TABLE = DefaultCSSClassProvider.create ("d-xl-table");
  public static final ICSSClassProvider D_XL_TABLE_CELL = DefaultCSSClassProvider.create ("d-xl-table-cell");
  public static final ICSSClassProvider D_XL_TABLE_ROW = DefaultCSSClassProvider.create ("d-xl-table-row");
  public static final ICSSClassProvider DISABLED = DefaultCSSClassProvider.create ("disabled");
  public static final ICSSClassProvider DISPLAY_1 = DefaultCSSClassProvider.create ("display-1");
  public static final ICSSClassProvider DISPLAY_2 = DefaultCSSClassProvider.create ("display-2");
  public static final ICSSClassProvider DISPLAY_3 = DefaultCSSClassProvider.create ("display-3");
  public static final ICSSClassProvider DISPLAY_4 = DefaultCSSClassProvider.create ("display-4");
  public static final ICSSClassProvider DROPDOWN = DefaultCSSClassProvider.create ("dropdown");
  public static final ICSSClassProvider DROPDOWN_DIVIDER = DefaultCSSClassProvider.create ("dropdown-divider");
  public static final ICSSClassProvider DROPDOWN_HEADER = DefaultCSSClassProvider.create ("dropdown-header");
  public static final ICSSClassProvider DROPDOWN_ITEM = DefaultCSSClassProvider.create ("dropdown-item");
  public static final ICSSClassProvider DROPDOWN_ITEM_TEXT = DefaultCSSClassProvider.create ("dropdown-item-text");
  public static final ICSSClassProvider DROPDOWN_MENU = DefaultCSSClassProvider.create ("dropdown-menu");
  public static final ICSSClassProvider DROPDOWN_MENU_LEFT = DefaultCSSClassProvider.create ("dropdown-menu-left");
  public static final ICSSClassProvider DROPDOWN_MENU_LG_LEFT = DefaultCSSClassProvider.create ("dropdown-menu-lg-left");
  public static final ICSSClassProvider DROPDOWN_MENU_LG_RIGHT = DefaultCSSClassProvider.create ("dropdown-menu-lg-right");
  public static final ICSSClassProvider DROPDOWN_MENU_MD_LEFT = DefaultCSSClassProvider.create ("dropdown-menu-md-left");
  public static final ICSSClassProvider DROPDOWN_MENU_MD_RIGHT = DefaultCSSClassProvider.create ("dropdown-menu-md-right");
  public static final ICSSClassProvider DROPDOWN_MENU_RIGHT = DefaultCSSClassProvider.create ("dropdown-menu-right");
  public static final ICSSClassProvider DROPDOWN_MENU_SM_LEFT = DefaultCSSClassProvider.create ("dropdown-menu-sm-left");
  public static final ICSSClassProvider DROPDOWN_MENU_SM_RIGHT = DefaultCSSClassProvider.create ("dropdown-menu-sm-right");
  public static final ICSSClassProvider DROPDOWN_MENU_XL_LEFT = DefaultCSSClassProvider.create ("dropdown-menu-xl-left");
  public static final ICSSClassProvider DROPDOWN_MENU_XL_RIGHT = DefaultCSSClassProvider.create ("dropdown-menu-xl-right");
  public static final ICSSClassProvider DROPDOWN_TOGGLE = DefaultCSSClassProvider.create ("dropdown-toggle");
  public static final ICSSClassProvider DROPDOWN_TOGGLE_SPLIT = DefaultCSSClassProvider.create ("dropdown-toggle-split");
  public static final ICSSClassProvider DROPLEFT = DefaultCSSClassProvider.create ("dropleft");
  public static final ICSSClassProvider DROPRIGHT = DefaultCSSClassProvider.create ("dropright");
  public static final ICSSClassProvider DROPUP = DefaultCSSClassProvider.create ("dropup");
  public static final ICSSClassProvider EMBED_RESPONSIVE = DefaultCSSClassProvider.create ("embed-responsive");
  public static final ICSSClassProvider EMBED_RESPONSIVE_16BY9 = DefaultCSSClassProvider.create ("embed-responsive-16by9");
  public static final ICSSClassProvider EMBED_RESPONSIVE_1BY1 = DefaultCSSClassProvider.create ("embed-responsive-1by1");
  public static final ICSSClassProvider EMBED_RESPONSIVE_21BY9 = DefaultCSSClassProvider.create ("embed-responsive-21by9");
  public static final ICSSClassProvider EMBED_RESPONSIVE_4BY3 = DefaultCSSClassProvider.create ("embed-responsive-4by3");
  public static final ICSSClassProvider EMBED_RESPONSIVE_ITEM = DefaultCSSClassProvider.create ("embed-responsive-item");
  public static final ICSSClassProvider FADE = DefaultCSSClassProvider.create ("fade");
  public static final ICSSClassProvider FIGURE = DefaultCSSClassProvider.create ("figure");
  public static final ICSSClassProvider FIGURE_CAPTION = DefaultCSSClassProvider.create ("figure-caption");
  public static final ICSSClassProvider FIGURE_IMG = DefaultCSSClassProvider.create ("figure-img");
  public static final ICSSClassProvider FIXED_BOTTOM = DefaultCSSClassProvider.create ("fixed-bottom");
  public static final ICSSClassProvider FIXED_TOP = DefaultCSSClassProvider.create ("fixed-top");
  public static final ICSSClassProvider FLEX_COLUMN = DefaultCSSClassProvider.create ("flex-column");
  public static final ICSSClassProvider FLEX_COLUMN_REVERSE = DefaultCSSClassProvider.create ("flex-column-reverse");
  public static final ICSSClassProvider FLEX_FILL = DefaultCSSClassProvider.create ("flex-fill");
  public static final ICSSClassProvider FLEX_GROW_0 = DefaultCSSClassProvider.create ("flex-grow-0");
  public static final ICSSClassProvider FLEX_GROW_1 = DefaultCSSClassProvider.create ("flex-grow-1");
  public static final ICSSClassProvider FLEX_LG_COLUMN = DefaultCSSClassProvider.create ("flex-lg-column");
  public static final ICSSClassProvider FLEX_LG_COLUMN_REVERSE = DefaultCSSClassProvider.create ("flex-lg-column-reverse");
  public static final ICSSClassProvider FLEX_LG_FILL = DefaultCSSClassProvider.create ("flex-lg-fill");
  public static final ICSSClassProvider FLEX_LG_GROW_0 = DefaultCSSClassProvider.create ("flex-lg-grow-0");
  public static final ICSSClassProvider FLEX_LG_GROW_1 = DefaultCSSClassProvider.create ("flex-lg-grow-1");
  public static final ICSSClassProvider FLEX_LG_NOWRAP = DefaultCSSClassProvider.create ("flex-lg-nowrap");
  public static final ICSSClassProvider FLEX_LG_ROW = DefaultCSSClassProvider.create ("flex-lg-row");
  public static final ICSSClassProvider FLEX_LG_ROW_REVERSE = DefaultCSSClassProvider.create ("flex-lg-row-reverse");
  public static final ICSSClassProvider FLEX_LG_SHRINK_0 = DefaultCSSClassProvider.create ("flex-lg-shrink-0");
  public static final ICSSClassProvider FLEX_LG_SHRINK_1 = DefaultCSSClassProvider.create ("flex-lg-shrink-1");
  public static final ICSSClassProvider FLEX_LG_WRAP = DefaultCSSClassProvider.create ("flex-lg-wrap");
  public static final ICSSClassProvider FLEX_LG_WRAP_REVERSE = DefaultCSSClassProvider.create ("flex-lg-wrap-reverse");
  public static final ICSSClassProvider FLEX_MD_COLUMN = DefaultCSSClassProvider.create ("flex-md-column");
  public static final ICSSClassProvider FLEX_MD_COLUMN_REVERSE = DefaultCSSClassProvider.create ("flex-md-column-reverse");
  public static final ICSSClassProvider FLEX_MD_FILL = DefaultCSSClassProvider.create ("flex-md-fill");
  public static final ICSSClassProvider FLEX_MD_GROW_0 = DefaultCSSClassProvider.create ("flex-md-grow-0");
  public static final ICSSClassProvider FLEX_MD_GROW_1 = DefaultCSSClassProvider.create ("flex-md-grow-1");
  public static final ICSSClassProvider FLEX_MD_NOWRAP = DefaultCSSClassProvider.create ("flex-md-nowrap");
  public static final ICSSClassProvider FLEX_MD_ROW = DefaultCSSClassProvider.create ("flex-md-row");
  public static final ICSSClassProvider FLEX_MD_ROW_REVERSE = DefaultCSSClassProvider.create ("flex-md-row-reverse");
  public static final ICSSClassProvider FLEX_MD_SHRINK_0 = DefaultCSSClassProvider.create ("flex-md-shrink-0");
  public static final ICSSClassProvider FLEX_MD_SHRINK_1 = DefaultCSSClassProvider.create ("flex-md-shrink-1");
  public static final ICSSClassProvider FLEX_MD_WRAP = DefaultCSSClassProvider.create ("flex-md-wrap");
  public static final ICSSClassProvider FLEX_MD_WRAP_REVERSE = DefaultCSSClassProvider.create ("flex-md-wrap-reverse");
  public static final ICSSClassProvider FLEX_NOWRAP = DefaultCSSClassProvider.create ("flex-nowrap");
  public static final ICSSClassProvider FLEX_ROW = DefaultCSSClassProvider.create ("flex-row");
  public static final ICSSClassProvider FLEX_ROW_REVERSE = DefaultCSSClassProvider.create ("flex-row-reverse");
  public static final ICSSClassProvider FLEX_SHRINK_0 = DefaultCSSClassProvider.create ("flex-shrink-0");
  public static final ICSSClassProvider FLEX_SHRINK_1 = DefaultCSSClassProvider.create ("flex-shrink-1");
  public static final ICSSClassProvider FLEX_SM_COLUMN = DefaultCSSClassProvider.create ("flex-sm-column");
  public static final ICSSClassProvider FLEX_SM_COLUMN_REVERSE = DefaultCSSClassProvider.create ("flex-sm-column-reverse");
  public static final ICSSClassProvider FLEX_SM_FILL = DefaultCSSClassProvider.create ("flex-sm-fill");
  public static final ICSSClassProvider FLEX_SM_GROW_0 = DefaultCSSClassProvider.create ("flex-sm-grow-0");
  public static final ICSSClassProvider FLEX_SM_GROW_1 = DefaultCSSClassProvider.create ("flex-sm-grow-1");
  public static final ICSSClassProvider FLEX_SM_NOWRAP = DefaultCSSClassProvider.create ("flex-sm-nowrap");
  public static final ICSSClassProvider FLEX_SM_ROW = DefaultCSSClassProvider.create ("flex-sm-row");
  public static final ICSSClassProvider FLEX_SM_ROW_REVERSE = DefaultCSSClassProvider.create ("flex-sm-row-reverse");
  public static final ICSSClassProvider FLEX_SM_SHRINK_0 = DefaultCSSClassProvider.create ("flex-sm-shrink-0");
  public static final ICSSClassProvider FLEX_SM_SHRINK_1 = DefaultCSSClassProvider.create ("flex-sm-shrink-1");
  public static final ICSSClassProvider FLEX_SM_WRAP = DefaultCSSClassProvider.create ("flex-sm-wrap");
  public static final ICSSClassProvider FLEX_SM_WRAP_REVERSE = DefaultCSSClassProvider.create ("flex-sm-wrap-reverse");
  public static final ICSSClassProvider FLEX_WRAP = DefaultCSSClassProvider.create ("flex-wrap");
  public static final ICSSClassProvider FLEX_WRAP_REVERSE = DefaultCSSClassProvider.create ("flex-wrap-reverse");
  public static final ICSSClassProvider FLEX_XL_COLUMN = DefaultCSSClassProvider.create ("flex-xl-column");
  public static final ICSSClassProvider FLEX_XL_COLUMN_REVERSE = DefaultCSSClassProvider.create ("flex-xl-column-reverse");
  public static final ICSSClassProvider FLEX_XL_FILL = DefaultCSSClassProvider.create ("flex-xl-fill");
  public static final ICSSClassProvider FLEX_XL_GROW_0 = DefaultCSSClassProvider.create ("flex-xl-grow-0");
  public static final ICSSClassProvider FLEX_XL_GROW_1 = DefaultCSSClassProvider.create ("flex-xl-grow-1");
  public static final ICSSClassProvider FLEX_XL_NOWRAP = DefaultCSSClassProvider.create ("flex-xl-nowrap");
  public static final ICSSClassProvider FLEX_XL_ROW = DefaultCSSClassProvider.create ("flex-xl-row");
  public static final ICSSClassProvider FLEX_XL_ROW_REVERSE = DefaultCSSClassProvider.create ("flex-xl-row-reverse");
  public static final ICSSClassProvider FLEX_XL_SHRINK_0 = DefaultCSSClassProvider.create ("flex-xl-shrink-0");
  public static final ICSSClassProvider FLEX_XL_SHRINK_1 = DefaultCSSClassProvider.create ("flex-xl-shrink-1");
  public static final ICSSClassProvider FLEX_XL_WRAP = DefaultCSSClassProvider.create ("flex-xl-wrap");
  public static final ICSSClassProvider FLEX_XL_WRAP_REVERSE = DefaultCSSClassProvider.create ("flex-xl-wrap-reverse");
  public static final ICSSClassProvider FLOAT_LEFT = DefaultCSSClassProvider.create ("float-left");
  public static final ICSSClassProvider FLOAT_LG_LEFT = DefaultCSSClassProvider.create ("float-lg-left");
  public static final ICSSClassProvider FLOAT_LG_NONE = DefaultCSSClassProvider.create ("float-lg-none");
  public static final ICSSClassProvider FLOAT_LG_RIGHT = DefaultCSSClassProvider.create ("float-lg-right");
  public static final ICSSClassProvider FLOAT_MD_LEFT = DefaultCSSClassProvider.create ("float-md-left");
  public static final ICSSClassProvider FLOAT_MD_NONE = DefaultCSSClassProvider.create ("float-md-none");
  public static final ICSSClassProvider FLOAT_MD_RIGHT = DefaultCSSClassProvider.create ("float-md-right");
  public static final ICSSClassProvider FLOAT_NONE = DefaultCSSClassProvider.create ("float-none");
  public static final ICSSClassProvider FLOAT_RIGHT = DefaultCSSClassProvider.create ("float-right");
  public static final ICSSClassProvider FLOAT_SM_LEFT = DefaultCSSClassProvider.create ("float-sm-left");
  public static final ICSSClassProvider FLOAT_SM_NONE = DefaultCSSClassProvider.create ("float-sm-none");
  public static final ICSSClassProvider FLOAT_SM_RIGHT = DefaultCSSClassProvider.create ("float-sm-right");
  public static final ICSSClassProvider FLOAT_XL_LEFT = DefaultCSSClassProvider.create ("float-xl-left");
  public static final ICSSClassProvider FLOAT_XL_NONE = DefaultCSSClassProvider.create ("float-xl-none");
  public static final ICSSClassProvider FLOAT_XL_RIGHT = DefaultCSSClassProvider.create ("float-xl-right");
  public static final ICSSClassProvider FOCUS = DefaultCSSClassProvider.create ("focus");
  public static final ICSSClassProvider FONT_ITALIC = DefaultCSSClassProvider.create ("font-italic");
  public static final ICSSClassProvider FONT_WEIGHT_BOLD = DefaultCSSClassProvider.create ("font-weight-bold");
  public static final ICSSClassProvider FONT_WEIGHT_BOLDER = DefaultCSSClassProvider.create ("font-weight-bolder");
  public static final ICSSClassProvider FONT_WEIGHT_LIGHT = DefaultCSSClassProvider.create ("font-weight-light");
  public static final ICSSClassProvider FONT_WEIGHT_LIGHTER = DefaultCSSClassProvider.create ("font-weight-lighter");
  public static final ICSSClassProvider FONT_WEIGHT_NORMAL = DefaultCSSClassProvider.create ("font-weight-normal");
  public static final ICSSClassProvider FORM_CHECK = DefaultCSSClassProvider.create ("form-check");
  public static final ICSSClassProvider FORM_CHECK_INLINE = DefaultCSSClassProvider.create ("form-check-inline");
  public static final ICSSClassProvider FORM_CHECK_INPUT = DefaultCSSClassProvider.create ("form-check-input");
  public static final ICSSClassProvider FORM_CHECK_LABEL = DefaultCSSClassProvider.create ("form-check-label");
  public static final ICSSClassProvider FORM_CONTROL = DefaultCSSClassProvider.create ("form-control");
  public static final ICSSClassProvider FORM_CONTROL_FILE = DefaultCSSClassProvider.create ("form-control-file");
  public static final ICSSClassProvider FORM_CONTROL_LG = DefaultCSSClassProvider.create ("form-control-lg");
  public static final ICSSClassProvider FORM_CONTROL_PLAINTEXT = DefaultCSSClassProvider.create ("form-control-plaintext");
  public static final ICSSClassProvider FORM_CONTROL_RANGE = DefaultCSSClassProvider.create ("form-control-range");
  public static final ICSSClassProvider FORM_CONTROL_SM = DefaultCSSClassProvider.create ("form-control-sm");
  public static final ICSSClassProvider FORM_GROUP = DefaultCSSClassProvider.create ("form-group");
  public static final ICSSClassProvider FORM_INLINE = DefaultCSSClassProvider.create ("form-inline");
  public static final ICSSClassProvider FORM_ROW = DefaultCSSClassProvider.create ("form-row");
  public static final ICSSClassProvider FORM_TEXT = DefaultCSSClassProvider.create ("form-text");
  public static final ICSSClassProvider H_100 = DefaultCSSClassProvider.create ("h-100");
  public static final ICSSClassProvider H_25 = DefaultCSSClassProvider.create ("h-25");
  public static final ICSSClassProvider H_50 = DefaultCSSClassProvider.create ("h-50");
  public static final ICSSClassProvider H_75 = DefaultCSSClassProvider.create ("h-75");
  public static final ICSSClassProvider H_AUTO = DefaultCSSClassProvider.create ("h-auto");
  public static final ICSSClassProvider H1 = DefaultCSSClassProvider.create ("h1");
  public static final ICSSClassProvider H2 = DefaultCSSClassProvider.create ("h2");
  public static final ICSSClassProvider H3 = DefaultCSSClassProvider.create ("h3");
  public static final ICSSClassProvider H4 = DefaultCSSClassProvider.create ("h4");
  public static final ICSSClassProvider H5 = DefaultCSSClassProvider.create ("h5");
  public static final ICSSClassProvider H6 = DefaultCSSClassProvider.create ("h6");
  public static final ICSSClassProvider HIDE = DefaultCSSClassProvider.create ("hide");
  public static final ICSSClassProvider IMG_FLUID = DefaultCSSClassProvider.create ("img-fluid");
  public static final ICSSClassProvider IMG_THUMBNAIL = DefaultCSSClassProvider.create ("img-thumbnail");
  public static final ICSSClassProvider INITIALISM = DefaultCSSClassProvider.create ("initialism");
  public static final ICSSClassProvider INPUT_GROUP = DefaultCSSClassProvider.create ("input-group");
  public static final ICSSClassProvider INPUT_GROUP_APPEND = DefaultCSSClassProvider.create ("input-group-append");
  public static final ICSSClassProvider INPUT_GROUP_LG = DefaultCSSClassProvider.create ("input-group-lg");
  public static final ICSSClassProvider INPUT_GROUP_PREPEND = DefaultCSSClassProvider.create ("input-group-prepend");
  public static final ICSSClassProvider INPUT_GROUP_SM = DefaultCSSClassProvider.create ("input-group-sm");
  public static final ICSSClassProvider INPUT_GROUP_TEXT = DefaultCSSClassProvider.create ("input-group-text");
  public static final ICSSClassProvider INVALID_FEEDBACK = DefaultCSSClassProvider.create ("invalid-feedback");
  public static final ICSSClassProvider INVALID_TOOLTIP = DefaultCSSClassProvider.create ("invalid-tooltip");
  public static final ICSSClassProvider INVISIBLE = DefaultCSSClassProvider.create ("invisible");
  public static final ICSSClassProvider IS_INVALID = DefaultCSSClassProvider.create ("is-invalid");
  public static final ICSSClassProvider IS_VALID = DefaultCSSClassProvider.create ("is-valid");
  public static final ICSSClassProvider JUMBOTRON = DefaultCSSClassProvider.create ("jumbotron");
  public static final ICSSClassProvider JUMBOTRON_FLUID = DefaultCSSClassProvider.create ("jumbotron-fluid");
  public static final ICSSClassProvider JUSTIFY_CONTENT_AROUND = DefaultCSSClassProvider.create ("justify-content-around");
  public static final ICSSClassProvider JUSTIFY_CONTENT_BETWEEN = DefaultCSSClassProvider.create ("justify-content-between");
  public static final ICSSClassProvider JUSTIFY_CONTENT_CENTER = DefaultCSSClassProvider.create ("justify-content-center");
  public static final ICSSClassProvider JUSTIFY_CONTENT_END = DefaultCSSClassProvider.create ("justify-content-end");
  public static final ICSSClassProvider JUSTIFY_CONTENT_LG_AROUND = DefaultCSSClassProvider.create ("justify-content-lg-around");
  public static final ICSSClassProvider JUSTIFY_CONTENT_LG_BETWEEN = DefaultCSSClassProvider.create ("justify-content-lg-between");
  public static final ICSSClassProvider JUSTIFY_CONTENT_LG_CENTER = DefaultCSSClassProvider.create ("justify-content-lg-center");
  public static final ICSSClassProvider JUSTIFY_CONTENT_LG_END = DefaultCSSClassProvider.create ("justify-content-lg-end");
  public static final ICSSClassProvider JUSTIFY_CONTENT_LG_START = DefaultCSSClassProvider.create ("justify-content-lg-start");
  public static final ICSSClassProvider JUSTIFY_CONTENT_MD_AROUND = DefaultCSSClassProvider.create ("justify-content-md-around");
  public static final ICSSClassProvider JUSTIFY_CONTENT_MD_BETWEEN = DefaultCSSClassProvider.create ("justify-content-md-between");
  public static final ICSSClassProvider JUSTIFY_CONTENT_MD_CENTER = DefaultCSSClassProvider.create ("justify-content-md-center");
  public static final ICSSClassProvider JUSTIFY_CONTENT_MD_END = DefaultCSSClassProvider.create ("justify-content-md-end");
  public static final ICSSClassProvider JUSTIFY_CONTENT_MD_START = DefaultCSSClassProvider.create ("justify-content-md-start");
  public static final ICSSClassProvider JUSTIFY_CONTENT_SM_AROUND = DefaultCSSClassProvider.create ("justify-content-sm-around");
  public static final ICSSClassProvider JUSTIFY_CONTENT_SM_BETWEEN = DefaultCSSClassProvider.create ("justify-content-sm-between");
  public static final ICSSClassProvider JUSTIFY_CONTENT_SM_CENTER = DefaultCSSClassProvider.create ("justify-content-sm-center");
  public static final ICSSClassProvider JUSTIFY_CONTENT_SM_END = DefaultCSSClassProvider.create ("justify-content-sm-end");
  public static final ICSSClassProvider JUSTIFY_CONTENT_SM_START = DefaultCSSClassProvider.create ("justify-content-sm-start");
  public static final ICSSClassProvider JUSTIFY_CONTENT_START = DefaultCSSClassProvider.create ("justify-content-start");
  public static final ICSSClassProvider JUSTIFY_CONTENT_XL_AROUND = DefaultCSSClassProvider.create ("justify-content-xl-around");
  public static final ICSSClassProvider JUSTIFY_CONTENT_XL_BETWEEN = DefaultCSSClassProvider.create ("justify-content-xl-between");
  public static final ICSSClassProvider JUSTIFY_CONTENT_XL_CENTER = DefaultCSSClassProvider.create ("justify-content-xl-center");
  public static final ICSSClassProvider JUSTIFY_CONTENT_XL_END = DefaultCSSClassProvider.create ("justify-content-xl-end");
  public static final ICSSClassProvider JUSTIFY_CONTENT_XL_START = DefaultCSSClassProvider.create ("justify-content-xl-start");
  public static final ICSSClassProvider LEAD = DefaultCSSClassProvider.create ("lead");
  public static final ICSSClassProvider LIST_GROUP = DefaultCSSClassProvider.create ("list-group");
  public static final ICSSClassProvider LIST_GROUP_FLUSH = DefaultCSSClassProvider.create ("list-group-flush");
  public static final ICSSClassProvider LIST_GROUP_HORIZONTAL = DefaultCSSClassProvider.create ("list-group-horizontal");
  public static final ICSSClassProvider LIST_GROUP_HORIZONTAL_LG = DefaultCSSClassProvider.create ("list-group-horizontal-lg");
  public static final ICSSClassProvider LIST_GROUP_HORIZONTAL_MD = DefaultCSSClassProvider.create ("list-group-horizontal-md");
  public static final ICSSClassProvider LIST_GROUP_HORIZONTAL_SM = DefaultCSSClassProvider.create ("list-group-horizontal-sm");
  public static final ICSSClassProvider LIST_GROUP_HORIZONTAL_XL = DefaultCSSClassProvider.create ("list-group-horizontal-xl");
  public static final ICSSClassProvider LIST_GROUP_ITEM = DefaultCSSClassProvider.create ("list-group-item");
  public static final ICSSClassProvider LIST_GROUP_ITEM_ACTION = DefaultCSSClassProvider.create ("list-group-item-action");
  public static final ICSSClassProvider LIST_GROUP_ITEM_DANGER = DefaultCSSClassProvider.create ("list-group-item-danger");
  public static final ICSSClassProvider LIST_GROUP_ITEM_DARK = DefaultCSSClassProvider.create ("list-group-item-dark");
  public static final ICSSClassProvider LIST_GROUP_ITEM_INFO = DefaultCSSClassProvider.create ("list-group-item-info");
  public static final ICSSClassProvider LIST_GROUP_ITEM_LIGHT = DefaultCSSClassProvider.create ("list-group-item-light");
  public static final ICSSClassProvider LIST_GROUP_ITEM_PRIMARY = DefaultCSSClassProvider.create ("list-group-item-primary");
  public static final ICSSClassProvider LIST_GROUP_ITEM_SECONDARY = DefaultCSSClassProvider.create ("list-group-item-secondary");
  public static final ICSSClassProvider LIST_GROUP_ITEM_SUCCESS = DefaultCSSClassProvider.create ("list-group-item-success");
  public static final ICSSClassProvider LIST_GROUP_ITEM_WARNING = DefaultCSSClassProvider.create ("list-group-item-warning");
  public static final ICSSClassProvider LIST_INLINE = DefaultCSSClassProvider.create ("list-inline");
  public static final ICSSClassProvider LIST_INLINE_ITEM = DefaultCSSClassProvider.create ("list-inline-item");
  public static final ICSSClassProvider LIST_UNSTYLED = DefaultCSSClassProvider.create ("list-unstyled");
  public static final ICSSClassProvider M_0 = DefaultCSSClassProvider.create ("m-0");
  public static final ICSSClassProvider M_1 = DefaultCSSClassProvider.create ("m-1");
  public static final ICSSClassProvider M_2 = DefaultCSSClassProvider.create ("m-2");
  public static final ICSSClassProvider M_3 = DefaultCSSClassProvider.create ("m-3");
  public static final ICSSClassProvider M_4 = DefaultCSSClassProvider.create ("m-4");
  public static final ICSSClassProvider M_5 = DefaultCSSClassProvider.create ("m-5");
  public static final ICSSClassProvider M_AUTO = DefaultCSSClassProvider.create ("m-auto");
  public static final ICSSClassProvider M_LG_0 = DefaultCSSClassProvider.create ("m-lg-0");
  public static final ICSSClassProvider M_LG_1 = DefaultCSSClassProvider.create ("m-lg-1");
  public static final ICSSClassProvider M_LG_2 = DefaultCSSClassProvider.create ("m-lg-2");
  public static final ICSSClassProvider M_LG_3 = DefaultCSSClassProvider.create ("m-lg-3");
  public static final ICSSClassProvider M_LG_4 = DefaultCSSClassProvider.create ("m-lg-4");
  public static final ICSSClassProvider M_LG_5 = DefaultCSSClassProvider.create ("m-lg-5");
  public static final ICSSClassProvider M_LG_AUTO = DefaultCSSClassProvider.create ("m-lg-auto");
  public static final ICSSClassProvider M_LG_N1 = DefaultCSSClassProvider.create ("m-lg-n1");
  public static final ICSSClassProvider M_LG_N2 = DefaultCSSClassProvider.create ("m-lg-n2");
  public static final ICSSClassProvider M_LG_N3 = DefaultCSSClassProvider.create ("m-lg-n3");
  public static final ICSSClassProvider M_LG_N4 = DefaultCSSClassProvider.create ("m-lg-n4");
  public static final ICSSClassProvider M_LG_N5 = DefaultCSSClassProvider.create ("m-lg-n5");
  public static final ICSSClassProvider M_MD_0 = DefaultCSSClassProvider.create ("m-md-0");
  public static final ICSSClassProvider M_MD_1 = DefaultCSSClassProvider.create ("m-md-1");
  public static final ICSSClassProvider M_MD_2 = DefaultCSSClassProvider.create ("m-md-2");
  public static final ICSSClassProvider M_MD_3 = DefaultCSSClassProvider.create ("m-md-3");
  public static final ICSSClassProvider M_MD_4 = DefaultCSSClassProvider.create ("m-md-4");
  public static final ICSSClassProvider M_MD_5 = DefaultCSSClassProvider.create ("m-md-5");
  public static final ICSSClassProvider M_MD_AUTO = DefaultCSSClassProvider.create ("m-md-auto");
  public static final ICSSClassProvider M_MD_N1 = DefaultCSSClassProvider.create ("m-md-n1");
  public static final ICSSClassProvider M_MD_N2 = DefaultCSSClassProvider.create ("m-md-n2");
  public static final ICSSClassProvider M_MD_N3 = DefaultCSSClassProvider.create ("m-md-n3");
  public static final ICSSClassProvider M_MD_N4 = DefaultCSSClassProvider.create ("m-md-n4");
  public static final ICSSClassProvider M_MD_N5 = DefaultCSSClassProvider.create ("m-md-n5");
  public static final ICSSClassProvider M_N1 = DefaultCSSClassProvider.create ("m-n1");
  public static final ICSSClassProvider M_N2 = DefaultCSSClassProvider.create ("m-n2");
  public static final ICSSClassProvider M_N3 = DefaultCSSClassProvider.create ("m-n3");
  public static final ICSSClassProvider M_N4 = DefaultCSSClassProvider.create ("m-n4");
  public static final ICSSClassProvider M_N5 = DefaultCSSClassProvider.create ("m-n5");
  public static final ICSSClassProvider M_SM_0 = DefaultCSSClassProvider.create ("m-sm-0");
  public static final ICSSClassProvider M_SM_1 = DefaultCSSClassProvider.create ("m-sm-1");
  public static final ICSSClassProvider M_SM_2 = DefaultCSSClassProvider.create ("m-sm-2");
  public static final ICSSClassProvider M_SM_3 = DefaultCSSClassProvider.create ("m-sm-3");
  public static final ICSSClassProvider M_SM_4 = DefaultCSSClassProvider.create ("m-sm-4");
  public static final ICSSClassProvider M_SM_5 = DefaultCSSClassProvider.create ("m-sm-5");
  public static final ICSSClassProvider M_SM_AUTO = DefaultCSSClassProvider.create ("m-sm-auto");
  public static final ICSSClassProvider M_SM_N1 = DefaultCSSClassProvider.create ("m-sm-n1");
  public static final ICSSClassProvider M_SM_N2 = DefaultCSSClassProvider.create ("m-sm-n2");
  public static final ICSSClassProvider M_SM_N3 = DefaultCSSClassProvider.create ("m-sm-n3");
  public static final ICSSClassProvider M_SM_N4 = DefaultCSSClassProvider.create ("m-sm-n4");
  public static final ICSSClassProvider M_SM_N5 = DefaultCSSClassProvider.create ("m-sm-n5");
  public static final ICSSClassProvider M_XL_0 = DefaultCSSClassProvider.create ("m-xl-0");
  public static final ICSSClassProvider M_XL_1 = DefaultCSSClassProvider.create ("m-xl-1");
  public static final ICSSClassProvider M_XL_2 = DefaultCSSClassProvider.create ("m-xl-2");
  public static final ICSSClassProvider M_XL_3 = DefaultCSSClassProvider.create ("m-xl-3");
  public static final ICSSClassProvider M_XL_4 = DefaultCSSClassProvider.create ("m-xl-4");
  public static final ICSSClassProvider M_XL_5 = DefaultCSSClassProvider.create ("m-xl-5");
  public static final ICSSClassProvider M_XL_AUTO = DefaultCSSClassProvider.create ("m-xl-auto");
  public static final ICSSClassProvider M_XL_N1 = DefaultCSSClassProvider.create ("m-xl-n1");
  public static final ICSSClassProvider M_XL_N2 = DefaultCSSClassProvider.create ("m-xl-n2");
  public static final ICSSClassProvider M_XL_N3 = DefaultCSSClassProvider.create ("m-xl-n3");
  public static final ICSSClassProvider M_XL_N4 = DefaultCSSClassProvider.create ("m-xl-n4");
  public static final ICSSClassProvider M_XL_N5 = DefaultCSSClassProvider.create ("m-xl-n5");
  public static final ICSSClassProvider MARK = DefaultCSSClassProvider.create ("mark");
  public static final ICSSClassProvider MB_0 = DefaultCSSClassProvider.create ("mb-0");
  public static final ICSSClassProvider MB_1 = DefaultCSSClassProvider.create ("mb-1");
  public static final ICSSClassProvider MB_2 = DefaultCSSClassProvider.create ("mb-2");
  public static final ICSSClassProvider MB_3 = DefaultCSSClassProvider.create ("mb-3");
  public static final ICSSClassProvider MB_4 = DefaultCSSClassProvider.create ("mb-4");
  public static final ICSSClassProvider MB_5 = DefaultCSSClassProvider.create ("mb-5");
  public static final ICSSClassProvider MB_AUTO = DefaultCSSClassProvider.create ("mb-auto");
  public static final ICSSClassProvider MB_LG_0 = DefaultCSSClassProvider.create ("mb-lg-0");
  public static final ICSSClassProvider MB_LG_1 = DefaultCSSClassProvider.create ("mb-lg-1");
  public static final ICSSClassProvider MB_LG_2 = DefaultCSSClassProvider.create ("mb-lg-2");
  public static final ICSSClassProvider MB_LG_3 = DefaultCSSClassProvider.create ("mb-lg-3");
  public static final ICSSClassProvider MB_LG_4 = DefaultCSSClassProvider.create ("mb-lg-4");
  public static final ICSSClassProvider MB_LG_5 = DefaultCSSClassProvider.create ("mb-lg-5");
  public static final ICSSClassProvider MB_LG_AUTO = DefaultCSSClassProvider.create ("mb-lg-auto");
  public static final ICSSClassProvider MB_LG_N1 = DefaultCSSClassProvider.create ("mb-lg-n1");
  public static final ICSSClassProvider MB_LG_N2 = DefaultCSSClassProvider.create ("mb-lg-n2");
  public static final ICSSClassProvider MB_LG_N3 = DefaultCSSClassProvider.create ("mb-lg-n3");
  public static final ICSSClassProvider MB_LG_N4 = DefaultCSSClassProvider.create ("mb-lg-n4");
  public static final ICSSClassProvider MB_LG_N5 = DefaultCSSClassProvider.create ("mb-lg-n5");
  public static final ICSSClassProvider MB_MD_0 = DefaultCSSClassProvider.create ("mb-md-0");
  public static final ICSSClassProvider MB_MD_1 = DefaultCSSClassProvider.create ("mb-md-1");
  public static final ICSSClassProvider MB_MD_2 = DefaultCSSClassProvider.create ("mb-md-2");
  public static final ICSSClassProvider MB_MD_3 = DefaultCSSClassProvider.create ("mb-md-3");
  public static final ICSSClassProvider MB_MD_4 = DefaultCSSClassProvider.create ("mb-md-4");
  public static final ICSSClassProvider MB_MD_5 = DefaultCSSClassProvider.create ("mb-md-5");
  public static final ICSSClassProvider MB_MD_AUTO = DefaultCSSClassProvider.create ("mb-md-auto");
  public static final ICSSClassProvider MB_MD_N1 = DefaultCSSClassProvider.create ("mb-md-n1");
  public static final ICSSClassProvider MB_MD_N2 = DefaultCSSClassProvider.create ("mb-md-n2");
  public static final ICSSClassProvider MB_MD_N3 = DefaultCSSClassProvider.create ("mb-md-n3");
  public static final ICSSClassProvider MB_MD_N4 = DefaultCSSClassProvider.create ("mb-md-n4");
  public static final ICSSClassProvider MB_MD_N5 = DefaultCSSClassProvider.create ("mb-md-n5");
  public static final ICSSClassProvider MB_N1 = DefaultCSSClassProvider.create ("mb-n1");
  public static final ICSSClassProvider MB_N2 = DefaultCSSClassProvider.create ("mb-n2");
  public static final ICSSClassProvider MB_N3 = DefaultCSSClassProvider.create ("mb-n3");
  public static final ICSSClassProvider MB_N4 = DefaultCSSClassProvider.create ("mb-n4");
  public static final ICSSClassProvider MB_N5 = DefaultCSSClassProvider.create ("mb-n5");
  public static final ICSSClassProvider MB_SM_0 = DefaultCSSClassProvider.create ("mb-sm-0");
  public static final ICSSClassProvider MB_SM_1 = DefaultCSSClassProvider.create ("mb-sm-1");
  public static final ICSSClassProvider MB_SM_2 = DefaultCSSClassProvider.create ("mb-sm-2");
  public static final ICSSClassProvider MB_SM_3 = DefaultCSSClassProvider.create ("mb-sm-3");
  public static final ICSSClassProvider MB_SM_4 = DefaultCSSClassProvider.create ("mb-sm-4");
  public static final ICSSClassProvider MB_SM_5 = DefaultCSSClassProvider.create ("mb-sm-5");
  public static final ICSSClassProvider MB_SM_AUTO = DefaultCSSClassProvider.create ("mb-sm-auto");
  public static final ICSSClassProvider MB_SM_N1 = DefaultCSSClassProvider.create ("mb-sm-n1");
  public static final ICSSClassProvider MB_SM_N2 = DefaultCSSClassProvider.create ("mb-sm-n2");
  public static final ICSSClassProvider MB_SM_N3 = DefaultCSSClassProvider.create ("mb-sm-n3");
  public static final ICSSClassProvider MB_SM_N4 = DefaultCSSClassProvider.create ("mb-sm-n4");
  public static final ICSSClassProvider MB_SM_N5 = DefaultCSSClassProvider.create ("mb-sm-n5");
  public static final ICSSClassProvider MB_XL_0 = DefaultCSSClassProvider.create ("mb-xl-0");
  public static final ICSSClassProvider MB_XL_1 = DefaultCSSClassProvider.create ("mb-xl-1");
  public static final ICSSClassProvider MB_XL_2 = DefaultCSSClassProvider.create ("mb-xl-2");
  public static final ICSSClassProvider MB_XL_3 = DefaultCSSClassProvider.create ("mb-xl-3");
  public static final ICSSClassProvider MB_XL_4 = DefaultCSSClassProvider.create ("mb-xl-4");
  public static final ICSSClassProvider MB_XL_5 = DefaultCSSClassProvider.create ("mb-xl-5");
  public static final ICSSClassProvider MB_XL_AUTO = DefaultCSSClassProvider.create ("mb-xl-auto");
  public static final ICSSClassProvider MB_XL_N1 = DefaultCSSClassProvider.create ("mb-xl-n1");
  public static final ICSSClassProvider MB_XL_N2 = DefaultCSSClassProvider.create ("mb-xl-n2");
  public static final ICSSClassProvider MB_XL_N3 = DefaultCSSClassProvider.create ("mb-xl-n3");
  public static final ICSSClassProvider MB_XL_N4 = DefaultCSSClassProvider.create ("mb-xl-n4");
  public static final ICSSClassProvider MB_XL_N5 = DefaultCSSClassProvider.create ("mb-xl-n5");
  public static final ICSSClassProvider MEDIA = DefaultCSSClassProvider.create ("media");
  public static final ICSSClassProvider MEDIA_BODY = DefaultCSSClassProvider.create ("media-body");
  public static final ICSSClassProvider MH_100 = DefaultCSSClassProvider.create ("mh-100");
  public static final ICSSClassProvider MIN_VH_100 = DefaultCSSClassProvider.create ("min-vh-100");
  public static final ICSSClassProvider MIN_VW_100 = DefaultCSSClassProvider.create ("min-vw-100");
  public static final ICSSClassProvider ML_0 = DefaultCSSClassProvider.create ("ml-0");
  public static final ICSSClassProvider ML_1 = DefaultCSSClassProvider.create ("ml-1");
  public static final ICSSClassProvider ML_2 = DefaultCSSClassProvider.create ("ml-2");
  public static final ICSSClassProvider ML_3 = DefaultCSSClassProvider.create ("ml-3");
  public static final ICSSClassProvider ML_4 = DefaultCSSClassProvider.create ("ml-4");
  public static final ICSSClassProvider ML_5 = DefaultCSSClassProvider.create ("ml-5");
  public static final ICSSClassProvider ML_AUTO = DefaultCSSClassProvider.create ("ml-auto");
  public static final ICSSClassProvider ML_LG_0 = DefaultCSSClassProvider.create ("ml-lg-0");
  public static final ICSSClassProvider ML_LG_1 = DefaultCSSClassProvider.create ("ml-lg-1");
  public static final ICSSClassProvider ML_LG_2 = DefaultCSSClassProvider.create ("ml-lg-2");
  public static final ICSSClassProvider ML_LG_3 = DefaultCSSClassProvider.create ("ml-lg-3");
  public static final ICSSClassProvider ML_LG_4 = DefaultCSSClassProvider.create ("ml-lg-4");
  public static final ICSSClassProvider ML_LG_5 = DefaultCSSClassProvider.create ("ml-lg-5");
  public static final ICSSClassProvider ML_LG_AUTO = DefaultCSSClassProvider.create ("ml-lg-auto");
  public static final ICSSClassProvider ML_LG_N1 = DefaultCSSClassProvider.create ("ml-lg-n1");
  public static final ICSSClassProvider ML_LG_N2 = DefaultCSSClassProvider.create ("ml-lg-n2");
  public static final ICSSClassProvider ML_LG_N3 = DefaultCSSClassProvider.create ("ml-lg-n3");
  public static final ICSSClassProvider ML_LG_N4 = DefaultCSSClassProvider.create ("ml-lg-n4");
  public static final ICSSClassProvider ML_LG_N5 = DefaultCSSClassProvider.create ("ml-lg-n5");
  public static final ICSSClassProvider ML_MD_0 = DefaultCSSClassProvider.create ("ml-md-0");
  public static final ICSSClassProvider ML_MD_1 = DefaultCSSClassProvider.create ("ml-md-1");
  public static final ICSSClassProvider ML_MD_2 = DefaultCSSClassProvider.create ("ml-md-2");
  public static final ICSSClassProvider ML_MD_3 = DefaultCSSClassProvider.create ("ml-md-3");
  public static final ICSSClassProvider ML_MD_4 = DefaultCSSClassProvider.create ("ml-md-4");
  public static final ICSSClassProvider ML_MD_5 = DefaultCSSClassProvider.create ("ml-md-5");
  public static final ICSSClassProvider ML_MD_AUTO = DefaultCSSClassProvider.create ("ml-md-auto");
  public static final ICSSClassProvider ML_MD_N1 = DefaultCSSClassProvider.create ("ml-md-n1");
  public static final ICSSClassProvider ML_MD_N2 = DefaultCSSClassProvider.create ("ml-md-n2");
  public static final ICSSClassProvider ML_MD_N3 = DefaultCSSClassProvider.create ("ml-md-n3");
  public static final ICSSClassProvider ML_MD_N4 = DefaultCSSClassProvider.create ("ml-md-n4");
  public static final ICSSClassProvider ML_MD_N5 = DefaultCSSClassProvider.create ("ml-md-n5");
  public static final ICSSClassProvider ML_N1 = DefaultCSSClassProvider.create ("ml-n1");
  public static final ICSSClassProvider ML_N2 = DefaultCSSClassProvider.create ("ml-n2");
  public static final ICSSClassProvider ML_N3 = DefaultCSSClassProvider.create ("ml-n3");
  public static final ICSSClassProvider ML_N4 = DefaultCSSClassProvider.create ("ml-n4");
  public static final ICSSClassProvider ML_N5 = DefaultCSSClassProvider.create ("ml-n5");
  public static final ICSSClassProvider ML_SM_0 = DefaultCSSClassProvider.create ("ml-sm-0");
  public static final ICSSClassProvider ML_SM_1 = DefaultCSSClassProvider.create ("ml-sm-1");
  public static final ICSSClassProvider ML_SM_2 = DefaultCSSClassProvider.create ("ml-sm-2");
  public static final ICSSClassProvider ML_SM_3 = DefaultCSSClassProvider.create ("ml-sm-3");
  public static final ICSSClassProvider ML_SM_4 = DefaultCSSClassProvider.create ("ml-sm-4");
  public static final ICSSClassProvider ML_SM_5 = DefaultCSSClassProvider.create ("ml-sm-5");
  public static final ICSSClassProvider ML_SM_AUTO = DefaultCSSClassProvider.create ("ml-sm-auto");
  public static final ICSSClassProvider ML_SM_N1 = DefaultCSSClassProvider.create ("ml-sm-n1");
  public static final ICSSClassProvider ML_SM_N2 = DefaultCSSClassProvider.create ("ml-sm-n2");
  public static final ICSSClassProvider ML_SM_N3 = DefaultCSSClassProvider.create ("ml-sm-n3");
  public static final ICSSClassProvider ML_SM_N4 = DefaultCSSClassProvider.create ("ml-sm-n4");
  public static final ICSSClassProvider ML_SM_N5 = DefaultCSSClassProvider.create ("ml-sm-n5");
  public static final ICSSClassProvider ML_XL_0 = DefaultCSSClassProvider.create ("ml-xl-0");
  public static final ICSSClassProvider ML_XL_1 = DefaultCSSClassProvider.create ("ml-xl-1");
  public static final ICSSClassProvider ML_XL_2 = DefaultCSSClassProvider.create ("ml-xl-2");
  public static final ICSSClassProvider ML_XL_3 = DefaultCSSClassProvider.create ("ml-xl-3");
  public static final ICSSClassProvider ML_XL_4 = DefaultCSSClassProvider.create ("ml-xl-4");
  public static final ICSSClassProvider ML_XL_5 = DefaultCSSClassProvider.create ("ml-xl-5");
  public static final ICSSClassProvider ML_XL_AUTO = DefaultCSSClassProvider.create ("ml-xl-auto");
  public static final ICSSClassProvider ML_XL_N1 = DefaultCSSClassProvider.create ("ml-xl-n1");
  public static final ICSSClassProvider ML_XL_N2 = DefaultCSSClassProvider.create ("ml-xl-n2");
  public static final ICSSClassProvider ML_XL_N3 = DefaultCSSClassProvider.create ("ml-xl-n3");
  public static final ICSSClassProvider ML_XL_N4 = DefaultCSSClassProvider.create ("ml-xl-n4");
  public static final ICSSClassProvider ML_XL_N5 = DefaultCSSClassProvider.create ("ml-xl-n5");
  public static final ICSSClassProvider MODAL = DefaultCSSClassProvider.create ("modal");
  public static final ICSSClassProvider MODAL_BACKDROP = DefaultCSSClassProvider.create ("modal-backdrop");
  public static final ICSSClassProvider MODAL_BODY = DefaultCSSClassProvider.create ("modal-body");
  public static final ICSSClassProvider MODAL_CONTENT = DefaultCSSClassProvider.create ("modal-content");
  public static final ICSSClassProvider MODAL_DIALOG = DefaultCSSClassProvider.create ("modal-dialog");
  public static final ICSSClassProvider MODAL_DIALOG_CENTERED = DefaultCSSClassProvider.create ("modal-dialog-centered");
  public static final ICSSClassProvider MODAL_DIALOG_SCROLLABLE = DefaultCSSClassProvider.create ("modal-dialog-scrollable");
  public static final ICSSClassProvider MODAL_FOOTER = DefaultCSSClassProvider.create ("modal-footer");
  public static final ICSSClassProvider MODAL_HEADER = DefaultCSSClassProvider.create ("modal-header");
  public static final ICSSClassProvider MODAL_LG = DefaultCSSClassProvider.create ("modal-lg");
  public static final ICSSClassProvider MODAL_OPEN = DefaultCSSClassProvider.create ("modal-open");
  public static final ICSSClassProvider MODAL_SCROLLBAR_MEASURE = DefaultCSSClassProvider.create ("modal-scrollbar-measure");
  public static final ICSSClassProvider MODAL_SM = DefaultCSSClassProvider.create ("modal-sm");
  public static final ICSSClassProvider MODAL_STATIC = DefaultCSSClassProvider.create ("modal-static");
  public static final ICSSClassProvider MODAL_TITLE = DefaultCSSClassProvider.create ("modal-title");
  public static final ICSSClassProvider MODAL_XL = DefaultCSSClassProvider.create ("modal-xl");
  public static final ICSSClassProvider MR_0 = DefaultCSSClassProvider.create ("mr-0");
  public static final ICSSClassProvider MR_1 = DefaultCSSClassProvider.create ("mr-1");
  public static final ICSSClassProvider MR_2 = DefaultCSSClassProvider.create ("mr-2");
  public static final ICSSClassProvider MR_3 = DefaultCSSClassProvider.create ("mr-3");
  public static final ICSSClassProvider MR_4 = DefaultCSSClassProvider.create ("mr-4");
  public static final ICSSClassProvider MR_5 = DefaultCSSClassProvider.create ("mr-5");
  public static final ICSSClassProvider MR_AUTO = DefaultCSSClassProvider.create ("mr-auto");
  public static final ICSSClassProvider MR_LG_0 = DefaultCSSClassProvider.create ("mr-lg-0");
  public static final ICSSClassProvider MR_LG_1 = DefaultCSSClassProvider.create ("mr-lg-1");
  public static final ICSSClassProvider MR_LG_2 = DefaultCSSClassProvider.create ("mr-lg-2");
  public static final ICSSClassProvider MR_LG_3 = DefaultCSSClassProvider.create ("mr-lg-3");
  public static final ICSSClassProvider MR_LG_4 = DefaultCSSClassProvider.create ("mr-lg-4");
  public static final ICSSClassProvider MR_LG_5 = DefaultCSSClassProvider.create ("mr-lg-5");
  public static final ICSSClassProvider MR_LG_AUTO = DefaultCSSClassProvider.create ("mr-lg-auto");
  public static final ICSSClassProvider MR_LG_N1 = DefaultCSSClassProvider.create ("mr-lg-n1");
  public static final ICSSClassProvider MR_LG_N2 = DefaultCSSClassProvider.create ("mr-lg-n2");
  public static final ICSSClassProvider MR_LG_N3 = DefaultCSSClassProvider.create ("mr-lg-n3");
  public static final ICSSClassProvider MR_LG_N4 = DefaultCSSClassProvider.create ("mr-lg-n4");
  public static final ICSSClassProvider MR_LG_N5 = DefaultCSSClassProvider.create ("mr-lg-n5");
  public static final ICSSClassProvider MR_MD_0 = DefaultCSSClassProvider.create ("mr-md-0");
  public static final ICSSClassProvider MR_MD_1 = DefaultCSSClassProvider.create ("mr-md-1");
  public static final ICSSClassProvider MR_MD_2 = DefaultCSSClassProvider.create ("mr-md-2");
  public static final ICSSClassProvider MR_MD_3 = DefaultCSSClassProvider.create ("mr-md-3");
  public static final ICSSClassProvider MR_MD_4 = DefaultCSSClassProvider.create ("mr-md-4");
  public static final ICSSClassProvider MR_MD_5 = DefaultCSSClassProvider.create ("mr-md-5");
  public static final ICSSClassProvider MR_MD_AUTO = DefaultCSSClassProvider.create ("mr-md-auto");
  public static final ICSSClassProvider MR_MD_N1 = DefaultCSSClassProvider.create ("mr-md-n1");
  public static final ICSSClassProvider MR_MD_N2 = DefaultCSSClassProvider.create ("mr-md-n2");
  public static final ICSSClassProvider MR_MD_N3 = DefaultCSSClassProvider.create ("mr-md-n3");
  public static final ICSSClassProvider MR_MD_N4 = DefaultCSSClassProvider.create ("mr-md-n4");
  public static final ICSSClassProvider MR_MD_N5 = DefaultCSSClassProvider.create ("mr-md-n5");
  public static final ICSSClassProvider MR_N1 = DefaultCSSClassProvider.create ("mr-n1");
  public static final ICSSClassProvider MR_N2 = DefaultCSSClassProvider.create ("mr-n2");
  public static final ICSSClassProvider MR_N3 = DefaultCSSClassProvider.create ("mr-n3");
  public static final ICSSClassProvider MR_N4 = DefaultCSSClassProvider.create ("mr-n4");
  public static final ICSSClassProvider MR_N5 = DefaultCSSClassProvider.create ("mr-n5");
  public static final ICSSClassProvider MR_SM_0 = DefaultCSSClassProvider.create ("mr-sm-0");
  public static final ICSSClassProvider MR_SM_1 = DefaultCSSClassProvider.create ("mr-sm-1");
  public static final ICSSClassProvider MR_SM_2 = DefaultCSSClassProvider.create ("mr-sm-2");
  public static final ICSSClassProvider MR_SM_3 = DefaultCSSClassProvider.create ("mr-sm-3");
  public static final ICSSClassProvider MR_SM_4 = DefaultCSSClassProvider.create ("mr-sm-4");
  public static final ICSSClassProvider MR_SM_5 = DefaultCSSClassProvider.create ("mr-sm-5");
  public static final ICSSClassProvider MR_SM_AUTO = DefaultCSSClassProvider.create ("mr-sm-auto");
  public static final ICSSClassProvider MR_SM_N1 = DefaultCSSClassProvider.create ("mr-sm-n1");
  public static final ICSSClassProvider MR_SM_N2 = DefaultCSSClassProvider.create ("mr-sm-n2");
  public static final ICSSClassProvider MR_SM_N3 = DefaultCSSClassProvider.create ("mr-sm-n3");
  public static final ICSSClassProvider MR_SM_N4 = DefaultCSSClassProvider.create ("mr-sm-n4");
  public static final ICSSClassProvider MR_SM_N5 = DefaultCSSClassProvider.create ("mr-sm-n5");
  public static final ICSSClassProvider MR_XL_0 = DefaultCSSClassProvider.create ("mr-xl-0");
  public static final ICSSClassProvider MR_XL_1 = DefaultCSSClassProvider.create ("mr-xl-1");
  public static final ICSSClassProvider MR_XL_2 = DefaultCSSClassProvider.create ("mr-xl-2");
  public static final ICSSClassProvider MR_XL_3 = DefaultCSSClassProvider.create ("mr-xl-3");
  public static final ICSSClassProvider MR_XL_4 = DefaultCSSClassProvider.create ("mr-xl-4");
  public static final ICSSClassProvider MR_XL_5 = DefaultCSSClassProvider.create ("mr-xl-5");
  public static final ICSSClassProvider MR_XL_AUTO = DefaultCSSClassProvider.create ("mr-xl-auto");
  public static final ICSSClassProvider MR_XL_N1 = DefaultCSSClassProvider.create ("mr-xl-n1");
  public static final ICSSClassProvider MR_XL_N2 = DefaultCSSClassProvider.create ("mr-xl-n2");
  public static final ICSSClassProvider MR_XL_N3 = DefaultCSSClassProvider.create ("mr-xl-n3");
  public static final ICSSClassProvider MR_XL_N4 = DefaultCSSClassProvider.create ("mr-xl-n4");
  public static final ICSSClassProvider MR_XL_N5 = DefaultCSSClassProvider.create ("mr-xl-n5");
  public static final ICSSClassProvider MT_0 = DefaultCSSClassProvider.create ("mt-0");
  public static final ICSSClassProvider MT_1 = DefaultCSSClassProvider.create ("mt-1");
  public static final ICSSClassProvider MT_2 = DefaultCSSClassProvider.create ("mt-2");
  public static final ICSSClassProvider MT_3 = DefaultCSSClassProvider.create ("mt-3");
  public static final ICSSClassProvider MT_4 = DefaultCSSClassProvider.create ("mt-4");
  public static final ICSSClassProvider MT_5 = DefaultCSSClassProvider.create ("mt-5");
  public static final ICSSClassProvider MT_AUTO = DefaultCSSClassProvider.create ("mt-auto");
  public static final ICSSClassProvider MT_LG_0 = DefaultCSSClassProvider.create ("mt-lg-0");
  public static final ICSSClassProvider MT_LG_1 = DefaultCSSClassProvider.create ("mt-lg-1");
  public static final ICSSClassProvider MT_LG_2 = DefaultCSSClassProvider.create ("mt-lg-2");
  public static final ICSSClassProvider MT_LG_3 = DefaultCSSClassProvider.create ("mt-lg-3");
  public static final ICSSClassProvider MT_LG_4 = DefaultCSSClassProvider.create ("mt-lg-4");
  public static final ICSSClassProvider MT_LG_5 = DefaultCSSClassProvider.create ("mt-lg-5");
  public static final ICSSClassProvider MT_LG_AUTO = DefaultCSSClassProvider.create ("mt-lg-auto");
  public static final ICSSClassProvider MT_LG_N1 = DefaultCSSClassProvider.create ("mt-lg-n1");
  public static final ICSSClassProvider MT_LG_N2 = DefaultCSSClassProvider.create ("mt-lg-n2");
  public static final ICSSClassProvider MT_LG_N3 = DefaultCSSClassProvider.create ("mt-lg-n3");
  public static final ICSSClassProvider MT_LG_N4 = DefaultCSSClassProvider.create ("mt-lg-n4");
  public static final ICSSClassProvider MT_LG_N5 = DefaultCSSClassProvider.create ("mt-lg-n5");
  public static final ICSSClassProvider MT_MD_0 = DefaultCSSClassProvider.create ("mt-md-0");
  public static final ICSSClassProvider MT_MD_1 = DefaultCSSClassProvider.create ("mt-md-1");
  public static final ICSSClassProvider MT_MD_2 = DefaultCSSClassProvider.create ("mt-md-2");
  public static final ICSSClassProvider MT_MD_3 = DefaultCSSClassProvider.create ("mt-md-3");
  public static final ICSSClassProvider MT_MD_4 = DefaultCSSClassProvider.create ("mt-md-4");
  public static final ICSSClassProvider MT_MD_5 = DefaultCSSClassProvider.create ("mt-md-5");
  public static final ICSSClassProvider MT_MD_AUTO = DefaultCSSClassProvider.create ("mt-md-auto");
  public static final ICSSClassProvider MT_MD_N1 = DefaultCSSClassProvider.create ("mt-md-n1");
  public static final ICSSClassProvider MT_MD_N2 = DefaultCSSClassProvider.create ("mt-md-n2");
  public static final ICSSClassProvider MT_MD_N3 = DefaultCSSClassProvider.create ("mt-md-n3");
  public static final ICSSClassProvider MT_MD_N4 = DefaultCSSClassProvider.create ("mt-md-n4");
  public static final ICSSClassProvider MT_MD_N5 = DefaultCSSClassProvider.create ("mt-md-n5");
  public static final ICSSClassProvider MT_N1 = DefaultCSSClassProvider.create ("mt-n1");
  public static final ICSSClassProvider MT_N2 = DefaultCSSClassProvider.create ("mt-n2");
  public static final ICSSClassProvider MT_N3 = DefaultCSSClassProvider.create ("mt-n3");
  public static final ICSSClassProvider MT_N4 = DefaultCSSClassProvider.create ("mt-n4");
  public static final ICSSClassProvider MT_N5 = DefaultCSSClassProvider.create ("mt-n5");
  public static final ICSSClassProvider MT_SM_0 = DefaultCSSClassProvider.create ("mt-sm-0");
  public static final ICSSClassProvider MT_SM_1 = DefaultCSSClassProvider.create ("mt-sm-1");
  public static final ICSSClassProvider MT_SM_2 = DefaultCSSClassProvider.create ("mt-sm-2");
  public static final ICSSClassProvider MT_SM_3 = DefaultCSSClassProvider.create ("mt-sm-3");
  public static final ICSSClassProvider MT_SM_4 = DefaultCSSClassProvider.create ("mt-sm-4");
  public static final ICSSClassProvider MT_SM_5 = DefaultCSSClassProvider.create ("mt-sm-5");
  public static final ICSSClassProvider MT_SM_AUTO = DefaultCSSClassProvider.create ("mt-sm-auto");
  public static final ICSSClassProvider MT_SM_N1 = DefaultCSSClassProvider.create ("mt-sm-n1");
  public static final ICSSClassProvider MT_SM_N2 = DefaultCSSClassProvider.create ("mt-sm-n2");
  public static final ICSSClassProvider MT_SM_N3 = DefaultCSSClassProvider.create ("mt-sm-n3");
  public static final ICSSClassProvider MT_SM_N4 = DefaultCSSClassProvider.create ("mt-sm-n4");
  public static final ICSSClassProvider MT_SM_N5 = DefaultCSSClassProvider.create ("mt-sm-n5");
  public static final ICSSClassProvider MT_XL_0 = DefaultCSSClassProvider.create ("mt-xl-0");
  public static final ICSSClassProvider MT_XL_1 = DefaultCSSClassProvider.create ("mt-xl-1");
  public static final ICSSClassProvider MT_XL_2 = DefaultCSSClassProvider.create ("mt-xl-2");
  public static final ICSSClassProvider MT_XL_3 = DefaultCSSClassProvider.create ("mt-xl-3");
  public static final ICSSClassProvider MT_XL_4 = DefaultCSSClassProvider.create ("mt-xl-4");
  public static final ICSSClassProvider MT_XL_5 = DefaultCSSClassProvider.create ("mt-xl-5");
  public static final ICSSClassProvider MT_XL_AUTO = DefaultCSSClassProvider.create ("mt-xl-auto");
  public static final ICSSClassProvider MT_XL_N1 = DefaultCSSClassProvider.create ("mt-xl-n1");
  public static final ICSSClassProvider MT_XL_N2 = DefaultCSSClassProvider.create ("mt-xl-n2");
  public static final ICSSClassProvider MT_XL_N3 = DefaultCSSClassProvider.create ("mt-xl-n3");
  public static final ICSSClassProvider MT_XL_N4 = DefaultCSSClassProvider.create ("mt-xl-n4");
  public static final ICSSClassProvider MT_XL_N5 = DefaultCSSClassProvider.create ("mt-xl-n5");
  public static final ICSSClassProvider MW_100 = DefaultCSSClassProvider.create ("mw-100");
  public static final ICSSClassProvider MX_0 = DefaultCSSClassProvider.create ("mx-0");
  public static final ICSSClassProvider MX_1 = DefaultCSSClassProvider.create ("mx-1");
  public static final ICSSClassProvider MX_2 = DefaultCSSClassProvider.create ("mx-2");
  public static final ICSSClassProvider MX_3 = DefaultCSSClassProvider.create ("mx-3");
  public static final ICSSClassProvider MX_4 = DefaultCSSClassProvider.create ("mx-4");
  public static final ICSSClassProvider MX_5 = DefaultCSSClassProvider.create ("mx-5");
  public static final ICSSClassProvider MX_AUTO = DefaultCSSClassProvider.create ("mx-auto");
  public static final ICSSClassProvider MX_LG_0 = DefaultCSSClassProvider.create ("mx-lg-0");
  public static final ICSSClassProvider MX_LG_1 = DefaultCSSClassProvider.create ("mx-lg-1");
  public static final ICSSClassProvider MX_LG_2 = DefaultCSSClassProvider.create ("mx-lg-2");
  public static final ICSSClassProvider MX_LG_3 = DefaultCSSClassProvider.create ("mx-lg-3");
  public static final ICSSClassProvider MX_LG_4 = DefaultCSSClassProvider.create ("mx-lg-4");
  public static final ICSSClassProvider MX_LG_5 = DefaultCSSClassProvider.create ("mx-lg-5");
  public static final ICSSClassProvider MX_LG_AUTO = DefaultCSSClassProvider.create ("mx-lg-auto");
  public static final ICSSClassProvider MX_LG_N1 = DefaultCSSClassProvider.create ("mx-lg-n1");
  public static final ICSSClassProvider MX_LG_N2 = DefaultCSSClassProvider.create ("mx-lg-n2");
  public static final ICSSClassProvider MX_LG_N3 = DefaultCSSClassProvider.create ("mx-lg-n3");
  public static final ICSSClassProvider MX_LG_N4 = DefaultCSSClassProvider.create ("mx-lg-n4");
  public static final ICSSClassProvider MX_LG_N5 = DefaultCSSClassProvider.create ("mx-lg-n5");
  public static final ICSSClassProvider MX_MD_0 = DefaultCSSClassProvider.create ("mx-md-0");
  public static final ICSSClassProvider MX_MD_1 = DefaultCSSClassProvider.create ("mx-md-1");
  public static final ICSSClassProvider MX_MD_2 = DefaultCSSClassProvider.create ("mx-md-2");
  public static final ICSSClassProvider MX_MD_3 = DefaultCSSClassProvider.create ("mx-md-3");
  public static final ICSSClassProvider MX_MD_4 = DefaultCSSClassProvider.create ("mx-md-4");
  public static final ICSSClassProvider MX_MD_5 = DefaultCSSClassProvider.create ("mx-md-5");
  public static final ICSSClassProvider MX_MD_AUTO = DefaultCSSClassProvider.create ("mx-md-auto");
  public static final ICSSClassProvider MX_MD_N1 = DefaultCSSClassProvider.create ("mx-md-n1");
  public static final ICSSClassProvider MX_MD_N2 = DefaultCSSClassProvider.create ("mx-md-n2");
  public static final ICSSClassProvider MX_MD_N3 = DefaultCSSClassProvider.create ("mx-md-n3");
  public static final ICSSClassProvider MX_MD_N4 = DefaultCSSClassProvider.create ("mx-md-n4");
  public static final ICSSClassProvider MX_MD_N5 = DefaultCSSClassProvider.create ("mx-md-n5");
  public static final ICSSClassProvider MX_N1 = DefaultCSSClassProvider.create ("mx-n1");
  public static final ICSSClassProvider MX_N2 = DefaultCSSClassProvider.create ("mx-n2");
  public static final ICSSClassProvider MX_N3 = DefaultCSSClassProvider.create ("mx-n3");
  public static final ICSSClassProvider MX_N4 = DefaultCSSClassProvider.create ("mx-n4");
  public static final ICSSClassProvider MX_N5 = DefaultCSSClassProvider.create ("mx-n5");
  public static final ICSSClassProvider MX_SM_0 = DefaultCSSClassProvider.create ("mx-sm-0");
  public static final ICSSClassProvider MX_SM_1 = DefaultCSSClassProvider.create ("mx-sm-1");
  public static final ICSSClassProvider MX_SM_2 = DefaultCSSClassProvider.create ("mx-sm-2");
  public static final ICSSClassProvider MX_SM_3 = DefaultCSSClassProvider.create ("mx-sm-3");
  public static final ICSSClassProvider MX_SM_4 = DefaultCSSClassProvider.create ("mx-sm-4");
  public static final ICSSClassProvider MX_SM_5 = DefaultCSSClassProvider.create ("mx-sm-5");
  public static final ICSSClassProvider MX_SM_AUTO = DefaultCSSClassProvider.create ("mx-sm-auto");
  public static final ICSSClassProvider MX_SM_N1 = DefaultCSSClassProvider.create ("mx-sm-n1");
  public static final ICSSClassProvider MX_SM_N2 = DefaultCSSClassProvider.create ("mx-sm-n2");
  public static final ICSSClassProvider MX_SM_N3 = DefaultCSSClassProvider.create ("mx-sm-n3");
  public static final ICSSClassProvider MX_SM_N4 = DefaultCSSClassProvider.create ("mx-sm-n4");
  public static final ICSSClassProvider MX_SM_N5 = DefaultCSSClassProvider.create ("mx-sm-n5");
  public static final ICSSClassProvider MX_XL_0 = DefaultCSSClassProvider.create ("mx-xl-0");
  public static final ICSSClassProvider MX_XL_1 = DefaultCSSClassProvider.create ("mx-xl-1");
  public static final ICSSClassProvider MX_XL_2 = DefaultCSSClassProvider.create ("mx-xl-2");
  public static final ICSSClassProvider MX_XL_3 = DefaultCSSClassProvider.create ("mx-xl-3");
  public static final ICSSClassProvider MX_XL_4 = DefaultCSSClassProvider.create ("mx-xl-4");
  public static final ICSSClassProvider MX_XL_5 = DefaultCSSClassProvider.create ("mx-xl-5");
  public static final ICSSClassProvider MX_XL_AUTO = DefaultCSSClassProvider.create ("mx-xl-auto");
  public static final ICSSClassProvider MX_XL_N1 = DefaultCSSClassProvider.create ("mx-xl-n1");
  public static final ICSSClassProvider MX_XL_N2 = DefaultCSSClassProvider.create ("mx-xl-n2");
  public static final ICSSClassProvider MX_XL_N3 = DefaultCSSClassProvider.create ("mx-xl-n3");
  public static final ICSSClassProvider MX_XL_N4 = DefaultCSSClassProvider.create ("mx-xl-n4");
  public static final ICSSClassProvider MX_XL_N5 = DefaultCSSClassProvider.create ("mx-xl-n5");
  public static final ICSSClassProvider MY_0 = DefaultCSSClassProvider.create ("my-0");
  public static final ICSSClassProvider MY_1 = DefaultCSSClassProvider.create ("my-1");
  public static final ICSSClassProvider MY_2 = DefaultCSSClassProvider.create ("my-2");
  public static final ICSSClassProvider MY_3 = DefaultCSSClassProvider.create ("my-3");
  public static final ICSSClassProvider MY_4 = DefaultCSSClassProvider.create ("my-4");
  public static final ICSSClassProvider MY_5 = DefaultCSSClassProvider.create ("my-5");
  public static final ICSSClassProvider MY_AUTO = DefaultCSSClassProvider.create ("my-auto");
  public static final ICSSClassProvider MY_LG_0 = DefaultCSSClassProvider.create ("my-lg-0");
  public static final ICSSClassProvider MY_LG_1 = DefaultCSSClassProvider.create ("my-lg-1");
  public static final ICSSClassProvider MY_LG_2 = DefaultCSSClassProvider.create ("my-lg-2");
  public static final ICSSClassProvider MY_LG_3 = DefaultCSSClassProvider.create ("my-lg-3");
  public static final ICSSClassProvider MY_LG_4 = DefaultCSSClassProvider.create ("my-lg-4");
  public static final ICSSClassProvider MY_LG_5 = DefaultCSSClassProvider.create ("my-lg-5");
  public static final ICSSClassProvider MY_LG_AUTO = DefaultCSSClassProvider.create ("my-lg-auto");
  public static final ICSSClassProvider MY_LG_N1 = DefaultCSSClassProvider.create ("my-lg-n1");
  public static final ICSSClassProvider MY_LG_N2 = DefaultCSSClassProvider.create ("my-lg-n2");
  public static final ICSSClassProvider MY_LG_N3 = DefaultCSSClassProvider.create ("my-lg-n3");
  public static final ICSSClassProvider MY_LG_N4 = DefaultCSSClassProvider.create ("my-lg-n4");
  public static final ICSSClassProvider MY_LG_N5 = DefaultCSSClassProvider.create ("my-lg-n5");
  public static final ICSSClassProvider MY_MD_0 = DefaultCSSClassProvider.create ("my-md-0");
  public static final ICSSClassProvider MY_MD_1 = DefaultCSSClassProvider.create ("my-md-1");
  public static final ICSSClassProvider MY_MD_2 = DefaultCSSClassProvider.create ("my-md-2");
  public static final ICSSClassProvider MY_MD_3 = DefaultCSSClassProvider.create ("my-md-3");
  public static final ICSSClassProvider MY_MD_4 = DefaultCSSClassProvider.create ("my-md-4");
  public static final ICSSClassProvider MY_MD_5 = DefaultCSSClassProvider.create ("my-md-5");
  public static final ICSSClassProvider MY_MD_AUTO = DefaultCSSClassProvider.create ("my-md-auto");
  public static final ICSSClassProvider MY_MD_N1 = DefaultCSSClassProvider.create ("my-md-n1");
  public static final ICSSClassProvider MY_MD_N2 = DefaultCSSClassProvider.create ("my-md-n2");
  public static final ICSSClassProvider MY_MD_N3 = DefaultCSSClassProvider.create ("my-md-n3");
  public static final ICSSClassProvider MY_MD_N4 = DefaultCSSClassProvider.create ("my-md-n4");
  public static final ICSSClassProvider MY_MD_N5 = DefaultCSSClassProvider.create ("my-md-n5");
  public static final ICSSClassProvider MY_N1 = DefaultCSSClassProvider.create ("my-n1");
  public static final ICSSClassProvider MY_N2 = DefaultCSSClassProvider.create ("my-n2");
  public static final ICSSClassProvider MY_N3 = DefaultCSSClassProvider.create ("my-n3");
  public static final ICSSClassProvider MY_N4 = DefaultCSSClassProvider.create ("my-n4");
  public static final ICSSClassProvider MY_N5 = DefaultCSSClassProvider.create ("my-n5");
  public static final ICSSClassProvider MY_SM_0 = DefaultCSSClassProvider.create ("my-sm-0");
  public static final ICSSClassProvider MY_SM_1 = DefaultCSSClassProvider.create ("my-sm-1");
  public static final ICSSClassProvider MY_SM_2 = DefaultCSSClassProvider.create ("my-sm-2");
  public static final ICSSClassProvider MY_SM_3 = DefaultCSSClassProvider.create ("my-sm-3");
  public static final ICSSClassProvider MY_SM_4 = DefaultCSSClassProvider.create ("my-sm-4");
  public static final ICSSClassProvider MY_SM_5 = DefaultCSSClassProvider.create ("my-sm-5");
  public static final ICSSClassProvider MY_SM_AUTO = DefaultCSSClassProvider.create ("my-sm-auto");
  public static final ICSSClassProvider MY_SM_N1 = DefaultCSSClassProvider.create ("my-sm-n1");
  public static final ICSSClassProvider MY_SM_N2 = DefaultCSSClassProvider.create ("my-sm-n2");
  public static final ICSSClassProvider MY_SM_N3 = DefaultCSSClassProvider.create ("my-sm-n3");
  public static final ICSSClassProvider MY_SM_N4 = DefaultCSSClassProvider.create ("my-sm-n4");
  public static final ICSSClassProvider MY_SM_N5 = DefaultCSSClassProvider.create ("my-sm-n5");
  public static final ICSSClassProvider MY_XL_0 = DefaultCSSClassProvider.create ("my-xl-0");
  public static final ICSSClassProvider MY_XL_1 = DefaultCSSClassProvider.create ("my-xl-1");
  public static final ICSSClassProvider MY_XL_2 = DefaultCSSClassProvider.create ("my-xl-2");
  public static final ICSSClassProvider MY_XL_3 = DefaultCSSClassProvider.create ("my-xl-3");
  public static final ICSSClassProvider MY_XL_4 = DefaultCSSClassProvider.create ("my-xl-4");
  public static final ICSSClassProvider MY_XL_5 = DefaultCSSClassProvider.create ("my-xl-5");
  public static final ICSSClassProvider MY_XL_AUTO = DefaultCSSClassProvider.create ("my-xl-auto");
  public static final ICSSClassProvider MY_XL_N1 = DefaultCSSClassProvider.create ("my-xl-n1");
  public static final ICSSClassProvider MY_XL_N2 = DefaultCSSClassProvider.create ("my-xl-n2");
  public static final ICSSClassProvider MY_XL_N3 = DefaultCSSClassProvider.create ("my-xl-n3");
  public static final ICSSClassProvider MY_XL_N4 = DefaultCSSClassProvider.create ("my-xl-n4");
  public static final ICSSClassProvider MY_XL_N5 = DefaultCSSClassProvider.create ("my-xl-n5");
  public static final ICSSClassProvider NAV = DefaultCSSClassProvider.create ("nav");
  public static final ICSSClassProvider NAV_FILL = DefaultCSSClassProvider.create ("nav-fill");
  public static final ICSSClassProvider NAV_ITEM = DefaultCSSClassProvider.create ("nav-item");
  public static final ICSSClassProvider NAV_JUSTIFIED = DefaultCSSClassProvider.create ("nav-justified");
  public static final ICSSClassProvider NAV_LINK = DefaultCSSClassProvider.create ("nav-link");
  public static final ICSSClassProvider NAV_PILLS = DefaultCSSClassProvider.create ("nav-pills");
  public static final ICSSClassProvider NAV_TABS = DefaultCSSClassProvider.create ("nav-tabs");
  public static final ICSSClassProvider NAVBAR = DefaultCSSClassProvider.create ("navbar");
  public static final ICSSClassProvider NAVBAR_BRAND = DefaultCSSClassProvider.create ("navbar-brand");
  public static final ICSSClassProvider NAVBAR_COLLAPSE = DefaultCSSClassProvider.create ("navbar-collapse");
  public static final ICSSClassProvider NAVBAR_DARK = DefaultCSSClassProvider.create ("navbar-dark");
  public static final ICSSClassProvider NAVBAR_EXPAND = DefaultCSSClassProvider.create ("navbar-expand");
  public static final ICSSClassProvider NAVBAR_EXPAND_LG = DefaultCSSClassProvider.create ("navbar-expand-lg");
  public static final ICSSClassProvider NAVBAR_EXPAND_MD = DefaultCSSClassProvider.create ("navbar-expand-md");
  public static final ICSSClassProvider NAVBAR_EXPAND_SM = DefaultCSSClassProvider.create ("navbar-expand-sm");
  public static final ICSSClassProvider NAVBAR_EXPAND_XL = DefaultCSSClassProvider.create ("navbar-expand-xl");
  public static final ICSSClassProvider NAVBAR_LIGHT = DefaultCSSClassProvider.create ("navbar-light");
  public static final ICSSClassProvider NAVBAR_NAV = DefaultCSSClassProvider.create ("navbar-nav");
  public static final ICSSClassProvider NAVBAR_TEXT = DefaultCSSClassProvider.create ("navbar-text");
  public static final ICSSClassProvider NAVBAR_TOGGLER = DefaultCSSClassProvider.create ("navbar-toggler");
  public static final ICSSClassProvider NAVBAR_TOGGLER_ICON = DefaultCSSClassProvider.create ("navbar-toggler-icon");
  public static final ICSSClassProvider NO_GUTTERS = DefaultCSSClassProvider.create ("no-gutters");
  public static final ICSSClassProvider OFFSET_1 = DefaultCSSClassProvider.create ("offset-1");
  public static final ICSSClassProvider OFFSET_10 = DefaultCSSClassProvider.create ("offset-10");
  public static final ICSSClassProvider OFFSET_11 = DefaultCSSClassProvider.create ("offset-11");
  public static final ICSSClassProvider OFFSET_2 = DefaultCSSClassProvider.create ("offset-2");
  public static final ICSSClassProvider OFFSET_3 = DefaultCSSClassProvider.create ("offset-3");
  public static final ICSSClassProvider OFFSET_4 = DefaultCSSClassProvider.create ("offset-4");
  public static final ICSSClassProvider OFFSET_5 = DefaultCSSClassProvider.create ("offset-5");
  public static final ICSSClassProvider OFFSET_6 = DefaultCSSClassProvider.create ("offset-6");
  public static final ICSSClassProvider OFFSET_7 = DefaultCSSClassProvider.create ("offset-7");
  public static final ICSSClassProvider OFFSET_8 = DefaultCSSClassProvider.create ("offset-8");
  public static final ICSSClassProvider OFFSET_9 = DefaultCSSClassProvider.create ("offset-9");
  public static final ICSSClassProvider OFFSET_LG_0 = DefaultCSSClassProvider.create ("offset-lg-0");
  public static final ICSSClassProvider OFFSET_LG_1 = DefaultCSSClassProvider.create ("offset-lg-1");
  public static final ICSSClassProvider OFFSET_LG_10 = DefaultCSSClassProvider.create ("offset-lg-10");
  public static final ICSSClassProvider OFFSET_LG_11 = DefaultCSSClassProvider.create ("offset-lg-11");
  public static final ICSSClassProvider OFFSET_LG_2 = DefaultCSSClassProvider.create ("offset-lg-2");
  public static final ICSSClassProvider OFFSET_LG_3 = DefaultCSSClassProvider.create ("offset-lg-3");
  public static final ICSSClassProvider OFFSET_LG_4 = DefaultCSSClassProvider.create ("offset-lg-4");
  public static final ICSSClassProvider OFFSET_LG_5 = DefaultCSSClassProvider.create ("offset-lg-5");
  public static final ICSSClassProvider OFFSET_LG_6 = DefaultCSSClassProvider.create ("offset-lg-6");
  public static final ICSSClassProvider OFFSET_LG_7 = DefaultCSSClassProvider.create ("offset-lg-7");
  public static final ICSSClassProvider OFFSET_LG_8 = DefaultCSSClassProvider.create ("offset-lg-8");
  public static final ICSSClassProvider OFFSET_LG_9 = DefaultCSSClassProvider.create ("offset-lg-9");
  public static final ICSSClassProvider OFFSET_MD_0 = DefaultCSSClassProvider.create ("offset-md-0");
  public static final ICSSClassProvider OFFSET_MD_1 = DefaultCSSClassProvider.create ("offset-md-1");
  public static final ICSSClassProvider OFFSET_MD_10 = DefaultCSSClassProvider.create ("offset-md-10");
  public static final ICSSClassProvider OFFSET_MD_11 = DefaultCSSClassProvider.create ("offset-md-11");
  public static final ICSSClassProvider OFFSET_MD_2 = DefaultCSSClassProvider.create ("offset-md-2");
  public static final ICSSClassProvider OFFSET_MD_3 = DefaultCSSClassProvider.create ("offset-md-3");
  public static final ICSSClassProvider OFFSET_MD_4 = DefaultCSSClassProvider.create ("offset-md-4");
  public static final ICSSClassProvider OFFSET_MD_5 = DefaultCSSClassProvider.create ("offset-md-5");
  public static final ICSSClassProvider OFFSET_MD_6 = DefaultCSSClassProvider.create ("offset-md-6");
  public static final ICSSClassProvider OFFSET_MD_7 = DefaultCSSClassProvider.create ("offset-md-7");
  public static final ICSSClassProvider OFFSET_MD_8 = DefaultCSSClassProvider.create ("offset-md-8");
  public static final ICSSClassProvider OFFSET_MD_9 = DefaultCSSClassProvider.create ("offset-md-9");
  public static final ICSSClassProvider OFFSET_SM_0 = DefaultCSSClassProvider.create ("offset-sm-0");
  public static final ICSSClassProvider OFFSET_SM_1 = DefaultCSSClassProvider.create ("offset-sm-1");
  public static final ICSSClassProvider OFFSET_SM_10 = DefaultCSSClassProvider.create ("offset-sm-10");
  public static final ICSSClassProvider OFFSET_SM_11 = DefaultCSSClassProvider.create ("offset-sm-11");
  public static final ICSSClassProvider OFFSET_SM_2 = DefaultCSSClassProvider.create ("offset-sm-2");
  public static final ICSSClassProvider OFFSET_SM_3 = DefaultCSSClassProvider.create ("offset-sm-3");
  public static final ICSSClassProvider OFFSET_SM_4 = DefaultCSSClassProvider.create ("offset-sm-4");
  public static final ICSSClassProvider OFFSET_SM_5 = DefaultCSSClassProvider.create ("offset-sm-5");
  public static final ICSSClassProvider OFFSET_SM_6 = DefaultCSSClassProvider.create ("offset-sm-6");
  public static final ICSSClassProvider OFFSET_SM_7 = DefaultCSSClassProvider.create ("offset-sm-7");
  public static final ICSSClassProvider OFFSET_SM_8 = DefaultCSSClassProvider.create ("offset-sm-8");
  public static final ICSSClassProvider OFFSET_SM_9 = DefaultCSSClassProvider.create ("offset-sm-9");
  public static final ICSSClassProvider OFFSET_XL_0 = DefaultCSSClassProvider.create ("offset-xl-0");
  public static final ICSSClassProvider OFFSET_XL_1 = DefaultCSSClassProvider.create ("offset-xl-1");
  public static final ICSSClassProvider OFFSET_XL_10 = DefaultCSSClassProvider.create ("offset-xl-10");
  public static final ICSSClassProvider OFFSET_XL_11 = DefaultCSSClassProvider.create ("offset-xl-11");
  public static final ICSSClassProvider OFFSET_XL_2 = DefaultCSSClassProvider.create ("offset-xl-2");
  public static final ICSSClassProvider OFFSET_XL_3 = DefaultCSSClassProvider.create ("offset-xl-3");
  public static final ICSSClassProvider OFFSET_XL_4 = DefaultCSSClassProvider.create ("offset-xl-4");
  public static final ICSSClassProvider OFFSET_XL_5 = DefaultCSSClassProvider.create ("offset-xl-5");
  public static final ICSSClassProvider OFFSET_XL_6 = DefaultCSSClassProvider.create ("offset-xl-6");
  public static final ICSSClassProvider OFFSET_XL_7 = DefaultCSSClassProvider.create ("offset-xl-7");
  public static final ICSSClassProvider OFFSET_XL_8 = DefaultCSSClassProvider.create ("offset-xl-8");
  public static final ICSSClassProvider OFFSET_XL_9 = DefaultCSSClassProvider.create ("offset-xl-9");
  public static final ICSSClassProvider ORDER_0 = DefaultCSSClassProvider.create ("order-0");
  public static final ICSSClassProvider ORDER_1 = DefaultCSSClassProvider.create ("order-1");
  public static final ICSSClassProvider ORDER_10 = DefaultCSSClassProvider.create ("order-10");
  public static final ICSSClassProvider ORDER_11 = DefaultCSSClassProvider.create ("order-11");
  public static final ICSSClassProvider ORDER_12 = DefaultCSSClassProvider.create ("order-12");
  public static final ICSSClassProvider ORDER_2 = DefaultCSSClassProvider.create ("order-2");
  public static final ICSSClassProvider ORDER_3 = DefaultCSSClassProvider.create ("order-3");
  public static final ICSSClassProvider ORDER_4 = DefaultCSSClassProvider.create ("order-4");
  public static final ICSSClassProvider ORDER_5 = DefaultCSSClassProvider.create ("order-5");
  public static final ICSSClassProvider ORDER_6 = DefaultCSSClassProvider.create ("order-6");
  public static final ICSSClassProvider ORDER_7 = DefaultCSSClassProvider.create ("order-7");
  public static final ICSSClassProvider ORDER_8 = DefaultCSSClassProvider.create ("order-8");
  public static final ICSSClassProvider ORDER_9 = DefaultCSSClassProvider.create ("order-9");
  public static final ICSSClassProvider ORDER_FIRST = DefaultCSSClassProvider.create ("order-first");
  public static final ICSSClassProvider ORDER_LAST = DefaultCSSClassProvider.create ("order-last");
  public static final ICSSClassProvider ORDER_LG_0 = DefaultCSSClassProvider.create ("order-lg-0");
  public static final ICSSClassProvider ORDER_LG_1 = DefaultCSSClassProvider.create ("order-lg-1");
  public static final ICSSClassProvider ORDER_LG_10 = DefaultCSSClassProvider.create ("order-lg-10");
  public static final ICSSClassProvider ORDER_LG_11 = DefaultCSSClassProvider.create ("order-lg-11");
  public static final ICSSClassProvider ORDER_LG_12 = DefaultCSSClassProvider.create ("order-lg-12");
  public static final ICSSClassProvider ORDER_LG_2 = DefaultCSSClassProvider.create ("order-lg-2");
  public static final ICSSClassProvider ORDER_LG_3 = DefaultCSSClassProvider.create ("order-lg-3");
  public static final ICSSClassProvider ORDER_LG_4 = DefaultCSSClassProvider.create ("order-lg-4");
  public static final ICSSClassProvider ORDER_LG_5 = DefaultCSSClassProvider.create ("order-lg-5");
  public static final ICSSClassProvider ORDER_LG_6 = DefaultCSSClassProvider.create ("order-lg-6");
  public static final ICSSClassProvider ORDER_LG_7 = DefaultCSSClassProvider.create ("order-lg-7");
  public static final ICSSClassProvider ORDER_LG_8 = DefaultCSSClassProvider.create ("order-lg-8");
  public static final ICSSClassProvider ORDER_LG_9 = DefaultCSSClassProvider.create ("order-lg-9");
  public static final ICSSClassProvider ORDER_LG_FIRST = DefaultCSSClassProvider.create ("order-lg-first");
  public static final ICSSClassProvider ORDER_LG_LAST = DefaultCSSClassProvider.create ("order-lg-last");
  public static final ICSSClassProvider ORDER_MD_0 = DefaultCSSClassProvider.create ("order-md-0");
  public static final ICSSClassProvider ORDER_MD_1 = DefaultCSSClassProvider.create ("order-md-1");
  public static final ICSSClassProvider ORDER_MD_10 = DefaultCSSClassProvider.create ("order-md-10");
  public static final ICSSClassProvider ORDER_MD_11 = DefaultCSSClassProvider.create ("order-md-11");
  public static final ICSSClassProvider ORDER_MD_12 = DefaultCSSClassProvider.create ("order-md-12");
  public static final ICSSClassProvider ORDER_MD_2 = DefaultCSSClassProvider.create ("order-md-2");
  public static final ICSSClassProvider ORDER_MD_3 = DefaultCSSClassProvider.create ("order-md-3");
  public static final ICSSClassProvider ORDER_MD_4 = DefaultCSSClassProvider.create ("order-md-4");
  public static final ICSSClassProvider ORDER_MD_5 = DefaultCSSClassProvider.create ("order-md-5");
  public static final ICSSClassProvider ORDER_MD_6 = DefaultCSSClassProvider.create ("order-md-6");
  public static final ICSSClassProvider ORDER_MD_7 = DefaultCSSClassProvider.create ("order-md-7");
  public static final ICSSClassProvider ORDER_MD_8 = DefaultCSSClassProvider.create ("order-md-8");
  public static final ICSSClassProvider ORDER_MD_9 = DefaultCSSClassProvider.create ("order-md-9");
  public static final ICSSClassProvider ORDER_MD_FIRST = DefaultCSSClassProvider.create ("order-md-first");
  public static final ICSSClassProvider ORDER_MD_LAST = DefaultCSSClassProvider.create ("order-md-last");
  public static final ICSSClassProvider ORDER_SM_0 = DefaultCSSClassProvider.create ("order-sm-0");
  public static final ICSSClassProvider ORDER_SM_1 = DefaultCSSClassProvider.create ("order-sm-1");
  public static final ICSSClassProvider ORDER_SM_10 = DefaultCSSClassProvider.create ("order-sm-10");
  public static final ICSSClassProvider ORDER_SM_11 = DefaultCSSClassProvider.create ("order-sm-11");
  public static final ICSSClassProvider ORDER_SM_12 = DefaultCSSClassProvider.create ("order-sm-12");
  public static final ICSSClassProvider ORDER_SM_2 = DefaultCSSClassProvider.create ("order-sm-2");
  public static final ICSSClassProvider ORDER_SM_3 = DefaultCSSClassProvider.create ("order-sm-3");
  public static final ICSSClassProvider ORDER_SM_4 = DefaultCSSClassProvider.create ("order-sm-4");
  public static final ICSSClassProvider ORDER_SM_5 = DefaultCSSClassProvider.create ("order-sm-5");
  public static final ICSSClassProvider ORDER_SM_6 = DefaultCSSClassProvider.create ("order-sm-6");
  public static final ICSSClassProvider ORDER_SM_7 = DefaultCSSClassProvider.create ("order-sm-7");
  public static final ICSSClassProvider ORDER_SM_8 = DefaultCSSClassProvider.create ("order-sm-8");
  public static final ICSSClassProvider ORDER_SM_9 = DefaultCSSClassProvider.create ("order-sm-9");
  public static final ICSSClassProvider ORDER_SM_FIRST = DefaultCSSClassProvider.create ("order-sm-first");
  public static final ICSSClassProvider ORDER_SM_LAST = DefaultCSSClassProvider.create ("order-sm-last");
  public static final ICSSClassProvider ORDER_XL_0 = DefaultCSSClassProvider.create ("order-xl-0");
  public static final ICSSClassProvider ORDER_XL_1 = DefaultCSSClassProvider.create ("order-xl-1");
  public static final ICSSClassProvider ORDER_XL_10 = DefaultCSSClassProvider.create ("order-xl-10");
  public static final ICSSClassProvider ORDER_XL_11 = DefaultCSSClassProvider.create ("order-xl-11");
  public static final ICSSClassProvider ORDER_XL_12 = DefaultCSSClassProvider.create ("order-xl-12");
  public static final ICSSClassProvider ORDER_XL_2 = DefaultCSSClassProvider.create ("order-xl-2");
  public static final ICSSClassProvider ORDER_XL_3 = DefaultCSSClassProvider.create ("order-xl-3");
  public static final ICSSClassProvider ORDER_XL_4 = DefaultCSSClassProvider.create ("order-xl-4");
  public static final ICSSClassProvider ORDER_XL_5 = DefaultCSSClassProvider.create ("order-xl-5");
  public static final ICSSClassProvider ORDER_XL_6 = DefaultCSSClassProvider.create ("order-xl-6");
  public static final ICSSClassProvider ORDER_XL_7 = DefaultCSSClassProvider.create ("order-xl-7");
  public static final ICSSClassProvider ORDER_XL_8 = DefaultCSSClassProvider.create ("order-xl-8");
  public static final ICSSClassProvider ORDER_XL_9 = DefaultCSSClassProvider.create ("order-xl-9");
  public static final ICSSClassProvider ORDER_XL_FIRST = DefaultCSSClassProvider.create ("order-xl-first");
  public static final ICSSClassProvider ORDER_XL_LAST = DefaultCSSClassProvider.create ("order-xl-last");
  public static final ICSSClassProvider OVERFLOW_AUTO = DefaultCSSClassProvider.create ("overflow-auto");
  public static final ICSSClassProvider OVERFLOW_HIDDEN = DefaultCSSClassProvider.create ("overflow-hidden");
  public static final ICSSClassProvider P_0 = DefaultCSSClassProvider.create ("p-0");
  public static final ICSSClassProvider P_1 = DefaultCSSClassProvider.create ("p-1");
  public static final ICSSClassProvider P_2 = DefaultCSSClassProvider.create ("p-2");
  public static final ICSSClassProvider P_3 = DefaultCSSClassProvider.create ("p-3");
  public static final ICSSClassProvider P_4 = DefaultCSSClassProvider.create ("p-4");
  public static final ICSSClassProvider P_5 = DefaultCSSClassProvider.create ("p-5");
  public static final ICSSClassProvider P_LG_0 = DefaultCSSClassProvider.create ("p-lg-0");
  public static final ICSSClassProvider P_LG_1 = DefaultCSSClassProvider.create ("p-lg-1");
  public static final ICSSClassProvider P_LG_2 = DefaultCSSClassProvider.create ("p-lg-2");
  public static final ICSSClassProvider P_LG_3 = DefaultCSSClassProvider.create ("p-lg-3");
  public static final ICSSClassProvider P_LG_4 = DefaultCSSClassProvider.create ("p-lg-4");
  public static final ICSSClassProvider P_LG_5 = DefaultCSSClassProvider.create ("p-lg-5");
  public static final ICSSClassProvider P_MD_0 = DefaultCSSClassProvider.create ("p-md-0");
  public static final ICSSClassProvider P_MD_1 = DefaultCSSClassProvider.create ("p-md-1");
  public static final ICSSClassProvider P_MD_2 = DefaultCSSClassProvider.create ("p-md-2");
  public static final ICSSClassProvider P_MD_3 = DefaultCSSClassProvider.create ("p-md-3");
  public static final ICSSClassProvider P_MD_4 = DefaultCSSClassProvider.create ("p-md-4");
  public static final ICSSClassProvider P_MD_5 = DefaultCSSClassProvider.create ("p-md-5");
  public static final ICSSClassProvider P_SM_0 = DefaultCSSClassProvider.create ("p-sm-0");
  public static final ICSSClassProvider P_SM_1 = DefaultCSSClassProvider.create ("p-sm-1");
  public static final ICSSClassProvider P_SM_2 = DefaultCSSClassProvider.create ("p-sm-2");
  public static final ICSSClassProvider P_SM_3 = DefaultCSSClassProvider.create ("p-sm-3");
  public static final ICSSClassProvider P_SM_4 = DefaultCSSClassProvider.create ("p-sm-4");
  public static final ICSSClassProvider P_SM_5 = DefaultCSSClassProvider.create ("p-sm-5");
  public static final ICSSClassProvider P_XL_0 = DefaultCSSClassProvider.create ("p-xl-0");
  public static final ICSSClassProvider P_XL_1 = DefaultCSSClassProvider.create ("p-xl-1");
  public static final ICSSClassProvider P_XL_2 = DefaultCSSClassProvider.create ("p-xl-2");
  public static final ICSSClassProvider P_XL_3 = DefaultCSSClassProvider.create ("p-xl-3");
  public static final ICSSClassProvider P_XL_4 = DefaultCSSClassProvider.create ("p-xl-4");
  public static final ICSSClassProvider P_XL_5 = DefaultCSSClassProvider.create ("p-xl-5");
  public static final ICSSClassProvider PAGE_ITEM = DefaultCSSClassProvider.create ("page-item");
  public static final ICSSClassProvider PAGE_LINK = DefaultCSSClassProvider.create ("page-link");
  public static final ICSSClassProvider PAGINATION = DefaultCSSClassProvider.create ("pagination");
  public static final ICSSClassProvider PAGINATION_LG = DefaultCSSClassProvider.create ("pagination-lg");
  public static final ICSSClassProvider PAGINATION_SM = DefaultCSSClassProvider.create ("pagination-sm");
  public static final ICSSClassProvider PB_0 = DefaultCSSClassProvider.create ("pb-0");
  public static final ICSSClassProvider PB_1 = DefaultCSSClassProvider.create ("pb-1");
  public static final ICSSClassProvider PB_2 = DefaultCSSClassProvider.create ("pb-2");
  public static final ICSSClassProvider PB_3 = DefaultCSSClassProvider.create ("pb-3");
  public static final ICSSClassProvider PB_4 = DefaultCSSClassProvider.create ("pb-4");
  public static final ICSSClassProvider PB_5 = DefaultCSSClassProvider.create ("pb-5");
  public static final ICSSClassProvider PB_LG_0 = DefaultCSSClassProvider.create ("pb-lg-0");
  public static final ICSSClassProvider PB_LG_1 = DefaultCSSClassProvider.create ("pb-lg-1");
  public static final ICSSClassProvider PB_LG_2 = DefaultCSSClassProvider.create ("pb-lg-2");
  public static final ICSSClassProvider PB_LG_3 = DefaultCSSClassProvider.create ("pb-lg-3");
  public static final ICSSClassProvider PB_LG_4 = DefaultCSSClassProvider.create ("pb-lg-4");
  public static final ICSSClassProvider PB_LG_5 = DefaultCSSClassProvider.create ("pb-lg-5");
  public static final ICSSClassProvider PB_MD_0 = DefaultCSSClassProvider.create ("pb-md-0");
  public static final ICSSClassProvider PB_MD_1 = DefaultCSSClassProvider.create ("pb-md-1");
  public static final ICSSClassProvider PB_MD_2 = DefaultCSSClassProvider.create ("pb-md-2");
  public static final ICSSClassProvider PB_MD_3 = DefaultCSSClassProvider.create ("pb-md-3");
  public static final ICSSClassProvider PB_MD_4 = DefaultCSSClassProvider.create ("pb-md-4");
  public static final ICSSClassProvider PB_MD_5 = DefaultCSSClassProvider.create ("pb-md-5");
  public static final ICSSClassProvider PB_SM_0 = DefaultCSSClassProvider.create ("pb-sm-0");
  public static final ICSSClassProvider PB_SM_1 = DefaultCSSClassProvider.create ("pb-sm-1");
  public static final ICSSClassProvider PB_SM_2 = DefaultCSSClassProvider.create ("pb-sm-2");
  public static final ICSSClassProvider PB_SM_3 = DefaultCSSClassProvider.create ("pb-sm-3");
  public static final ICSSClassProvider PB_SM_4 = DefaultCSSClassProvider.create ("pb-sm-4");
  public static final ICSSClassProvider PB_SM_5 = DefaultCSSClassProvider.create ("pb-sm-5");
  public static final ICSSClassProvider PB_XL_0 = DefaultCSSClassProvider.create ("pb-xl-0");
  public static final ICSSClassProvider PB_XL_1 = DefaultCSSClassProvider.create ("pb-xl-1");
  public static final ICSSClassProvider PB_XL_2 = DefaultCSSClassProvider.create ("pb-xl-2");
  public static final ICSSClassProvider PB_XL_3 = DefaultCSSClassProvider.create ("pb-xl-3");
  public static final ICSSClassProvider PB_XL_4 = DefaultCSSClassProvider.create ("pb-xl-4");
  public static final ICSSClassProvider PB_XL_5 = DefaultCSSClassProvider.create ("pb-xl-5");
  public static final ICSSClassProvider PL_0 = DefaultCSSClassProvider.create ("pl-0");
  public static final ICSSClassProvider PL_1 = DefaultCSSClassProvider.create ("pl-1");
  public static final ICSSClassProvider PL_2 = DefaultCSSClassProvider.create ("pl-2");
  public static final ICSSClassProvider PL_3 = DefaultCSSClassProvider.create ("pl-3");
  public static final ICSSClassProvider PL_4 = DefaultCSSClassProvider.create ("pl-4");
  public static final ICSSClassProvider PL_5 = DefaultCSSClassProvider.create ("pl-5");
  public static final ICSSClassProvider PL_LG_0 = DefaultCSSClassProvider.create ("pl-lg-0");
  public static final ICSSClassProvider PL_LG_1 = DefaultCSSClassProvider.create ("pl-lg-1");
  public static final ICSSClassProvider PL_LG_2 = DefaultCSSClassProvider.create ("pl-lg-2");
  public static final ICSSClassProvider PL_LG_3 = DefaultCSSClassProvider.create ("pl-lg-3");
  public static final ICSSClassProvider PL_LG_4 = DefaultCSSClassProvider.create ("pl-lg-4");
  public static final ICSSClassProvider PL_LG_5 = DefaultCSSClassProvider.create ("pl-lg-5");
  public static final ICSSClassProvider PL_MD_0 = DefaultCSSClassProvider.create ("pl-md-0");
  public static final ICSSClassProvider PL_MD_1 = DefaultCSSClassProvider.create ("pl-md-1");
  public static final ICSSClassProvider PL_MD_2 = DefaultCSSClassProvider.create ("pl-md-2");
  public static final ICSSClassProvider PL_MD_3 = DefaultCSSClassProvider.create ("pl-md-3");
  public static final ICSSClassProvider PL_MD_4 = DefaultCSSClassProvider.create ("pl-md-4");
  public static final ICSSClassProvider PL_MD_5 = DefaultCSSClassProvider.create ("pl-md-5");
  public static final ICSSClassProvider PL_SM_0 = DefaultCSSClassProvider.create ("pl-sm-0");
  public static final ICSSClassProvider PL_SM_1 = DefaultCSSClassProvider.create ("pl-sm-1");
  public static final ICSSClassProvider PL_SM_2 = DefaultCSSClassProvider.create ("pl-sm-2");
  public static final ICSSClassProvider PL_SM_3 = DefaultCSSClassProvider.create ("pl-sm-3");
  public static final ICSSClassProvider PL_SM_4 = DefaultCSSClassProvider.create ("pl-sm-4");
  public static final ICSSClassProvider PL_SM_5 = DefaultCSSClassProvider.create ("pl-sm-5");
  public static final ICSSClassProvider PL_XL_0 = DefaultCSSClassProvider.create ("pl-xl-0");
  public static final ICSSClassProvider PL_XL_1 = DefaultCSSClassProvider.create ("pl-xl-1");
  public static final ICSSClassProvider PL_XL_2 = DefaultCSSClassProvider.create ("pl-xl-2");
  public static final ICSSClassProvider PL_XL_3 = DefaultCSSClassProvider.create ("pl-xl-3");
  public static final ICSSClassProvider PL_XL_4 = DefaultCSSClassProvider.create ("pl-xl-4");
  public static final ICSSClassProvider PL_XL_5 = DefaultCSSClassProvider.create ("pl-xl-5");
  public static final ICSSClassProvider POINTER_EVENT = DefaultCSSClassProvider.create ("pointer-event");
  public static final ICSSClassProvider POPOVER = DefaultCSSClassProvider.create ("popover");
  public static final ICSSClassProvider POPOVER_BODY = DefaultCSSClassProvider.create ("popover-body");
  public static final ICSSClassProvider POPOVER_HEADER = DefaultCSSClassProvider.create ("popover-header");
  public static final ICSSClassProvider POSITION_ABSOLUTE = DefaultCSSClassProvider.create ("position-absolute");
  public static final ICSSClassProvider POSITION_FIXED = DefaultCSSClassProvider.create ("position-fixed");
  public static final ICSSClassProvider POSITION_RELATIVE = DefaultCSSClassProvider.create ("position-relative");
  public static final ICSSClassProvider POSITION_STATIC = DefaultCSSClassProvider.create ("position-static");
  public static final ICSSClassProvider POSITION_STICKY = DefaultCSSClassProvider.create ("position-sticky");
  public static final ICSSClassProvider PR_0 = DefaultCSSClassProvider.create ("pr-0");
  public static final ICSSClassProvider PR_1 = DefaultCSSClassProvider.create ("pr-1");
  public static final ICSSClassProvider PR_2 = DefaultCSSClassProvider.create ("pr-2");
  public static final ICSSClassProvider PR_3 = DefaultCSSClassProvider.create ("pr-3");
  public static final ICSSClassProvider PR_4 = DefaultCSSClassProvider.create ("pr-4");
  public static final ICSSClassProvider PR_5 = DefaultCSSClassProvider.create ("pr-5");
  public static final ICSSClassProvider PR_LG_0 = DefaultCSSClassProvider.create ("pr-lg-0");
  public static final ICSSClassProvider PR_LG_1 = DefaultCSSClassProvider.create ("pr-lg-1");
  public static final ICSSClassProvider PR_LG_2 = DefaultCSSClassProvider.create ("pr-lg-2");
  public static final ICSSClassProvider PR_LG_3 = DefaultCSSClassProvider.create ("pr-lg-3");
  public static final ICSSClassProvider PR_LG_4 = DefaultCSSClassProvider.create ("pr-lg-4");
  public static final ICSSClassProvider PR_LG_5 = DefaultCSSClassProvider.create ("pr-lg-5");
  public static final ICSSClassProvider PR_MD_0 = DefaultCSSClassProvider.create ("pr-md-0");
  public static final ICSSClassProvider PR_MD_1 = DefaultCSSClassProvider.create ("pr-md-1");
  public static final ICSSClassProvider PR_MD_2 = DefaultCSSClassProvider.create ("pr-md-2");
  public static final ICSSClassProvider PR_MD_3 = DefaultCSSClassProvider.create ("pr-md-3");
  public static final ICSSClassProvider PR_MD_4 = DefaultCSSClassProvider.create ("pr-md-4");
  public static final ICSSClassProvider PR_MD_5 = DefaultCSSClassProvider.create ("pr-md-5");
  public static final ICSSClassProvider PR_SM_0 = DefaultCSSClassProvider.create ("pr-sm-0");
  public static final ICSSClassProvider PR_SM_1 = DefaultCSSClassProvider.create ("pr-sm-1");
  public static final ICSSClassProvider PR_SM_2 = DefaultCSSClassProvider.create ("pr-sm-2");
  public static final ICSSClassProvider PR_SM_3 = DefaultCSSClassProvider.create ("pr-sm-3");
  public static final ICSSClassProvider PR_SM_4 = DefaultCSSClassProvider.create ("pr-sm-4");
  public static final ICSSClassProvider PR_SM_5 = DefaultCSSClassProvider.create ("pr-sm-5");
  public static final ICSSClassProvider PR_XL_0 = DefaultCSSClassProvider.create ("pr-xl-0");
  public static final ICSSClassProvider PR_XL_1 = DefaultCSSClassProvider.create ("pr-xl-1");
  public static final ICSSClassProvider PR_XL_2 = DefaultCSSClassProvider.create ("pr-xl-2");
  public static final ICSSClassProvider PR_XL_3 = DefaultCSSClassProvider.create ("pr-xl-3");
  public static final ICSSClassProvider PR_XL_4 = DefaultCSSClassProvider.create ("pr-xl-4");
  public static final ICSSClassProvider PR_XL_5 = DefaultCSSClassProvider.create ("pr-xl-5");
  public static final ICSSClassProvider PRE_SCROLLABLE = DefaultCSSClassProvider.create ("pre-scrollable");
  public static final ICSSClassProvider PROGRESS = DefaultCSSClassProvider.create ("progress");
  public static final ICSSClassProvider PROGRESS_BAR = DefaultCSSClassProvider.create ("progress-bar");
  public static final ICSSClassProvider PROGRESS_BAR_ANIMATED = DefaultCSSClassProvider.create ("progress-bar-animated");
  public static final ICSSClassProvider PROGRESS_BAR_STRIPED = DefaultCSSClassProvider.create ("progress-bar-striped");
  public static final ICSSClassProvider PT_0 = DefaultCSSClassProvider.create ("pt-0");
  public static final ICSSClassProvider PT_1 = DefaultCSSClassProvider.create ("pt-1");
  public static final ICSSClassProvider PT_2 = DefaultCSSClassProvider.create ("pt-2");
  public static final ICSSClassProvider PT_3 = DefaultCSSClassProvider.create ("pt-3");
  public static final ICSSClassProvider PT_4 = DefaultCSSClassProvider.create ("pt-4");
  public static final ICSSClassProvider PT_5 = DefaultCSSClassProvider.create ("pt-5");
  public static final ICSSClassProvider PT_LG_0 = DefaultCSSClassProvider.create ("pt-lg-0");
  public static final ICSSClassProvider PT_LG_1 = DefaultCSSClassProvider.create ("pt-lg-1");
  public static final ICSSClassProvider PT_LG_2 = DefaultCSSClassProvider.create ("pt-lg-2");
  public static final ICSSClassProvider PT_LG_3 = DefaultCSSClassProvider.create ("pt-lg-3");
  public static final ICSSClassProvider PT_LG_4 = DefaultCSSClassProvider.create ("pt-lg-4");
  public static final ICSSClassProvider PT_LG_5 = DefaultCSSClassProvider.create ("pt-lg-5");
  public static final ICSSClassProvider PT_MD_0 = DefaultCSSClassProvider.create ("pt-md-0");
  public static final ICSSClassProvider PT_MD_1 = DefaultCSSClassProvider.create ("pt-md-1");
  public static final ICSSClassProvider PT_MD_2 = DefaultCSSClassProvider.create ("pt-md-2");
  public static final ICSSClassProvider PT_MD_3 = DefaultCSSClassProvider.create ("pt-md-3");
  public static final ICSSClassProvider PT_MD_4 = DefaultCSSClassProvider.create ("pt-md-4");
  public static final ICSSClassProvider PT_MD_5 = DefaultCSSClassProvider.create ("pt-md-5");
  public static final ICSSClassProvider PT_SM_0 = DefaultCSSClassProvider.create ("pt-sm-0");
  public static final ICSSClassProvider PT_SM_1 = DefaultCSSClassProvider.create ("pt-sm-1");
  public static final ICSSClassProvider PT_SM_2 = DefaultCSSClassProvider.create ("pt-sm-2");
  public static final ICSSClassProvider PT_SM_3 = DefaultCSSClassProvider.create ("pt-sm-3");
  public static final ICSSClassProvider PT_SM_4 = DefaultCSSClassProvider.create ("pt-sm-4");
  public static final ICSSClassProvider PT_SM_5 = DefaultCSSClassProvider.create ("pt-sm-5");
  public static final ICSSClassProvider PT_XL_0 = DefaultCSSClassProvider.create ("pt-xl-0");
  public static final ICSSClassProvider PT_XL_1 = DefaultCSSClassProvider.create ("pt-xl-1");
  public static final ICSSClassProvider PT_XL_2 = DefaultCSSClassProvider.create ("pt-xl-2");
  public static final ICSSClassProvider PT_XL_3 = DefaultCSSClassProvider.create ("pt-xl-3");
  public static final ICSSClassProvider PT_XL_4 = DefaultCSSClassProvider.create ("pt-xl-4");
  public static final ICSSClassProvider PT_XL_5 = DefaultCSSClassProvider.create ("pt-xl-5");
  public static final ICSSClassProvider PX_0 = DefaultCSSClassProvider.create ("px-0");
  public static final ICSSClassProvider PX_1 = DefaultCSSClassProvider.create ("px-1");
  public static final ICSSClassProvider PX_2 = DefaultCSSClassProvider.create ("px-2");
  public static final ICSSClassProvider PX_3 = DefaultCSSClassProvider.create ("px-3");
  public static final ICSSClassProvider PX_4 = DefaultCSSClassProvider.create ("px-4");
  public static final ICSSClassProvider PX_5 = DefaultCSSClassProvider.create ("px-5");
  public static final ICSSClassProvider PX_LG_0 = DefaultCSSClassProvider.create ("px-lg-0");
  public static final ICSSClassProvider PX_LG_1 = DefaultCSSClassProvider.create ("px-lg-1");
  public static final ICSSClassProvider PX_LG_2 = DefaultCSSClassProvider.create ("px-lg-2");
  public static final ICSSClassProvider PX_LG_3 = DefaultCSSClassProvider.create ("px-lg-3");
  public static final ICSSClassProvider PX_LG_4 = DefaultCSSClassProvider.create ("px-lg-4");
  public static final ICSSClassProvider PX_LG_5 = DefaultCSSClassProvider.create ("px-lg-5");
  public static final ICSSClassProvider PX_MD_0 = DefaultCSSClassProvider.create ("px-md-0");
  public static final ICSSClassProvider PX_MD_1 = DefaultCSSClassProvider.create ("px-md-1");
  public static final ICSSClassProvider PX_MD_2 = DefaultCSSClassProvider.create ("px-md-2");
  public static final ICSSClassProvider PX_MD_3 = DefaultCSSClassProvider.create ("px-md-3");
  public static final ICSSClassProvider PX_MD_4 = DefaultCSSClassProvider.create ("px-md-4");
  public static final ICSSClassProvider PX_MD_5 = DefaultCSSClassProvider.create ("px-md-5");
  public static final ICSSClassProvider PX_SM_0 = DefaultCSSClassProvider.create ("px-sm-0");
  public static final ICSSClassProvider PX_SM_1 = DefaultCSSClassProvider.create ("px-sm-1");
  public static final ICSSClassProvider PX_SM_2 = DefaultCSSClassProvider.create ("px-sm-2");
  public static final ICSSClassProvider PX_SM_3 = DefaultCSSClassProvider.create ("px-sm-3");
  public static final ICSSClassProvider PX_SM_4 = DefaultCSSClassProvider.create ("px-sm-4");
  public static final ICSSClassProvider PX_SM_5 = DefaultCSSClassProvider.create ("px-sm-5");
  public static final ICSSClassProvider PX_XL_0 = DefaultCSSClassProvider.create ("px-xl-0");
  public static final ICSSClassProvider PX_XL_1 = DefaultCSSClassProvider.create ("px-xl-1");
  public static final ICSSClassProvider PX_XL_2 = DefaultCSSClassProvider.create ("px-xl-2");
  public static final ICSSClassProvider PX_XL_3 = DefaultCSSClassProvider.create ("px-xl-3");
  public static final ICSSClassProvider PX_XL_4 = DefaultCSSClassProvider.create ("px-xl-4");
  public static final ICSSClassProvider PX_XL_5 = DefaultCSSClassProvider.create ("px-xl-5");
  public static final ICSSClassProvider PY_0 = DefaultCSSClassProvider.create ("py-0");
  public static final ICSSClassProvider PY_1 = DefaultCSSClassProvider.create ("py-1");
  public static final ICSSClassProvider PY_2 = DefaultCSSClassProvider.create ("py-2");
  public static final ICSSClassProvider PY_3 = DefaultCSSClassProvider.create ("py-3");
  public static final ICSSClassProvider PY_4 = DefaultCSSClassProvider.create ("py-4");
  public static final ICSSClassProvider PY_5 = DefaultCSSClassProvider.create ("py-5");
  public static final ICSSClassProvider PY_LG_0 = DefaultCSSClassProvider.create ("py-lg-0");
  public static final ICSSClassProvider PY_LG_1 = DefaultCSSClassProvider.create ("py-lg-1");
  public static final ICSSClassProvider PY_LG_2 = DefaultCSSClassProvider.create ("py-lg-2");
  public static final ICSSClassProvider PY_LG_3 = DefaultCSSClassProvider.create ("py-lg-3");
  public static final ICSSClassProvider PY_LG_4 = DefaultCSSClassProvider.create ("py-lg-4");
  public static final ICSSClassProvider PY_LG_5 = DefaultCSSClassProvider.create ("py-lg-5");
  public static final ICSSClassProvider PY_MD_0 = DefaultCSSClassProvider.create ("py-md-0");
  public static final ICSSClassProvider PY_MD_1 = DefaultCSSClassProvider.create ("py-md-1");
  public static final ICSSClassProvider PY_MD_2 = DefaultCSSClassProvider.create ("py-md-2");
  public static final ICSSClassProvider PY_MD_3 = DefaultCSSClassProvider.create ("py-md-3");
  public static final ICSSClassProvider PY_MD_4 = DefaultCSSClassProvider.create ("py-md-4");
  public static final ICSSClassProvider PY_MD_5 = DefaultCSSClassProvider.create ("py-md-5");
  public static final ICSSClassProvider PY_SM_0 = DefaultCSSClassProvider.create ("py-sm-0");
  public static final ICSSClassProvider PY_SM_1 = DefaultCSSClassProvider.create ("py-sm-1");
  public static final ICSSClassProvider PY_SM_2 = DefaultCSSClassProvider.create ("py-sm-2");
  public static final ICSSClassProvider PY_SM_3 = DefaultCSSClassProvider.create ("py-sm-3");
  public static final ICSSClassProvider PY_SM_4 = DefaultCSSClassProvider.create ("py-sm-4");
  public static final ICSSClassProvider PY_SM_5 = DefaultCSSClassProvider.create ("py-sm-5");
  public static final ICSSClassProvider PY_XL_0 = DefaultCSSClassProvider.create ("py-xl-0");
  public static final ICSSClassProvider PY_XL_1 = DefaultCSSClassProvider.create ("py-xl-1");
  public static final ICSSClassProvider PY_XL_2 = DefaultCSSClassProvider.create ("py-xl-2");
  public static final ICSSClassProvider PY_XL_3 = DefaultCSSClassProvider.create ("py-xl-3");
  public static final ICSSClassProvider PY_XL_4 = DefaultCSSClassProvider.create ("py-xl-4");
  public static final ICSSClassProvider PY_XL_5 = DefaultCSSClassProvider.create ("py-xl-5");
  public static final ICSSClassProvider ROUNDED = DefaultCSSClassProvider.create ("rounded");
  public static final ICSSClassProvider ROUNDED_0 = DefaultCSSClassProvider.create ("rounded-0");
  public static final ICSSClassProvider ROUNDED_BOTTOM = DefaultCSSClassProvider.create ("rounded-bottom");
  public static final ICSSClassProvider ROUNDED_CIRCLE = DefaultCSSClassProvider.create ("rounded-circle");
  public static final ICSSClassProvider ROUNDED_LEFT = DefaultCSSClassProvider.create ("rounded-left");
  public static final ICSSClassProvider ROUNDED_LG = DefaultCSSClassProvider.create ("rounded-lg");
  public static final ICSSClassProvider ROUNDED_PILL = DefaultCSSClassProvider.create ("rounded-pill");
  public static final ICSSClassProvider ROUNDED_RIGHT = DefaultCSSClassProvider.create ("rounded-right");
  public static final ICSSClassProvider ROUNDED_SM = DefaultCSSClassProvider.create ("rounded-sm");
  public static final ICSSClassProvider ROUNDED_TOP = DefaultCSSClassProvider.create ("rounded-top");
  public static final ICSSClassProvider ROW = DefaultCSSClassProvider.create ("row");
  public static final ICSSClassProvider ROW_COLS_1 = DefaultCSSClassProvider.create ("row-cols-1");
  public static final ICSSClassProvider ROW_COLS_2 = DefaultCSSClassProvider.create ("row-cols-2");
  public static final ICSSClassProvider ROW_COLS_3 = DefaultCSSClassProvider.create ("row-cols-3");
  public static final ICSSClassProvider ROW_COLS_4 = DefaultCSSClassProvider.create ("row-cols-4");
  public static final ICSSClassProvider ROW_COLS_5 = DefaultCSSClassProvider.create ("row-cols-5");
  public static final ICSSClassProvider ROW_COLS_6 = DefaultCSSClassProvider.create ("row-cols-6");
  public static final ICSSClassProvider ROW_COLS_LG_1 = DefaultCSSClassProvider.create ("row-cols-lg-1");
  public static final ICSSClassProvider ROW_COLS_LG_2 = DefaultCSSClassProvider.create ("row-cols-lg-2");
  public static final ICSSClassProvider ROW_COLS_LG_3 = DefaultCSSClassProvider.create ("row-cols-lg-3");
  public static final ICSSClassProvider ROW_COLS_LG_4 = DefaultCSSClassProvider.create ("row-cols-lg-4");
  public static final ICSSClassProvider ROW_COLS_LG_5 = DefaultCSSClassProvider.create ("row-cols-lg-5");
  public static final ICSSClassProvider ROW_COLS_LG_6 = DefaultCSSClassProvider.create ("row-cols-lg-6");
  public static final ICSSClassProvider ROW_COLS_MD_1 = DefaultCSSClassProvider.create ("row-cols-md-1");
  public static final ICSSClassProvider ROW_COLS_MD_2 = DefaultCSSClassProvider.create ("row-cols-md-2");
  public static final ICSSClassProvider ROW_COLS_MD_3 = DefaultCSSClassProvider.create ("row-cols-md-3");
  public static final ICSSClassProvider ROW_COLS_MD_4 = DefaultCSSClassProvider.create ("row-cols-md-4");
  public static final ICSSClassProvider ROW_COLS_MD_5 = DefaultCSSClassProvider.create ("row-cols-md-5");
  public static final ICSSClassProvider ROW_COLS_MD_6 = DefaultCSSClassProvider.create ("row-cols-md-6");
  public static final ICSSClassProvider ROW_COLS_SM_1 = DefaultCSSClassProvider.create ("row-cols-sm-1");
  public static final ICSSClassProvider ROW_COLS_SM_2 = DefaultCSSClassProvider.create ("row-cols-sm-2");
  public static final ICSSClassProvider ROW_COLS_SM_3 = DefaultCSSClassProvider.create ("row-cols-sm-3");
  public static final ICSSClassProvider ROW_COLS_SM_4 = DefaultCSSClassProvider.create ("row-cols-sm-4");
  public static final ICSSClassProvider ROW_COLS_SM_5 = DefaultCSSClassProvider.create ("row-cols-sm-5");
  public static final ICSSClassProvider ROW_COLS_SM_6 = DefaultCSSClassProvider.create ("row-cols-sm-6");
  public static final ICSSClassProvider ROW_COLS_XL_1 = DefaultCSSClassProvider.create ("row-cols-xl-1");
  public static final ICSSClassProvider ROW_COLS_XL_2 = DefaultCSSClassProvider.create ("row-cols-xl-2");
  public static final ICSSClassProvider ROW_COLS_XL_3 = DefaultCSSClassProvider.create ("row-cols-xl-3");
  public static final ICSSClassProvider ROW_COLS_XL_4 = DefaultCSSClassProvider.create ("row-cols-xl-4");
  public static final ICSSClassProvider ROW_COLS_XL_5 = DefaultCSSClassProvider.create ("row-cols-xl-5");
  public static final ICSSClassProvider ROW_COLS_XL_6 = DefaultCSSClassProvider.create ("row-cols-xl-6");
  public static final ICSSClassProvider SHADOW = DefaultCSSClassProvider.create ("shadow");
  public static final ICSSClassProvider SHADOW_LG = DefaultCSSClassProvider.create ("shadow-lg");
  public static final ICSSClassProvider SHADOW_NONE = DefaultCSSClassProvider.create ("shadow-none");
  public static final ICSSClassProvider SHADOW_SM = DefaultCSSClassProvider.create ("shadow-sm");
  public static final ICSSClassProvider SHOW = DefaultCSSClassProvider.create ("show");
  public static final ICSSClassProvider SHOWING = DefaultCSSClassProvider.create ("showing");
  public static final ICSSClassProvider SMALL = DefaultCSSClassProvider.create ("small");
  public static final ICSSClassProvider SPINNER_BORDER = DefaultCSSClassProvider.create ("spinner-border");
  public static final ICSSClassProvider SPINNER_BORDER_SM = DefaultCSSClassProvider.create ("spinner-border-sm");
  public static final ICSSClassProvider SPINNER_GROW = DefaultCSSClassProvider.create ("spinner-grow");
  public static final ICSSClassProvider SPINNER_GROW_SM = DefaultCSSClassProvider.create ("spinner-grow-sm");
  public static final ICSSClassProvider SR_ONLY = DefaultCSSClassProvider.create ("sr-only");
  public static final ICSSClassProvider SR_ONLY_FOCUSABLE = DefaultCSSClassProvider.create ("sr-only-focusable");
  public static final ICSSClassProvider STICKY_TOP = DefaultCSSClassProvider.create ("sticky-top");
  public static final ICSSClassProvider STRETCHED_LINK = DefaultCSSClassProvider.create ("stretched-link");
  public static final ICSSClassProvider TAB_CONTENT = DefaultCSSClassProvider.create ("tab-content");
  public static final ICSSClassProvider TAB_PANE = DefaultCSSClassProvider.create ("tab-pane");
  public static final ICSSClassProvider TABLE = DefaultCSSClassProvider.create ("table");
  public static final ICSSClassProvider TABLE_ACTIVE = DefaultCSSClassProvider.create ("table-active");
  public static final ICSSClassProvider TABLE_BORDERED = DefaultCSSClassProvider.create ("table-bordered");
  public static final ICSSClassProvider TABLE_BORDERLESS = DefaultCSSClassProvider.create ("table-borderless");
  public static final ICSSClassProvider TABLE_DANGER = DefaultCSSClassProvider.create ("table-danger");
  public static final ICSSClassProvider TABLE_DARK = DefaultCSSClassProvider.create ("table-dark");
  public static final ICSSClassProvider TABLE_HOVER = DefaultCSSClassProvider.create ("table-hover");
  public static final ICSSClassProvider TABLE_INFO = DefaultCSSClassProvider.create ("table-info");
  public static final ICSSClassProvider TABLE_LIGHT = DefaultCSSClassProvider.create ("table-light");
  public static final ICSSClassProvider TABLE_PRIMARY = DefaultCSSClassProvider.create ("table-primary");
  public static final ICSSClassProvider TABLE_RESPONSIVE = DefaultCSSClassProvider.create ("table-responsive");
  public static final ICSSClassProvider TABLE_RESPONSIVE_LG = DefaultCSSClassProvider.create ("table-responsive-lg");
  public static final ICSSClassProvider TABLE_RESPONSIVE_MD = DefaultCSSClassProvider.create ("table-responsive-md");
  public static final ICSSClassProvider TABLE_RESPONSIVE_SM = DefaultCSSClassProvider.create ("table-responsive-sm");
  public static final ICSSClassProvider TABLE_RESPONSIVE_XL = DefaultCSSClassProvider.create ("table-responsive-xl");
  public static final ICSSClassProvider TABLE_SECONDARY = DefaultCSSClassProvider.create ("table-secondary");
  public static final ICSSClassProvider TABLE_SM = DefaultCSSClassProvider.create ("table-sm");
  public static final ICSSClassProvider TABLE_STRIPED = DefaultCSSClassProvider.create ("table-striped");
  public static final ICSSClassProvider TABLE_SUCCESS = DefaultCSSClassProvider.create ("table-success");
  public static final ICSSClassProvider TABLE_WARNING = DefaultCSSClassProvider.create ("table-warning");
  public static final ICSSClassProvider TEXT_BLACK_50 = DefaultCSSClassProvider.create ("text-black-50");
  public static final ICSSClassProvider TEXT_BODY = DefaultCSSClassProvider.create ("text-body");
  public static final ICSSClassProvider TEXT_BREAK = DefaultCSSClassProvider.create ("text-break");
  public static final ICSSClassProvider TEXT_CAPITALIZE = DefaultCSSClassProvider.create ("text-capitalize");
  public static final ICSSClassProvider TEXT_CENTER = DefaultCSSClassProvider.create ("text-center");
  public static final ICSSClassProvider TEXT_DANGER = DefaultCSSClassProvider.create ("text-danger");
  public static final ICSSClassProvider TEXT_DARK = DefaultCSSClassProvider.create ("text-dark");
  public static final ICSSClassProvider TEXT_DECORATION_NONE = DefaultCSSClassProvider.create ("text-decoration-none");
  public static final ICSSClassProvider TEXT_HIDE = DefaultCSSClassProvider.create ("text-hide");
  public static final ICSSClassProvider TEXT_INFO = DefaultCSSClassProvider.create ("text-info");
  public static final ICSSClassProvider TEXT_JUSTIFY = DefaultCSSClassProvider.create ("text-justify");
  public static final ICSSClassProvider TEXT_LEFT = DefaultCSSClassProvider.create ("text-left");
  public static final ICSSClassProvider TEXT_LG_CENTER = DefaultCSSClassProvider.create ("text-lg-center");
  public static final ICSSClassProvider TEXT_LG_LEFT = DefaultCSSClassProvider.create ("text-lg-left");
  public static final ICSSClassProvider TEXT_LG_RIGHT = DefaultCSSClassProvider.create ("text-lg-right");
  public static final ICSSClassProvider TEXT_LIGHT = DefaultCSSClassProvider.create ("text-light");
  public static final ICSSClassProvider TEXT_LOWERCASE = DefaultCSSClassProvider.create ("text-lowercase");
  public static final ICSSClassProvider TEXT_MD_CENTER = DefaultCSSClassProvider.create ("text-md-center");
  public static final ICSSClassProvider TEXT_MD_LEFT = DefaultCSSClassProvider.create ("text-md-left");
  public static final ICSSClassProvider TEXT_MD_RIGHT = DefaultCSSClassProvider.create ("text-md-right");
  public static final ICSSClassProvider TEXT_MONOSPACE = DefaultCSSClassProvider.create ("text-monospace");
  public static final ICSSClassProvider TEXT_MUTED = DefaultCSSClassProvider.create ("text-muted");
  public static final ICSSClassProvider TEXT_NOWRAP = DefaultCSSClassProvider.create ("text-nowrap");
  public static final ICSSClassProvider TEXT_PRIMARY = DefaultCSSClassProvider.create ("text-primary");
  public static final ICSSClassProvider TEXT_RESET = DefaultCSSClassProvider.create ("text-reset");
  public static final ICSSClassProvider TEXT_RIGHT = DefaultCSSClassProvider.create ("text-right");
  public static final ICSSClassProvider TEXT_SECONDARY = DefaultCSSClassProvider.create ("text-secondary");
  public static final ICSSClassProvider TEXT_SM_CENTER = DefaultCSSClassProvider.create ("text-sm-center");
  public static final ICSSClassProvider TEXT_SM_LEFT = DefaultCSSClassProvider.create ("text-sm-left");
  public static final ICSSClassProvider TEXT_SM_RIGHT = DefaultCSSClassProvider.create ("text-sm-right");
  public static final ICSSClassProvider TEXT_SUCCESS = DefaultCSSClassProvider.create ("text-success");
  public static final ICSSClassProvider TEXT_TRUNCATE = DefaultCSSClassProvider.create ("text-truncate");
  public static final ICSSClassProvider TEXT_UPPERCASE = DefaultCSSClassProvider.create ("text-uppercase");
  public static final ICSSClassProvider TEXT_WARNING = DefaultCSSClassProvider.create ("text-warning");
  public static final ICSSClassProvider TEXT_WHITE = DefaultCSSClassProvider.create ("text-white");
  public static final ICSSClassProvider TEXT_WHITE_50 = DefaultCSSClassProvider.create ("text-white-50");
  public static final ICSSClassProvider TEXT_WRAP = DefaultCSSClassProvider.create ("text-wrap");
  public static final ICSSClassProvider TEXT_XL_CENTER = DefaultCSSClassProvider.create ("text-xl-center");
  public static final ICSSClassProvider TEXT_XL_LEFT = DefaultCSSClassProvider.create ("text-xl-left");
  public static final ICSSClassProvider TEXT_XL_RIGHT = DefaultCSSClassProvider.create ("text-xl-right");
  public static final ICSSClassProvider THEAD_DARK = DefaultCSSClassProvider.create ("thead-dark");
  public static final ICSSClassProvider THEAD_LIGHT = DefaultCSSClassProvider.create ("thead-light");
  public static final ICSSClassProvider TOAST = DefaultCSSClassProvider.create ("toast");
  public static final ICSSClassProvider TOAST_BODY = DefaultCSSClassProvider.create ("toast-body");
  public static final ICSSClassProvider TOAST_HEADER = DefaultCSSClassProvider.create ("toast-header");
  public static final ICSSClassProvider TOOLTIP = DefaultCSSClassProvider.create ("tooltip");
  public static final ICSSClassProvider TOOLTIP_INNER = DefaultCSSClassProvider.create ("tooltip-inner");
  public static final ICSSClassProvider USER_SELECT_ALL = DefaultCSSClassProvider.create ("user-select-all");
  public static final ICSSClassProvider USER_SELECT_AUTO = DefaultCSSClassProvider.create ("user-select-auto");
  public static final ICSSClassProvider USER_SELECT_NONE = DefaultCSSClassProvider.create ("user-select-none");
  public static final ICSSClassProvider VALID_FEEDBACK = DefaultCSSClassProvider.create ("valid-feedback");
  public static final ICSSClassProvider VALID_TOOLTIP = DefaultCSSClassProvider.create ("valid-tooltip");
  public static final ICSSClassProvider VH_100 = DefaultCSSClassProvider.create ("vh-100");
  public static final ICSSClassProvider VISIBLE = DefaultCSSClassProvider.create ("visible");
  public static final ICSSClassProvider VW_100 = DefaultCSSClassProvider.create ("vw-100");
  public static final ICSSClassProvider W_100 = DefaultCSSClassProvider.create ("w-100");
  public static final ICSSClassProvider W_25 = DefaultCSSClassProvider.create ("w-25");
  public static final ICSSClassProvider W_50 = DefaultCSSClassProvider.create ("w-50");
  public static final ICSSClassProvider W_75 = DefaultCSSClassProvider.create ("w-75");
  public static final ICSSClassProvider W_AUTO = DefaultCSSClassProvider.create ("w-auto");
  public static final ICSSClassProvider WAS_VALIDATED = DefaultCSSClassProvider.create ("was-validated");

  private CBootstrapCSS ()
  {}

  // Requires Bootstrap customization to be enabled:
  public static final ICSSClassProvider BG_GRADIENT_DANGER = DefaultCSSClassProvider.create ("bg-gradient-danger");
  public static final ICSSClassProvider BG_GRADIENT_DARK = DefaultCSSClassProvider.create ("bg-gradient-dark");
  public static final ICSSClassProvider BG_GRADIENT_INFO = DefaultCSSClassProvider.create ("bg-gradient-info");
  public static final ICSSClassProvider BG_GRADIENT_LIGHT = DefaultCSSClassProvider.create ("bg-gradient-light");
  public static final ICSSClassProvider BG_GRADIENT_PRIMARY = DefaultCSSClassProvider.create ("bg-gradient-primary");
  public static final ICSSClassProvider BG_GRADIENT_SECONDARY = DefaultCSSClassProvider.create ("bg-gradient-secondary");
  public static final ICSSClassProvider BG_GRADIENT_SUCCESS = DefaultCSSClassProvider.create ("bg-gradient-success");
  public static final ICSSClassProvider BG_GRADIENT_WARNING = DefaultCSSClassProvider.create ("bg-gradient-warning");
}
