/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.bootstrap4.EBootstrapCSSPathProvider;
import com.helger.photon.bootstrap4.EBootstrapJSPathProvider;
import com.helger.photon.uicore.EUICoreJSPathProvider;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BootstrapCustomConfig {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static ICommonsList<ICSSPathProvider> s_aCSS = new CommonsArrayList();
    private static ICommonsList<IJSPathProvider> s_aJS = new CommonsArrayList();

    private BootstrapCustomConfig() {
    }

    public static void setBootstrapCSS(ICSSPathProvider ... iCSSPathProviderArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iCSSPathProviderArray, (String)"CSSPathProvider");
        s_aRWLock.writeLocked(() -> {
            s_aCSS.clear();
            for (ICSSPathProvider iCSSPathProvider : iCSSPathProviderArray) {
                s_aCSS.add((Object)iCSSPathProvider);
            }
        });
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<ICSSPathProvider> getAllBootstrapCSS() {
        return (ICommonsList)s_aRWLock.readLockedGet(() -> s_aCSS.getClone());
    }

    public static void setBootstrapJS(IJSPathProvider ... iJSPathProviderArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iJSPathProviderArray, (String)"JSPathProvider");
        s_aRWLock.writeLocked(() -> {
            s_aJS.clear();
            for (IJSPathProvider iJSPathProvider : iJSPathProviderArray) {
                s_aJS.add((Object)iJSPathProvider);
            }
        });
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<IJSPathProvider> getAllBootstrapJS() {
        return (ICommonsList)s_aRWLock.readLockedGet(() -> s_aJS.getClone());
    }

    static {
        s_aCSS.add((Object)EBootstrapCSSPathProvider.BOOTSTRAP);
        s_aCSS.add((Object)EBootstrapCSSPathProvider.BOOTSTRAP_PH);
        s_aJS.add((Object)EUICoreJSPathProvider.POPPER);
        s_aJS.add((Object)EBootstrapJSPathProvider.BOOTSTRAP);
        s_aJS.add((Object)EBootstrapJSPathProvider.BOOTSTRAP_PH);
    }
}

