/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.alert;

import com.helger.commons.ValueEnforcer;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.textlevel.HCA;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.alert.EBootstrapAlertType;
import com.helger.photon.bootstrap4.base.AbstractBootstrapDiv;
import com.helger.photon.bootstrap4.utils.BootstrapCloseIcon;
import javax.annotation.Nonnull;

public abstract class AbstractBootstrapAlert<IMPLTYPE extends AbstractBootstrapAlert<IMPLTYPE>>
extends AbstractBootstrapDiv<IMPLTYPE> {
    public static final String JS_EVENT_CLOSE = "close.bs.alert";
    public static final String JS_EVENT_CLOSED = "closed.bs.alert";
    public static final boolean DEFAULT_SHOW_CLOSE = false;
    private EBootstrapAlertType m_eType;
    private boolean m_bShowClose = false;

    public AbstractBootstrapAlert(@Nonnull EBootstrapAlertType eBootstrapAlertType) {
        this.setType(eBootstrapAlertType);
    }

    @Nonnull
    public final EBootstrapAlertType getType() {
        return this.m_eType;
    }

    @Nonnull
    public final IMPLTYPE setType(@Nonnull EBootstrapAlertType eBootstrapAlertType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapAlertType), (String)"Type");
        this.m_eType = eBootstrapAlertType;
        return (IMPLTYPE)((Object)((AbstractBootstrapAlert)this.thisAsT()));
    }

    @Nonnull
    public final IMPLTYPE setTypeIfWorse(@Nonnull EBootstrapAlertType eBootstrapAlertType) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapAlertType), (String)"Type");
        if (this.m_eType == null || eBootstrapAlertType.ordinal() > this.m_eType.ordinal()) {
            this.m_eType = eBootstrapAlertType;
        }
        return (IMPLTYPE)((Object)((AbstractBootstrapAlert)this.thisAsT()));
    }

    public final boolean isShowClose() {
        return this.m_bShowClose;
    }

    @Nonnull
    public final IMPLTYPE setShowClose(boolean bl) {
        this.m_bShowClose = bl;
        return (IMPLTYPE)((Object)((AbstractBootstrapAlert)this.thisAsT()));
    }

    public boolean canConvertToMicroNode(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode) {
        if (this.hasNoChildren()) {
            return false;
        }
        return super.canConvertToMicroNode(iHCConversionSettingsToNode);
    }

    @Override
    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClasses(new ICSSClassProvider[]{CBootstrapCSS.ALERT, this.m_eType});
        if (this.m_bShowClose) {
            this.addClass(CBootstrapCSS.ALERT_DISMISSIBLE);
            BootstrapCloseIcon bootstrapCloseIcon = new BootstrapCloseIcon();
            bootstrapCloseIcon.customAttrs().setDataAttr("dismiss", "alert");
            this.addChild((IHCNode)bootstrapCloseIcon);
        }
    }

    @Nonnull
    public static HCA createAlertLink() {
        HCA hCA = (HCA)new HCA().addClass(CBootstrapCSS.ALERT_LINK);
        return hCA;
    }
}

