/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.ext;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.ext.HCExtHelper;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.photon.bootstrap4.alert.AbstractBootstrapAlert;
import com.helger.photon.bootstrap4.alert.EBootstrapAlertType;
import com.helger.photon.core.mgr.PhotonBasicManager;
import com.helger.photon.core.systemmsg.ESystemMessageType;
import com.helger.photon.core.systemmsg.ISystemMessageRenderer;
import com.helger.photon.core.systemmsg.SystemMessageManager;
import com.helger.photon.uicore.UITextFormatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class BootstrapSystemMessage
extends AbstractBootstrapAlert<BootstrapSystemMessage> {
    public static final ISystemMessageRenderer FORMATTER_DEFAULT = (string, iHCElementWithChildren) -> {
        IHCElementWithChildren cfr_ignored_0 = (IHCElementWithChildren)iHCElementWithChildren.addChildren((Iterable)HCExtHelper.nl2divList((String)string));
    };
    public static final ISystemMessageRenderer FORMATTER_MARKDOWN = (string, iHCElementWithChildren) -> {
        IHCElementWithChildren cfr_ignored_0 = (IHCElementWithChildren)iHCElementWithChildren.addChild(UITextFormatter.markdown((String)string));
    };
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ISystemMessageRenderer s_aFormatter = FORMATTER_DEFAULT;

    @Nonnull
    public static ISystemMessageRenderer getDefaultFormatter() {
        return (ISystemMessageRenderer)s_aRWLock.readLockedGet(() -> s_aFormatter);
    }

    public static void setDefaultFormatter(@Nonnull ISystemMessageRenderer iSystemMessageRenderer) {
        ValueEnforcer.notNull((Object)iSystemMessageRenderer, (String)"Formatter");
        s_aRWLock.writeLockedGet(() -> {
            s_aFormatter = iSystemMessageRenderer;
            return s_aFormatter;
        });
    }

    public static boolean isDefaultMarkdown() {
        return EqualsHelper.identityEqual((Object)BootstrapSystemMessage.getDefaultFormatter(), (Object)FORMATTER_MARKDOWN);
    }

    public static void setDefaultUseMarkdown(boolean bl) {
        BootstrapSystemMessage.setDefaultFormatter(bl ? FORMATTER_MARKDOWN : FORMATTER_DEFAULT);
    }

    @Nonnull
    public static EBootstrapAlertType getAlertType(@Nonnull ESystemMessageType eSystemMessageType) {
        switch (eSystemMessageType) {
            case INFO: {
                return EBootstrapAlertType.INFO;
            }
            case WARNING: {
                return EBootstrapAlertType.WARNING;
            }
            case ERROR: {
                return EBootstrapAlertType.DANGER;
            }
            case SUCCESS: {
                return EBootstrapAlertType.SUCCESS;
            }
        }
        throw new IllegalArgumentException("Illegal message type: " + eSystemMessageType);
    }

    protected BootstrapSystemMessage(@Nonnull ESystemMessageType eSystemMessageType) {
        super(BootstrapSystemMessage.getAlertType(eSystemMessageType));
    }

    @Nonnull
    public BootstrapSystemMessage setSystemMessage(@Nullable String string) {
        this.removeAllChildren();
        if (StringHelper.hasText((String)string)) {
            BootstrapSystemMessage.getDefaultFormatter().renderSystemMessage(string, (IHCElementWithChildren)this);
        }
        return this;
    }

    @Nullable
    public static BootstrapSystemMessage createDefault() {
        SystemMessageManager systemMessageManager = PhotonBasicManager.getSystemMessageMgr();
        return BootstrapSystemMessage.create(systemMessageManager.getMessageType(), systemMessageManager.getSystemMessage());
    }

    @Nullable
    public static BootstrapSystemMessage create(@Nonnull ESystemMessageType eSystemMessageType, @Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return new BootstrapSystemMessage(eSystemMessageType).setSystemMessage(string);
    }
}

