/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.form;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.string.StringHelper;
import com.helger.html.css.DefaultCSSClassProvider;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.HCCtrlHelper;
import com.helger.html.hc.html.forms.IHCControl;
import com.helger.html.hc.html.forms.IHCInput;
import com.helger.html.hc.html.textlevel.HCSmall;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.form.BootstrapInvalidFeedback;
import com.helger.photon.uicore.html.formlabel.HCFormLabel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class BootstrapFormHelper {
    public static final ICSSClassProvider CSS_CLASS_FORM_GROUP_ERROR_TEXT = DefaultCSSClassProvider.create((String)"form-group-error-text");
    public static final ICSSClassProvider CSS_CLASS_FORM_GROUP_HELP_TEXT = DefaultCSSClassProvider.create((String)"form-group-help-text");
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapFormHelper.class);
    private static final BootstrapFormHelper s_aInstance = new BootstrapFormHelper();

    private BootstrapFormHelper() {
    }

    public static void markAsFormControl(@Nullable IHCNode iHCNode) {
        if (iHCNode instanceof IHCControl) {
            IHCControl iHCControl = (IHCControl)iHCNode;
            ICSSClassProvider iCSSClassProvider = CBootstrapCSS.FORM_CONTROL;
            if (iHCControl instanceof IHCInput) {
                IHCInput iHCInput = (IHCInput)iHCControl;
                EHCInputType eHCInputType = iHCInput.getType();
                switch (eHCInputType) {
                    case CHECKBOX: 
                    case RADIO: {
                        iCSSClassProvider = CBootstrapCSS.FORM_CHECK_INPUT;
                        break;
                    }
                    case FILE: {
                        iCSSClassProvider = CBootstrapCSS.FORM_CONTROL_FILE;
                        break;
                    }
                    case HIDDEN: {
                        iCSSClassProvider = null;
                    }
                }
            }
            if (iCSSClassProvider != null) {
                iHCControl.addClass(iCSSClassProvider);
            }
        }
    }

    public static void markAsFormControls(@Nullable Iterable<? extends IHCNode> iterable) {
        if (iterable != null) {
            for (IHCNode iHCNode : iterable) {
                BootstrapFormHelper.markAsFormControl(iHCNode);
            }
        }
    }

    public static void markChildrenAsFormControls(@Nullable IHCNode iHCNode2) {
        if (iHCNode2 != null) {
            iHCNode2.forAllChildren(iHCNode -> BootstrapFormHelper.markAsFormControls((Iterable<? extends IHCNode>)HCCtrlHelper.getAllHCControls((IHCNode)iHCNode)));
        }
    }

    public static void connectFormControlWithLabel(@Nullable IHCElement<?> iHCElement, @Nullable HCFormLabel hCFormLabel) {
        if (iHCElement != null && hCFormLabel != null) {
            hCFormLabel.setFor(iHCElement);
            iHCElement.customAttrs().setAriaLabeledBy((IHCElement)hCFormLabel);
        }
    }

    public static void connectFormControlsWithLabel(@Nullable Iterable<? extends IHCElement<?>> iterable, @Nullable HCFormLabel hCFormLabel) {
        if (iterable != null && hCFormLabel != null) {
            boolean bl = false;
            for (IHCElement<?> iHCElement : iterable) {
                if (!bl) {
                    hCFormLabel.setFor(iHCElement);
                    bl = true;
                }
                iHCElement.customAttrs().setAriaLabeledBy((IHCElement)hCFormLabel);
            }
        }
    }

    public static void applyFormControlValidityState(@Nullable IHCElement<?> iHCElement, @Nullable IErrorList iErrorList) {
        ValueEnforcer.notNull(iHCElement, (String)"Element");
        if (iErrorList != null && iErrorList.containsAtLeastOneError()) {
            iHCElement.addClass(CBootstrapCSS.IS_INVALID);
        }
    }

    public static void applyFormControlValidityState(@Nullable Iterable<? extends IHCElement<?>> iterable, @Nullable IErrorList iErrorList) {
        if (iterable != null && iErrorList != null) {
            boolean bl = iErrorList.containsAtLeastOneError();
            for (IHCElement<?> iHCElement : iterable) {
                if (!bl) continue;
                iHCElement.addClass(CBootstrapCSS.IS_INVALID);
            }
        }
    }

    @Nonnull
    public static BootstrapInvalidFeedback createDefaultErrorNode(@Nonnull IError iError, @Nonnull Locale locale) {
        return BootstrapFormHelper.createDefaultErrorNode(iError, locale, false);
    }

    @Nonnull
    public static BootstrapInvalidFeedback createDefaultErrorNode(@Nonnull IError iError, @Nonnull Locale locale, boolean bl) {
        Object object;
        String string = "";
        if (bl && StringHelper.hasText((String)(object = iError.getErrorLocation().getAsString()))) {
            string = string + object + " ";
        }
        if (StringHelper.hasText((String)(object = iError.getErrorID()))) {
            string = string + "[" + object + "] ";
        }
        if (StringHelper.hasNoText((String)(object = StringHelper.getNotNull((String)iError.getErrorText(locale))))) {
            LOGGER.warn("Error " + iError + " has no text in locale " + locale);
        } else {
            string = string + object;
        }
        object = (BootstrapInvalidFeedback)new BootstrapInvalidFeedback().addClass(CSS_CLASS_FORM_GROUP_ERROR_TEXT);
        object.addChild(string);
        return object;
    }

    @Nonnull
    public static HCNodeList createDefaultErrorNode(@Nullable IErrorList iErrorList, @Nonnull Locale locale) {
        return BootstrapFormHelper.createDefaultErrorNode(iErrorList, locale, false);
    }

    @Nonnull
    public static HCNodeList createDefaultErrorNode(@Nullable IErrorList iErrorList, @Nonnull Locale locale, boolean bl) {
        HCNodeList hCNodeList = new HCNodeList();
        if (iErrorList != null) {
            for (IError iError : iErrorList) {
                hCNodeList.addChild((IHCNode)BootstrapFormHelper.createDefaultErrorNode(iError, locale, bl));
            }
        }
        return hCNodeList;
    }

    @Nullable
    public static IHCElementWithChildren<?> createDefaultHelpTextNode(@Nullable String string) {
        return BootstrapFormHelper.createDefaultHelpTextNode((IHCNode)HCTextNode.createOnDemand((String)string));
    }

    @Nullable
    public static IHCElementWithChildren<?> createDefaultHelpTextNode(@Nullable IHCNode iHCNode) {
        if (iHCNode == null) {
            return null;
        }
        HCSmall hCSmall = new HCSmall();
        hCSmall.addClass(CBootstrapCSS.FORM_TEXT);
        hCSmall.addClass(CBootstrapCSS.TEXT_MUTED);
        hCSmall.addClass(CSS_CLASS_FORM_GROUP_HELP_TEXT);
        hCSmall.addChild(iHCNode);
        return hCSmall;
    }

    @Nonnull
    public static String getDefaultPlaceholderText(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren) {
        if (iHCElementWithChildren instanceof HCFormLabel) {
            return iHCElementWithChildren.getPlainText();
        }
        String string = StringHelper.trimEnd((String)iHCElementWithChildren.getPlainText(), (String)":");
        string = StringHelper.trimEnd((String)string, (String)"\u00b0");
        string = StringHelper.trimEnd((String)string, (String)"*");
        return string;
    }

    @Nonnull
    public static HCNodeList createStandaloneFormCtrl(@Nullable IHCNode iHCNode, @Nullable IErrorList iErrorList, @Nonnull Locale locale) {
        BootstrapFormHelper.markAsFormControl(iHCNode);
        if (iHCNode instanceof IHCElement) {
            BootstrapFormHelper.applyFormControlValidityState((IHCElement)iHCNode, iErrorList);
        }
        return (HCNodeList)((HCNodeList)new HCNodeList().addChild(iHCNode)).addChild((IHCNode)BootstrapFormHelper.createDefaultErrorNode(iErrorList, locale));
    }
}

