/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.form;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.IErrorList;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.IHCElement;
import com.helger.html.hc.html.IHCElementWithChildren;
import com.helger.html.hc.html.forms.AbstractHCCheckBox;
import com.helger.html.hc.html.forms.AbstractHCRadioButton;
import com.helger.html.hc.html.forms.EHCInputType;
import com.helger.html.hc.html.forms.HCCtrlHelper;
import com.helger.html.hc.html.forms.IHCControl;
import com.helger.html.hc.html.forms.IHCInput;
import com.helger.html.hc.html.forms.IHCTextArea;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.form.BootstrapFormGroup;
import com.helger.photon.bootstrap4.form.BootstrapFormHelper;
import com.helger.photon.bootstrap4.form.IBootstrapFormGroupContainer;
import com.helger.photon.bootstrap4.form.IBootstrapFormGroupRenderer;
import com.helger.photon.bootstrap4.grid.BootstrapRow;
import com.helger.photon.uicore.html.formlabel.HCFormLabel;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DefaultBootstrapFormGroupRenderer
implements IBootstrapFormGroupRenderer {
    private boolean m_bUseIcons = false;
    private boolean m_bForceNoCheckBoxHandling = false;

    @Override
    public boolean isUseIcons() {
        return this.m_bUseIcons;
    }

    @Override
    @Nonnull
    public DefaultBootstrapFormGroupRenderer setUseIcons(boolean bl) {
        this.m_bUseIcons = bl;
        return this;
    }

    public boolean isForceNoCheckBoxHandling() {
        return this.m_bForceNoCheckBoxHandling;
    }

    @Nonnull
    public DefaultBootstrapFormGroupRenderer setForceNoCheckBoxHandling(boolean bl) {
        this.m_bForceNoCheckBoxHandling = bl;
        return this;
    }

    @OverrideOnDemand
    protected void modifyFirstControlIfLabelIsPresent(@Nonnull IHCElementWithChildren<?> iHCElementWithChildren, @Nonnull IHCControl<?> iHCControl) {
        IHCTextArea iHCTextArea;
        if (iHCControl instanceof IHCInput) {
            IHCInput iHCInput = (IHCInput)iHCControl;
            EHCInputType eHCInputType = iHCInput.getType();
            if (eHCInputType != null && eHCInputType.hasPlaceholder() && !iHCInput.hasPlaceholder()) {
                iHCInput.setPlaceholder(BootstrapFormHelper.getDefaultPlaceholderText(iHCElementWithChildren));
            }
        } else if (iHCControl instanceof IHCTextArea && !(iHCTextArea = (IHCTextArea)iHCControl).hasPlaceholder()) {
            iHCTextArea.setPlaceholder(BootstrapFormHelper.getDefaultPlaceholderText(iHCElementWithChildren));
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IHCElementWithChildren<?> createHelpTextNode(@Nonnull IHCNode iHCNode) {
        return BootstrapFormHelper.createDefaultHelpTextNode(iHCNode);
    }

    @Nullable
    @OverrideOnDemand
    protected IHCElement<?> createSingleErrorNode(@Nonnull IError iError, @Nonnull Locale locale) {
        return BootstrapFormHelper.createDefaultErrorNode(iError, locale);
    }

    @OverrideOnDemand
    protected void modifyFinalNode(@Nonnull IBootstrapFormGroupContainer<?> iBootstrapFormGroupContainer, @Nonnull BootstrapFormGroup bootstrapFormGroup, @Nonnull AbstractHCDiv<?> abstractHCDiv) {
    }

    @Nonnull
    public AbstractHCDiv<?> renderFormGroup(@Nonnull IBootstrapFormGroupContainer<?> iBootstrapFormGroupContainer, @Nonnull BootstrapFormGroup bootstrapFormGroup, @Nonnull Locale locale) {
        boolean bl;
        boolean bl2;
        IError iError2;
        IHCControl iHCControl;
        HCFormLabel hCFormLabel = bootstrapFormGroup.getLabel();
        IHCNode iHCNode = bootstrapFormGroup.getCtrl();
        IHCNode iHCNode2 = bootstrapFormGroup.getHelpText();
        IErrorList iErrorList = bootstrapFormGroup.getErrorList();
        boolean bl3 = iBootstrapFormGroupContainer.getFormType().isInline();
        ICommonsList iCommonsList = HCCtrlHelper.getAllHCControls((IHCNode)iHCNode);
        if (iCommonsList.isNotEmpty()) {
            iHCControl = (IHCControl)iCommonsList.getFirst();
            BootstrapFormHelper.markAsFormControls((Iterable<? extends IHCNode>)iCommonsList);
            BootstrapFormHelper.connectFormControlsWithLabel(iCommonsList, hCFormLabel);
            BootstrapFormHelper.applyFormControlValidityState(iCommonsList, iErrorList);
        } else {
            iHCControl = null;
        }
        HCNodeList hCNodeList = new HCNodeList();
        if (iErrorList != null && iErrorList.isNotEmpty()) {
            for (IError iError2 : iErrorList) {
                IHCElement<?> iHCElement = this.createSingleErrorNode(iError2, locale);
                if (iHCControl == null) {
                    iHCElement.addClass(CBootstrapCSS.D_BLOCK);
                }
                hCNodeList.addChild(iHCElement);
            }
        }
        IHCElementWithChildren<?> iHCElementWithChildren = null;
        if (iHCNode2 != null && iHCNode != null) {
            iHCElementWithChildren = this.createHelpTextNode(iHCNode2);
            if (bl3) {
                iHCElementWithChildren.addClass(CBootstrapCSS.SR_ONLY);
            }
        }
        if (this.m_bForceNoCheckBoxHandling || iCommonsList.size() != 1) {
            bl2 = false;
            bl = false;
        } else {
            bl2 = iHCControl instanceof AbstractHCCheckBox;
            bl = iHCControl instanceof AbstractHCRadioButton;
        }
        if (bl2 || bl) {
            iHCControl.addClass(CBootstrapCSS.FORM_CHECK_INPUT);
            HCDiv hCDiv = (HCDiv)((HCDiv)new HCDiv().addClass(CBootstrapCSS.FORM_CHECK)).addChild(iHCNode);
            if (bl3) {
                if (hCFormLabel != null) {
                    hCFormLabel.addClass(CBootstrapCSS.FORM_CHECK_LABEL);
                    hCDiv.addChild((IHCNode)hCFormLabel);
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                iError2 = (AbstractHCDiv)((HCDiv)((HCDiv)hCDiv.addClass(CBootstrapCSS.MR_SM_2)).addChild((IHCNode)hCNodeList)).addChild(iHCElementWithChildren);
            } else {
                if (hCFormLabel != null) {
                    hCFormLabel.addClass(CBootstrapCSS.FORM_CHECK_LABEL);
                    hCDiv.addChild((IHCNode)hCFormLabel);
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                HCDiv hCDiv2 = (HCDiv)((HCDiv)((HCDiv)new HCDiv().addChild((IHCNode)hCDiv)).addChild((IHCNode)hCNodeList)).addChild(iHCElementWithChildren);
                if (!bl3) {
                    iBootstrapFormGroupContainer.getLeft().applyOffsetTo(hCDiv2);
                    iBootstrapFormGroupContainer.getRight().applyTo(hCDiv2);
                }
                iError2 = bl3 ? new HCDiv() : new BootstrapRow();
                ((AbstractHCDiv)iError2.addClass(CBootstrapCSS.FORM_GROUP)).addChild((IHCNode)hCDiv2);
            }
        } else if (bl3) {
            if (iHCControl != null) {
                iHCControl.addClass(CBootstrapCSS.MR_SM_2);
            }
            HCDiv hCDiv = (HCDiv)((HCDiv)((HCDiv)new HCDiv().addChild(iHCNode)).addChild((IHCNode)hCNodeList)).addChild(iHCElementWithChildren);
            if (hCFormLabel == null || hCFormLabel.hasNoChildren()) {
                iError2 = hCDiv;
            } else {
                hCFormLabel.addClass(CBootstrapCSS.SR_ONLY);
                if (iHCControl != null) {
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                iError2 = (AbstractHCDiv)((HCDiv)new HCDiv().addChild((IHCNode)hCFormLabel)).addChild((IHCNode)hCDiv);
            }
        } else {
            iError2 = (AbstractHCDiv)new BootstrapRow().addClass(CBootstrapCSS.FORM_GROUP);
            HCDiv hCDiv = (HCDiv)((HCDiv)((HCDiv)new HCDiv().addChild(iHCNode)).addChild((IHCNode)hCNodeList)).addChild(iHCElementWithChildren);
            iBootstrapFormGroupContainer.getRight().applyTo(hCDiv);
            if (hCFormLabel == null || hCFormLabel.hasNoChildren()) {
                if (!bl3) {
                    iBootstrapFormGroupContainer.getLeft().applyOffsetTo(hCDiv);
                }
                iError2.addChild((IHCNode)hCDiv);
            } else {
                if (bl3) {
                    hCFormLabel.addClass(CBootstrapCSS.SR_ONLY);
                }
                if (iHCControl != null) {
                    this.modifyFirstControlIfLabelIsPresent((IHCElementWithChildren<?>)hCFormLabel, (IHCControl<?>)iHCControl);
                }
                if (!bl3) {
                    iBootstrapFormGroupContainer.getLeft().applyTo(hCFormLabel);
                }
                ((AbstractHCDiv)iError2.addChild((IHCNode)hCFormLabel)).addChild((IHCNode)hCDiv);
            }
        }
        bootstrapFormGroup.applyBasicHTMLTo((IHCElement<?>)iError2);
        this.modifyFinalNode(iBootstrapFormGroupContainer, bootstrapFormGroup, (AbstractHCDiv<?>)iError2);
        return iError2;
    }
}

