/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.grid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.html.IHCElement;
import com.helger.photon.bootstrap4.grid.EBootstrapGridLG;
import com.helger.photon.bootstrap4.grid.EBootstrapGridMD;
import com.helger.photon.bootstrap4.grid.EBootstrapGridSM;
import com.helger.photon.bootstrap4.grid.EBootstrapGridXL;
import com.helger.photon.bootstrap4.grid.EBootstrapGridXS;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BootstrapGridSpec
implements Serializable {
    public static final BootstrapGridSpec NONE = new BootstrapGridSpec(null, null, null, null, null);
    public static final BootstrapGridSpec EVENLY = new BootstrapGridSpec(EBootstrapGridXS.EVENLY, null, null, null, null);
    private final EBootstrapGridXS m_eXS;
    private final EBootstrapGridSM m_eSM;
    private final EBootstrapGridMD m_eMD;
    private final EBootstrapGridLG m_eLG;
    private final EBootstrapGridXL m_eXL;

    public BootstrapGridSpec(@Nullable EBootstrapGridXS eBootstrapGridXS, @Nullable EBootstrapGridSM eBootstrapGridSM, @Nullable EBootstrapGridMD eBootstrapGridMD, @Nullable EBootstrapGridLG eBootstrapGridLG, @Nullable EBootstrapGridXL eBootstrapGridXL) {
        this.m_eXS = eBootstrapGridXS;
        this.m_eSM = eBootstrapGridSM;
        this.m_eMD = eBootstrapGridMD;
        this.m_eLG = eBootstrapGridLG;
        this.m_eXL = eBootstrapGridXL;
    }

    @Nullable
    public EBootstrapGridXS getXS() {
        return this.m_eXS;
    }

    @Nullable
    public EBootstrapGridSM getSM() {
        return this.m_eSM;
    }

    @Nullable
    public EBootstrapGridMD getMD() {
        return this.m_eMD;
    }

    @Nullable
    public EBootstrapGridLG getLG() {
        return this.m_eLG;
    }

    @Nullable
    public EBootstrapGridXL getXL() {
        return this.m_eXL;
    }

    @Nonnull
    public <T extends IHCElement<T>> T applyTo(@Nonnull T t) {
        ValueEnforcer.notNull(t, (String)"Element");
        int n = -1;
        if (this.m_eXS != null) {
            t.addClass((ICSSClassProvider)this.m_eXS);
            n = this.m_eXS.getParts();
        }
        if (this.m_eSM != null && this.m_eSM.getParts() != n) {
            t.addClass((ICSSClassProvider)this.m_eSM);
            n = this.m_eSM.getParts();
        }
        if (this.m_eMD != null && this.m_eMD.getParts() != n) {
            t.addClass((ICSSClassProvider)this.m_eMD);
            n = this.m_eMD.getParts();
        }
        if (this.m_eLG != null && this.m_eLG.getParts() != n) {
            t.addClass((ICSSClassProvider)this.m_eLG);
            n = this.m_eLG.getParts();
        }
        if (this.m_eXL != null && this.m_eXL.getParts() != n) {
            t.addClass((ICSSClassProvider)this.m_eXL);
            n = this.m_eXL.getParts();
        }
        return t;
    }

    @Nonnull
    public <T extends IHCElement<T>> T applyOffsetTo(@Nonnull T t) {
        ValueEnforcer.notNull(t, (String)"Element");
        int n = -1;
        if (this.m_eXS != null && this.m_eXS.getParts() > 0) {
            t.addClass(this.m_eXS.getCSSClassOffset());
            n = this.m_eXS.getParts();
        }
        if (this.m_eSM != null && this.m_eSM.getParts() > 0 && this.m_eSM.getParts() != n) {
            t.addClass(this.m_eSM.getCSSClassOffset());
            n = this.m_eSM.getParts();
        }
        if (this.m_eMD != null && this.m_eMD.getParts() > 0 && this.m_eMD.getParts() != n) {
            t.addClass(this.m_eMD.getCSSClassOffset());
            n = this.m_eMD.getParts();
        }
        if (this.m_eLG != null && this.m_eLG.getParts() > 0 && this.m_eLG.getParts() != n) {
            t.addClass(this.m_eLG.getCSSClassOffset());
            n = this.m_eLG.getParts();
        }
        if (this.m_eXL != null && this.m_eXL.getParts() > 0 && this.m_eXL.getParts() != n) {
            t.addClass(this.m_eXL.getCSSClassOffset());
            n = this.m_eXL.getParts();
        }
        return t;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("xs", (Enum)this.m_eXS).append("sm", (Enum)this.m_eSM).append("md", (Enum)this.m_eMD).append("lg", (Enum)this.m_eLG).append("xl", (Enum)this.m_eXL).getToString();
    }

    @Nonnull
    public static BootstrapGridSpec create(int n) {
        return BootstrapGridSpec.create(n, -1, -1, -1, -1);
    }

    @Nonnull
    public static BootstrapGridSpec create(int n, int n2, int n3, int n4, int n5) {
        return new BootstrapGridSpec(EBootstrapGridXS.getFromParts(n), EBootstrapGridSM.getFromParts(n2), EBootstrapGridMD.getFromParts(n3), EBootstrapGridLG.getFromParts(n4), EBootstrapGridXL.getFromParts(n5));
    }
}

