/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.grid;

import com.helger.html.css.ICSSClassProvider;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.grid.EBootstrapGridType;
import com.helger.photon.bootstrap4.grid.IBootstrapGridElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EBootstrapGridMD implements IBootstrapGridElement
{
    MD_1(1, CBootstrapCSS.COL_MD_1, CBootstrapCSS.OFFSET_MD_1),
    MD_2(2, CBootstrapCSS.COL_MD_2, CBootstrapCSS.OFFSET_MD_2),
    MD_3(3, CBootstrapCSS.COL_MD_3, CBootstrapCSS.OFFSET_MD_3),
    MD_4(4, CBootstrapCSS.COL_MD_4, CBootstrapCSS.OFFSET_MD_4),
    MD_5(5, CBootstrapCSS.COL_MD_5, CBootstrapCSS.OFFSET_MD_5),
    MD_6(6, CBootstrapCSS.COL_MD_6, CBootstrapCSS.OFFSET_MD_6),
    MD_7(7, CBootstrapCSS.COL_MD_7, CBootstrapCSS.OFFSET_MD_7),
    MD_8(8, CBootstrapCSS.COL_MD_8, CBootstrapCSS.OFFSET_MD_8),
    MD_9(9, CBootstrapCSS.COL_MD_9, CBootstrapCSS.OFFSET_MD_9),
    MD_10(10, CBootstrapCSS.COL_MD_10, CBootstrapCSS.OFFSET_MD_10),
    MD_11(11, CBootstrapCSS.COL_MD_11, CBootstrapCSS.OFFSET_MD_11),
    MD_12(12, CBootstrapCSS.COL_MD_12, null),
    AUTO(-2, CBootstrapCSS.COL_MD_AUTO, null),
    EVENLY(-3, CBootstrapCSS.COL_MD, null);

    private final int m_nParts;
    private final ICSSClassProvider m_aCSSClass;
    private final ICSSClassProvider m_aCSSClassOffset;

    private EBootstrapGridMD(@Nullable int n2, ICSSClassProvider iCSSClassProvider, ICSSClassProvider iCSSClassProvider2) {
        this.m_nParts = n2;
        this.m_aCSSClass = iCSSClassProvider;
        this.m_aCSSClassOffset = iCSSClassProvider2;
    }

    @Override
    @Nonnull
    public EBootstrapGridType getGridType() {
        return EBootstrapGridType.MD;
    }

    @Override
    public int getParts() {
        return this.m_nParts;
    }

    @Nullable
    public String getCSSClass() {
        return this.m_aCSSClass == null ? null : this.m_aCSSClass.getCSSClass();
    }

    @Nullable
    public ICSSClassProvider getCSSClassOffset() {
        return this.m_aCSSClassOffset;
    }

    @Override
    public boolean isMax() {
        return this == MD_12;
    }

    @Nullable
    public static EBootstrapGridMD getFromParts(int n) {
        switch (n) {
            case 1: {
                return MD_1;
            }
            case 2: {
                return MD_2;
            }
            case 3: {
                return MD_3;
            }
            case 4: {
                return MD_4;
            }
            case 5: {
                return MD_5;
            }
            case 6: {
                return MD_6;
            }
            case 7: {
                return MD_7;
            }
            case 8: {
                return MD_8;
            }
            case 9: {
                return MD_9;
            }
            case 10: {
                return MD_10;
            }
            case 11: {
                return MD_11;
            }
            case 12: {
                return MD_12;
            }
            case -2: {
                return AUTO;
            }
            case -3: {
                return EVENLY;
            }
        }
        return null;
    }
}

