/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.grid;

import com.helger.commons.annotation.Nonempty;
import com.helger.html.css.ICSSClassProvider;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.grid.EBootstrapGridType;
import com.helger.photon.bootstrap4.grid.IBootstrapGridElement;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EBootstrapGridSM implements IBootstrapGridElement
{
    SM_1(1, CBootstrapCSS.COL_SM_1, CBootstrapCSS.OFFSET_SM_1),
    SM_2(2, CBootstrapCSS.COL_SM_2, CBootstrapCSS.OFFSET_SM_2),
    SM_3(3, CBootstrapCSS.COL_SM_3, CBootstrapCSS.OFFSET_SM_3),
    SM_4(4, CBootstrapCSS.COL_SM_4, CBootstrapCSS.OFFSET_SM_4),
    SM_5(5, CBootstrapCSS.COL_SM_5, CBootstrapCSS.OFFSET_SM_5),
    SM_6(6, CBootstrapCSS.COL_SM_6, CBootstrapCSS.OFFSET_SM_6),
    SM_7(7, CBootstrapCSS.COL_SM_7, CBootstrapCSS.OFFSET_SM_7),
    SM_8(8, CBootstrapCSS.COL_SM_8, CBootstrapCSS.OFFSET_SM_8),
    SM_9(9, CBootstrapCSS.COL_SM_9, CBootstrapCSS.OFFSET_SM_9),
    SM_10(10, CBootstrapCSS.COL_SM_10, CBootstrapCSS.OFFSET_SM_10),
    SM_11(11, CBootstrapCSS.COL_SM_11, CBootstrapCSS.OFFSET_SM_11),
    SM_12(12, CBootstrapCSS.COL_SM_12, null),
    AUTO(-2, CBootstrapCSS.COL_SM_AUTO, null),
    EVENLY(-3, CBootstrapCSS.COL_SM, null);

    private final int m_nParts;
    private final ICSSClassProvider m_aCSSClass;
    private final ICSSClassProvider m_aCSSClassOffset;

    private EBootstrapGridSM(@Nullable int n2, ICSSClassProvider iCSSClassProvider, ICSSClassProvider iCSSClassProvider2) {
        this.m_nParts = n2;
        this.m_aCSSClass = iCSSClassProvider;
        this.m_aCSSClassOffset = iCSSClassProvider2;
    }

    @Override
    @Nonnull
    public EBootstrapGridType getGridType() {
        return EBootstrapGridType.SM;
    }

    @Override
    @Nonnegative
    public int getParts() {
        return this.m_nParts;
    }

    @Nonnull
    @Nonempty
    public String getCSSClass() {
        return this.m_aCSSClass.getCSSClass();
    }

    @Nullable
    public ICSSClassProvider getCSSClassOffset() {
        return this.m_aCSSClassOffset;
    }

    @Override
    public boolean isMax() {
        return this == SM_12;
    }

    @Nullable
    public static EBootstrapGridSM getFromParts(int n) {
        switch (n) {
            case 1: {
                return SM_1;
            }
            case 2: {
                return SM_2;
            }
            case 3: {
                return SM_3;
            }
            case 4: {
                return SM_4;
            }
            case 5: {
                return SM_5;
            }
            case 6: {
                return SM_6;
            }
            case 7: {
                return SM_7;
            }
            case 8: {
                return SM_8;
            }
            case 9: {
                return SM_9;
            }
            case 10: {
                return SM_10;
            }
            case 11: {
                return SM_11;
            }
            case 12: {
                return SM_12;
            }
            case -2: {
                return AUTO;
            }
            case -3: {
                return EVENLY;
            }
        }
        return null;
    }
}

