/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.grid;

import com.helger.commons.lang.EnumHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EBootstrapGridType {
    XS("", 0, 576),
    SM("-sm", 576, 768),
    MD("-md", 768, 992),
    LG("-lg", 992, 1200),
    XL("-xl", 1200, -1);

    private final String m_sCSSClassNamePart;
    private final int m_nMinWidthIncl;
    private final int m_nMaxWidthExcl;

    private EBootstrapGridType(String string2, int n2, int n3) {
        this.m_sCSSClassNamePart = string2;
        this.m_nMinWidthIncl = n2;
        this.m_nMaxWidthExcl = n3;
    }

    @Nonnull
    public String getCSSClassNamePart() {
        return this.m_sCSSClassNamePart;
    }

    public boolean isForWidth(int n) {
        return n >= this.m_nMinWidthIncl && (n < this.m_nMaxWidthExcl || this.m_nMaxWidthExcl < 0);
    }

    @Nullable
    public static EBootstrapGridType getForWidth(int n) {
        if (n < 0) {
            return null;
        }
        return (EBootstrapGridType)EnumHelper.findFirst(EBootstrapGridType.class, eBootstrapGridType -> eBootstrapGridType.isForWidth(n));
    }
}

