/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.inputgroup;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.StringHelper;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.forms.AbstractHCButton;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.textlevel.HCSpan;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.dropdown.BootstrapDropdownMenu;
import com.helger.photon.bootstrap4.inputgroup.EBootstrapInputGroupSize;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BootstrapInputGroup
extends AbstractHCDiv<BootstrapInputGroup> {
    private EBootstrapInputGroupSize m_eSize;

    public BootstrapInputGroup() {
        this(EBootstrapInputGroupSize.DEFAULT);
    }

    public BootstrapInputGroup(@Nonnull EBootstrapInputGroupSize eBootstrapInputGroupSize) {
        this.setSize(eBootstrapInputGroupSize);
    }

    @Nonnull
    public final EBootstrapInputGroupSize getSize() {
        return this.m_eSize;
    }

    @Nonnull
    public final BootstrapInputGroup setSize(@Nonnull EBootstrapInputGroupSize eBootstrapInputGroupSize) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapInputGroupSize), (String)"Size");
        this.m_eSize = eBootstrapInputGroupSize;
        return this;
    }

    @Nonnull
    @OverrideOnDemand
    public HCDiv createGroupPrepend() {
        return (HCDiv)new HCDiv().addClass(CBootstrapCSS.INPUT_GROUP_PREPEND);
    }

    @Nonnull
    @OverrideOnDemand
    public HCDiv createGroupAppend() {
        return (HCDiv)new HCDiv().addClass(CBootstrapCSS.INPUT_GROUP_APPEND);
    }

    @Nonnull
    public HCDiv getOrCreateGroupPrepend() {
        HCDiv hCDiv = (HCDiv)this.findFirstChild(iHCNode -> iHCNode instanceof HCDiv && ((HCDiv)iHCNode).containsClass(CBootstrapCSS.INPUT_GROUP_PREPEND));
        return hCDiv != null ? hCDiv : (HCDiv)this.addAndReturnChild((IHCNode)this.createGroupPrepend());
    }

    @Nonnull
    public HCDiv getOrCreateGroupAppend() {
        HCDiv hCDiv = (HCDiv)this.findFirstChild(iHCNode -> iHCNode instanceof HCDiv && ((HCDiv)iHCNode).containsClass(CBootstrapCSS.INPUT_GROUP_APPEND));
        return hCDiv != null ? hCDiv : (HCDiv)this.addAndReturnChild((IHCNode)this.createGroupAppend());
    }

    @Nonnull
    public static HCSpan getWrapped(@Nonnull String string) {
        return (HCSpan)((HCSpan)new HCSpan().addClass(CBootstrapCSS.INPUT_GROUP_TEXT)).addChild(string);
    }

    @Nonnull
    public static IHCNode getWrapped(@Nonnull IHCNode iHCNode) {
        if (iHCNode instanceof AbstractHCButton || iHCNode instanceof BootstrapDropdownMenu) {
            return iHCNode;
        }
        return ((HCDiv)new HCDiv().addClass(CBootstrapCSS.INPUT_GROUP_TEXT)).addChild(iHCNode);
    }

    @Nonnull
    public final BootstrapInputGroup addChildPrefix(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            this.getOrCreateGroupPrepend().addChild((IHCNode)BootstrapInputGroup.getWrapped(string));
        }
        return this;
    }

    @Nonnull
    public final BootstrapInputGroup addChildPrefix(@Nullable IHCNode iHCNode) {
        if (iHCNode != null) {
            this.getOrCreateGroupPrepend().addChild(BootstrapInputGroup.getWrapped(iHCNode));
        }
        return this;
    }

    @Nonnull
    public final BootstrapInputGroup addChildSuffix(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            this.getOrCreateGroupAppend().addChild((IHCNode)BootstrapInputGroup.getWrapped(string));
        }
        return this;
    }

    @Nonnull
    public final BootstrapInputGroup addChildSuffix(@Nullable IHCNode iHCNode) {
        if (iHCNode != null) {
            this.getOrCreateGroupAppend().addChild(BootstrapInputGroup.getWrapped(iHCNode));
        }
        return this;
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        this.addClasses(new ICSSClassProvider[]{CBootstrapCSS.INPUT_GROUP, this.m_eSize});
    }
}

