/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.bootstrap4.modal;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.html.EHTMLRole;
import com.helger.html.css.ICSSClassProvider;
import com.helger.html.hc.IHCConversionSettingsToNode;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCHasID;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.html.grouping.AbstractHCDiv;
import com.helger.html.hc.html.grouping.HCDiv;
import com.helger.html.hc.html.sections.HCH5;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.impl.HCTextNode;
import com.helger.html.jquery.JQuery;
import com.helger.html.jscode.IJSExpression;
import com.helger.html.jscode.IJSStatement;
import com.helger.html.jscode.JSAssocArray;
import com.helger.html.jscode.JSInvocation;
import com.helger.html.jscode.JSPackage;
import com.helger.photon.bootstrap4.CBootstrapCSS;
import com.helger.photon.bootstrap4.modal.EBootstrapModalOptionBackdrop;
import com.helger.photon.bootstrap4.modal.EBootstrapModalSize;
import com.helger.photon.bootstrap4.utils.BootstrapCloseIcon;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BootstrapModal
extends AbstractHCDiv<BootstrapModal> {
    public static final String JS_EVENT_SHOW = "show.bs.modal";
    public static final String JS_EVENT_SHOWN = "shown.bs.modal";
    public static final String JS_EVENT_HIDE = "hide.bs.modal";
    public static final String JS_EVENT_HIDDEN = "hidden.bs.modal";
    public static final String JS_EVENT_LOADED = "loaded.bs.modal";
    public static final boolean DEFAULT_FADE = true;
    public static final boolean DEFAULT_VERTICALLY_CENTERED = true;
    public static final boolean DEFAULT_SCROLL_BODY = false;
    public static final boolean DEFAULT_SHOW_CLOSE = true;
    private EBootstrapModalSize m_eSize;
    private boolean m_bFade = true;
    private boolean m_bVerticallyCentered = true;
    private boolean m_bScrollBody = false;
    private boolean m_bShowClose = true;
    private IHCNode m_aHeader;
    private IHCNode m_aBody;
    private IHCNode m_aFooter;

    public BootstrapModal() {
        this(EBootstrapModalSize.DEFAULT);
    }

    public BootstrapModal(@Nonnull EBootstrapModalSize eBootstrapModalSize) {
        this.ensureID();
        this.setSize(eBootstrapModalSize);
    }

    @Nonnull
    public final EBootstrapModalSize getSize() {
        return this.m_eSize;
    }

    @Nonnull
    public final BootstrapModal setSize(@Nonnull EBootstrapModalSize eBootstrapModalSize) {
        ValueEnforcer.notNull((Object)((Object)eBootstrapModalSize), (String)"Size");
        this.m_eSize = eBootstrapModalSize;
        return this;
    }

    public final boolean isFade() {
        return this.m_bFade;
    }

    @Nonnull
    public final BootstrapModal setFade(boolean bl) {
        this.m_bFade = bl;
        return this;
    }

    public final boolean isVerticallyCentered() {
        return this.m_bVerticallyCentered;
    }

    @Nonnull
    public final BootstrapModal setVerticallyCentered(boolean bl) {
        this.m_bVerticallyCentered = bl;
        return this;
    }

    public final boolean isScrollBody() {
        return this.m_bScrollBody;
    }

    @Nonnull
    public final BootstrapModal setScrollBody(boolean bl) {
        this.m_bScrollBody = bl;
        return this;
    }

    public final boolean isShowClose() {
        return this.m_bShowClose;
    }

    @Nonnull
    public final BootstrapModal setShowClose(boolean bl) {
        this.m_bShowClose = bl;
        return this;
    }

    @Nonnull
    public final BootstrapModal setHeader(@Nullable String string) {
        return this.setHeader((IHCNode)HCTextNode.createOnDemand((String)string));
    }

    @Nonnull
    public final BootstrapModal setHeader(@Nullable IHCNode iHCNode) {
        this.m_aHeader = iHCNode;
        return this;
    }

    @Nonnull
    public final BootstrapModal setHeader(IHCNode ... iHCNodeArray) {
        return this.setHeader((IHCNode)new HCNodeList().addChildren(iHCNodeArray));
    }

    @Nonnull
    public final BootstrapModal setHeader(@Nullable Iterable<? extends IHCNode> iterable) {
        return this.setHeader((IHCNode)new HCNodeList().addChildren(iterable));
    }

    @Nonnull
    public final BootstrapModal setBody(@Nullable String string) {
        return this.setBody((IHCNode)HCTextNode.createOnDemand((String)string));
    }

    @Nonnull
    public final BootstrapModal setBody(@Nullable IHCNode iHCNode) {
        this.m_aBody = iHCNode;
        return this;
    }

    @Nonnull
    public final BootstrapModal setBody(IHCNode ... iHCNodeArray) {
        return this.setBody((IHCNode)new HCNodeList().addChildren(iHCNodeArray));
    }

    @Nonnull
    public final BootstrapModal setBody(@Nullable Iterable<? extends IHCNode> iterable) {
        return this.setBody((IHCNode)new HCNodeList().addChildren(iterable));
    }

    @Nonnull
    public final BootstrapModal setFooter(@Nullable String string) {
        return this.setFooter((IHCNode)HCTextNode.createOnDemand((String)string));
    }

    @Nonnull
    public final BootstrapModal setFooter(@Nullable IHCNode iHCNode) {
        this.m_aFooter = iHCNode;
        return this;
    }

    @Nonnull
    public final BootstrapModal setFooter(IHCNode ... iHCNodeArray) {
        return this.setFooter((IHCNode)new HCNodeList().addChildren(iHCNodeArray));
    }

    @Nonnull
    public final BootstrapModal setFooter(@Nullable Iterable<? extends IHCNode> iterable) {
        return this.setFooter((IHCNode)new HCNodeList().addChildren(iterable));
    }

    @Nonnull
    @Nonempty
    private String _getContentID() {
        return this.getID() + "content";
    }

    @Nonnull
    @Nonempty
    private String _getTitleID() {
        return this.getID() + "title";
    }

    protected void onFinalizeNodeState(@Nonnull IHCConversionSettingsToNode iHCConversionSettingsToNode, @Nonnull IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable) {
        super.onFinalizeNodeState(iHCConversionSettingsToNode, iHCHasChildrenMutable);
        ((BootstrapModal)((BootstrapModal)this.addClass(CBootstrapCSS.MODAL)).setRole(EHTMLRole.DIALOG)).setTabIndex(-1L);
        this.customAttrs().setAriaHidden(true);
        if (this.m_bFade) {
            this.addClass(CBootstrapCSS.FADE);
        }
        HCDiv hCDiv = (HCDiv)this.addAndReturnChild((IHCNode)((HCDiv)((HCDiv)new HCDiv().addClass(CBootstrapCSS.MODAL_DIALOG)).addClass((ICSSClassProvider)this.m_eSize)).setRole(EHTMLRole.DOCUMENT));
        if (this.m_bVerticallyCentered) {
            hCDiv.addClass(CBootstrapCSS.MODAL_DIALOG_CENTERED);
        }
        if (this.m_bScrollBody) {
            hCDiv.addClass(CBootstrapCSS.MODAL_DIALOG_SCROLLABLE);
        }
        HCDiv hCDiv2 = (HCDiv)hCDiv.addAndReturnChild((IHCNode)((HCDiv)new HCDiv().addClass(CBootstrapCSS.MODAL_CONTENT)).setID(this._getContentID()));
        if (this.m_aHeader != null) {
            String string = this._getTitleID();
            this.customAttrs().setAriaLabeledBy(string);
            HCDiv hCDiv3 = (HCDiv)hCDiv2.addAndReturnChild((IHCNode)new HCDiv().addClass(CBootstrapCSS.MODAL_HEADER));
            hCDiv3.addChild((IHCNode)((HCH5)((HCH5)new HCH5().addClass(CBootstrapCSS.MODAL_TITLE)).setID(string)).addChild(this.m_aHeader));
            if (this.m_bShowClose) {
                BootstrapCloseIcon bootstrapCloseIcon = new BootstrapCloseIcon();
                bootstrapCloseIcon.customAttrs().setDataAttr("dismiss", "modal");
                hCDiv3.addChild((IHCNode)bootstrapCloseIcon);
            }
        }
        if (this.m_aBody != null) {
            hCDiv2.addChild((IHCNode)((HCDiv)new HCDiv().addClass(CBootstrapCSS.MODAL_BODY)).addChild(this.m_aBody));
        }
        if (this.m_aFooter != null) {
            hCDiv2.addChild((IHCNode)((HCDiv)new HCDiv().addClass(CBootstrapCSS.MODAL_FOOTER)).addChild(this.m_aFooter));
        }
    }

    @Nonnull
    public JSInvocation jsModal() {
        return JQuery.idRef((IHCHasID)this).invoke("modal");
    }

    @Nonnull
    public JSPackage openModal(@Nullable EBootstrapModalOptionBackdrop eBootstrapModalOptionBackdrop, @Nullable Boolean bl, @Nullable Boolean bl2, @Nullable Boolean bl3, @Nullable String string) {
        JSPackage jSPackage = new JSPackage();
        JSAssocArray jSAssocArray = new JSAssocArray();
        if (eBootstrapModalOptionBackdrop != null) {
            jSAssocArray.add("backdrop", eBootstrapModalOptionBackdrop.getJSExpression());
        }
        if (bl2 != null) {
            jSAssocArray.add("focus", bl2.booleanValue());
        }
        if (bl != null) {
            jSAssocArray.add("keyboard", bl.booleanValue());
        }
        if (bl3 != null) {
            jSAssocArray.add("show", bl3.booleanValue());
        }
        jSPackage.add((IJSStatement)this.jsModal().arg((IJSExpression)jSAssocArray));
        if (StringHelper.hasText((String)string)) {
            jSPackage.add((IJSStatement)JQuery.idRef((String)this._getContentID()).load(string));
        }
        return jSPackage;
    }

    @Nonnull
    public JSInvocation jsModalToggle() {
        return (JSInvocation)this.jsModal().arg("toggle");
    }

    @Nonnull
    public JSInvocation jsModalShow() {
        return (JSInvocation)this.jsModal().arg("show");
    }

    @Nonnull
    public JSInvocation jsModalHide() {
        return (JSInvocation)this.jsModal().arg("hide");
    }

    @Nonnull
    public JSInvocation jsModalHandleUpdate() {
        return (JSInvocation)this.jsModal().arg("handleUpdate");
    }

    @Nonnull
    public JSInvocation jsModalDispose() {
        return (JSInvocation)this.jsModal().arg("dispose");
    }
}

