/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkexport.format;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.photon.exchange.EExchangeFileType;
import com.helger.photon.exchange.bulkexport.EExportDataType;
import com.helger.photon.exchange.bulkexport.EExportRecordType;
import com.helger.photon.exchange.bulkexport.IExportRecord;
import com.helger.photon.exchange.bulkexport.IExportRecordField;
import com.helger.photon.exchange.bulkexport.IExportRecordProvider;
import com.helger.photon.exchange.bulkexport.IExporterFile;
import com.helger.poi.excel.EExcelVersion;
import com.helger.poi.excel.WorkbookCreationHelper;
import com.helger.poi.excel.style.ExcelStyle;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

@NotThreadSafe
public class ExporterExcel
implements IExporterFile {
    private static final ExcelStyle DEFAULT_STYLE_DATE = new ExcelStyle().setDataFormat("dd.mm.yyyy");
    private static final ExcelStyle DEFAULT_STYLE_TIME = new ExcelStyle().setDataFormat("hh:mm:ss");
    private static final ExcelStyle DEFAULT_STYLE_DATETIME = new ExcelStyle().setDataFormat("dd.mm.yyyy hh:mm:ss");
    private final EExcelVersion m_eVersion;
    private ExcelStyle m_aStyleBoolean;
    private ExcelStyle m_aStyleInt;
    private ExcelStyle m_aStyleDouble;
    private ExcelStyle m_aStyleText;
    private ExcelStyle m_aStyleDate = DEFAULT_STYLE_DATE;
    private ExcelStyle m_aStyleTime = DEFAULT_STYLE_TIME;
    private ExcelStyle m_aStyleDateTime = DEFAULT_STYLE_DATETIME;

    public ExporterExcel(@Nonnull EExcelVersion eExcelVersion) {
        this.m_eVersion = (EExcelVersion)ValueEnforcer.notNull((Object)eExcelVersion, (String)"Version");
    }

    @Nonnull
    public EExcelVersion getExcelVersion() {
        return this.m_eVersion;
    }

    @Nonnull
    public ExporterExcel setStyleBoolean(@Nullable ExcelStyle excelStyle) {
        this.m_aStyleBoolean = excelStyle == null ? null : excelStyle.getClone();
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public ExcelStyle getStyleBoolean() {
        return this.m_aStyleBoolean == null ? null : this.m_aStyleBoolean.getClone();
    }

    @Nonnull
    public ExporterExcel setStyleInt(@Nullable ExcelStyle excelStyle) {
        this.m_aStyleInt = excelStyle == null ? null : excelStyle.getClone();
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public ExcelStyle getStyleInt() {
        return this.m_aStyleInt == null ? null : this.m_aStyleInt.getClone();
    }

    @Nonnull
    public ExporterExcel setStyleDouble(@Nullable ExcelStyle excelStyle) {
        this.m_aStyleDouble = excelStyle == null ? null : excelStyle.getClone();
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public ExcelStyle getStyleDouble() {
        return this.m_aStyleDouble == null ? null : this.m_aStyleDouble.getClone();
    }

    @Nonnull
    public ExporterExcel setStyleText(@Nullable ExcelStyle excelStyle) {
        this.m_aStyleText = excelStyle == null ? null : excelStyle.getClone();
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public ExcelStyle getStyleText() {
        return this.m_aStyleText == null ? null : this.m_aStyleText.getClone();
    }

    @Nonnull
    public ExporterExcel setStyleDate(@Nonnull ExcelStyle excelStyle) {
        this.m_aStyleDate = ((ExcelStyle)ValueEnforcer.notNull((Object)excelStyle, (String)"Style")).getClone();
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ExcelStyle getStyleDate() {
        return this.m_aStyleDate.getClone();
    }

    @Nonnull
    public ExporterExcel setStyleTime(@Nonnull ExcelStyle excelStyle) {
        this.m_aStyleTime = ((ExcelStyle)ValueEnforcer.notNull((Object)excelStyle, (String)"Style")).getClone();
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ExcelStyle getStyleTime() {
        return this.m_aStyleTime.getClone();
    }

    @Nonnull
    public ExporterExcel setStyleDateTime(@Nonnull ExcelStyle excelStyle) {
        this.m_aStyleDateTime = ((ExcelStyle)ValueEnforcer.notNull((Object)excelStyle, (String)"Style")).getClone();
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ExcelStyle getStyleDateTime() {
        return this.m_aStyleDateTime.getClone();
    }

    @OverrideOnDemand
    protected void onAddRow(@Nonnull WorkbookCreationHelper workbookCreationHelper, @Nonnull EExportRecordType eExportRecordType, @Nonnull Row row, @Nonnegative int n) {
    }

    @OverrideOnDemand
    protected void onAddCell(@Nonnull WorkbookCreationHelper workbookCreationHelper, @Nonnull EExportRecordType eExportRecordType, @Nonnull Cell cell, @Nonnegative int n, @Nonnull EExportDataType eExportDataType) {
    }

    private void _emitRecord(@Nonnull WorkbookCreationHelper workbookCreationHelper, @Nonnull EExportRecordType eExportRecordType, @Nonnull IExportRecord iExportRecord) {
        int n = workbookCreationHelper.getRowCount();
        Row row = workbookCreationHelper.addRow();
        this.onAddRow(workbookCreationHelper, eExportRecordType, row, n);
        for (IExportRecordField iExportRecordField : iExportRecord.getAllFields()) {
            Cell cell;
            Object object = iExportRecordField.getFieldValue();
            if (object == null) {
                workbookCreationHelper.addCell();
                continue;
            }
            int n2 = workbookCreationHelper.getCellCountInRow();
            switch (iExportRecordField.getFieldType()) {
                case BOOLEAN: {
                    cell = workbookCreationHelper.addCell(((Boolean)object).booleanValue());
                    if (this.m_aStyleBoolean == null) break;
                    workbookCreationHelper.addCellStyle(this.m_aStyleBoolean);
                    break;
                }
                case DOUBLE: {
                    cell = workbookCreationHelper.addCell(((Number)object).doubleValue());
                    if (this.m_aStyleDouble == null) break;
                    workbookCreationHelper.addCellStyle(this.m_aStyleDouble);
                    break;
                }
                case INT: {
                    cell = workbookCreationHelper.addCell((double)((Number)object).intValue());
                    if (this.m_aStyleInt == null) break;
                    workbookCreationHelper.addCellStyle(this.m_aStyleInt);
                    break;
                }
                case TEXT: {
                    cell = workbookCreationHelper.addCell((String)object);
                    if (this.m_aStyleText == null) break;
                    workbookCreationHelper.addCellStyle(this.m_aStyleText);
                    break;
                }
                case DATE: {
                    cell = workbookCreationHelper.addCell((Date)TypeConverter.convert((Object)object, Date.class));
                    workbookCreationHelper.addCellStyle(this.m_aStyleDate);
                    break;
                }
                case TIME: {
                    cell = workbookCreationHelper.addCell((Date)TypeConverter.convert((Object)object, Date.class));
                    workbookCreationHelper.addCellStyle(this.m_aStyleTime);
                    break;
                }
                case DATETIME: {
                    cell = object instanceof LocalDateTime ? workbookCreationHelper.addCell((Date)TypeConverter.convert((Object)object, Date.class)) : workbookCreationHelper.addCell((Calendar)TypeConverter.convert((Object)object, GregorianCalendar.class));
                    workbookCreationHelper.addCellStyle(this.m_aStyleDateTime);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The type " + (Object)((Object)iExportRecordField.getFieldType()) + " cannot be written to Excel!");
                }
            }
            this.onAddCell(workbookCreationHelper, eExportRecordType, cell, n2, iExportRecordField.getFieldType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final ESuccess exportRecords(@Nonnull IExportRecordProvider iExportRecordProvider, @Nonnull @WillClose OutputStream outputStream) {
        try {
            ValueEnforcer.notNull((Object)iExportRecordProvider, (String)"Provider");
            ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
            WorkbookCreationHelper workbookCreationHelper = new WorkbookCreationHelper(this.m_eVersion);
            workbookCreationHelper.createNewSheet();
            iExportRecordProvider.forEachHeaderRecord(iExportRecord -> this._emitRecord(workbookCreationHelper, EExportRecordType.HEADER, (IExportRecord)iExportRecord));
            iExportRecordProvider.forEachBodyRecord(iExportRecord -> this._emitRecord(workbookCreationHelper, EExportRecordType.BODY, (IExportRecord)iExportRecord));
            iExportRecordProvider.forEachFooterRecord(iExportRecord -> this._emitRecord(workbookCreationHelper, EExportRecordType.FOOTER, (IExportRecord)iExportRecord));
            if (workbookCreationHelper.getRowCount() == 0) {
                ESuccess eSuccess = ESuccess.FAILURE;
                return eSuccess;
            }
            workbookCreationHelper.autoSizeAllColumns();
            ESuccess eSuccess = workbookCreationHelper.writeTo(outputStream);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    @Override
    @Nonnull
    public EExchangeFileType getFileType() {
        return this.m_eVersion.equals((Object)EExcelVersion.XLS) ? EExchangeFileType.XLS : EExchangeFileType.XLSX;
    }
}

