/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkexport.format;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.photon.exchange.EExchangeFileType;
import com.helger.photon.exchange.bulkexport.IExportRecord;
import com.helger.photon.exchange.bulkexport.IExportRecordField;
import com.helger.photon.exchange.bulkexport.IExportRecordProvider;
import com.helger.photon.exchange.bulkexport.IExporterFile;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ExporterXML
implements IExporterFile {
    public static final boolean DEFAULT_EMIT_TYPE_ATTRIBUTE = true;
    private static final String ELEMENT_ROOT = "root";
    private static final String ELEMENT_HEADER = "header";
    private static final String ELEMENT_BODY = "body";
    private static final String ELEMENT_FOOTER = "footer";
    private static final String ELEMENT_RECORD = "record";
    private static final String ELEMENT_FIELD = "field";
    private static final String ATTR_TYPE = "type";
    private final XMLWriterSettings m_aXWS = new XMLWriterSettings();
    private boolean m_bEmitTypeAttr = true;

    @Nonnull
    public ExporterXML setCharset(@Nonnull Charset charset) {
        this.m_aXWS.setCharset(charset);
        return this;
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aXWS.getCharset();
    }

    @Nonnull
    @ReturnsMutableObject(value="Design")
    public XMLWriterSettings getXMLWriterSettings() {
        return this.m_aXWS;
    }

    @Nonnull
    public ExporterXML setEmitTypeAttr(boolean bl) {
        this.m_bEmitTypeAttr = bl;
        return this;
    }

    private void _emitRecord(@Nonnull IMicroElement iMicroElement, @Nonnull IExportRecord iExportRecord) {
        IMicroElement iMicroElement2 = iMicroElement.appendElement(ELEMENT_RECORD);
        for (IExportRecordField iExportRecordField : iExportRecord.getAllFields()) {
            Object object = iExportRecordField.getFieldValue();
            IMicroElement iMicroElement3 = iMicroElement2.appendElement(ELEMENT_FIELD);
            if (this.m_bEmitTypeAttr) {
                iMicroElement3.setAttribute(ATTR_TYPE, iExportRecordField.getFieldType().getID());
            }
            if (object == null) continue;
            iMicroElement3.appendTextWithConversion(object);
        }
    }

    @Nullable
    public IMicroDocument convertRecords(@Nonnull IExportRecordProvider iExportRecordProvider) {
        ValueEnforcer.notNull((Object)iExportRecordProvider, (String)"Provider");
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_ROOT);
        IMicroElement iMicroElement2 = iMicroElement.appendElement(ELEMENT_HEADER);
        iExportRecordProvider.forEachHeaderRecord(iExportRecord -> this._emitRecord(iMicroElement2, (IExportRecord)iExportRecord));
        IMicroElement iMicroElement3 = iMicroElement.appendElement(ELEMENT_BODY);
        iExportRecordProvider.forEachBodyRecord(iExportRecord -> this._emitRecord(iMicroElement3, (IExportRecord)iExportRecord));
        IMicroElement iMicroElement4 = iMicroElement.appendElement(ELEMENT_FOOTER);
        iExportRecordProvider.forEachFooterRecord(iExportRecord -> this._emitRecord(iMicroElement4, (IExportRecord)iExportRecord));
        if (iMicroElement3.hasNoChildren()) {
            return null;
        }
        return microDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess exportRecords(@Nonnull IExportRecordProvider iExportRecordProvider, @Nonnull @WillClose OutputStream outputStream) {
        try {
            ValueEnforcer.notNull((Object)iExportRecordProvider, (String)"Provider");
            ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
            IMicroDocument iMicroDocument = this.convertRecords(iExportRecordProvider);
            if (iMicroDocument == null) {
                ESuccess eSuccess = ESuccess.FAILURE;
                return eSuccess;
            }
            MicroWriter.writeToStream((IMicroNode)iMicroDocument, (OutputStream)outputStream, (IXMLWriterSettings)this.m_aXWS);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    @Override
    @Nonnull
    public EExchangeFileType getFileType() {
        return EExchangeFileType.XML;
    }
}

