/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkimport;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.type.ITypedObject;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BulkImportResult
implements ISuccessIndicator {
    public static final boolean DEFAULT_SUCCESS = true;
    public static final int DEFAULT_MAX_WARNINGS = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkImportResult.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final int m_nMaxWarnings;
    private boolean m_bSuccess = true;
    private final ICommonsOrderedMap<String, ITypedObject<String>> m_aAdded = new CommonsLinkedHashMap();
    private final ICommonsOrderedMap<String, ITypedObject<String>> m_aChanged = new CommonsLinkedHashMap();
    private final ICommonsList<String> m_aFailed = new CommonsArrayList();
    private final ICommonsList<String> m_aWarnings = new CommonsArrayList();
    private int m_nAdditionalWarnings = 0;

    public BulkImportResult() {
        this(1000);
    }

    public BulkImportResult(@Nonnegative int n) {
        this.m_nMaxWarnings = n;
    }

    public final void registerAdded(@Nonnull ITypedObject<String> iTypedObject) {
        this.m_aRWLock.writeLockedGet(() -> (ITypedObject)this.m_aAdded.put(iTypedObject.getID(), (Object)iTypedObject));
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ITypedObject<String>> getAllAdded() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aAdded.copyOfValues());
    }

    @Nonnegative
    public final int getAddedCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aAdded.size());
    }

    public final boolean containsAdded(@Nonnull ITypedObject<String> iTypedObject) {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aAdded.containsKey(iTypedObject.getID()));
    }

    public final void registerChanged(@Nonnull ITypedObject<String> iTypedObject) {
        this.m_aRWLock.writeLockedGet(() -> (ITypedObject)this.m_aChanged.put(iTypedObject.getID(), (Object)iTypedObject));
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<ITypedObject<String>> getAllChanged() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aChanged.copyOfValues());
    }

    @Nonnegative
    public final int getChangedCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aChanged.size());
    }

    public final boolean containsChanged(@Nonnull ITypedObject<String> iTypedObject) {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aChanged.containsKey(iTypedObject.getID()));
    }

    public final void registerFailed(String string) {
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aFailed.add((Object)string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllFailed() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aFailed.getClone());
    }

    @Nonnegative
    public final int getFailedCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aFailed.size());
    }

    public final boolean containsFailed(@Nullable String string) {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aFailed.contains((Object)string));
    }

    public final void addWarning(String string) {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aWarnings.size() < this.m_nMaxWarnings) {
                this.m_aWarnings.add((Object)string);
            } else {
                ++this.m_nAdditionalWarnings;
            }
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getAllWarnings() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aWarnings.getClone());
    }

    @Nonnegative
    public final int getWarningsCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aWarnings.size() + this.m_nAdditionalWarnings);
    }

    public final void setSuccess(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bSuccess = bl;
            return this.m_bSuccess;
        });
    }

    public final boolean isSuccess() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bSuccess);
    }
}

