/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.functional.IThrowingFunction;
import com.helger.commons.state.EChange;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.base.PLPageSet;
import java.io.IOException;
import javax.annotation.Nonnull;

public interface IPLVisitor {
    default public void onPageSetStart(@Nonnull PLPageSet pLPageSet) throws IOException {
    }

    @Nonnull
    default public EChange onElement(@Nonnull IPLRenderableObject<?> iPLRenderableObject) throws IOException {
        return EChange.UNCHANGED;
    }

    default public void onPageSetEnd(@Nonnull PLPageSet pLPageSet) throws IOException {
    }

    @Nonnull
    public static IPLVisitor createElementVisitor(final @Nonnull IThrowingFunction<? super IPLRenderableObject<?>, EChange, IOException> iThrowingFunction) {
        ValueEnforcer.notNull(iThrowingFunction, (String)"ElementConsumer");
        return new IPLVisitor(){

            @Override
            @Nonnull
            public EChange onElement(@Nonnull IPLRenderableObject<?> iPLRenderableObject) throws IOException {
                return (EChange)iThrowingFunction.apply(iPLRenderableObject);
            }
        };
    }
}

