/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.list;

import com.helger.commons.ValueEnforcer;
import com.helger.pdflayout.base.AbstractPLRenderableObject;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.base.IPLSplittableObject;
import com.helger.pdflayout.base.PLSplitResult;
import com.helger.pdflayout.element.list.IBulletPointCreator;
import com.helger.pdflayout.element.table.PLTable;
import com.helger.pdflayout.element.table.PLTableCell;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.SizeSpec;
import com.helger.pdflayout.spec.WidthSpec;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PLBulletPointList
extends AbstractPLRenderableObject<PLBulletPointList>
implements IPLSplittableObject<PLBulletPointList, PLTable> {
    private final PLTable m_aTable;
    private final IBulletPointCreator m_aBulletPointCreator;

    public PLBulletPointList(@Nonnull WidthSpec widthSpec, @Nonnull IBulletPointCreator iBulletPointCreator) {
        ValueEnforcer.notNull((Object)widthSpec, (String)"WidthSpec");
        ValueEnforcer.notNull((Object)iBulletPointCreator, (String)"BulletPointCreator");
        this.m_aTable = (PLTable)new PLTable(widthSpec, WidthSpec.star()).setID("bulletpoint-list");
        this.m_aBulletPointCreator = iBulletPointCreator;
    }

    @Nonnull
    public final PLTable getUnderlyingTable() {
        return this.m_aTable;
    }

    @Nonnull
    public final IBulletPointCreator getBulletPointCreator() {
        return this.m_aBulletPointCreator;
    }

    @Nonnull
    public PLBulletPointList addBulletPoint(@Nonnull IPLRenderableObject<?> iPLRenderableObject) {
        int n = this.m_aTable.getRowCount();
        PLTableCell pLTableCell = (PLTableCell)new PLTableCell(this.m_aBulletPointCreator.getBulletPointElement(n)).setID("bulletpoint");
        PLTableCell pLTableCell2 = (PLTableCell)new PLTableCell(iPLRenderableObject).setID("content");
        this.m_aTable.addRow(pLTableCell, pLTableCell2);
        return this;
    }

    @Override
    protected SizeSpec onPrepare(PreparationContext preparationContext) {
        return this.m_aTable.prepare(preparationContext);
    }

    @Override
    protected void onMarkAsNotPrepared() {
        this.m_aTable.internalMarkAsNotPrepared();
    }

    @Override
    protected void onRender(PageRenderContext pageRenderContext) throws IOException {
        this.m_aTable.render(pageRenderContext);
    }

    @Override
    @Nonnull
    public PLTable internalCreateNewVertSplitObject(@Nonnull PLTable pLTable) {
        return this.m_aTable.internalCreateNewVertSplitObject(pLTable);
    }

    @Override
    public final boolean isVertSplittable() {
        return this.m_aTable.isVertSplittable();
    }

    @Override
    @Nonnull
    public final PLBulletPointList setVertSplittable(boolean bl) {
        this.m_aTable.setVertSplittable(bl);
        return this;
    }

    @Override
    @Nullable
    public final PLSplitResult splitElementVert(@Nonnegative float f, @Nonnegative float f2) {
        return this.m_aTable.splitElementVert(f, f2);
    }
}

