/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.text;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLInlineElement;
import com.helger.pdflayout.base.EPLPlaceholder;
import com.helger.pdflayout.base.IPLElement;
import com.helger.pdflayout.base.IPLHasHorizontalAlignment;
import com.helger.pdflayout.base.IPLSplittableObject;
import com.helger.pdflayout.base.PLElementWithSize;
import com.helger.pdflayout.base.PLSplitResult;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.pdfbox.PDPageContentStreamWithCache;
import com.helger.pdflayout.render.PLRenderHelper;
import com.helger.pdflayout.render.PagePreRenderContext;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.EHorzAlignment;
import com.helger.pdflayout.spec.FontSpec;
import com.helger.pdflayout.spec.LoadedFont;
import com.helger.pdflayout.spec.SizeSpec;
import com.helger.pdflayout.spec.TextAndWidthSpec;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractPLText<IMPLTYPE extends AbstractPLText<IMPLTYPE>>
extends AbstractPLInlineElement<IMPLTYPE>
implements IPLHasHorizontalAlignment<IMPLTYPE>,
IPLSplittableObject<IMPLTYPE, IMPLTYPE> {
    public static final float DEFAULT_LINE_SPACING = 1.0f;
    public static final int DEFAULT_MAX_ROWS = -1;
    public static final boolean DEFAULT_REPLACE_PLACEHOLDERS = false;
    private String m_sOriginalText;
    private String m_sTextWithPlaceholdersReplaced;
    private final FontSpec m_aFontSpec;
    private float m_fLineSpacing = 1.0f;
    private EHorzAlignment m_eHorzAlign = DEFAULT_HORZ_ALIGNMENT;
    private int m_nMaxRows = -1;
    private boolean m_bVertSplittable = true;
    private boolean m_bReplacePlaceholder = false;
    private transient LoadedFont m_aLoadedFont;
    protected float m_fTextHeight;
    protected float m_fDescent;
    private float m_fCustomAscentFirstLine = 0.0f;
    protected int m_nPreparedLineCountUnmodified = -1;
    protected ICommonsList<TextAndWidthSpec> m_aPreparedLinesUnmodified;
    protected ICommonsList<TextAndWidthSpec> m_aPreparedLines;
    private static final ICommonsMap<String, String> ESTIMATION_REPLACEMENTS = EPLPlaceholder.getEstimationReplacements();

    @Nonnull
    public static String getCleanedPLText(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return "";
        }
        String string2 = string;
        string2 = StringHelper.replaceAll((String)string2, (String)"\r\n", (CharSequence)"\n");
        string2 = StringHelper.replaceAll((String)string2, (char)'\r', (char)'\n');
        return string2;
    }

    public AbstractPLText(@Nullable String string, @Nonnull FontSpec fontSpec) {
        this._setText(string);
        this.m_aFontSpec = (FontSpec)ValueEnforcer.notNull((Object)fontSpec, (String)"FontSpec");
    }

    private void _setText(@Nullable String string) {
        this.m_sTextWithPlaceholdersReplaced = this.m_sOriginalText = AbstractPLText.getCleanedPLText(string);
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        super.setBasicDataFrom(IMPLTYPE);
        this.setLineSpacing(((AbstractPLText)IMPLTYPE).getLineSpacing());
        this.setHorzAlign(((AbstractPLText)IMPLTYPE).getHorzAlign());
        this.setMaxRows(((AbstractPLText)IMPLTYPE).getMaxRows());
        this.setVertSplittable(((AbstractPLText)IMPLTYPE).isVertSplittable());
        this.setReplacePlaceholder(((AbstractPLText)IMPLTYPE).isReplacePlaceholder());
        return (IMPLTYPE)((AbstractPLText)this.thisAsT());
    }

    @Nonnull
    public final String getText() {
        return this.m_sOriginalText;
    }

    public final boolean hasText() {
        return this.m_sOriginalText.length() > 0;
    }

    public final boolean hasNoText() {
        return this.m_sOriginalText.length() == 0;
    }

    @Nonnull
    public final FontSpec getFontSpec() {
        return this.m_aFontSpec;
    }

    public final float getLineSpacing() {
        return this.m_fLineSpacing;
    }

    @Nonnull
    public final IMPLTYPE setLineSpacing(@Nonnegative float f) {
        ValueEnforcer.isGE0((float)f, (String)"LineSpacing");
        this.m_fLineSpacing = f;
        return (IMPLTYPE)((AbstractPLText)this.thisAsT());
    }

    @Override
    @Nonnull
    public final EHorzAlignment getHorzAlign() {
        return this.m_eHorzAlign;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setHorzAlign(@Nonnull EHorzAlignment eHorzAlignment) {
        this.m_eHorzAlign = (EHorzAlignment)((Object)ValueEnforcer.notNull((Object)((Object)eHorzAlignment), (String)"HorzAlign"));
        return (IMPLTYPE)((AbstractPLText)this.thisAsT());
    }

    @CheckForSigned
    public final int getMaxRows() {
        return this.m_nMaxRows;
    }

    @Nonnull
    public final IMPLTYPE setMaxRows(int n) {
        this.m_nMaxRows = n;
        return (IMPLTYPE)((AbstractPLText)this.thisAsT());
    }

    @Override
    public final boolean isVertSplittable() {
        return this.m_bVertSplittable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setVertSplittable(boolean bl) {
        this.m_bVertSplittable = bl;
        return (IMPLTYPE)((AbstractPLText)this.thisAsT());
    }

    public final boolean isReplacePlaceholder() {
        return this.m_bReplacePlaceholder;
    }

    @Nonnull
    public final IMPLTYPE setReplacePlaceholder(boolean bl) {
        this.m_bReplacePlaceholder = bl;
        return (IMPLTYPE)((AbstractPLText)this.thisAsT());
    }

    public final float getCustomAscentFirstLine() {
        return this.m_fCustomAscentFirstLine;
    }

    @Nonnull
    public final IMPLTYPE setCustomAscentFirstLine(float f) {
        this.m_fCustomAscentFirstLine = f;
        return (IMPLTYPE)((AbstractPLText)this.thisAsT());
    }

    final void internalSetPreparedLines(@Nonnull ICommonsList<TextAndWidthSpec> iCommonsList) {
        int n;
        this.m_nPreparedLineCountUnmodified = n = iCommonsList.size();
        this.m_aPreparedLinesUnmodified = iCommonsList;
        if (this.m_nMaxRows <= 0) {
            this.m_aPreparedLines = iCommonsList;
        } else if (n <= this.m_nMaxRows) {
            this.m_aPreparedLines = iCommonsList;
        } else {
            this.m_aPreparedLines = new CommonsArrayList(this.m_nMaxRows);
            for (int i = 0; i < this.m_nMaxRows; ++i) {
                this.m_aPreparedLines.add(iCommonsList.get(i));
            }
        }
    }

    final void internalSetPreparedFontData(@Nonnull LoadedFont loadedFont, float f, float f2) {
        ValueEnforcer.notNull((Object)loadedFont, (String)"LoadedFont");
        this.m_aLoadedFont = loadedFont;
        this.m_fTextHeight = f;
        this.m_fDescent = f2;
    }

    @Nonnull
    private SizeSpec _prepareText(float f, boolean bl) throws IOException {
        float f2 = this.m_aFontSpec.getFontSize();
        this.m_fTextHeight = this.m_aLoadedFont.getTextHeight(f2);
        this.m_fDescent = this.m_aLoadedFont.getDescent(f2);
        if (this.hasNoText()) {
            return new SizeSpec(0.0f, this.m_fTextHeight);
        }
        String string = bl ? this.m_sTextWithPlaceholdersReplaced : StringHelper.replaceMultiple((String)this.m_sOriginalText, ESTIMATION_REPLACEMENTS);
        this.internalSetPreparedLines(this.m_aLoadedFont.getFitToWidth(string, f2, f));
        float f3 = Float.MIN_VALUE;
        for (TextAndWidthSpec textAndWidthSpec : this.m_aPreparedLines) {
            f3 = Math.max(f3, textAndWidthSpec.getWidth());
        }
        return new SizeSpec(f3, this.getDisplayHeightOfLineCount(this.m_aPreparedLines.size(), false));
    }

    @Override
    protected SizeSpec onPrepare(@Nonnull PreparationContext preparationContext) {
        float f = preparationContext.getAvailableWidth() - this.getOutlineXSum();
        try {
            this.m_aLoadedFont = preparationContext.getGlobalContext().getLoadedFont(this.m_aFontSpec);
            return this._prepareText(f, false);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to prepare text element: " + this.toString(), iOException);
        }
    }

    @Override
    protected void onMarkAsNotPrepared() {
        this.m_nPreparedLineCountUnmodified = -1;
        this.m_aPreparedLinesUnmodified = null;
        this.m_aPreparedLines = null;
    }

    private void _setDisplayTextAfterPrepare(@Nonnull String string, float f) throws IOException {
        this.internalMarkAsNotPrepared();
        this.m_sTextWithPlaceholdersReplaced = string;
        SizeSpec sizeSpec = this._prepareText(f, true);
        this.internalMarkAsPrepared(sizeSpec);
    }

    @Nonnegative
    public int getPreparedLineCountUnmodified() {
        this.internalCheckAlreadyPrepared();
        return this.m_nPreparedLineCountUnmodified;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<TextAndWidthSpec> getAllPreparedLinesUnmodified() {
        this.internalCheckAlreadyPrepared();
        return new CommonsArrayList(this.m_aPreparedLinesUnmodified);
    }

    protected final float getDisplayHeightOfLineCount(@Nonnegative int n, boolean bl) {
        if (n == 0) {
            return 0.0f;
        }
        if (n == 1) {
            return this.m_fTextHeight;
        }
        if (bl) {
            return (float)n * this.m_fTextHeight * this.m_fLineSpacing;
        }
        return (float)(n - 1) * this.m_fTextHeight * this.m_fLineSpacing + 1.0f * this.m_fTextHeight;
    }

    @Nonnull
    private PLElementWithSize _splitGetCopy(float f, @Nonnull @Nonempty List<TextAndWidthSpec> list, boolean bl, @Nonnull String string) {
        ValueEnforcer.notEmpty(list, (String)"Lines");
        CommonsArrayList commonsArrayList = new CommonsArrayList(list);
        SizeSpec sizeSpec = new SizeSpec(f, this.getDisplayHeightOfLineCount(commonsArrayList.size(), true));
        String string2 = StringHelper.getImplodedMapped((char)'\n', (Iterable)commonsArrayList, TextAndWidthSpec::getText);
        AbstractPLText abstractPLText = (AbstractPLText)((AbstractPLText)this.internalCreateNewVertSplitObject((IPLSplittableObject)this.thisAsT())).setID(this.getID() + string);
        abstractPLText._setText(string2);
        abstractPLText.setVertSplittable(bl);
        abstractPLText.setMinWidth(this.getMinWidth());
        abstractPLText.setMaxWidth(this.getMaxWidth());
        abstractPLText.internalMarkAsPrepared(sizeSpec);
        abstractPLText.internalSetPreparedLines((ICommonsList<TextAndWidthSpec>)commonsArrayList);
        abstractPLText.internalSetPreparedFontData(this.m_aLoadedFont, this.m_fTextHeight, this.m_fDescent);
        return new PLElementWithSize(abstractPLText, sizeSpec);
    }

    @Override
    @Nullable
    public PLSplitResult splitElementVert(float f, float f2) {
        if (f2 <= 0.0f) {
            return null;
        }
        ICommonsList<TextAndWidthSpec> iCommonsList = this.m_aPreparedLines;
        int n = (int)((f2 + (this.m_fLineSpacing - 1.0f) * this.m_fTextHeight) / (this.m_fTextHeight * this.m_fLineSpacing));
        if (n <= 0) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Failed to split because the result would be " + n + " lines for available height " + f2 + " and line height " + this.m_fTextHeight * this.m_fLineSpacing);
            }
            return null;
        }
        if (n >= iCommonsList.size()) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Failed to split because the result of " + n + " lines fits into the available height " + f2 + " and line height " + this.m_fTextHeight * this.m_fLineSpacing + " (=" + this.getDisplayHeightOfLineCount(n, true) + ")");
            }
            return null;
        }
        float f3 = this.getDisplayHeightOfLineCount(n, true);
        if (f3 > f2 && --n <= 0) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Failed to split because the result would be " + n + " lines for available height " + f2 + " and expected height " + f3);
            }
            return null;
        }
        PLElementWithSize pLElementWithSize = this._splitGetCopy(f, iCommonsList.subList(0, n), false, "-1");
        PLElementWithSize pLElementWithSize2 = this._splitGetCopy(f, iCommonsList.subList(n, iCommonsList.size()), true, "-2");
        return new PLSplitResult(pLElementWithSize, pLElementWithSize2);
    }

    @Override
    @Nonnull
    public EChange beforeRender(@Nonnull PagePreRenderContext pagePreRenderContext) throws IOException {
        String string;
        String string2;
        if (this.m_bReplacePlaceholder && !(string2 = this.m_sOriginalText).equals(string = StringHelper.replaceMultiple((String)string2, pagePreRenderContext.getAllPlaceholders()))) {
            this._setDisplayTextAfterPrepare(string, this.getPrepareAvailableSize().getWidth());
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Override
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        if (this.hasNoText()) {
            return;
        }
        PLRenderHelper.fillAndRenderBorder((IPLElement)this.thisAsT(), pageRenderContext, 0.0f, 0.0f);
        float f = pageRenderContext.getStartLeft() + this.getOutlineLeft();
        float f2 = pageRenderContext.getStartTop() - this.getOutlineTop();
        if (PLDebugLog.isDebugRender()) {
            PLDebugLog.debugRender(this, "Display at " + PLDebugLog.getXYWH(f, f2, this.getRenderWidth(), this.getRenderHeight()) + " with " + this.m_aPreparedLines.size() + " lines");
        }
        PDPageContentStreamWithCache pDPageContentStreamWithCache = pageRenderContext.getContentStream();
        pDPageContentStreamWithCache.beginText();
        pDPageContentStreamWithCache.setFont(this.m_aLoadedFont, this.m_aFontSpec);
        float f3 = this.m_fTextHeight;
        float f4 = this.getPreparedWidth();
        boolean bl = this.m_eHorzAlign == EHorzAlignment.JUSTIFY;
        int n = 0;
        int n2 = this.m_aPreparedLines.size();
        for (TextAndWidthSpec textAndWidthSpec : this.m_aPreparedLines) {
            boolean bl2 = n < n2 - 1;
            float f5 = textAndWidthSpec.getWidth();
            String string = textAndWidthSpec.getText();
            float f6 = this.getIndentX(f4, f5);
            if (n == 0) {
                pDPageContentStreamWithCache.moveTextPositionByAmount(f + f6, f2 - f3 - this.m_fDescent + this.m_fCustomAscentFirstLine);
            } else if (f6 != 0.0f) {
                pDPageContentStreamWithCache.moveTextPositionByAmount(f6, 0.0f);
            }
            if (bl) {
                if (bl2) {
                    float f7 = 0.0f;
                    if (string.length() > 1) {
                        f7 = (f4 - f5) / (float)(string.length() - 1);
                    }
                    pDPageContentStreamWithCache.setCharacterSpacing(f7);
                } else if (n > 0) {
                    pDPageContentStreamWithCache.setCharacterSpacing(0.0f);
                }
            }
            pDPageContentStreamWithCache.drawString(string);
            ++n;
            if (!bl2) continue;
            pDPageContentStreamWithCache.moveTextPositionByAmount(-f6, -f3 * this.m_fLineSpacing);
        }
        pDPageContentStreamWithCache.endText();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("OriginalText", (Object)this.m_sOriginalText).append("TextWithPlaceholdersReplaced", (Object)this.m_sTextWithPlaceholdersReplaced).append("FontSpec", (Object)this.m_aFontSpec).append("LineSpacing", this.m_fLineSpacing).append("HorzAlign", (Enum)this.m_eHorzAlign).append("MaxRows", this.m_nMaxRows).append("VertSplittable", this.m_bVertSplittable).append("ReplacePlaceholder", this.m_bReplacePlaceholder).getToString();
    }
}

