/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.vbox;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLElement;
import com.helger.pdflayout.base.AbstractPLRenderableObject;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.base.IPLSplittableObject;
import com.helger.pdflayout.base.IPLVisitor;
import com.helger.pdflayout.base.PLElementWithSize;
import com.helger.pdflayout.base.PLSplitResult;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.element.vbox.PLVBoxRow;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.HeightSpec;
import com.helger.pdflayout.spec.SizeSpec;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPLVBox<IMPLTYPE extends AbstractPLVBox<IMPLTYPE>>
extends AbstractPLRenderableObject<IMPLTYPE>
implements IPLSplittableObject<IMPLTYPE, IMPLTYPE> {
    public static final boolean DEFAULT_FULL_WIDTH = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPLVBox.class);
    private final ICommonsList<PLVBoxRow> m_aRows = new CommonsArrayList();
    private boolean m_bVertSplittable = true;
    private int m_nHeaderRowCount = 0;
    private boolean m_bFullWidth = true;
    private SizeSpec[] m_aPreparedRowSize;
    private SizeSpec[] m_aPreparedElementSize;

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        super.setBasicDataFrom(IMPLTYPE);
        this.setVertSplittable(((AbstractPLVBox)IMPLTYPE).isVertSplittable());
        this.setHeaderRowCount(((AbstractPLVBox)IMPLTYPE).getHeaderRowCount());
        this.setFullWidth(((AbstractPLVBox)IMPLTYPE).isFullWidth());
        return (IMPLTYPE)((AbstractPLVBox)this.thisAsT());
    }

    @Nonnegative
    public int getRowCount() {
        return this.m_aRows.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PLVBoxRow> getAllRows() {
        return (ICommonsList)this.m_aRows.getClone();
    }

    @Nonnull
    public Iterable<PLVBoxRow> getRows() {
        return this.m_aRows;
    }

    public void forEachRow(@Nonnull Consumer<? super PLVBoxRow> consumer) {
        this.m_aRows.forEach(consumer);
    }

    public void forEachRowByIndex(@Nonnull ObjIntConsumer<? super PLVBoxRow> objIntConsumer) {
        this.m_aRows.forEachByIndex(objIntConsumer);
    }

    @Nullable
    public PLVBoxRow getRowAtIndex(@Nonnegative int n) {
        return (PLVBoxRow)this.m_aRows.getAtIndex(n);
    }

    @Nullable
    public PLVBoxRow getFirstRow() {
        return (PLVBoxRow)this.m_aRows.getFirst();
    }

    @Nullable
    public PLVBoxRow getLastRow() {
        return (PLVBoxRow)this.m_aRows.getLast();
    }

    @Nullable
    public IPLRenderableObject<?> getRowElementAtIndex(@Nonnegative int n) {
        PLVBoxRow pLVBoxRow = this.getRowAtIndex(n);
        return pLVBoxRow == null ? null : pLVBoxRow.getElement();
    }

    @Nullable
    public IPLRenderableObject<?> getFirstRowElement() {
        PLVBoxRow pLVBoxRow = this.getFirstRow();
        return pLVBoxRow == null ? null : pLVBoxRow.getElement();
    }

    @Nullable
    public IPLRenderableObject<?> getLastRowElement() {
        PLVBoxRow pLVBoxRow = this.getLastRow();
        return pLVBoxRow == null ? null : pLVBoxRow.getElement();
    }

    @Nonnull
    public HeightSpec getDefaultHeight() {
        return HeightSpec.auto();
    }

    @Nonnull
    private PLVBoxRow _addAndReturnRow(@CheckForSigned int n, @Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull HeightSpec heightSpec) {
        PLVBoxRow pLVBoxRow = new PLVBoxRow(iPLRenderableObject, heightSpec);
        if (n < 0 || n >= this.m_aRows.size()) {
            this.m_aRows.add((Object)pLVBoxRow);
        } else {
            this.m_aRows.add(n, (Object)pLVBoxRow);
        }
        return pLVBoxRow;
    }

    @Nonnull
    public PLVBoxRow addAndReturnRow(@Nonnull IPLRenderableObject<?> iPLRenderableObject) {
        return this.addAndReturnRow(iPLRenderableObject, this.getDefaultHeight());
    }

    @Nonnull
    public final PLVBoxRow addAndReturnRow(@Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull HeightSpec heightSpec) {
        this.internalCheckNotPrepared();
        return this._addAndReturnRow(-1, iPLRenderableObject, heightSpec);
    }

    @Nonnull
    public IMPLTYPE addRow(@Nonnull IPLRenderableObject<?> iPLRenderableObject) {
        return this.addRow(iPLRenderableObject, this.getDefaultHeight());
    }

    @Nonnull
    public final IMPLTYPE addRow(@Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull HeightSpec heightSpec) {
        this.addAndReturnRow(iPLRenderableObject, heightSpec);
        return (IMPLTYPE)((AbstractPLVBox)this.thisAsT());
    }

    @Nonnull
    public PLVBoxRow addAndReturnRow(@Nonnegative int n, @Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull HeightSpec heightSpec) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        this.internalCheckNotPrepared();
        return this._addAndReturnRow(n, iPLRenderableObject, heightSpec);
    }

    @Nonnull
    public IMPLTYPE addRow(@Nonnegative int n, @Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull HeightSpec heightSpec) {
        this.addAndReturnRow(n, iPLRenderableObject, heightSpec);
        return (IMPLTYPE)((AbstractPLVBox)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE removeRow(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        this.internalCheckNotPrepared();
        this.m_aRows.remove(n);
        return (IMPLTYPE)((AbstractPLVBox)this.thisAsT());
    }

    @Override
    public final boolean isVertSplittable() {
        return this.m_bVertSplittable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setVertSplittable(boolean bl) {
        this.m_bVertSplittable = bl;
        return (IMPLTYPE)((AbstractPLVBox)this.thisAsT());
    }

    @Nonnegative
    public final int getHeaderRowCount() {
        return this.m_nHeaderRowCount;
    }

    @Nonnull
    public final IMPLTYPE setHeaderRowCount(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"HeaderRowCount");
        this.m_nHeaderRowCount = n;
        return (IMPLTYPE)((AbstractPLVBox)this.thisAsT());
    }

    public boolean containsAnyVertSplittableElement() {
        return this.m_aRows.containsAny(pLVBoxRow -> pLVBoxRow.getElement().isVertSplittable());
    }

    public final boolean isFullWidth() {
        return this.m_bFullWidth;
    }

    @Nonnull
    public final IMPLTYPE setFullWidth(boolean bl) {
        this.m_bFullWidth = bl;
        return (IMPLTYPE)((AbstractPLVBox)this.thisAsT());
    }

    @Override
    @Nonnull
    public EChange visit(@Nonnull IPLVisitor iPLVisitor) throws IOException {
        EChange eChange = EChange.UNCHANGED;
        for (PLVBoxRow pLVBoxRow : this.m_aRows) {
            eChange = eChange.or((IChangeIndicator)pLVBoxRow.getElement().visit(iPLVisitor));
        }
        return eChange;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected SizeSpec onPrepare(@Nonnull PreparationContext preparationContext) {
        float f;
        float f2;
        IPLRenderableObject<?> iPLRenderableObject;
        float f3;
        this.m_aPreparedRowSize = new SizeSpec[this.m_aRows.size()];
        this.m_aPreparedElementSize = new SizeSpec[this.m_aRows.size()];
        float f4 = preparationContext.getAvailableWidth() - this.getOutlineXSum();
        float f5 = preparationContext.getAvailableHeight() - this.getOutlineYSum();
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n = 0;
        int n2 = 0;
        for (PLVBoxRow pLVBoxRow : this.m_aRows) {
            switch (pLVBoxRow.getHeight().getType()) {
                case STAR: {
                    ++n;
                    break;
                }
                case AUTO: {
                    ++n2;
                }
            }
        }
        int n3 = 0;
        float f9 = f5;
        for (PLVBoxRow pLVBoxRow : this.m_aRows) {
            if (pLVBoxRow.getHeight().isAbsolute()) {
                IPLRenderableObject<?> iPLRenderableObject2 = pLVBoxRow.getElement();
                f3 = pLVBoxRow.getHeight().getEffectiveValue(f5);
                SizeSpec sizeSpec = iPLRenderableObject2.prepare(new PreparationContext(preparationContext.getGlobalContext(), f4, f3));
                f6 = Math.max(f6, sizeSpec.getWidth());
                float f10 = sizeSpec.getWidth() + iPLRenderableObject2.getOutlineXSum();
                f7 = Math.max(f7, f10);
                f8 += f3;
                f9 -= f3;
                this.m_aPreparedRowSize[n3] = new SizeSpec(this.m_bFullWidth ? f4 : f10, f3);
                this.m_aPreparedElementSize[n3] = sizeSpec;
            }
            ++n3;
        }
        float f11 = f8;
        float f12 = 0.0f;
        float f13 = 0.0f;
        f3 = n2 + n == 0 ? 0.0f : f9 / (float)(n2 + n);
        float f14 = f3 * (float)n2;
        SizeSpec[] sizeSpecArray = new SizeSpec[this.m_aRows.size()];
        n3 = 0;
        for (PLVBoxRow pLVBoxRow : this.m_aRows) {
            if (pLVBoxRow.getHeight().isAuto()) {
                iPLRenderableObject = pLVBoxRow.getElement();
                SizeSpec sizeSpec = iPLRenderableObject.prepare(new PreparationContext(preparationContext.getGlobalContext(), f4, f14));
                f2 = sizeSpec.getHeight() + iPLRenderableObject.getOutlineYSum();
                if (f2 <= f3) {
                    f8 += f2;
                    f11 += f2;
                    f12 += f3 - f2;
                    f6 = Math.max(f6, sizeSpec.getWidth());
                    f = sizeSpec.getWidth() + iPLRenderableObject.getOutlineXSum();
                    f7 = Math.max(f7, f);
                    this.m_aPreparedRowSize[n3] = new SizeSpec(this.m_bFullWidth ? f4 : f, f2);
                    this.m_aPreparedElementSize[n3] = sizeSpec;
                } else {
                    sizeSpecArray[n3] = sizeSpec;
                    f12 += f3;
                    f13 += f2;
                }
            }
            ++n3;
        }
        n3 = 0;
        for (PLVBoxRow pLVBoxRow : this.m_aRows) {
            if (pLVBoxRow.getHeight().isAuto() && sizeSpecArray[n3] != null) {
                iPLRenderableObject = pLVBoxRow.getElement();
                float f15 = sizeSpecArray[n3].getHeight() + iPLRenderableObject.getOutlineYSum();
                f2 = f13 == 0.0f ? 0.0f : f15 / f13;
                f = Math.max(f12 * f2, sizeSpecArray[n3].getHeight());
                if (iPLRenderableObject instanceof AbstractPLRenderableObject) {
                    ((AbstractPLRenderableObject)iPLRenderableObject).internalMarkAsNotPrepared();
                }
                SizeSpec sizeSpec = iPLRenderableObject.prepare(new PreparationContext(preparationContext.getGlobalContext(), f4, f));
                float f16 = sizeSpec.getHeight() + iPLRenderableObject.getOutlineYSum();
                f6 = Math.max(f6, sizeSpec.getWidth());
                float f17 = sizeSpec.getWidth() + iPLRenderableObject.getOutlineXSum();
                f7 = Math.max(f7, f17);
                f8 += f16;
                if (f16 > f) {
                    f11 += f;
                    if (!iPLRenderableObject.isVertSplittable() && LOGGER.isWarnEnabled()) {
                        LOGGER.warn("VBox row element " + iPLRenderableObject.getDebugID() + " uses more height (" + f16 + ") than is available (" + f + " and is NOT vertical splittable!");
                    }
                } else {
                    f11 += f16;
                }
                this.m_aPreparedRowSize[n3] = new SizeSpec(this.m_bFullWidth ? f4 : f17, f16);
                this.m_aPreparedElementSize[n3] = sizeSpec;
            }
            ++n3;
        }
        f9 = f5 - f11;
        boolean bl = f9 <= 0.0f;
        n3 = 0;
        for (PLVBoxRow pLVBoxRow : this.m_aRows) {
            if (pLVBoxRow.getHeight().isStar()) {
                IPLRenderableObject<?> iPLRenderableObject3 = pLVBoxRow.getElement();
                if (n == 0) {
                    throw new IllegalStateException("Internal inconsistency");
                }
                float f18 = f9 / (float)n;
                SizeSpec sizeSpec = iPLRenderableObject3.prepare(new PreparationContext(preparationContext.getGlobalContext(), f4, bl ? f5 : f18));
                f6 = Math.max(f6, sizeSpec.getWidth());
                float f19 = sizeSpec.getWidth() + iPLRenderableObject3.getOutlineXSum();
                f7 = Math.max(f7, f19);
                float f20 = bl ? sizeSpec.getHeight() + iPLRenderableObject3.getOutlineYSum() : f18;
                f8 += f20;
                this.m_aPreparedRowSize[n3] = new SizeSpec(this.m_bFullWidth ? f4 : f19, f20);
                this.m_aPreparedElementSize[n3] = sizeSpec;
            }
            ++n3;
        }
        n3 = 0;
        for (Object object : this.m_aRows) {
            IPLRenderableObject<?> iPLRenderableObject4 = ((PLVBoxRow)object).getElement();
            if (iPLRenderableObject4 instanceof AbstractPLElement) {
                AbstractPLElement abstractPLElement = (AbstractPLElement)iPLRenderableObject4;
                abstractPLElement.setMinSize(this.m_bFullWidth ? f4 - abstractPLElement.getOutlineXSum() : f6, this.m_aPreparedRowSize[n3].getHeight() - abstractPLElement.getOutlineYSum());
            }
            ++n3;
        }
        if (PLDebugLog.isDebugPrepare()) {
            if ((double)(f7 - f4) > 0.01) {
                PLDebugLog.debugPrepare(this, "uses more width (" + f7 + ") than available (" + f4 + ")!");
            }
            if ((double)(f8 - f5) > 0.01 && !this.isVertSplittable()) {
                PLDebugLog.debugPrepare(this, "uses more height (" + f8 + ") than available (" + f5 + ")!");
            }
        }
        return new SizeSpec(f7, f8);
    }

    @Override
    protected void onMarkAsNotPrepared() {
        this.m_aPreparedRowSize = null;
        this.m_aPreparedElementSize = null;
        for (PLVBoxRow pLVBoxRow : this.m_aRows) {
            if (!(pLVBoxRow.getElement() instanceof AbstractPLRenderableObject)) continue;
            ((AbstractPLRenderableObject)pLVBoxRow.getElement()).internalMarkAsNotPrepared();
        }
    }

    @Override
    @Nullable
    public PLSplitResult splitElementVert(float f, float f2) {
        ICommonsList iCommonsList;
        if (f2 <= 0.0f) {
            return null;
        }
        if (!this.containsAnyVertSplittableElement()) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Cannot split because no vertical splittable elements are contained");
            }
            return null;
        }
        IPLSplittableObject iPLSplittableObject = ((AbstractPLVBox)((AbstractPLVBox)this.internalCreateNewVertSplitObject((IPLSplittableObject)this.thisAsT())).setID(this.getID() + "-1")).setVertSplittable(false);
        IPLSplittableObject iPLSplittableObject2 = ((AbstractPLVBox)((AbstractPLVBox)this.internalCreateNewVertSplitObject((IPLSplittableObject)this.thisAsT())).setID(this.getID() + "-2")).setVertSplittable(true);
        int n = this.getRowCount();
        CommonsArrayList commonsArrayList = new CommonsArrayList(n);
        CommonsArrayList commonsArrayList2 = new CommonsArrayList(n);
        float f3 = 0.0f;
        for (int i = 0; i < this.m_nHeaderRowCount; ++i) {
            iCommonsList = this.getRowElementAtIndex(i);
            ((AbstractPLVBox)iPLSplittableObject).addRow((IPLRenderableObject<?>)iCommonsList);
            ((AbstractPLVBox)iPLSplittableObject2).addRow((IPLRenderableObject<?>)iCommonsList);
            f3 += this.m_aPreparedRowSize[i].getHeight();
            commonsArrayList.add((Object)this.m_aPreparedRowSize[i]);
            commonsArrayList2.add((Object)this.m_aPreparedElementSize[i]);
        }
        ICommonsList iCommonsList2 = (ICommonsList)commonsArrayList.getClone();
        iCommonsList = (ICommonsList)commonsArrayList2.getClone();
        float f4 = f3;
        boolean bl = true;
        for (int i = this.m_nHeaderRowCount; i < n; ++i) {
            IPLRenderableObject<?> iPLRenderableObject = this.getRowElementAtIndex(i);
            float f5 = this.m_aPreparedRowSize[i].getHeight();
            if (bl) {
                if (f3 + f5 <= f2) {
                    ((AbstractPLVBox)iPLSplittableObject).addRow(iPLRenderableObject);
                    f3 += f5;
                    commonsArrayList.add((Object)this.m_aPreparedRowSize[i]);
                    commonsArrayList2.add((Object)this.m_aPreparedElementSize[i]);
                    continue;
                }
                bl = false;
                boolean bl2 = false;
                if (iPLRenderableObject.isVertSplittable()) {
                    PLSplitResult pLSplitResult;
                    float f6 = this.m_aPreparedElementSize[i].getWidth();
                    float f7 = f2 - f3 - iPLRenderableObject.getOutlineYSum();
                    if (PLDebugLog.isDebugSplit()) {
                        PLDebugLog.debugSplit(this, "Trying to split " + iPLRenderableObject.getDebugID() + " into pieces for split size " + PLDebugLog.getWH(f6, f7));
                    }
                    if ((pLSplitResult = iPLRenderableObject.getAsSplittable().splitElementVert(f6, f7)) != null) {
                        IPLRenderableObject<?> iPLRenderableObject2 = pLSplitResult.getFirstElement().getElement();
                        ((AbstractPLVBox)iPLSplittableObject).addRow(iPLRenderableObject2);
                        f3 += pLSplitResult.getFirstElement().getHeightFull();
                        commonsArrayList.add((Object)pLSplitResult.getFirstElement().getSizeFull());
                        commonsArrayList2.add((Object)pLSplitResult.getFirstElement().getSize());
                        IPLRenderableObject<?> iPLRenderableObject3 = pLSplitResult.getSecondElement().getElement();
                        ((AbstractPLVBox)iPLSplittableObject2).addRow(iPLRenderableObject3);
                        f4 += pLSplitResult.getSecondElement().getHeightFull();
                        iCommonsList2.add((Object)pLSplitResult.getSecondElement().getSizeFull());
                        iCommonsList.add((Object)pLSplitResult.getSecondElement().getSize());
                        if (PLDebugLog.isDebugSplit()) {
                            PLDebugLog.debugSplit(this, "Split row element " + iPLRenderableObject.getDebugID() + " (Row " + i + ") into pieces: " + iPLRenderableObject2.getDebugID() + " (" + pLSplitResult.getFirstElement().getWidth() + "+" + iPLRenderableObject2.getOutlineXSum() + " & " + pLSplitResult.getFirstElement().getHeight() + "+" + iPLRenderableObject2.getOutlineYSum() + ") and " + iPLRenderableObject3.getDebugID() + " (" + pLSplitResult.getSecondElement().getWidth() + "+" + iPLRenderableObject3.getOutlineXSum() + " & " + pLSplitResult.getSecondElement().getHeight() + "+" + iPLRenderableObject3.getOutlineYSum() + ")");
                        }
                        bl2 = true;
                    } else if (PLDebugLog.isDebugSplit()) {
                        PLDebugLog.debugSplit(this, "Failed to split row element " + iPLRenderableObject.getDebugID() + " (Row " + i + ") into pieces");
                    }
                }
                if (bl2) continue;
                ((AbstractPLVBox)iPLSplittableObject2).addRow(iPLRenderableObject);
                f4 += f5;
                iCommonsList2.add((Object)this.m_aPreparedRowSize[i]);
                iCommonsList.add((Object)this.m_aPreparedElementSize[i]);
                continue;
            }
            ((AbstractPLVBox)iPLSplittableObject2).addRow(iPLRenderableObject);
            f4 += f5;
            iCommonsList2.add((Object)this.m_aPreparedRowSize[i]);
            iCommonsList.add((Object)this.m_aPreparedElementSize[i]);
        }
        if (((AbstractPLVBox)iPLSplittableObject).getRowCount() == this.m_nHeaderRowCount) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Splitting makes no sense, because VBox 1 would be empty");
            }
            return null;
        }
        if (((AbstractPLVBox)iPLSplittableObject2).getRowCount() == this.m_nHeaderRowCount) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Splitting makes no sense, because VBox 2 would be empty");
            }
            return null;
        }
        ((AbstractPLRenderableObject)((Object)iPLSplittableObject)).internalMarkAsPrepared(new SizeSpec(f, f3));
        ((AbstractPLVBox)iPLSplittableObject).m_aPreparedRowSize = (SizeSpec[])ArrayHelper.newArray((Collection)commonsArrayList, SizeSpec.class);
        ((AbstractPLVBox)iPLSplittableObject).m_aPreparedElementSize = (SizeSpec[])ArrayHelper.newArray((Collection)commonsArrayList2, SizeSpec.class);
        ((AbstractPLRenderableObject)((Object)iPLSplittableObject2)).internalMarkAsPrepared(new SizeSpec(f, f4));
        ((AbstractPLVBox)iPLSplittableObject2).m_aPreparedRowSize = (SizeSpec[])ArrayHelper.newArray((Collection)iCommonsList2, SizeSpec.class);
        ((AbstractPLVBox)iPLSplittableObject2).m_aPreparedElementSize = (SizeSpec[])ArrayHelper.newArray((Collection)iCommonsList, SizeSpec.class);
        return new PLSplitResult(new PLElementWithSize((IPLRenderableObject<?>)((Object)iPLSplittableObject), new SizeSpec(f, f3)), new PLElementWithSize((IPLRenderableObject<?>)((Object)iPLSplittableObject2), new SizeSpec(f, f4)));
    }

    @Override
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        float f = pageRenderContext.getStartLeft() + this.getOutlineLeft();
        float f2 = pageRenderContext.getStartTop() - this.getOutlineTop();
        int n = 0;
        for (PLVBoxRow pLVBoxRow : this.m_aRows) {
            IPLRenderableObject<?> iPLRenderableObject = pLVBoxRow.getElement();
            float f3 = this.m_aPreparedRowSize[n].getWidth();
            float f4 = this.m_aPreparedRowSize[n].getHeight();
            PageRenderContext pageRenderContext2 = new PageRenderContext(pageRenderContext, f, f2, f3, f4);
            iPLRenderableObject.render(pageRenderContext2);
            f2 -= f4;
            ++n;
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Rows", this.m_aRows).appendIfNotNull("PreparedRowSize", (Object)this.m_aPreparedRowSize).appendIfNotNull("PreparedElementSize", (Object)this.m_aPreparedElementSize).getToString();
    }
}

